/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.jbpm;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.DoNotRetryException;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.workflow.jbpm.AlfrescoJobExecutor;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.db.JobSession;
import org.jbpm.job.Job;
import org.jbpm.job.executor.JobExecutor;
import org.jbpm.job.executor.JobExecutorThread;
import org.jbpm.persistence.JbpmPersistenceException;
import org.jbpm.svc.Services;
import org.jbpm.taskmgmt.exe.TaskInstance;

public class AlfrescoJobExecutorThread
extends JobExecutorThread {
    private static final QName LOCK_QNAME = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"AlfrescoJbpmJobExecutor");
    private static Log logger = LogFactory.getLog(AlfrescoJobExecutorThread.class);
    private AlfrescoJobExecutor alfrescoJobExecutor;
    private boolean isActive = true;
    private long jbpmMaxLockTime;
    private long jobLockTTL = 0L;
    private String jobLockToken = null;
    private JbpmConfiguration jbpmConfiguration;

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    public AlfrescoJobExecutorThread(String name, AlfrescoJobExecutor jobExecutor, JbpmConfiguration jbpmConfiguration, int idleInterval, int maxIdleInterval, long maxLockTime, int maxHistory) {
        super(name, (JobExecutor)jobExecutor, jbpmConfiguration, idleInterval, maxIdleInterval, maxLockTime, maxHistory);
        this.alfrescoJobExecutor = jobExecutor;
        this.jbpmMaxLockTime = maxLockTime;
        this.jobLockTTL = this.jbpmMaxLockTime + 600000L;
        this.jbpmConfiguration = jbpmConfiguration;
    }

    protected Collection acquireJobs() {
        Collection jobs = Collections.EMPTY_LIST;
        if (this.isActive && !this.alfrescoJobExecutor.getTransactionService().isReadOnly()) {
            try {
                jobs = this.alfrescoJobExecutor.getTransactionService().getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Collection>(){

                    @Override
                    public Collection execute() throws Throwable {
                        if (AlfrescoJobExecutorThread.this.jobLockToken != null) {
                            AlfrescoJobExecutorThread.this.refreshExecutorLock(AlfrescoJobExecutorThread.this.jobLockToken);
                        } else {
                            AlfrescoJobExecutorThread.this.jobLockToken = AlfrescoJobExecutorThread.this.getExecutorLock();
                        }
                        try {
                            return AlfrescoJobExecutorThread.super.acquireJobs();
                        }
                        catch (Throwable t) {
                            logger.error((Object)"Failed to acquire jobs");
                            AlfrescoJobExecutorThread.this.releaseExecutorLock(AlfrescoJobExecutorThread.this.jobLockToken);
                            AlfrescoJobExecutorThread.this.jobLockToken = null;
                            throw t;
                        }
                    }
                });
                if (jobs != null) {
                    if (logger.isDebugEnabled() && !logger.isTraceEnabled() && !jobs.isEmpty()) {
                        logger.debug((Object)("acquired " + jobs.size() + " job" + (jobs.size() != 1 ? "s" : "")));
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("acquired " + jobs.size() + " job" + (jobs.size() != 1 ? "s" : "") + (jobs.size() > 0 ? ": " + jobs.toString() : "")));
                    }
                    if (jobs.size() == 0) {
                        this.releaseExecutorLock(this.jobLockToken);
                        this.jobLockToken = null;
                    }
                }
            }
            catch (LockAcquisitionException e) {
                this.jobLockToken = null;
            }
        }
        return jobs;
    }

    protected Date getNextDueDate() {
        if (!this.isActive) {
            return null;
        }
        return this.alfrescoJobExecutor.getTransactionService().getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Date>(){

            @Override
            public Date execute() throws Throwable {
                return AlfrescoJobExecutorThread.super.getNextDueDate();
            }
        }, true);
    }

    protected void executeJob(final Job jobIn) {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                AlfrescoJobExecutorThread.this.executeJobImpl(jobIn);
                return null;
            }
        }, (String)this.getActorId(jobIn));
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    private String getActorId(Job jobIn) {
        String actorId;
        TaskInstance taskInstance = jobIn.getTaskInstance();
        if (taskInstance != null && (actorId = taskInstance.getActorId()) != null && actorId.length() > 0) {
            return actorId;
        }
        return AuthenticationUtil.getSystemUserName();
    }

    private void executeJobImpl(final Job jobIn) {
        if (!this.isActive || this.alfrescoJobExecutor.getTransactionService().isReadOnly()) {
            return;
        }
        try {
            RetryingTransactionHelper tranHelper = this.alfrescoJobExecutor.getTransactionService().getRetryingTransactionHelper();
            tranHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                @Override
                public Object execute() throws Throwable {
                    JbpmContext jbpmContext = AlfrescoJobExecutorThread.this.jbpmConfiguration.createJbpmContext();
                    try {
                        long totalLockTimeInMillis;
                        JobSession jobSession = jbpmContext.getJobSession();
                        Job job = jobSession.loadJob(jobIn.getId());
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)("executing " + job));
                        }
                        if (job.execute(jbpmContext)) {
                            jobSession.deleteJob(job);
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("executed and deleted: " + job));
                            }
                        }
                        if ((totalLockTimeInMillis = System.currentTimeMillis() - job.getLockTime().getTime()) > AlfrescoJobExecutorThread.this.jbpmMaxLockTime) {
                            logger.warn((Object)("setRollbackOnly: exceeded maxLockTime (" + AlfrescoJobExecutorThread.this.jbpmMaxLockTime + ") " + job));
                            jbpmContext.setRollbackOnly();
                        }
                    }
                    catch (Exception e) {
                        if (AlfrescoJobExecutorThread.this.isPersistenceException(e)) {
                            throw new AlfrescoJbpmPersistenceException(e);
                        }
                        throw e;
                    }
                    finally {
                        jbpmContext.close();
                    }
                    return null;
                }
            });
        }
        catch (LockAcquisitionException e) {
            this.jobLockToken = null;
        }
        catch (JbpmPersistenceException pe) {
            if (Services.isCausedByStaleState((JbpmPersistenceException)pe)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("optimistic locking failed, couldn't complete job " + jobIn), (Throwable)pe);
                }
            } else {
                this.handleException(jobIn, (Exception)((Object)pe));
            }
        }
        catch (Exception e) {
            this.handleException(jobIn, e);
        }
    }

    private void handleException(final Job jobIn, final Exception e) {
        block3: {
            if (logger.isErrorEnabled()) {
                logger.error((Object)("failed to execute " + jobIn), (Throwable)e);
            }
            try {
                RetryingTransactionHelper tranHelper = this.alfrescoJobExecutor.getTransactionService().getRetryingTransactionHelper();
                tranHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Object execute() throws Throwable {
                        JbpmContext jbpmContext = AlfrescoJobExecutorThread.this.jbpmConfiguration.createJbpmContext();
                        try {
                            JobSession jobSession = jbpmContext.getJobSession();
                            Job job = jobSession.loadJob(jobIn.getId());
                            StringWriter memoryWriter = new StringWriter();
                            e.printStackTrace(new PrintWriter(memoryWriter));
                            job.setException(memoryWriter.toString());
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("attempting to update exception/retries: " + job));
                            }
                            int retries = 0;
                            if (!AlfrescoJobExecutorThread.this.isPersistenceException(e)) {
                                retries = job.getRetries() - 1;
                            }
                            job.setRetries(retries);
                            if (logger.isInfoEnabled()) {
                                String msg = "updated job exception and set to " + job.getRetries() + " retries: " + jobIn;
                                logger.info((Object)msg);
                            }
                        }
                        finally {
                            jbpmContext.close();
                        }
                        return null;
                    }
                });
            }
            catch (Exception e2) {
                if (!logger.isErrorEnabled()) break block3;
                logger.error((Object)("failed to update job exception/retries " + jobIn), (Throwable)e2);
            }
        }
    }

    private String getExecutorLock() {
        String lockToken = null;
        if (this.alfrescoJobExecutor.getJobExecutorLockEnabled()) {
            try {
                lockToken = this.alfrescoJobExecutor.getJobLockService().getLock(LOCK_QNAME, this.jobLockTTL, 3000L, 10);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)(Thread.currentThread().getName() + " got lock token: " + lockToken));
                }
            }
            catch (LockAcquisitionException e) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"Failed to get Alfresco Job Executor lock - may already running in another thread");
                }
                throw e;
            }
        }
        return lockToken;
    }

    private void refreshExecutorLock(String lockToken) {
        if (lockToken != null) {
            try {
                this.alfrescoJobExecutor.getJobLockService().refreshLock(lockToken, LOCK_QNAME, this.jobLockTTL);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)(Thread.currentThread().getName() + " refreshed lock token: " + lockToken));
                }
            }
            catch (LockAcquisitionException e) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Failed to refresh Alfresco Job Executor lock  - may no longer exist (" + lockToken + ")"));
                }
                throw e;
            }
        }
    }

    private void releaseExecutorLock(String lockToken) {
        if (lockToken != null) {
            try {
                this.alfrescoJobExecutor.getJobLockService().releaseLock(lockToken, LOCK_QNAME);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)(Thread.currentThread().getName() + " released lock token: " + lockToken));
                }
            }
            catch (LockAcquisitionException e) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Failed to release Alfresco Job Executor lock - may no longer exist (" + lockToken + ")"));
                }
                throw e;
            }
        }
    }

    private boolean isPersistenceException(Throwable throwable) {
        do {
            if (!(throwable instanceof HibernateException)) continue;
            return true;
        } while ((throwable = throwable.getCause()) != null);
        return false;
    }

    public static class AlfrescoJbpmPersistenceException
    extends Exception
    implements DoNotRetryException {
        private static final long serialVersionUID = -2233119713831272158L;

        public AlfrescoJbpmPersistenceException(Throwable cause) {
            super(cause);
        }
    }
}

