/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.jbpm;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.zip.ZipInputStream;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authority.AuthorityDAO;
import org.alfresco.repo.workflow.AlfrescoBpmEngine;
import org.alfresco.repo.workflow.BPMEngineRegistry;
import org.alfresco.repo.workflow.WorkflowEngine;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.repo.workflow.jbpm.JBPMJpdlXmlReader;
import org.alfresco.repo.workflow.jbpm.JBPMNode;
import org.alfresco.repo.workflow.jbpm.JBPMNodeList;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowDeployment;
import org.alfresco.service.cmr.workflow.WorkflowException;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowInstanceQuery;
import org.alfresco.service.cmr.workflow.WorkflowNode;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskDefinition;
import org.alfresco.service.cmr.workflow.WorkflowTaskQuery;
import org.alfresco.service.cmr.workflow.WorkflowTaskState;
import org.alfresco.service.cmr.workflow.WorkflowTimer;
import org.alfresco.service.cmr.workflow.WorkflowTransition;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.alfresco.util.collections.CollectionUtils;
import org.alfresco.util.collections.Function;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.CacheMode;
import org.hibernate.Criteria;
import org.hibernate.FlushMode;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;
import org.hibernate.proxy.HibernateProxy;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.context.exe.TokenVariableMap;
import org.jbpm.context.exe.VariableInstance;
import org.jbpm.context.exe.converter.BooleanToStringConverter;
import org.jbpm.context.exe.variableinstance.DateInstance;
import org.jbpm.context.exe.variableinstance.LongInstance;
import org.jbpm.context.exe.variableinstance.NullInstance;
import org.jbpm.context.exe.variableinstance.StringInstance;
import org.jbpm.db.GraphSession;
import org.jbpm.db.TaskMgmtSession;
import org.jbpm.file.def.FileDefinition;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.Comment;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.graph.node.StartState;
import org.jbpm.job.Timer;
import org.jbpm.jpdl.par.ProcessArchive;
import org.jbpm.jpdl.xml.Problem;
import org.jbpm.taskmgmt.def.Task;
import org.jbpm.taskmgmt.def.TaskMgmtDefinition;
import org.jbpm.taskmgmt.exe.PooledActor;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.springframework.dao.DataAccessException;
import org.springframework.util.StringUtils;
import org.springmodules.workflow.jbpm31.JbpmAccessor;
import org.springmodules.workflow.jbpm31.JbpmCallback;
import org.springmodules.workflow.jbpm31.JbpmTemplate;

public class JBPMEngine
extends AlfrescoBpmEngine
implements WorkflowEngine {
    private static Log logger = LogFactory.getLog(JBPMEngine.class);
    protected NodeService nodeService;
    protected ServiceRegistry serviceRegistry;
    protected PersonService personService;
    protected AuthorityDAO authorityDAO;
    protected JbpmTemplate jbpmTemplate;
    protected SearchService unprotectedSearchService;
    protected StoreRef companyHomeStore;
    protected String companyHomePath;
    private Map<String, QName> ignoredProperties = new HashMap<String, QName>(3);
    private static final String COMPLETED_TASKS_QUERY = "select ti from org.jbpm.taskmgmt.exe.TaskInstance as ti where ti.actorId = :actorId and ti.isOpen = false and ti.end is not null";
    private static final String PROCESS_TIMERS_QUERY = "select timer from org.jbpm.job.Timer timer where timer.processInstance = :process ";
    private static final String WORKFLOW_PATH_SEPERATOR = "-";
    private static final String WORKFLOW_TOKEN_SEPERATOR = "@";
    private static final String TITLE_LABEL = "title";
    private static final String DESC_LABEL = "description";
    private static final String DEFAULT_TRANSITION_LABEL = "bpm_businessprocessmodel.transition";
    private static final String ERR_MANDATORY_TASK_PROPERTIES_MISSING = "Jbpm.engine.mandatory.properties.missing";
    private static final String ERR_DEPLOY_WORKFLOW = "jbpm.engine.deploy.workflow.error";
    private static final String ERR_IS_WORKFLOW_DEPLOYED = "jbpm.engine.is.workflow.deployed.error";
    private static final String ERR_UNDEPLOY_WORKFLOW = "jbpm.engine.undeploy.workflow.error";
    private static final String ERR_GET_WORKFLOW_DEF = "jbpm.engine.get.workflow.definition.error";
    private static final String ERR_GET_WORKFLOW_DEF_BY_ID = "jbpm.engine.get.workflow.definition.by.id.error";
    private static final String ERR_GET_WORKFLOW_DEF_BY_NAME = "jbpm.engine.get.workflow.definition.by.name.error";
    private static final String ERR_GET_ALL_DEFS_BY_NAME = "jbpm.engine.get.all.workflow.definitions.by.name.error";
    private static final String ERR_GET_DEF_IMAGE = "jbpm.engine.get.workflow.definition.image.error";
    private static final String ERR_GET_TASK_DEFS = "jbpm.engine.get.task.definitions.error";
    private static final String ERR_GET_PROCESS_DEF = "jbpm.engine.get.process.definition.error";
    private static final String ERR_START_WORKFLOW = "jbpm.enginestart.workflow.error";
    private static final String ERR_GET_ACTIVE_WORKFLOW_INSTS = "jbpm.engine.get.active.workflows.error";
    private static final String ERR_GET_WORKFLOW_INST_BY_ID = "jbpm.engine.get.workflow.instance.by.id.error";
    private static final String ERR_GET_PROCESS_INSTANCE = "jbpm.engine.get.process.instance.error";
    private static final String ERR_GET_WORKFLOW_PATHS = "jbpm.engine.get.workflow.paths.error";
    private static final String ERR_GET_PATH_PROPERTIES = "jbpm.engine.get.path.properties.error";
    private static final String ERR_CANCEL_WORKFLOW = "jbpm.engine.cancel.workflow.error";
    private static final String ERR_DELETE_WORKFLOW = "jbpm.engine.delete.workflow.error";
    private static final String ERR_SIGNAL_TRANSITION = "jbpm.engine.signal.transition.error";
    protected static final String ERR_INVALID_EVENT = "jbpm.engine.invalid.event";
    private static final String ERR_FIRE_EVENT = "jbpm.engine.fire.event.error";
    private static final String ERR_GET_TASKS_FOR_PATH = "jbpm.engine.get.tasks.for.path.error";
    private static final String ERR_GET_TIMERS = "jbpm.engine.get.timers.error";
    protected static final String ERR_FIND_COMPLETED_TASK_INSTS = "jbpm.engine.find.completed.task.instances.error";
    private static final String ERR_GET_ASSIGNED_TASKS = "jbpm.engine.get.assigned.tasks.error";
    private static final String ERR_GET_POOLED_TASKS = "jbpm.engine.get.pooled.tasks.error";
    private static final String ERR_QUERY_TASKS = "jbpm.engine.query.tasks.error";
    private static final String ERR_GET_TASK_INST = "jbpm.engine.get.task.instance.error";
    private static final String ERR_UPDATE_TASK = "jbpm.engine.update.task.error";
    protected static final String ERR_END_TASK_INVALID_TRANSITION = "jbpm.engine.end.task.invalid.transition";
    private static final String ERR_END_TASK = "jbpm.engine.end.task.error";
    private static final String ERR_GET_TASK_BY_ID = "jbpm.engine.get.task.by.id.error";
    private static final String ERR_GET_START_TASK = "jbpm.engine.get.start.task.error";
    private static final String ERR_COMPILE_PROCESS_DEF_zip = "jbpm.engine.compile.process.definition.zip.error";
    private static final String ERR_COMPILE_PROCESS_DEF_XML = "jbpm.engine.compile.process.definition.xml.error";
    private static final String ERR_COMPILE_PROCESS_DEF_UNSUPPORTED = "jbpm.engine.compile.process.definition.unsupported.error";
    private static final String ERR_GET_JBPM_ID = "jbpm.engine.get.jbpm.id.error";
    private static final String ERR_GET_WORKFLOW_TOKEN_INVALID = "jbpm.engine.get.workflow.token.invalid";
    private static final String ERR_GET_WORKFLOW_TOKEN_NULL = "jbpm.engine.get.workflow.token.is.null";
    private static final String ERR_SET_TASK_PROPS_INVALID_VALUE = "jbpm.engine.set.task.properties.invalid.value";
    private static final String ERR_CONVERT_VALUE = "jbpm.engine.convert.value.error";
    private static final String ERR_GET_COMPANY_HOME_INVALID = "jbpm.engine.get.company.home.invalid";
    private static final String ERR_GET_COMPANY_HOME_MULTIPLE = "jbpm.engine.get.company.home.multiple";
    public static final String ENGINE_ID = "jbpm";

    public JBPMEngine() {
        this.ignoredProperties.put(WorkflowModel.PROP_STATUS.getLocalName(), WorkflowModel.PROP_STATUS);
        this.ignoredProperties.put(WorkflowModel.PROP_PACKAGE_ITEM_ACTION_GROUP.getLocalName(), WorkflowModel.PROP_PACKAGE_ITEM_ACTION_GROUP);
        this.ignoredProperties.put(WorkflowModel.PROP_PACKAGE_ACTION_GROUP.getLocalName(), WorkflowModel.PROP_PACKAGE_ACTION_GROUP);
    }

    public void setJBPMTemplate(JbpmTemplate jbpmTemplate) {
        this.jbpmTemplate = jbpmTemplate;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setAuthorityDAO(AuthorityDAO authorityDAO) {
        this.authorityDAO = authorityDAO;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setCompanyHomePath(String companyHomePath) {
        this.companyHomePath = companyHomePath;
    }

    public void setCompanyHomeStore(String companyHomeStore) {
        this.companyHomeStore = new StoreRef(companyHomeStore);
    }

    public void setUnprotectedSearchService(SearchService unprotectedSearchService) {
        this.unprotectedSearchService = unprotectedSearchService;
    }

    @Override
    public WorkflowDeployment deployDefinition(InputStream workflowDefinition, String mimetype) {
        return this.deployDefinition(workflowDefinition, mimetype, null);
    }

    @Override
    public WorkflowDeployment deployDefinition(final InputStream workflowDefinition, final String mimetype, String name) {
        try {
            return (WorkflowDeployment)this.jbpmTemplate.execute(new JbpmCallback(){

                public Object doInJbpm(JbpmContext context) {
                    CompiledProcessDefinition compiledDef = JBPMEngine.this.compileProcessDefinition(workflowDefinition, mimetype);
                    context.deployProcessDefinition(compiledDef.def);
                    WorkflowDeployment workflowDeployment = JBPMEngine.this.createWorkflowDeployment(compiledDef);
                    return workflowDeployment;
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_DEPLOY_WORKFLOW);
            throw new WorkflowException(msg, e);
        }
    }

    @Override
    public boolean isDefinitionDeployed(final InputStream workflowDefinition, final String mimetype) {
        try {
            return (Boolean)this.jbpmTemplate.execute(new JbpmCallback(){

                public Boolean doInJbpm(JbpmContext context) {
                    String definitionName;
                    CompiledProcessDefinition processDefinition = JBPMEngine.this.compileProcessDefinition(workflowDefinition, mimetype);
                    GraphSession graphSession = context.getGraphSession();
                    ProcessDefinition existingDefinition = graphSession.findLatestProcessDefinition(definitionName = processDefinition.def.getName());
                    return existingDefinition != null;
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_IS_WORKFLOW_DEPLOYED);
            throw new WorkflowException(msg, e);
        }
    }

    @Override
    public void undeployDefinition(final String workflowDefinitionId) {
        try {
            this.jbpmTemplate.execute(new JbpmCallback(){

                public Object doInJbpm(JbpmContext context) {
                    GraphSession graphSession = context.getGraphSession();
                    ProcessDefinition processDefinition = JBPMEngine.this.getProcessDefinition(graphSession, workflowDefinitionId);
                    graphSession.deleteProcessDefinition(processDefinition);
                    return null;
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_UNDEPLOY_WORKFLOW, workflowDefinitionId);
            throw new WorkflowException(msg, e);
        }
    }

    @Override
    public List<WorkflowDefinition> getDefinitions() {
        try {
            return (List)this.jbpmTemplate.execute(new JbpmCallback(){

                public Object doInJbpm(JbpmContext context) {
                    GraphSession graphSession = context.getGraphSession();
                    List processDefs = graphSession.findLatestProcessDefinitions();
                    return JBPMEngine.this.getValidDefinitions(processDefs);
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_GET_WORKFLOW_DEF);
            throw new WorkflowException(msg, e);
        }
    }

    private List<WorkflowDefinition> getValidDefinitions(Collection<ProcessDefinition> definitions) {
        List<ProcessDefinition> filteredDefs = this.factory.filterByDomain(definitions, new Function<ProcessDefinition, String>(){

            public String apply(ProcessDefinition definition) {
                return definition.getName();
            }
        });
        return this.convertDefinitions(filteredDefs);
    }

    private List<WorkflowDefinition> convertDefinitions(Collection<ProcessDefinition> definitions) {
        return CollectionUtils.transform(definitions, (Function)new Function<ProcessDefinition, WorkflowDefinition>(){

            public WorkflowDefinition apply(ProcessDefinition value) {
                try {
                    return JBPMEngine.this.createWorkflowDefinition(value);
                }
                catch (Exception ex) {
                    logger.warn((Object)("Unable to load workflow definition: '" + value + "' due to exception."), (Throwable)ex);
                    return null;
                }
            }
        });
    }

    private List<WorkflowInstance> convertWorkflows(Collection<ProcessInstance> instances) {
        return CollectionUtils.transform(instances, (Function)new Function<ProcessInstance, WorkflowInstance>(){

            public WorkflowInstance apply(ProcessInstance value) {
                try {
                    return JBPMEngine.this.createWorkflowInstance(value);
                }
                catch (Exception ex) {
                    logger.warn((Object)("Unable to load workflow instance: '" + value + "' due to exception."), (Throwable)ex);
                    return null;
                }
            }
        });
    }

    @Override
    public List<WorkflowDefinition> getAllDefinitions() {
        try {
            return (List)this.jbpmTemplate.execute(new JbpmCallback(){

                public Object doInJbpm(JbpmContext context) {
                    GraphSession graphSession = context.getGraphSession();
                    List processDefs = graphSession.findAllProcessDefinitions();
                    return JBPMEngine.this.getValidDefinitions(processDefs);
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_GET_WORKFLOW_DEF);
            throw new WorkflowException(msg, e);
        }
    }

    @Override
    public WorkflowDefinition getDefinitionById(final String workflowDefinitionId) {
        try {
            return (WorkflowDefinition)this.jbpmTemplate.execute(new JbpmCallback(){

                public Object doInJbpm(JbpmContext context) {
                    GraphSession graphSession = context.getGraphSession();
                    ProcessDefinition processDefinition = JBPMEngine.this.getProcessDefinition(graphSession, workflowDefinitionId);
                    return JBPMEngine.this.createWorkflowDefinition(processDefinition);
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_GET_WORKFLOW_DEF_BY_ID, workflowDefinitionId);
            throw new WorkflowException(msg, e);
        }
    }

    @Override
    public WorkflowDefinition getDefinitionByName(final String workflowName) {
        try {
            return (WorkflowDefinition)this.jbpmTemplate.execute(new JbpmCallback(){

                public Object doInJbpm(JbpmContext context) {
                    String definitionName;
                    GraphSession graphSession = context.getGraphSession();
                    ProcessDefinition processDef = graphSession.findLatestProcessDefinition(definitionName = JBPMEngine.this.tenantService.getName(JBPMEngine.this.createLocalId(workflowName)));
                    return processDef == null ? null : JBPMEngine.this.createWorkflowDefinition(processDef);
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_GET_WORKFLOW_DEF_BY_NAME, workflowName);
            throw new WorkflowException(msg, e);
        }
    }

    @Override
    public List<WorkflowDefinition> getAllDefinitionsByName(final String workflowName) {
        try {
            return (List)this.jbpmTemplate.execute(new JbpmCallback(){

                public Object doInJbpm(JbpmContext context) {
                    GraphSession graphSession = context.getGraphSession();
                    String definitionName = JBPMEngine.this.tenantService.getName(JBPMEngine.this.createLocalId(workflowName));
                    List processDefs = graphSession.findAllProcessDefinitionVersions(definitionName);
                    return JBPMEngine.this.convertDefinitions(processDefs);
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_GET_ALL_DEFS_BY_NAME, workflowName);
            throw new WorkflowException(msg, e);
        }
    }

    @Override
    public byte[] getDefinitionImage(final String workflowDefinitionId) {
        try {
            return (byte[])this.jbpmTemplate.execute(new JbpmCallback(){

                public Object doInJbpm(JbpmContext context) {
                    GraphSession graphSession = context.getGraphSession();
                    ProcessDefinition processDefinition = JBPMEngine.this.getProcessDefinition(graphSession, workflowDefinitionId);
                    FileDefinition fileDefinition = processDefinition.getFileDefinition();
                    return fileDefinition == null ? null : fileDefinition.getBytes("processimage.jpg");
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_GET_DEF_IMAGE, workflowDefinitionId);
            throw new WorkflowException(msg, e);
        }
    }

    @Override
    public List<WorkflowTaskDefinition> getTaskDefinitions(final String workflowDefinitionId) {
        try {
            return (List)this.jbpmTemplate.execute(new JbpmCallback(){

                public Object doInJbpm(JbpmContext context) {
                    GraphSession graphSession = context.getGraphSession();
                    ProcessDefinition processDefinition = JBPMEngine.this.getProcessDefinition(graphSession, workflowDefinitionId);
                    if (processDefinition == null) {
                        return null;
                    }
                    String processName = processDefinition.getName();
                    if (JBPMEngine.this.tenantService.isEnabled()) {
                        JBPMEngine.this.tenantService.checkDomain(processName);
                    }
                    TaskMgmtDefinition taskMgmtDef = processDefinition.getTaskMgmtDefinition();
                    ArrayList<WorkflowTaskDefinition> workflowTaskDefs = new ArrayList<WorkflowTaskDefinition>();
                    for (Object task : taskMgmtDef.getTasks().values()) {
                        workflowTaskDefs.add(JBPMEngine.this.createWorkflowTaskDefinition((Task)task));
                    }
                    return workflowTaskDefs.size() == 0 ? null : workflowTaskDefs;
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_GET_TASK_DEFS, workflowDefinitionId);
            throw new WorkflowException(msg, e);
        }
    }

    protected ProcessDefinition getProcessDefinition(GraphSession graphSession, String workflowDefinitionId) {
        ProcessDefinition processDefinition = graphSession.getProcessDefinition(this.getJbpmId(workflowDefinitionId));
        if (processDefinition != null && this.tenantService.isEnabled()) {
            try {
                this.tenantService.checkDomain(processDefinition.getName());
            }
            catch (RuntimeException re) {
                processDefinition = null;
            }
        }
        if (processDefinition == null) {
            String msg = this.messageService.getMessage(ERR_GET_PROCESS_DEF, workflowDefinitionId);
            throw new WorkflowException(msg);
        }
        return processDefinition;
    }

    @Override
    public WorkflowPath startWorkflow(final String workflowDefinitionId, final Map<QName, Serializable> parameters) {
        try {
            return (WorkflowPath)this.jbpmTemplate.execute(new JbpmCallback(){

                public Object doInJbpm(JbpmContext context) {
                    Serializable packageNode;
                    String currentUserName = AuthenticationUtil.getFullyAuthenticatedUser();
                    context.setActorId(currentUserName);
                    GraphSession graphSession = context.getGraphSession();
                    ProcessDefinition processDefinition = JBPMEngine.this.getProcessDefinition(graphSession, workflowDefinitionId);
                    ProcessInstance processInstance = new ProcessInstance(processDefinition);
                    processInstance.setKey(GUID.generate());
                    ContextInstance processContext = processInstance.getContextInstance();
                    processContext.setVariable("cancelled", (Object)false);
                    if (parameters != null && (packageNode = (Serializable)parameters.get(WorkflowModel.ASSOC_PACKAGE)) != null) {
                        String pckgName = JBPMEngine.this.factory.mapQNameToName(WorkflowModel.ASSOC_PACKAGE);
                        processContext.setVariable(pckgName, (Object)new JBPMNode((NodeRef)packageNode, JBPMEngine.this.serviceRegistry));
                    }
                    NodeRef companyHome = JBPMEngine.this.getCompanyHome();
                    processContext.setVariable("companyhome", (Object)new JBPMNode(companyHome, JBPMEngine.this.serviceRegistry));
                    NodeRef initiatorPerson = JBPMEngine.this.mapNameToPerson(currentUserName);
                    if (initiatorPerson != null) {
                        processContext.setVariable("initiator", (Object)new JBPMNode(initiatorPerson, JBPMEngine.this.serviceRegistry));
                        NodeRef initiatorHome = (NodeRef)JBPMEngine.this.nodeService.getProperty(initiatorPerson, ContentModel.PROP_HOMEFOLDER);
                        if (initiatorHome != null) {
                            processContext.setVariable("initiatorhome", (Object)new JBPMNode(initiatorHome, JBPMEngine.this.serviceRegistry));
                        }
                    }
                    processContext.setVariable("workflowinstanceid", (Object)JBPMEngine.this.createGlobalId(new Long(processInstance.getId()).toString()));
                    Token token = processInstance.getRootToken();
                    Task startTask = processInstance.getTaskMgmtInstance().getTaskMgmtDefinition().getStartTask();
                    if (startTask != null) {
                        TaskInstance taskInstance = processInstance.getTaskMgmtInstance().createStartTaskInstance();
                        JBPMEngine.this.setTaskProperties(taskInstance, parameters);
                        token = taskInstance.getToken();
                    }
                    context.save(processInstance);
                    return JBPMEngine.this.createWorkflowPath(token);
                }
            });
        }
        catch (JbpmException e) {
            throw this.getStartWorkflowException(workflowDefinitionId, (Exception)((Object)e));
        }
        catch (DataAccessException e) {
            throw this.getStartWorkflowException(workflowDefinitionId, (Exception)((Object)e));
        }
    }

    private WorkflowException getStartWorkflowException(String workflowDefinitionId, Exception e) {
        String msg = this.messageService.getMessage(ERR_START_WORKFLOW, workflowDefinitionId);
        return new WorkflowException(msg, e);
    }

    @Override
    public List<WorkflowInstance> getActiveWorkflows() {
        return this.getWorkflows(new WorkflowInstanceQuery(true));
    }

    @Override
    public List<WorkflowInstance> getCompletedWorkflows() {
        return this.getWorkflows(new WorkflowInstanceQuery(false));
    }

    @Override
    public List<WorkflowInstance> getWorkflows() {
        return this.getWorkflows(new WorkflowInstanceQuery());
    }

    @Override
    public List<WorkflowInstance> getActiveWorkflows(String workflowDefinitionId) {
        return this.getWorkflows(new WorkflowInstanceQuery(workflowDefinitionId, true));
    }

    @Override
    public List<WorkflowInstance> getCompletedWorkflows(String workflowDefinitionId) {
        return this.getWorkflows(new WorkflowInstanceQuery(workflowDefinitionId, false));
    }

    @Override
    public List<WorkflowInstance> getWorkflows(String workflowDefinitionId) {
        return this.getWorkflows(new WorkflowInstanceQuery(workflowDefinitionId));
    }

    @Override
    public List<WorkflowInstance> getWorkflows(WorkflowInstanceQuery query) {
        try {
            List<ProcessInstance> instances = this.getProcessInstances(query);
            return this.convertWorkflows(instances);
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_GET_ACTIVE_WORKFLOW_INSTS, query.getWorkflowDefinitionId());
            throw new WorkflowException(msg, e);
        }
    }

    private List<ProcessInstance> getProcessInstances(final WorkflowInstanceQuery query) {
        return (List)this.jbpmTemplate.execute(new JbpmCallback(){

            public Object doInJbpm(JbpmContext context) {
                List<String> exludedDefs;
                Long processDefId;
                Session session = context.getSession();
                StringBuilder processSelect = new StringBuilder(1024).append("select process from org.jbpm.graph.exe.ProcessInstance as process");
                StringBuilder processWhere = new StringBuilder(1024);
                TreeMap<String, Object> processMap = new TreeMap<String, Object>();
                Long l = processDefId = query.getWorkflowDefinitionId() == null ? null : Long.valueOf(JBPMEngine.this.getJbpmId(query.getWorkflowDefinitionId()));
                if (processDefId != null) {
                    processSelect.append(" join process.processDefinition as definition");
                    processWhere.append(" and definition.id = :processDefId");
                    processMap.put("processDefId", processDefId);
                }
                if ((exludedDefs = query.getExcludedDefinitions()) != null && exludedDefs.size() > 0) {
                    if (processDefId == null) {
                        processSelect.append(" join process.processDefinition as definition");
                    }
                    for (String exDef : exludedDefs) {
                        exDef = BPMEngineRegistry.getLocalId(exDef);
                        exDef = exDef.replaceAll("\\*", "%");
                        processWhere.append(" and definition.name not like '").append(exDef).append("'");
                    }
                }
                if (Boolean.TRUE.equals(query.getActive())) {
                    processWhere.append(" and process.end is null");
                } else if (Boolean.FALSE.equals(query.getActive())) {
                    processWhere.append(" and process.end is not null");
                }
                if (query.getStartBefore() != null) {
                    processWhere.append(" and process.start <= :processStartBefore");
                    processMap.put("processStartBefore", query.getStartBefore());
                }
                if (query.getStartAfter() != null) {
                    processWhere.append(" and process.start >= :processStartAfter");
                    processMap.put("processStartAfter", query.getStartAfter());
                }
                if (query.getEndBefore() != null) {
                    processWhere.append(" and process.end <= :processEndBefore");
                    processMap.put("processEndBefore", query.getEndBefore());
                }
                if (query.getEndAfter() != null) {
                    processWhere.append(" and process.end >= :processEndAfter");
                    processMap.put("processEndAfter", query.getEndAfter());
                }
                if (query.getCustomProps() != null) {
                    processSelect.append(" join process.instances as contextInstance").append(" join contextInstance.tokenVariableMaps as tokenVariableMap");
                    processWhere.append(" and contextInstance.class = org.jbpm.context.exe.ContextInstance").append(" and tokenVariableMap.token = process.rootToken");
                    int i = 0;
                    for (Map.Entry<QName, Object> prop : query.getCustomProps().entrySet()) {
                        String variable = "var" + ++i;
                        processMap.put(variable + "name", JBPMEngine.this.factory.mapQNameToName(prop.getKey()));
                        if (prop.getValue() == null) {
                            processSelect.append(", ").append(NullInstance.class.getName()).append(" as ").append(variable);
                            processWhere.append(" and ").append(variable).append(".tokenVariableMap = tokenVariableMap").append(" and ").append(variable).append(".name = :").append(variable).append("name");
                            continue;
                        }
                        PropertyDefinition propertyDefinition = JBPMEngine.this.dictionaryService.getProperty(prop.getKey());
                        if (propertyDefinition == null) {
                            processSelect.append(", ").append(StringInstance.class.getName()).append(" as ").append(variable);
                            processWhere.append(" and ").append(variable).append(".tokenVariableMap = tokenVariableMap").append(" and ").append(variable).append(".name = :").append(variable).append("name").append(" and ").append(variable).append(".value = :").append(variable).append("value");
                            processMap.put(variable + "value", prop.getValue().toString());
                            continue;
                        }
                        String propertyType = propertyDefinition.getDataType().getJavaClassName();
                        if (propertyType.equals("java.lang.String")) {
                            processSelect.append(", ").append(StringInstance.class.getName()).append(" as ").append(variable);
                            processWhere.append(" and ").append(variable).append(".tokenVariableMap = tokenVariableMap").append(" and ").append(variable).append(".name = :").append(variable).append("name").append(" and ").append(variable).append(".value = :").append(variable).append("value");
                            processMap.put(variable + "value", prop.getValue().toString());
                            continue;
                        }
                        if (propertyType.equals("java.lang.Long") || propertyType.equals("java.lang.Integer")) {
                            processSelect.append(", ").append(LongInstance.class.getName()).append(" as ").append(variable);
                            processWhere.append(" and ").append(variable).append(".tokenVariableMap = tokenVariableMap").append(" and ").append(variable).append(".name = :").append(variable).append("name").append(" and ").append(variable).append(".value = :").append(variable).append("value");
                            processMap.put(variable + "value", new Long(prop.getValue().toString()));
                            continue;
                        }
                        if (!propertyType.equals("java.util.Date")) continue;
                        processSelect.append(", ").append(DateInstance.class.getName()).append(" as ").append(variable);
                        Map dateProps = (Map)prop.getValue();
                        int datePropNum = 0;
                        for (Map.Entry dateProp : dateProps.entrySet()) {
                            ++datePropNum;
                            if (dateProp.getValue() == null) continue;
                            processWhere.append(" and ").append(variable).append(".tokenVariableMap = tokenVariableMap").append(" and ").append(variable).append(".name = :").append(variable).append("name");
                            if (dateProp.getKey() == WorkflowInstanceQuery.DatePosition.BEFORE) {
                                processMap.put(variable + "value" + datePropNum, JBPMEngine.this.calculateBeforeMidnight((Date)dateProp.getValue()));
                                processWhere.append(" and ").append(variable).append(".value <= :").append(variable).append("value").append(datePropNum);
                            }
                            if (dateProp.getKey() != WorkflowInstanceQuery.DatePosition.AFTER) continue;
                            processMap.put(variable + "value" + datePropNum, JBPMEngine.this.calculateMidnight((Date)dateProp.getValue()));
                            processWhere.append(" and ").append(variable).append(".value >= :").append(variable).append("value").append(datePropNum);
                        }
                    }
                }
                if (processWhere.length() > 4) {
                    processSelect.append(" where");
                    processSelect.append(processWhere, 4, processWhere.length());
                }
                processSelect.append(" order by process.id");
                return session.createQuery(processSelect.toString()).setProperties(processMap).list();
            }
        });
    }

    private Date calculateBeforeMidnight(Date date) {
        Date calc = DateUtils.truncate((Date)date, (int)5);
        calc = DateUtils.addDays((Date)calc, (int)1);
        return DateUtils.addSeconds((Date)calc, (int)-1);
    }

    private Date calculateMidnight(Date date) {
        return DateUtils.truncate((Date)date, (int)5);
    }

    @Override
    public WorkflowInstance getWorkflowById(final String workflowId) {
        try {
            return (WorkflowInstance)this.jbpmTemplate.execute(new JbpmCallback(){

                public Object doInJbpm(JbpmContext context) {
                    GraphSession graphSession = context.getGraphSession();
                    ProcessInstance processInstance = JBPMEngine.this.getProcessInstanceIfExists(graphSession, workflowId);
                    try {
                        return JBPMEngine.this.createWorkflowInstance(processInstance);
                    }
                    catch (Exception ex) {
                        logger.warn((Object)("Unable to load workflow instance: '" + processInstance + "' due to exception."), (Throwable)ex);
                        return null;
                    }
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_GET_WORKFLOW_INST_BY_ID);
            throw new WorkflowException(msg, e);
        }
    }

    private ProcessInstance getProcessInstanceIfExists(GraphSession graphSession, String workflowId) {
        ProcessInstance processInstance = graphSession.getProcessInstance(this.getJbpmId(workflowId));
        if (processInstance != null && this.tenantService.isEnabled()) {
            try {
                this.tenantService.checkDomain(processInstance.getProcessDefinition().getName());
            }
            catch (RuntimeException re) {
                processInstance = null;
            }
        }
        return processInstance;
    }

    protected ProcessInstance getProcessInstance(GraphSession graphSession, String workflowId) {
        ProcessInstance processInstance = this.getProcessInstanceIfExists(graphSession, workflowId);
        if (processInstance == null) {
            String msg = this.messageService.getMessage(ERR_GET_PROCESS_INSTANCE, workflowId);
            throw new WorkflowException(msg);
        }
        return processInstance;
    }

    @Override
    public List<WorkflowPath> getWorkflowPaths(final String workflowId) {
        try {
            return (List)this.jbpmTemplate.execute(new JbpmCallback(){

                public Object doInJbpm(JbpmContext context) {
                    GraphSession graphSession = context.getGraphSession();
                    ProcessInstance processInstance = JBPMEngine.this.getProcessInstance(graphSession, workflowId);
                    List tokens = processInstance.findAllTokens();
                    ArrayList<WorkflowPath> paths = new ArrayList<WorkflowPath>(tokens.size());
                    for (Token token : tokens) {
                        if (token.hasEnded()) continue;
                        WorkflowPath path = JBPMEngine.this.createWorkflowPath(token);
                        paths.add(path);
                    }
                    return paths;
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_GET_WORKFLOW_PATHS, workflowId);
            throw new WorkflowException(msg, e);
        }
    }

    @Override
    public Map<QName, Serializable> getPathProperties(final String pathId) {
        try {
            return (Map)this.jbpmTemplate.execute(new JbpmCallback(){

                public Map<QName, Serializable> doInJbpm(JbpmContext context) {
                    Token token;
                    GraphSession graphSession = context.getGraphSession();
                    ContextInstance instanceContext = token.getProcessInstance().getContextInstance();
                    HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>(10);
                    for (token = JBPMEngine.this.getWorkflowToken(graphSession, pathId); token != null; token = token.getParent()) {
                        TokenVariableMap varMap = instanceContext.getTokenVariableMap(token);
                        if (varMap == null) continue;
                        Map tokenVars = varMap.getVariablesLocally();
                        for (Map.Entry entry : tokenVars.entrySet()) {
                            String key = (String)entry.getKey();
                            QName qname = JBPMEngine.this.factory.mapNameToQName(key);
                            if (properties.containsKey(qname)) continue;
                            Serializable value = JBPMEngine.this.convertValue(entry.getValue());
                            properties.put(qname, value);
                        }
                    }
                    return properties;
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_GET_PATH_PROPERTIES, pathId);
            throw new WorkflowException(msg, e);
        }
    }

    @Override
    public WorkflowInstance cancelWorkflow(String workflowId) {
        return this.cancelWorkflows(Collections.singletonList(workflowId)).get(0);
    }

    @Override
    public List<WorkflowInstance> cancelWorkflows(final List<String> workflowIds) {
        return (List)this.jbpmTemplate.execute(new JbpmCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doInJbpm(JbpmContext context) {
                Session session = context.getSession();
                CacheMode cacheMode = session.getCacheMode();
                FlushMode flushMode = session.getFlushMode();
                session.setCacheMode(CacheMode.GET);
                session.setFlushMode(FlushMode.MANUAL);
                try {
                    ProcessInstance processInstance;
                    ArrayList<WorkflowInstance> workflowInstances = new ArrayList<WorkflowInstance>(workflowIds.size());
                    HashMap<String, ProcessInstance> processInstances = new HashMap<String, ProcessInstance>(workflowIds.size() * 2);
                    GraphSession graphSession = context.getGraphSession();
                    for (String workflowId : workflowIds) {
                        try {
                            processInstance = JBPMEngine.this.getProcessInstance(graphSession, workflowId);
                            processInstance.getContextInstance().setVariable("cancelled", (Object)true);
                            processInstance.end();
                            processInstances.put(workflowId, processInstance);
                        }
                        catch (JbpmException e) {
                            String msg = JBPMEngine.this.messageService.getMessage(JBPMEngine.ERR_CANCEL_WORKFLOW, workflowId);
                            throw new WorkflowException(msg, JbpmAccessor.convertJbpmException((JbpmException)e));
                        }
                    }
                    session.flush();
                    for (String workflowId : workflowIds) {
                        try {
                            processInstance = (ProcessInstance)processInstances.get(workflowId);
                            try {
                                workflowInstances.add(JBPMEngine.this.createWorkflowInstance(processInstance));
                            }
                            catch (Exception ex) {
                                logger.warn((Object)("Unable to load workflow instance: '" + processInstance + "' due to exception."), (Throwable)ex);
                            }
                            graphSession.deleteProcessInstance(processInstance, true, true);
                        }
                        catch (JbpmException e) {
                            String msg = JBPMEngine.this.messageService.getMessage(JBPMEngine.ERR_CANCEL_WORKFLOW, workflowId);
                            throw new WorkflowException(msg, JbpmAccessor.convertJbpmException((JbpmException)e));
                        }
                    }
                    session.flush();
                    ArrayList<WorkflowInstance> arrayList = workflowInstances;
                    return arrayList;
                }
                finally {
                    session.setCacheMode(cacheMode);
                    session.setFlushMode(flushMode);
                }
            }
        });
    }

    @Override
    public WorkflowInstance deleteWorkflow(final String workflowId) {
        try {
            return (WorkflowInstance)this.jbpmTemplate.execute(new JbpmCallback(){

                public Object doInJbpm(JbpmContext context) {
                    GraphSession graphSession = context.getGraphSession();
                    ProcessInstance processInstance = JBPMEngine.this.getProcessInstance(graphSession, workflowId);
                    graphSession.deleteProcessInstance(processInstance, true, true);
                    Date endDate = new Date();
                    WorkflowInstance workflowInstance = JBPMEngine.this.createWorkflowInstance(processInstance, endDate);
                    return workflowInstance;
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_DELETE_WORKFLOW, workflowId);
            throw new WorkflowException(msg, e);
        }
    }

    @Override
    public WorkflowPath signal(final String pathId, final String transition) {
        try {
            return (WorkflowPath)this.jbpmTemplate.execute(new JbpmCallback(){

                public Object doInJbpm(JbpmContext context) {
                    GraphSession graphSession = context.getGraphSession();
                    Token token = JBPMEngine.this.getWorkflowToken(graphSession, pathId);
                    if (transition == null) {
                        token.signal();
                    } else {
                        Node node = token.getNode();
                        if (!node.hasLeavingTransition(transition)) {
                            throw new WorkflowException("Transition '" + transition + "' is invalid for Workflow path '" + pathId + "'");
                        }
                        token.signal(transition);
                    }
                    ProcessInstance processInstance = token.getProcessInstance();
                    context.save(processInstance);
                    return JBPMEngine.this.createWorkflowPath(token);
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_SIGNAL_TRANSITION, transition, pathId);
            throw new WorkflowException(msg, e);
        }
    }

    @Override
    public WorkflowPath fireEvent(final String pathId, final String event) {
        try {
            return (WorkflowPath)this.jbpmTemplate.execute(new JbpmCallback(){

                public Object doInJbpm(JbpmContext context) {
                    if (event.equals("after-signal") || event.equals("before-signal") || event.equals("node-enter") || event.equals("node-leave") || event.equals("process-end") || event.equals("process-start") || event.equals("subprocess-created") || event.equals("subprocess-end") || event.equals("superstate-enter") || event.equals("superstate-leave") || event.equals("task-assign") || event.equals("task-create") || event.equals("task-end") || event.equals("task-start") || event.equals("timer") || event.equals("transition")) {
                        String msg = JBPMEngine.this.messageService.getMessage(JBPMEngine.ERR_INVALID_EVENT, event);
                        throw new WorkflowException(msg);
                    }
                    GraphSession graphSession = context.getGraphSession();
                    Token token = JBPMEngine.this.getWorkflowToken(graphSession, pathId);
                    ExecutionContext executionContext = new ExecutionContext(token);
                    TaskMgmtSession taskSession = context.getTaskMgmtSession();
                    List tasks = taskSession.findTaskInstancesByToken(token.getId());
                    if (tasks.size() == 0) {
                        Node node = token.getNode();
                        node.fireEvent(event, executionContext);
                    } else {
                        for (TaskInstance task : tasks) {
                            executionContext.setTaskInstance(task);
                            task.getTask().fireEvent(event, executionContext);
                        }
                    }
                    ProcessInstance processInstance = token.getProcessInstance();
                    context.save(processInstance);
                    return JBPMEngine.this.createWorkflowPath(token);
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_FIRE_EVENT, event, pathId);
            throw new WorkflowException(msg, e);
        }
    }

    @Override
    public List<WorkflowTask> getTasksForWorkflowPath(String pathId) {
        return this.getTasksForWorkflowPath(pathId, false);
    }

    public List<WorkflowTask> getTasksForWorkflowPath(final String pathId, final boolean sameSession) {
        try {
            return (List)this.jbpmTemplate.execute(new JbpmCallback(){

                public List<WorkflowTask> doInJbpm(JbpmContext context) {
                    GraphSession graphSession = context.getGraphSession();
                    Token token = JBPMEngine.this.getWorkflowToken(graphSession, pathId);
                    TaskMgmtSession taskSession = context.getTaskMgmtSession();
                    List tasks = taskSession.findTaskInstancesByToken(token.getId());
                    return JBPMEngine.this.getWorkflowTasks(tasks, sameSession);
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_GET_TASKS_FOR_PATH, pathId);
            throw new WorkflowException(msg, e);
        }
    }

    @Override
    public List<WorkflowTimer> getTimers(final String workflowId) {
        try {
            return (List)this.jbpmTemplate.execute(new JbpmCallback(){

                public List<WorkflowTimer> doInJbpm(JbpmContext context) {
                    GraphSession graphSession = context.getGraphSession();
                    ProcessInstance process = JBPMEngine.this.getProcessInstance(graphSession, workflowId);
                    Session session = context.getSession();
                    Query query = session.createQuery(JBPMEngine.PROCESS_TIMERS_QUERY);
                    query.setEntity("process", (Object)process);
                    List timers = query.list();
                    ArrayList<WorkflowTimer> workflowTimers = new ArrayList<WorkflowTimer>(timers.size());
                    for (Timer timer : timers) {
                        WorkflowTimer workflowTimer = JBPMEngine.this.createWorkflowTimer(timer);
                        workflowTimers.add(workflowTimer);
                    }
                    return workflowTimers;
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_GET_TIMERS, workflowId);
            throw new WorkflowException(msg, e);
        }
    }

    @Override
    public boolean hasWorkflowImage(String workflowInstanceId) {
        return false;
    }

    @Override
    public InputStream getWorkflowImage(String workflowInstanceId) {
        return null;
    }

    @Override
    public List<WorkflowTask> getAssignedTasks(String authority, WorkflowTaskState state) {
        return this.getAssignedTasks(authority, state, false);
    }

    public List<WorkflowTask> getAssignedTasks(final String authority, final WorkflowTaskState state, final boolean sameSession) {
        try {
            return (List)this.jbpmTemplate.execute(new JbpmCallback(){

                public List<WorkflowTask> doInJbpm(JbpmContext context) {
                    if (state.equals((Object)WorkflowTaskState.IN_PROGRESS)) {
                        return JBPMEngine.this.findActiveTaskInstances(authority, context);
                    }
                    List tasks = JBPMEngine.this.findCompletedTaskInstances(context, authority);
                    return JBPMEngine.this.getWorkflowTasks(tasks, sameSession);
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_GET_ASSIGNED_TASKS, new Object[]{authority, state});
            throw new WorkflowException(msg, e);
        }
    }

    private List<TaskInstance> findCompletedTaskInstances(JbpmContext jbpmContext, String actorId) {
        List result = null;
        try {
            Session session = jbpmContext.getSession();
            Query query = session.createQuery(COMPLETED_TASKS_QUERY);
            query.setString("actorId", actorId);
            result = query.list();
        }
        catch (Exception e) {
            String msg = this.messageService.getMessage(ERR_FIND_COMPLETED_TASK_INSTS, actorId);
            throw new JbpmException(msg, (Throwable)e);
        }
        return result;
    }

    private List<WorkflowTask> findActiveTaskInstances(String authority, JbpmContext context) {
        Session session = context.getSession();
        Query query = session.getNamedQuery("org.alfresco.repo.workflow.findTaskInstancesByActorId");
        query.setString("actorId", authority);
        query.setBoolean("true", true);
        List<WorkflowTask> workflowTasks = this.getWorkflowTasks(session, query.list());
        return workflowTasks;
    }

    protected List<WorkflowTask> getWorkflowTasks(Session session, List<Object[]> rows) {
        ArrayList<WorkflowTask> workflowTasks = new ArrayList<WorkflowTask>(rows.size());
        ArrayList<Long> taskInstanceIds = new ArrayList<Long>(rows.size());
        ArrayList<Long> contextInstanceIds = new ArrayList<Long>(rows.size());
        for (Object[] row : rows) {
            TaskInstance ti = (TaskInstance)row[0];
            taskInstanceIds.add(ti.getId());
            ContextInstance ci = (ContextInstance)row[8];
            contextInstanceIds.add(ci.getId());
        }
        HashMap<Long, TaskInstance> taskInstanceCache = new HashMap(rows.size());
        if (taskInstanceIds.size() > 0) {
            taskInstanceCache = this.cacheTasks(session, taskInstanceIds);
        }
        HashMap<Long, TokenVariableMap> variablesCache = new HashMap(rows.size());
        if (contextInstanceIds.size() > 0) {
            variablesCache = this.cacheVariables(session, contextInstanceIds);
        }
        taskInstanceIds.clear();
        contextInstanceIds.clear();
        for (Object[] row : rows) {
            try {
                WorkflowTask workflowTask = this.makeWorkflowTask(row, taskInstanceCache, variablesCache);
                if (workflowTask == null) continue;
                workflowTasks.add(workflowTask);
            }
            catch (Exception ex) {
                logger.warn((Object)("Unable to load workflow instance: '" + row[0] + "' due to exception."), (Throwable)ex);
            }
        }
        return workflowTasks;
    }

    private WorkflowTask makeWorkflowTask(Object[] row, Map<Long, TaskInstance> taskInstanceCache, Map<Long, TokenVariableMap> variablesCache) {
        TaskInstance ti = (TaskInstance)row[0];
        Token token = (Token)row[2];
        ProcessInstance processInstance = (ProcessInstance)row[3];
        Node node = (Node)row[4];
        Task task = (Task)row[5];
        ProcessDefinition processDefinition = (ProcessDefinition)row[6];
        Task startTask = (Task)row[7];
        ContextInstance contextInstance = (ContextInstance)row[8];
        if (this.tenantService.isEnabled()) {
            try {
                this.tenantService.checkDomain(processDefinition.getName());
            }
            catch (RuntimeException re) {
                return null;
            }
        }
        TaskInstance helperTi = taskInstanceCache.get(ti.getId());
        Map variables = variablesCache.get(contextInstance.getTokenVariableMap(token).getToken().getId()).getVariables();
        Map<QName, Serializable> properties = this.getTaskProperties(helperTi != null ? helperTi : ti, false, variablesCache);
        WorkflowDefinition wfDef = this.createWorkflowDefinition(processDefinition, startTask);
        WorkflowInstance instance = this.createWorkflowInstance(processInstance, wfDef, null, variables);
        WorkflowNode wfNode = this.createWorkflowNode(node);
        WorkflowPath path = this.createWorkflowPath(token, instance, wfNode);
        WorkflowTaskDefinition taskDef = this.createWorkflowTaskDefinition(task);
        return this.createWorkflowTask(ti, taskDef, path, properties);
    }

    private Map<Long, TokenVariableMap> cacheVariables(Session session, List<Long> ids) {
        int batchSize = 800;
        ArrayList<Long> batch = new ArrayList<Long>(ids.size());
        HashMap<Long, TokenVariableMap> cachedResults = new HashMap<Long, TokenVariableMap>();
        for (Long id : ids) {
            batch.add(id);
            if (batch.size() < batchSize) continue;
            this.cacheVariablesNoBatch(session, batch, cachedResults);
            batch.clear();
        }
        if (batch.size() > 0) {
            this.cacheVariablesNoBatch(session, batch, cachedResults);
        }
        batch.clear();
        return cachedResults;
    }

    private void cacheVariablesNoBatch(Session session, List<Long> contextInstanceIds, Map<Long, TokenVariableMap> variablesCache) {
        Query query = session.getNamedQuery("org.alfresco.repo.workflow.cacheInstanceVariables");
        query.setParameterList("ids", contextInstanceIds);
        query.setCacheMode(CacheMode.PUT);
        query.setFlushMode(FlushMode.MANUAL);
        query.setCacheable(true);
        List results = query.list();
        for (TokenVariableMap tokenVariableMap : results) {
            variablesCache.put(tokenVariableMap.getToken().getId(), tokenVariableMap);
        }
    }

    private Map<Long, TaskInstance> cacheTasks(Session session, List<Long> ids) {
        int batchSize = 800;
        ArrayList<Long> batch = new ArrayList<Long>(ids.size());
        HashMap<Long, TaskInstance> cachedResults = new HashMap<Long, TaskInstance>();
        for (Long id : ids) {
            batch.add(id);
            if (batch.size() < batchSize) continue;
            this.cacheTasksNoBatch(session, batch, cachedResults);
            batch.clear();
        }
        if (batch.size() > 0) {
            this.cacheTasksNoBatch(session, batch, cachedResults);
        }
        batch.clear();
        return cachedResults;
    }

    private void cacheTasksNoBatch(Session session, List<Long> taskInstanceIds, Map<Long, TaskInstance> returnMap) {
        Query query = session.getNamedQuery("org.alfresco.repo.workflow.cacheTaskInstanceProperties");
        query.setParameterList("ids", taskInstanceIds);
        query.setCacheMode(CacheMode.PUT);
        query.setFlushMode(FlushMode.MANUAL);
        query.setCacheable(true);
        List results = query.list();
        for (TaskInstance taskInstance : results) {
            returnMap.put(taskInstance.getId(), taskInstance);
        }
    }

    @Override
    public List<WorkflowTask> getPooledTasks(final List<String> authorities) {
        try {
            return (List)this.jbpmTemplate.execute(new JbpmCallback(){

                public List<WorkflowTask> doInJbpm(JbpmContext context) {
                    TaskMgmtSession taskSession = context.getTaskMgmtSession();
                    List tasks = taskSession.findPooledTaskInstances(authorities);
                    return JBPMEngine.this.getWorkflowTasks(tasks);
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_GET_POOLED_TASKS, authorities);
            throw new WorkflowException(msg, e);
        }
    }

    @Override
    public List<WorkflowTask> queryTasks(WorkflowTaskQuery query) {
        return this.queryTasks(query, false);
    }

    @Override
    public List<WorkflowTask> queryTasks(final WorkflowTaskQuery query, final boolean sameSession) {
        try {
            return (List)this.jbpmTemplate.execute(new JbpmCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public List<WorkflowTask> doInJbpm(JbpmContext context) {
                    Session session = context.getSession();
                    CacheMode cacheMode = session.getCacheMode();
                    try {
                        session.setCacheMode(CacheMode.GET);
                        Criteria criteria = JBPMEngine.this.createTaskQueryCriteria(session, query);
                        List tasks = criteria.list();
                        List<WorkflowTask> list = JBPMEngine.this.getWorkflowTasks(tasks, sameSession);
                        return list;
                    }
                    finally {
                        session.setCacheMode(cacheMode);
                    }
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_QUERY_TASKS, query);
            throw new WorkflowException(msg, e);
        }
    }

    protected List<WorkflowTask> getWorkflowTasks(List<TaskInstance> tasks) {
        return this.getWorkflowTasks(tasks, false);
    }

    protected List<WorkflowTask> getWorkflowTasks(List<TaskInstance> tasks, boolean sameSession) {
        AbstractList workflowTasks;
        List<TaskInstance> filteredTasks;
        if (this.tenantService.isEnabled()) {
            filteredTasks = new ArrayList<TaskInstance>(tasks.size());
            for (TaskInstance task : tasks) {
                try {
                    this.tenantService.checkDomain(task.getTask().getProcessDefinition().getName());
                    filteredTasks.add(task);
                }
                catch (RuntimeException re) {}
            }
        } else {
            filteredTasks = tasks;
        }
        if (sameSession) {
            workflowTasks = new AbstractList<WorkflowTask>(){

                @Override
                public WorkflowTask get(int index) {
                    TaskInstance task = (TaskInstance)filteredTasks.get(index);
                    return JBPMEngine.this.createWorkflowTask(task);
                }

                @Override
                public int size() {
                    return filteredTasks.size();
                }
            };
        } else {
            workflowTasks = new ArrayList(filteredTasks.size());
            for (TaskInstance task : filteredTasks) {
                try {
                    WorkflowTask workflowTask = this.createWorkflowTask(task);
                    workflowTasks.add(workflowTask);
                }
                catch (Exception ex) {
                    logger.warn((Object)("Unable to load workflow task: '" + task + "' due to exception."), (Throwable)ex);
                }
            }
        }
        return workflowTasks;
    }

    private Criteria createTaskQueryCriteria(Session session, WorkflowTaskQuery query) {
        Map<QName, Object> props;
        Map<QName, Object> props2;
        Criteria task = session.createCriteria(TaskInstance.class);
        if (query.getTaskId() != null) {
            task.add((Criterion)Restrictions.eq((String)"id", (Object)this.getJbpmId(query.getTaskId())));
        }
        if (query.getTaskState() != null) {
            WorkflowTaskState state = query.getTaskState();
            if (state == WorkflowTaskState.IN_PROGRESS) {
                task.add((Criterion)Restrictions.eq((String)"isOpen", (Object)true));
                task.add(Restrictions.isNull((String)"end"));
            } else if (state == WorkflowTaskState.COMPLETED) {
                task.add((Criterion)Restrictions.eq((String)"isOpen", (Object)false));
                task.add(Restrictions.isNotNull((String)"end"));
            }
        }
        if (query.getTaskName() != null) {
            task.add((Criterion)Restrictions.eq((String)"name", (Object)query.getTaskName().toPrefixString((NamespacePrefixResolver)this.namespaceService)));
        }
        if (query.getActorId() != null) {
            task.add((Criterion)Restrictions.eq((String)"actorId", (Object)query.getActorId()));
        }
        if (query.getTaskCustomProps() != null && (props2 = query.getTaskCustomProps()).size() > 0) {
            Criteria variables = task.createCriteria("variableInstances");
            Disjunction values = Restrictions.disjunction();
            for (Map.Entry<QName, Object> prop : props2.entrySet()) {
                Conjunction value = Restrictions.conjunction();
                value.add((Criterion)Restrictions.eq((String)"name", (Object)this.factory.mapQNameToName(prop.getKey())));
                value.add((Criterion)Restrictions.eq((String)"value", (Object)prop.getValue().toString()));
                values.add((Criterion)value);
            }
            variables.add((Criterion)values);
        }
        Criteria process = this.createProcessCriteria(task, query);
        if (query.getProcessCustomProps() != null && (props = query.getProcessCustomProps()).size() > 0) {
            Criteria variables = session.createCriteria(VariableInstance.class);
            variables.setProjection(Projections.distinct((Projection)Property.forName((String)"processInstance")));
            Disjunction values = Restrictions.disjunction();
            for (Map.Entry<QName, Object> prop : props.entrySet()) {
                Conjunction value = Restrictions.conjunction();
                value.add((Criterion)Restrictions.eq((String)"name", (Object)this.factory.mapQNameToName(prop.getKey())));
                value.add((Criterion)Restrictions.eq((String)"value", (Object)prop.getValue().toString()));
                values.add((Criterion)value);
            }
            variables.add((Criterion)values);
            this.createProcessCriteria(variables, query);
            Disjunction processIdCriteria = this.createProcessIdCriteria(variables);
            process = process == null ? task.createCriteria("processInstance") : process;
            process.add((Criterion)processIdCriteria);
        }
        if (query.getOrderBy() != null) {
            WorkflowTaskQuery.OrderBy[] orderBy;
            for (WorkflowTaskQuery.OrderBy orderByPart : orderBy = query.getOrderBy()) {
                if (orderByPart == WorkflowTaskQuery.OrderBy.TaskActor_Asc) {
                    task.addOrder(Order.asc((String)"actorId"));
                    continue;
                }
                if (orderByPart == WorkflowTaskQuery.OrderBy.TaskActor_Desc) {
                    task.addOrder(Order.desc((String)"actorId"));
                    continue;
                }
                if (orderByPart == WorkflowTaskQuery.OrderBy.TaskCreated_Asc) {
                    task.addOrder(Order.asc((String)"create"));
                    continue;
                }
                if (orderByPart == WorkflowTaskQuery.OrderBy.TaskCreated_Desc) {
                    task.addOrder(Order.desc((String)"create"));
                    continue;
                }
                if (orderByPart == WorkflowTaskQuery.OrderBy.TaskDue_Asc) {
                    task.addOrder(Order.asc((String)"dueDate"));
                    continue;
                }
                if (orderByPart == WorkflowTaskQuery.OrderBy.TaskDue_Desc) {
                    task.addOrder(Order.desc((String)"dueDate"));
                    continue;
                }
                if (orderByPart == WorkflowTaskQuery.OrderBy.TaskId_Asc) {
                    task.addOrder(Order.asc((String)"id"));
                    continue;
                }
                if (orderByPart == WorkflowTaskQuery.OrderBy.TaskId_Desc) {
                    task.addOrder(Order.desc((String)"id"));
                    continue;
                }
                if (orderByPart == WorkflowTaskQuery.OrderBy.TaskName_Asc) {
                    task.addOrder(Order.asc((String)"name"));
                    continue;
                }
                if (orderByPart == WorkflowTaskQuery.OrderBy.TaskName_Desc) {
                    task.addOrder(Order.desc((String)"name"));
                    continue;
                }
                if (orderByPart == WorkflowTaskQuery.OrderBy.TaskState_Asc) {
                    task.addOrder(Order.asc((String)"end"));
                    continue;
                }
                if (orderByPart != WorkflowTaskQuery.OrderBy.TaskState_Desc) continue;
                task.addOrder(Order.desc((String)"end"));
            }
        }
        if (query.getLimit() != -1) {
            task.setMaxResults(query.getLimit());
        }
        return task;
    }

    private Disjunction createProcessIdCriteria(Criteria variables) {
        List processList = variables.list();
        Object[] processIds = this.getProcessIds(processList);
        int batch = 0;
        ArrayList<Object> buf = new ArrayList<Object>(1000);
        Disjunction ids = Restrictions.disjunction();
        for (Object id : processIds) {
            if (batch < 1000) {
                ++batch;
                buf.add(id);
                continue;
            }
            ids.add(Restrictions.in((String)"id", buf));
            batch = 0;
            buf.clear();
        }
        if (!buf.isEmpty()) {
            ids.add(Restrictions.in((String)"id", buf));
        }
        return ids;
    }

    private Object[] getProcessIds(List<?> processList) {
        ArrayList<Long> ids = new ArrayList<Long>(processList.size());
        if (processList.isEmpty()) {
            ids.add(new Long(-1L));
        } else {
            for (Object obj : processList) {
                ProcessInstance instance = (ProcessInstance)obj;
                ids.add(instance.getId());
            }
        }
        return ids.toArray();
    }

    private Criteria createProcessCriteria(Criteria root, WorkflowTaskQuery query) {
        String definitionName;
        Criteria process = null;
        if (query.isActive() != null) {
            process = root.createCriteria("processInstance");
            if (query.isActive().booleanValue()) {
                process.add(Restrictions.isNull((String)"end"));
            } else {
                process.add(Restrictions.isNotNull((String)"end"));
            }
        }
        if (query.getProcessId() != null) {
            process = process == null ? root.createCriteria("processInstance") : process;
            process.add((Criterion)Restrictions.eq((String)"id", (Object)this.getJbpmId(query.getProcessId())));
        }
        if ((definitionName = query.getWorkflowDefinitionName()) != null) {
            definitionName = this.createLocalId(definitionName);
        }
        if (definitionName == null) {
            QName qName = query.getProcessName();
            String string = definitionName = qName == null ? null : qName.toPrefixString((NamespacePrefixResolver)this.namespaceService);
        }
        if (definitionName != null) {
            process = process == null ? root.createCriteria("processInstance") : process;
            Criteria processDef = process.createCriteria("processDefinition");
            String processName = this.tenantService.getName(definitionName);
            processDef.add((Criterion)Restrictions.eq((String)"name", (Object)processName));
        }
        return process;
    }

    protected TaskInstance getTaskInstance(TaskMgmtSession taskSession, String taskId) {
        TaskInstance taskInstance = taskSession.getTaskInstance(this.getJbpmId(taskId));
        if (taskInstance != null && this.tenantService.isEnabled()) {
            try {
                this.tenantService.checkDomain(taskInstance.getTask().getProcessDefinition().getName());
            }
            catch (RuntimeException re) {
                taskInstance = null;
            }
        }
        if (taskInstance == null) {
            String msg = this.messageService.getMessage(ERR_GET_TASK_INST, taskId);
            throw new WorkflowException(msg);
        }
        return taskInstance;
    }

    @Override
    public WorkflowTask updateTask(final String taskId, final Map<QName, Serializable> properties, final Map<QName, List<NodeRef>> add, final Map<QName, List<NodeRef>> remove) {
        try {
            return (WorkflowTask)this.jbpmTemplate.execute(new JbpmCallback(){

                public Object doInJbpm(JbpmContext context) {
                    Serializable existingValue;
                    QName key;
                    TaskMgmtSession taskSession = context.getTaskMgmtSession();
                    TaskInstance taskInstance = JBPMEngine.this.getTaskInstance(taskSession, taskId);
                    HashMap<QName, Serializable> newProperties = new HashMap<QName, Serializable>(10);
                    if (properties != null) {
                        newProperties.putAll(properties);
                    }
                    Map<QName, Serializable> existingProperties = JBPMEngine.this.getTaskProperties(taskInstance, false);
                    if (add != null) {
                        for (Map.Entry toAdd : add.entrySet()) {
                            LinkedList<NodeRef> existingAdd;
                            key = (QName)toAdd.getKey();
                            existingValue = (Serializable)newProperties.get(key);
                            if (existingValue == null) {
                                existingValue = existingProperties.get(key);
                            }
                            if (existingValue == null) {
                                newProperties.put(key, (Serializable)toAdd.getValue());
                                continue;
                            }
                            if (existingValue instanceof List) {
                                existingAdd = (LinkedList<NodeRef>)existingValue;
                            } else {
                                existingAdd = new LinkedList<NodeRef>();
                                existingAdd.add((NodeRef)existingValue);
                            }
                            for (NodeRef nodeRef : (List)toAdd.getValue()) {
                                if (existingAdd.contains(nodeRef)) continue;
                                existingAdd.add(nodeRef);
                            }
                            newProperties.put(key, existingAdd);
                        }
                    }
                    if (remove != null) {
                        for (Map.Entry toRemove : remove.entrySet()) {
                            key = (QName)toRemove.getKey();
                            existingValue = (Serializable)newProperties.get(key);
                            if (existingValue == null) {
                                existingValue = existingProperties.get(key);
                            }
                            if (existingValue == null) continue;
                            if (existingValue instanceof List) {
                                List existingRemove = (List)((Object)existingValue);
                                existingRemove.removeAll((Collection)toRemove.getValue());
                                newProperties.put(key, (Serializable)((Object)existingRemove));
                                continue;
                            }
                            if (!((List)toRemove.getValue()).contains(existingValue)) continue;
                            newProperties.put(key, new LinkedList());
                        }
                    }
                    if (!newProperties.isEmpty()) {
                        JBPMEngine.this.setTaskProperties(taskInstance, newProperties);
                        ProcessInstance processInstance = taskInstance.getToken().getProcessInstance();
                        context.save(processInstance);
                    }
                    return JBPMEngine.this.createWorkflowTask(taskInstance);
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_UPDATE_TASK, taskId);
            throw new WorkflowException(msg, e);
        }
    }

    @Override
    public WorkflowTask startTask(String taskId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public WorkflowTask suspendTask(String taskId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public WorkflowTask endTask(final String taskId, final String transition) {
        try {
            return (WorkflowTask)this.jbpmTemplate.execute(new JbpmCallback(){

                public Object doInJbpm(JbpmContext context) {
                    TaskMgmtSession taskSession = context.getTaskMgmtSession();
                    TaskInstance taskInstance = JBPMEngine.this.getTaskInstance(taskSession, taskId);
                    QName[] missingProps = JBPMEngine.this.getMissingMandatoryTaskProperties(taskInstance);
                    if (missingProps != null && missingProps.length > 0) {
                        String props = "";
                        for (int i = 0; i < missingProps.length; ++i) {
                            props = props + missingProps[i].toString() + (i < missingProps.length - 1 ? "," : "");
                        }
                        String msg = JBPMEngine.this.messageService.getMessage(JBPMEngine.ERR_MANDATORY_TASK_PROPERTIES_MISSING, props);
                        throw new WorkflowException(msg);
                    }
                    if (transition == null) {
                        taskInstance.end();
                    } else {
                        Node node = taskInstance.getToken().getNode();
                        if (node.getLeavingTransition(transition) == null) {
                            String msg = JBPMEngine.this.messageService.getMessage(JBPMEngine.ERR_END_TASK_INVALID_TRANSITION, transition, taskId);
                            throw new WorkflowException(msg);
                        }
                        taskInstance.end(transition);
                    }
                    ProcessInstance processInstance = taskInstance.getToken().getProcessInstance();
                    context.save(processInstance);
                    return JBPMEngine.this.createWorkflowTask(taskInstance);
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_END_TASK, transition, taskId);
            throw new WorkflowException(msg, e);
        }
    }

    @Override
    public WorkflowTask getTaskById(final String taskId) {
        try {
            return (WorkflowTask)this.jbpmTemplate.execute(new JbpmCallback(){

                public Object doInJbpm(JbpmContext context) {
                    TaskMgmtSession taskSession = context.getTaskMgmtSession();
                    TaskInstance taskInstance = JBPMEngine.this.getTaskInstance(taskSession, taskId);
                    return JBPMEngine.this.createWorkflowTask(taskInstance);
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_GET_TASK_BY_ID, taskId);
            throw new WorkflowException(msg, e);
        }
    }

    @Override
    public WorkflowTask getStartTask(final String workflowInstanceId) {
        try {
            return (WorkflowTask)this.jbpmTemplate.execute(new JbpmCallback(){

                public Object doInJbpm(JbpmContext context) {
                    GraphSession graphSession = context.getGraphSession();
                    ProcessInstance processInstance = JBPMEngine.this.getProcessInstanceIfExists(graphSession, workflowInstanceId);
                    if (processInstance == null) {
                        return null;
                    }
                    Task startTask = processInstance.getProcessDefinition().getTaskMgmtDefinition().getStartTask();
                    if (startTask == null) {
                        return null;
                    }
                    Session session = context.getSession();
                    Criteria taskCriteria = session.createCriteria(TaskInstance.class);
                    taskCriteria.add((Criterion)Restrictions.eq((String)"name", (Object)startTask.getName()));
                    Criteria process = taskCriteria.createCriteria("processInstance");
                    process.add((Criterion)Restrictions.eq((String)"id", (Object)processInstance.getId()));
                    TaskInstance taskInstance = (TaskInstance)taskCriteria.uniqueResult();
                    if (taskInstance == null) {
                        return null;
                    }
                    return JBPMEngine.this.createWorkflowTask(taskInstance);
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_GET_START_TASK, workflowInstanceId);
            throw new WorkflowException(msg, e);
        }
    }

    @Override
    public List<WorkflowTask> getStartTasks(final List<String> workflowInstanceIds, final boolean sameSession) {
        try {
            return (List)this.jbpmTemplate.execute(new JbpmCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object doInJbpm(JbpmContext context) {
                    ArrayList<Long> jbpmIds = new ArrayList<Long>(workflowInstanceIds.size());
                    TreeSet<String> startTaskNames = new TreeSet<String>();
                    for (String workflowInstanceId : workflowInstanceIds) {
                        GraphSession graphSession = context.getGraphSession();
                        ProcessInstance processInstance = JBPMEngine.this.getProcessInstanceIfExists(graphSession, workflowInstanceId);
                        if (processInstance == null) continue;
                        jbpmIds.add(processInstance.getId());
                        Task startTask = processInstance.getProcessDefinition().getTaskMgmtDefinition().getStartTask();
                        startTaskNames.add(startTask.getName());
                    }
                    if (jbpmIds.isEmpty()) {
                        return Collections.emptyList();
                    }
                    Session session = context.getSession();
                    Criteria taskCriteria = session.createCriteria(TaskInstance.class);
                    taskCriteria.add(Restrictions.in((String)"name", startTaskNames));
                    Criteria process = taskCriteria.createCriteria("processInstance");
                    process.add(Restrictions.in((String)"id", jbpmIds));
                    CacheMode cacheMode = session.getCacheMode();
                    try {
                        session.setCacheMode(CacheMode.GET);
                        List tasks = process.list();
                        List<WorkflowTask> list = JBPMEngine.this.getWorkflowTasks(tasks, sameSession);
                        return list;
                    }
                    finally {
                        session.setCacheMode(cacheMode);
                    }
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_QUERY_TASKS, workflowInstanceIds);
            throw new WorkflowException(msg, e);
        }
    }

    protected CompiledProcessDefinition compileProcessDefinition(InputStream definitionStream, String mimetype) {
        String actualMimetype = mimetype == null ? "application/zip" : mimetype;
        CompiledProcessDefinition compiledDef = null;
        if (actualMimetype.equals("application/zip")) {
            ZipInputStream zipInputStream = null;
            try {
                zipInputStream = new ZipInputStream(definitionStream);
                ProcessArchive reader = new ProcessArchive(zipInputStream);
                ProcessDefinition def = reader.parseProcessDefinition();
                compiledDef = new CompiledProcessDefinition(def, reader.getProblems());
            }
            catch (Exception e) {
                String msg = this.messageService.getMessage(ERR_COMPILE_PROCESS_DEF_zip);
                throw new JbpmException(msg, (Throwable)e);
            }
            finally {
                if (zipInputStream != null) {
                    try {
                        zipInputStream.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        if (actualMimetype.equals("text/xml")) {
            try {
                JBPMJpdlXmlReader jpdlReader = new JBPMJpdlXmlReader(definitionStream);
                ProcessDefinition def = jpdlReader.readProcessDefinition();
                List<Problem> problems = jpdlReader.getProblems();
                compiledDef = new CompiledProcessDefinition(def, problems);
            }
            catch (Exception e) {
                String msg = this.messageService.getMessage(ERR_COMPILE_PROCESS_DEF_XML);
                throw new JbpmException(msg, (Throwable)e);
            }
        } else {
            String msg = this.messageService.getMessage(ERR_COMPILE_PROCESS_DEF_UNSUPPORTED, mimetype);
            throw new JbpmException(msg);
        }
        if (this.tenantService.isEnabled()) {
            compiledDef.def.setName(this.tenantService.getName(compiledDef.def.getName()));
        }
        return compiledDef;
    }

    protected long getJbpmId(String id) {
        try {
            String theLong = this.createLocalId(id);
            return new Long(theLong);
        }
        catch (NumberFormatException e) {
            String msg = this.messageService.getMessage(ERR_GET_JBPM_ID, id);
            throw new WorkflowException(msg, e);
        }
    }

    protected Token getWorkflowToken(GraphSession session, String pathId) {
        String tokenId;
        String[] path = pathId.split(WORKFLOW_PATH_SEPERATOR);
        if (path.length != 2) {
            String msg = this.messageService.getMessage(ERR_GET_WORKFLOW_TOKEN_INVALID, pathId);
            throw new WorkflowException(msg);
        }
        ProcessInstance processInstance = this.getProcessInstance(session, path[0]);
        Token token = processInstance.findToken(tokenId = path[1].replace(WORKFLOW_TOKEN_SEPERATOR, "/"));
        if (token == null) {
            String msg = this.messageService.getMessage(ERR_GET_WORKFLOW_TOKEN_NULL, pathId);
            throw new WorkflowException(msg);
        }
        return token;
    }

    protected Map<QName, Serializable> getTaskProperties(TaskInstance instance, boolean localProperties) {
        return this.getTaskProperties(instance, localProperties, null);
    }

    protected Map<QName, Serializable> getTaskProperties(TaskInstance instance, boolean localProperties, Map<Long, TokenVariableMap> variablesCache) {
        Set pooledActors;
        TypeDefinition taskDef = this.getFullTaskDefinition(instance);
        Map taskProperties = taskDef.getProperties();
        Map taskAssocs = taskDef.getAssociations();
        Map vars = instance.getVariablesLocally();
        if (!localProperties) {
            ContextInstance context = instance.getContextInstance();
            for (Token token = instance.getToken(); token != null; token = token.getParent()) {
                TokenVariableMap varMap = null;
                varMap = variablesCache != null && variablesCache.containsKey(context.getTokenVariableMap(token).getToken().getId()) ? variablesCache.get(context.getTokenVariableMap(token).getToken().getId()) : context.getTokenVariableMap(token);
                if (varMap == null) continue;
                Map tokenVars = varMap.getVariablesLocally();
                for (Map.Entry entry : tokenVars.entrySet()) {
                    if (vars.containsKey(entry.getKey())) continue;
                    vars.put(entry.getKey(), entry.getValue());
                }
            }
        }
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>(10);
        for (Map.Entry entry : vars.entrySet()) {
            String key = (String)entry.getKey();
            QName qname = this.factory.mapNameToQName(key);
            boolean isAssoc = taskAssocs.containsKey(qname);
            if (!taskProperties.containsKey(qname) && !isAssoc && !instance.hasVariableLocally(key)) continue;
            Serializable value = this.convertValue((PropertyDefinition)taskProperties.get(qname), entry.getValue());
            properties.put(qname, value);
        }
        properties.put(WorkflowModel.PROP_TASK_ID, Long.valueOf(instance.getId()));
        properties.put(WorkflowModel.PROP_DESCRIPTION, (Serializable)((Object)instance.getDescription()));
        properties.put(WorkflowModel.PROP_START_DATE, instance.getStart());
        properties.put(WorkflowModel.PROP_DUE_DATE, instance.getDueDate());
        properties.put(WorkflowModel.PROP_COMPLETION_DATE, instance.getEnd());
        properties.put(WorkflowModel.PROP_PRIORITY, Integer.valueOf(instance.getPriority()));
        properties.put(ContentModel.PROP_CREATED, instance.getCreate());
        properties.put(ContentModel.PROP_OWNER, (Serializable)((Object)instance.getActorId()));
        List comments = instance.getComments();
        if (comments != null && comments.size() > 0) {
            properties.put(WorkflowModel.PROP_COMMENT, (Serializable)((Object)((Comment)comments.get(0)).getMessage()));
        }
        if ((pooledActors = instance.getPooledActors()) != null) {
            ArrayList<NodeRef> pooledNodeRefs = new ArrayList<NodeRef>(pooledActors.size());
            for (PooledActor pooledActor : pooledActors) {
                NodeRef pooledNodeRef = null;
                String pooledActorId = pooledActor.getActorId();
                pooledNodeRef = AuthorityType.getAuthorityType((String)pooledActorId) == AuthorityType.GROUP ? this.mapNameToAuthority(pooledActorId) : this.mapNameToPerson(pooledActorId);
                if (pooledNodeRef == null) continue;
                pooledNodeRefs.add(pooledNodeRef);
            }
            properties.put(WorkflowModel.ASSOC_POOLED_ACTORS, pooledNodeRefs);
        }
        return properties;
    }

    private TypeDefinition getFullTaskDefinition(TaskInstance instance) {
        Task task = instance.getTask();
        TypeDefinition taskType = this.factory.getTaskTypeDefinition(task.getName(), task.getStartState() != null);
        TypeDefinition taskDef = this.dictionaryService.getAnonymousType(taskType.getName());
        return taskDef;
    }

    protected void setTaskProperties(TaskInstance instance, Map<QName, Serializable> properties) {
        if (properties == null) {
            return;
        }
        TypeDefinition taskDef = this.getFullTaskDefinition(instance);
        Map taskProperties = taskDef.getProperties();
        Map taskAssocs = taskDef.getAssociations();
        for (Map.Entry<QName, Serializable> entry : properties.entrySet()) {
            QName key = entry.getKey();
            Object value = entry.getValue();
            PropertyDefinition propDef = (PropertyDefinition)taskProperties.get(key);
            if (propDef != null) {
                if (propDef.isProtected()) continue;
                value = value instanceof Collection ? (Serializable)((Object)DefaultTypeConverter.INSTANCE.convert(propDef.getDataType(), (Collection)value)) : (Serializable)DefaultTypeConverter.INSTANCE.convert(propDef.getDataType(), value);
                DataTypeDefinition dataTypeDef = propDef.getDataType();
                if (dataTypeDef.getName().equals((Object)DataTypeDefinition.NODE_REF)) {
                    value = this.convertNodeRefs(propDef.isMultiValued(), (Serializable)value);
                }
                if (key.equals((Object)WorkflowModel.PROP_DESCRIPTION)) {
                    if (value != null && !(value instanceof String)) {
                        throw this.getInvalidPropertyValueException(key, (Serializable)value);
                    }
                    instance.setDescription((String)value);
                    continue;
                }
                if (key.equals((Object)WorkflowModel.PROP_DUE_DATE)) {
                    if (value != null && !(value instanceof Date)) {
                        throw this.getInvalidPropertyValueException(key, (Serializable)value);
                    }
                    instance.setDueDate((Date)value);
                    continue;
                }
                if (key.equals((Object)WorkflowModel.PROP_PRIORITY)) {
                    if (!(value instanceof Integer)) {
                        throw this.getInvalidPropertyValueException(key, (Serializable)value);
                    }
                    instance.setPriority(((Integer)value).intValue());
                    continue;
                }
                if (key.equals((Object)WorkflowModel.PROP_COMMENT)) {
                    if (!(value instanceof String)) {
                        throw this.getInvalidPropertyValueException(key, (Serializable)value);
                    }
                    final List comments = instance.getComments();
                    if (comments != null && comments.size() > 0) {
                        this.jbpmTemplate.execute(new JbpmCallback(){

                            public Object doInJbpm(JbpmContext context) {
                                Session session = context.getSession();
                                for (Object obj : comments) {
                                    Comment comment = (Comment)obj;
                                    comment.getToken().getComments().remove(comment);
                                    session.delete((Object)comment);
                                }
                                comments.clear();
                                return null;
                            }
                        });
                    }
                    instance.addComment((String)value);
                    continue;
                }
                if (key.equals((Object)ContentModel.PROP_OWNER)) {
                    if (value != null && !(value instanceof String)) {
                        throw this.getInvalidPropertyValueException(key, (Serializable)value);
                    }
                    String actorId = (String)value;
                    String existingActorId = instance.getActorId();
                    if (existingActorId != null && existingActorId.equals(actorId)) continue;
                    instance.setActorId((String)value, false);
                    continue;
                }
            } else {
                AssociationDefinition assocDef = (AssociationDefinition)taskAssocs.get(key);
                if (assocDef != null) {
                    value = this.convertNodeRefs(assocDef.isTargetMany(), (Serializable)value);
                    if (key.equals((Object)WorkflowModel.ASSOC_POOLED_ACTORS)) {
                        String[] pooledActors = null;
                        if (value instanceof JBPMNodeList) {
                            JBPMNodeList actors = (JBPMNodeList)value;
                            pooledActors = new String[actors.size()];
                            int i = 0;
                            for (JBPMNode actor : actors) {
                                pooledActors[i++] = this.mapAuthorityToName(actor.getNodeRef());
                            }
                        } else if (value instanceof JBPMNode) {
                            JBPMNode node = (JBPMNode)value;
                            pooledActors = new String[]{this.mapAuthorityToName(node.getNodeRef())};
                        } else {
                            throw this.getInvalidPropertyValueException(key, (Serializable)value);
                        }
                        instance.setPooledActors(pooledActors);
                        continue;
                    }
                } else if (value instanceof NodeRef) {
                    value = new JBPMNode((NodeRef)value, this.serviceRegistry);
                }
            }
            String name = this.factory.mapQNameToName(key);
            instance.setVariableLocally(name, value);
        }
    }

    private WorkflowException getInvalidPropertyValueException(QName key, Serializable value) {
        String msg = this.messageService.getMessage(ERR_SET_TASK_PROPS_INVALID_VALUE, value, key);
        return new WorkflowException(msg);
    }

    protected void setDefaultTaskProperties(TaskInstance instance) {
        Map<QName, Serializable> existingValues = this.getTaskProperties(instance, false);
        HashMap<QName, Serializable> defaultValues = new HashMap<QName, Serializable>();
        TypeDefinition classDef = this.getFullTaskDefinition(instance);
        Map propertyDefs = classDef.getProperties();
        for (Map.Entry entry : propertyDefs.entrySet()) {
            String defaultValue = ((PropertyDefinition)entry.getValue()).getDefaultValue();
            if (defaultValue == null || existingValues.get(entry.getKey()) != null && !this.ignoredProperties.containsValue(entry.getKey())) continue;
            defaultValues.put((QName)entry.getKey(), (Serializable)((Object)defaultValue));
        }
        String description = (String)((Object)existingValues.get(WorkflowModel.PROP_DESCRIPTION));
        if (description == null || description.length() == 0) {
            description = (String)instance.getContextInstance().getVariable(this.factory.mapQNameToName(WorkflowModel.PROP_WORKFLOW_DESCRIPTION));
            if (description != null && description.length() > 0) {
                defaultValues.put(WorkflowModel.PROP_DESCRIPTION, (Serializable)((Object)description));
            } else {
                WorkflowTask task = this.createWorkflowTask(instance);
                defaultValues.put(WorkflowModel.PROP_DESCRIPTION, (Serializable)((Object)task.getTitle()));
            }
        }
        if (defaultValues.size() > 0) {
            this.setTaskProperties(instance, defaultValues);
        }
    }

    public void setDefaultStartTaskDescription(TaskInstance instance) {
        String description = instance.getTask().getDescription();
        if ((description == null || description.length() == 0) && (description = (String)instance.getContextInstance().getVariable(this.factory.mapQNameToName(WorkflowModel.PROP_WORKFLOW_DESCRIPTION))) != null && description.length() > 0) {
            HashMap<QName, Serializable> defaultValues = new HashMap<QName, Serializable>();
            defaultValues.put(WorkflowModel.PROP_DESCRIPTION, (Serializable)((Object)description));
            this.setTaskProperties(instance, defaultValues);
        }
    }

    protected void setDefaultWorkflowProperties(TaskInstance startTask) {
        String workflowContextName;
        String workflowPackageName;
        String workflowPriorityName;
        String workflowDueDateName;
        String workflowDescriptionName;
        Map<QName, Serializable> taskProperties = this.getTaskProperties(startTask, true);
        ContextInstance processContext = startTask.getContextInstance();
        if (!processContext.hasVariable(workflowDescriptionName = this.factory.mapQNameToName(WorkflowModel.PROP_WORKFLOW_DESCRIPTION))) {
            processContext.setVariable(workflowDescriptionName, (Object)taskProperties.get(WorkflowModel.PROP_WORKFLOW_DESCRIPTION));
        }
        if (!processContext.hasVariable(workflowDueDateName = this.factory.mapQNameToName(WorkflowModel.PROP_WORKFLOW_DUE_DATE))) {
            processContext.setVariable(workflowDueDateName, (Object)taskProperties.get(WorkflowModel.PROP_WORKFLOW_DUE_DATE));
        }
        if (!processContext.hasVariable(workflowPriorityName = this.factory.mapQNameToName(WorkflowModel.PROP_WORKFLOW_PRIORITY))) {
            processContext.setVariable(workflowPriorityName, (Object)taskProperties.get(WorkflowModel.PROP_WORKFLOW_PRIORITY));
        }
        if (!processContext.hasVariable(workflowPackageName = this.factory.mapQNameToName(WorkflowModel.ASSOC_PACKAGE))) {
            Serializable packageNodeRef = taskProperties.get(WorkflowModel.ASSOC_PACKAGE);
            processContext.setVariable(workflowPackageName, (Object)this.convertNodeRefs(packageNodeRef instanceof List, packageNodeRef));
        }
        if (!processContext.hasVariable(workflowContextName = this.factory.mapQNameToName(WorkflowModel.PROP_CONTEXT))) {
            Serializable contextRef = taskProperties.get(WorkflowModel.PROP_CONTEXT);
            processContext.setVariable(workflowContextName, (Object)this.convertNodeRefs(contextRef instanceof List, contextRef));
        }
    }

    protected QName[] getMissingMandatoryTaskProperties(TaskInstance instance) {
        Serializable value;
        boolean isMandatory;
        QName name;
        ArrayList missingProps = null;
        Map<QName, Serializable> existingValues = this.getTaskProperties(instance, false);
        TypeDefinition classDef = this.getFullTaskDefinition(instance);
        Map propertyDefs = classDef.getProperties();
        Map assocDefs = classDef.getAssociations();
        for (Map.Entry entry : propertyDefs.entrySet()) {
            name = (QName)entry.getKey();
            if (name.getNamespaceURI().equals("http://www.alfresco.org/model/content/1.0") || name.getNamespaceURI().equals("http://www.alfresco.org/model/system/1.0") || !(isMandatory = ((PropertyDefinition)entry.getValue()).isMandatory()) || (value = existingValues.get(entry.getKey())) != null && (!(value instanceof String) || ((String)((Object)value)).length() != 0)) continue;
            if (missingProps == null) {
                missingProps = new ArrayList();
            }
            missingProps.add(entry.getKey());
        }
        for (Map.Entry entry : assocDefs.entrySet()) {
            name = (QName)entry.getKey();
            if (name.getNamespaceURI().equals("http://www.alfresco.org/model/content/1.0") || name.getNamespaceURI().equals("http://www.alfresco.org/model/system/1.0") || !(isMandatory = ((AssociationDefinition)entry.getValue()).isTargetMandatory()) || (value = existingValues.get(entry.getKey())) != null && (!(value instanceof List) || !((List)((Object)value)).isEmpty())) continue;
            if (missingProps == null) {
                missingProps = new ArrayList();
            }
            missingProps.add(entry.getKey());
        }
        return missingProps == null ? null : missingProps.toArray(new QName[missingProps.size()]);
    }

    private Serializable convertValue(PropertyDefinition propDef, Object value) {
        if (propDef != null && value instanceof String && Boolean.class.getName().equals(propDef.getDataType().getJavaClassName())) {
            return (Serializable)new BooleanToStringConverter().revert(value);
        }
        return this.convertValue(value);
    }

    private Serializable convertValue(Object value) {
        Object alfValue = null;
        if (value != null) {
            if (value instanceof JBPMNode) {
                alfValue = ((JBPMNode)value).getNodeRef();
            } else if (value instanceof JBPMNodeList) {
                JBPMNodeList nodes = (JBPMNodeList)value;
                ArrayList<NodeRef> nodeRefs = new ArrayList<NodeRef>(nodes.size());
                for (JBPMNode node : nodes) {
                    nodeRefs.add(node.getNodeRef());
                }
                alfValue = nodeRefs;
            } else if (value instanceof Serializable) {
                alfValue = (Serializable)value;
            } else {
                String msg = this.messageService.getMessage(ERR_CONVERT_VALUE, value);
                throw new WorkflowException(msg);
            }
        }
        return alfValue;
    }

    private Serializable convertNodeRefs(boolean isMany, Serializable value) {
        if (value instanceof NodeRef) {
            if (isMany) {
                JBPMNodeList values = new JBPMNodeList();
                values.add(new JBPMNode((NodeRef)value, this.serviceRegistry));
                value = values;
            } else {
                value = new JBPMNode((NodeRef)value, this.serviceRegistry);
            }
        } else if (value instanceof List) {
            if (isMany) {
                JBPMNodeList values = new JBPMNodeList();
                for (NodeRef nodeRef : (List)value) {
                    values.add(new JBPMNode(nodeRef, this.serviceRegistry));
                }
                value = values;
            } else {
                List nodeRefs = (List)value;
                value = nodeRefs.size() == 0 ? null : new JBPMNode((NodeRef)nodeRefs.get(0), this.serviceRegistry);
            }
        }
        return value;
    }

    private NodeRef mapNameToPerson(String name) {
        NodeRef authority = null;
        if (name != null && this.personService.personExists(name)) {
            authority = this.personService.getPerson(name);
        }
        return authority;
    }

    private NodeRef mapNameToAuthority(String name) {
        NodeRef authority = null;
        if (name != null && this.authorityDAO.authorityExists(name)) {
            authority = this.authorityDAO.getAuthorityNodeRefOrNull(name);
        }
        return authority;
    }

    private String mapAuthorityToName(NodeRef authority) {
        String name = null;
        QName type = this.nodeService.getType(authority);
        name = this.dictionaryService.isSubClass(type, ContentModel.TYPE_PERSON) ? (String)((Object)this.nodeService.getProperty(authority, ContentModel.PROP_USERNAME)) : this.authorityDAO.getAuthorityName(authority);
        return name;
    }

    private String getLabel(String displayId, String labelKey, String defaultLabel) {
        String key = StringUtils.replace((String)displayId, (String)":", (String)"_");
        String label = this.messageService.getMessage(key = key + "." + labelKey);
        return label == null ? defaultLabel : label;
    }

    private NodeRef getCompanyHome() {
        if (this.tenantService.isEnabled()) {
            try {
                return this.tenantService.getRootNode(this.nodeService, this.serviceRegistry.getSearchService(), this.namespaceService, this.companyHomePath, this.nodeService.getRootNode(this.companyHomeStore));
            }
            catch (RuntimeException re) {
                String msg = this.messageService.getMessage(ERR_GET_COMPANY_HOME_INVALID, this.companyHomePath);
                throw new IllegalStateException(msg, re);
            }
        }
        List refs = this.unprotectedSearchService.selectNodes(this.nodeService.getRootNode(this.companyHomeStore), this.companyHomePath, null, (NamespacePrefixResolver)this.namespaceService, false);
        if (refs.size() != 1) {
            String msg = this.messageService.getMessage(ERR_GET_COMPANY_HOME_MULTIPLE, this.companyHomePath, refs.size());
            throw new IllegalStateException(msg);
        }
        return (NodeRef)refs.get(0);
    }

    protected WorkflowPath createWorkflowPath(Token token) {
        if (token == null) {
            return null;
        }
        WorkflowInstance wfInstance = this.createWorkflowInstance(token.getProcessInstance());
        WorkflowNode node = this.createWorkflowNode(token.getNode());
        return this.createWorkflowPath(token, wfInstance, node);
    }

    protected WorkflowPath createWorkflowPath(Token token, WorkflowInstance wfInstance, WorkflowNode node) {
        String tokenId = token.getFullName().replace("/", WORKFLOW_TOKEN_SEPERATOR);
        String id = token.getProcessInstance().getId() + WORKFLOW_PATH_SEPERATOR + tokenId;
        boolean isActive = !token.hasEnded();
        return this.factory.createPath(id, wfInstance, node, isActive);
    }

    protected WorkflowNode createWorkflowNode(Node node) {
        List<WorkflowTransition> wfTransitions;
        if (node == null) {
            return null;
        }
        String processName = node.getProcessDefinition().getName();
        String name = node.getName();
        String type = this.getRealNode(node).getClass().getSimpleName();
        boolean isTaskNode = type.equals("TaskNode");
        List transitions = node.getLeavingTransitions();
        if (transitions != null) {
            wfTransitions = new ArrayList(transitions.size());
            for (Transition transition : transitions) {
                wfTransitions.add(this.createWorkflowTransition(transition));
            }
        } else {
            wfTransitions = Collections.emptyList();
        }
        WorkflowTransition[] transArr = wfTransitions.toArray(new WorkflowTransition[0]);
        return this.factory.createNode(name, processName, name, null, type, isTaskNode, transArr);
    }

    protected WorkflowTransition createWorkflowTransition(Transition transition) {
        String description;
        String title;
        if (transition == null) {
            return null;
        }
        String id = transition.getName();
        Node node = transition.getFrom();
        boolean isDefault = node.getDefaultLeavingTransition().equals((Object)transition);
        if (id == null || id.length() == 0) {
            title = this.getLabel(DEFAULT_TRANSITION_LABEL, TITLE_LABEL, id);
            description = this.getLabel(DEFAULT_TRANSITION_LABEL, DESC_LABEL, title);
        } else {
            String nodeName = node.getName();
            String processName = node.getProcessDefinition().getName();
            title = this.getLabel(processName + ".node." + nodeName + ".transition." + id, TITLE_LABEL, id);
            description = this.getLabel(processName + ".node." + nodeName + ".transition." + id, DESC_LABEL, title);
        }
        return new WorkflowTransition(id, title, description, isDefault);
    }

    protected WorkflowInstance createWorkflowInstance(ProcessInstance instance) {
        return this.createWorkflowInstance(instance, null);
    }

    private WorkflowInstance createWorkflowInstance(ProcessInstance instance, Date endDate) {
        if (instance == null) {
            return null;
        }
        Map variables = instance.getContextInstance().getVariables();
        WorkflowDefinition definition = this.createWorkflowDefinition(instance.getProcessDefinition());
        return this.createWorkflowInstance(instance, definition, endDate, variables);
    }

    protected WorkflowInstance createWorkflowInstance(ProcessInstance instance, WorkflowDefinition definition, Date endDate, Map<String, Object> variables) {
        if (instance == null) {
            return null;
        }
        String id = Long.toString(instance.getId());
        Date startDate = instance.getStart();
        boolean isActive = false;
        if (endDate == null) {
            isActive = !instance.hasEnded();
            endDate = instance.getEnd();
        }
        return this.factory.createInstance(id, definition, variables, isActive, startDate, endDate);
    }

    protected WorkflowDefinition createWorkflowDefinition(ProcessDefinition definition) {
        if (definition == null) {
            return null;
        }
        Task startTask = definition.getTaskMgmtDefinition().getStartTask();
        return this.createWorkflowDefinition(definition, startTask);
    }

    private WorkflowDefinition createWorkflowDefinition(ProcessDefinition definition, Task startTask) {
        if (definition == null) {
            return null;
        }
        String id = Long.toString(definition.getId());
        String name = definition.getName();
        int version = definition.getVersion();
        WorkflowTaskDefinition startTaskDef = this.createWorkflowTaskDefinition(startTask);
        return this.factory.createDefinition(id, name, version, name, null, startTaskDef);
    }

    protected WorkflowTask createWorkflowTask(TaskInstance task) {
        WorkflowPath path = this.createWorkflowPath(task.getToken());
        Map<QName, Serializable> properties = this.getTaskProperties(task, false);
        WorkflowTaskDefinition definition = this.createWorkflowTaskDefinition(task.getTask());
        return this.createWorkflowTask(task, definition, path, properties);
    }

    private WorkflowTask createWorkflowTask(TaskInstance task, WorkflowTaskDefinition definition, WorkflowPath path, Map<QName, Serializable> properties) {
        if (task == null) {
            return null;
        }
        String processName = task.getTask().getProcessDefinition().getName();
        if (this.tenantService.isEnabled()) {
            this.tenantService.checkDomain(processName);
        }
        String id = Long.toString(task.getId());
        String name = task.getName();
        WorkflowTaskState state = this.getWorkflowTaskState(task);
        return this.factory.createTask(id, definition, name, null, null, state, path, properties);
    }

    protected WorkflowTaskDefinition createWorkflowTaskDefinition(Task task) {
        if (task == null) {
            return null;
        }
        String id = task.getName();
        boolean isStart = task.getStartState() != null;
        StartState node = isStart ? task.getStartState() : task.getTaskNode();
        WorkflowNode wfNode = this.createWorkflowNode((Node)node);
        return this.factory.createTaskDefinition(id, wfNode, id, isStart);
    }

    protected WorkflowDeployment createWorkflowDeployment(CompiledProcessDefinition compiledDef) {
        WorkflowDefinition definition = this.createWorkflowDefinition(compiledDef.def);
        String[] problems = compiledDef.problems;
        return this.factory.createDeployment(definition, problems);
    }

    protected WorkflowTimer createWorkflowTimer(Timer timer) {
        if (timer == null) {
            return null;
        }
        WorkflowPath path = this.createWorkflowPath(timer.getToken());
        WorkflowTask workflowTask = null;
        TaskInstance taskInstance = timer.getTaskInstance();
        if (taskInstance != null) {
            workflowTask = this.createWorkflowTask(taskInstance);
        }
        return this.factory.createWorkflowTimer(new Long(timer.getId()).toString(), timer.getName(), timer.getException(), timer.getDueDate(), path, workflowTask);
    }

    protected WorkflowTaskState getWorkflowTaskState(TaskInstance task) {
        if (task.hasEnded()) {
            return WorkflowTaskState.COMPLETED;
        }
        return WorkflowTaskState.IN_PROGRESS;
    }

    private Node getRealNode(Node node) {
        if (node instanceof HibernateProxy) {
            Node realNode = (Node)((HibernateProxy)node).getHibernateLazyInitializer().getImplementation();
            return realNode;
        }
        return node;
    }

    @Override
    protected QName getDefaultStartTaskType() {
        return WorkflowModel.TYPE_START_TASK;
    }

    private static class CompiledProcessDefinition {
        protected ProcessDefinition def;
        protected String[] problems;

        public CompiledProcessDefinition(ProcessDefinition def, List<Problem> problems) {
            this.def = def;
            this.problems = new String[problems.size()];
            int i = 0;
            for (Problem problem : problems) {
                this.problems[i++] = problem.toString();
            }
        }
    }
}

