/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.repository;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.TransformationOptionLimits;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransformationOptionLimitsMap
extends AbstractMap<String, Map<String, TransformationOptionLimits>> {
    private static final Log logger = LogFactory.getLog(TransformationOptionLimitsMap.class);
    private Map<String, Map<String, TransformationOptionLimits>> map = new HashMap<String, Map<String, TransformationOptionLimits>>();
    private List<String> propertyNames = Arrays.asList("maxsourcesizekbytes", "readlimitkbytes", "readlimittimems", "timeoutms", "maxpages", "pagelimit");

    public TransformationOptionLimitsMap(String values, MimetypeService mimetypeService) {
        String sourceMimetype = null;
        String targetMimetype = null;
        TransformationOptionLimits limits = null;
        String name = null;
        int entry = 1;
        State state = State.SOURCE;
        String[] bits = values.split("  *");
        mimetypeService.getMimetypesByExtension();
        block8: for (String bit : bits) {
            if ((bit = bit.trim()).length() == 0) continue;
            switch (state) {
                case SOURCE: {
                    String string = sourceMimetype = bit.equals("*") ? bit : mimetypeService.getMimetype(bit);
                    if (sourceMimetype == null) {
                        logger.error((Object)("Entry " + entry + " invalid source extension '" + bit + "' - ignored"));
                        continue block8;
                    }
                    state = State.TARGET;
                    continue block8;
                }
                case TARGET: {
                    String string = targetMimetype = bit.equals("*") ? bit : mimetypeService.getMimetype(bit);
                    if (targetMimetype == null) {
                        logger.error((Object)("Entry " + entry + " invalid target extension '" + bit + "' - ignored"));
                        continue block8;
                    }
                    limits = new TransformationOptionLimits();
                    state = State.NAME;
                    continue block8;
                }
                case NAME: {
                    if (";".equals(bit)) {
                        this.add(sourceMimetype, targetMimetype, limits);
                        ++entry;
                        state = State.SOURCE;
                        continue block8;
                    }
                    if (this.propertyNames.contains(bit.toLowerCase())) {
                        name = bit.toLowerCase();
                        state = State.VALUE;
                        continue block8;
                    }
                    logger.error((Object)("Entry " + entry + " invalid property name '" + bit + "' - ignored"));
                    continue block8;
                }
                case VALUE: {
                    try {
                        long value = Long.parseLong(bit);
                        if (name.equalsIgnoreCase("maxSourceSizeKBytes")) {
                            limits.setMaxSourceSizeKBytes(value);
                        } else if (name.equalsIgnoreCase("readLimitKBytes")) {
                            limits.setReadLimitKBytes(value);
                        } else if (name.equalsIgnoreCase("readLimitTimeMs")) {
                            limits.setReadLimitTimeMs(value);
                        } else if (name.equalsIgnoreCase("timeoutMs")) {
                            limits.setTimeoutMs(value);
                        } else if (value > Integer.MAX_VALUE) {
                            logger.error((Object)("Entry " + entry + " invalid property name '" + bit + "' - skipping property and value"));
                        } else if (name.equalsIgnoreCase("maxPages")) {
                            limits.setMaxPages((int)value);
                        } else if (name.equalsIgnoreCase("pageLimit")) {
                            limits.setPageLimit((int)value);
                        }
                    }
                    catch (NumberFormatException e) {
                        logger.error((Object)("Entry " + entry + " invalid value '" + bit + "' - skipping property and value"));
                    }
                    state = State.NAME;
                }
            }
        }
        if (state == State.NAME) {
            this.add(sourceMimetype, targetMimetype, limits);
        } else if (state != State.SOURCE) {
            logger.error((Object)("Entry " + entry + " is incomplete."));
        }
    }

    private void add(String sourceMimetype, String targetMimetype, TransformationOptionLimits limits) {
        Map<String, TransformationOptionLimits> map2 = this.map.get(sourceMimetype);
        if (map2 == null) {
            map2 = new HashMap<String, TransformationOptionLimits>();
            this.map.put(sourceMimetype, map2);
        }
        map2.put(targetMimetype, limits);
    }

    @Override
    public Set<Map.Entry<String, Map<String, TransformationOptionLimits>>> entrySet() {
        return this.map.entrySet();
    }

    private static enum State {
        SOURCE,
        TARGET,
        NAME,
        VALUE;

    }
}

