/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.alfresco.util.schemacomp.DbObjectVisitor;
import org.alfresco.util.schemacomp.DbProperty;
import org.alfresco.util.schemacomp.DefaultComparisonUtils;
import org.alfresco.util.schemacomp.DiffContext;
import org.alfresco.util.schemacomp.Difference;
import org.alfresco.util.schemacomp.Results;
import org.alfresco.util.schemacomp.model.AbstractDbObject;
import org.alfresco.util.schemacomp.model.DbObject;
import org.alfresco.util.schemacomp.validator.DbValidator;
import org.hibernate.dialect.Dialect;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.internal.verification.api.VerificationMode;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultComparisonUtilsTest {
    @Mock
    private Results differences;
    private DefaultComparisonUtils comparisonUtils;
    private DiffContext ctx;
    @Mock
    private Dialect dialect;

    @Before
    public void setUp() {
        this.comparisonUtils = new DefaultComparisonUtils();
        this.ctx = new DiffContext(this.dialect, this.differences, null, null);
    }

    @Test
    public void compareSimple() {
        this.comparisonUtils.compareSimple(this.prop(null), this.prop(null), this.ctx);
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.IN_BOTH_NO_DIFFERENCE, this.prop(null), this.prop(null));
        this.comparisonUtils.compareSimple(this.prop("not_null_string"), this.prop("not_null_string"), this.ctx);
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.IN_BOTH_NO_DIFFERENCE, this.prop("not_null_string"), this.prop("not_null_string"));
        this.comparisonUtils.compareSimple(this.prop("Not_Null_String"), this.prop("NOT_NULL_STRING"), this.ctx);
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.IN_BOTH_NO_DIFFERENCE, this.prop("Not_Null_String"), this.prop("NOT_NULL_STRING"));
        this.comparisonUtils.compareSimple(this.prop("left"), this.prop("right"), this.ctx);
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.IN_BOTH_BUT_DIFFERENCE, this.prop("left"), this.prop("right"));
        this.comparisonUtils.compareSimple(this.prop("left"), this.prop(null), this.ctx);
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.ONLY_IN_REFERENCE, this.prop("left"), this.prop(null));
        this.comparisonUtils.compareSimple(this.prop(null), this.prop("right"), this.ctx);
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.ONLY_IN_TARGET, this.prop(null), this.prop("right"));
    }

    public DbProperty prop(String propValue) {
        DbObjectWithCollection dbo = new DbObjectWithCollection("dbo", null);
        return this.dbPropForValue(dbo, "someProperty", propValue);
    }

    @Test
    public void compareCollections() {
        DatabaseObject db1 = new DatabaseObject("db1");
        DatabaseObject db2 = new DatabaseObject("db2");
        DatabaseObject db3 = new DatabaseObject("db3");
        DatabaseObject db4 = new DatabaseObject("db4");
        ArrayList left = new ArrayList();
        Collections.addAll(left, db1, db2, db4);
        ArrayList right = new ArrayList();
        Collections.addAll(right, db1, db3, db4);
        this.comparisonUtils.compareCollections(left, right, this.ctx);
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.IN_BOTH_BUT_DIFFERENCE, new DbProperty(db1), new DbProperty(db1));
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.ONLY_IN_REFERENCE, new DbProperty(db2), null);
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.ONLY_IN_TARGET, null, new DbProperty(db3));
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.IN_BOTH_BUT_DIFFERENCE, new DbProperty(db4), new DbProperty(db4));
    }

    @Test
    public void compareCollectionsWithMultipleMatches() {
        DatabaseObject db2 = new DatabaseObject("db2");
        DatabaseObject db3 = new DatabaseObject("db3");
        DatabaseObject db4 = new DatabaseObject("db4");
        DatabaseObject db1 = new DatabaseObject("db1", db2, db3);
        ArrayList left = new ArrayList();
        Collections.addAll(left, db1, db4);
        ArrayList right = new ArrayList();
        Collections.addAll(right, db1, db2, db3);
        this.comparisonUtils.compareCollections(left, right, this.ctx);
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.ONLY_IN_REFERENCE, new DbProperty(db4), null);
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.IN_BOTH_BUT_DIFFERENCE, new DbProperty(db1), new DbProperty(db1));
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.IN_BOTH_BUT_DIFFERENCE, new DbProperty(db1), new DbProperty(db2));
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.IN_BOTH_BUT_DIFFERENCE, new DbProperty(db1), new DbProperty(db3));
    }

    @Test
    public void propertyIsNotComparedWhenValidatorTakesResponsibility() {
        DatabaseObject db1 = new DatabaseObject("db1");
        DbProperty db1NameProp = new DbProperty(db1, "name");
        DatabaseObject db2 = new DatabaseObject("db2");
        DbProperty db2NameProp = new DbProperty(db2, "name");
        DbValidator nameValidator = (DbValidator)Mockito.mock(DbValidator.class);
        Mockito.when((Object)nameValidator.validates("name")).thenReturn((Object)true);
        db1.getValidators().add(nameValidator);
        this.comparisonUtils.compareSimple(db1NameProp, db2NameProp, this.ctx);
        ((Results)Mockito.verify((Object)this.differences, (VerificationMode)Mockito.never())).add(Difference.Where.IN_BOTH_BUT_DIFFERENCE, db1NameProp, db2NameProp);
    }

    @Test
    public void collectionPropertyIsNotComparedWhenValidatorTakesResponsibility() {
        ArrayList<Object> refCollection = new ArrayList<Object>();
        refCollection.add(123);
        refCollection.add("both");
        DbObjectWithCollection refDbObj = new DbObjectWithCollection("left", refCollection);
        DbProperty refCollProp = new DbProperty(refDbObj, "collection");
        ArrayList<Object> targetCollection = new ArrayList<Object>();
        targetCollection.add(234);
        targetCollection.add("both");
        DbObjectWithCollection targetDbObj = new DbObjectWithCollection("right", targetCollection);
        DbProperty targetCollProp = new DbProperty(targetDbObj, "collection");
        DbValidator validator = (DbValidator)Mockito.mock(DbValidator.class);
        Mockito.when((Object)validator.validates("collection")).thenReturn((Object)true);
        refDbObj.getValidators().add(validator);
        this.comparisonUtils.compareSimpleCollections(refCollProp, targetCollProp, this.ctx);
        ((Results)Mockito.verify((Object)this.differences, (VerificationMode)Mockito.never())).add(Difference.Where.IN_BOTH_NO_DIFFERENCE, this.dbPropForValue(refDbObj, "collection[1]", "both"), this.dbPropForValue(targetDbObj, "collection[1]", "both"));
        ((Results)Mockito.verify((Object)this.differences, (VerificationMode)Mockito.never())).add(Difference.Where.ONLY_IN_REFERENCE, this.dbPropForValue(refDbObj, "collection[0]", 123), this.dbPropForValue(targetDbObj, "collection", targetCollection));
        ((Results)Mockito.verify((Object)this.differences, (VerificationMode)Mockito.never())).add(Difference.Where.ONLY_IN_TARGET, this.dbPropForValue(refDbObj, "collection", refCollection), this.dbPropForValue(targetDbObj, "collection[0]", 234));
    }

    @Test
    public void objectIsNotComparedWhenValidatorTakesResponsibility() {
        DatabaseObject db1 = new DatabaseObject("db1");
        DatabaseObject db2 = new DatabaseObject("db2");
        DatabaseObject db3 = new DatabaseObject("db3");
        DatabaseObject db4 = new DatabaseObject("db4");
        ArrayList reference = new ArrayList();
        Collections.addAll(reference, db1, db3);
        ArrayList target = new ArrayList();
        Collections.addAll(target, db2, db4);
        DbValidator validator = (DbValidator)Mockito.mock(DbValidator.class);
        Mockito.when((Object)validator.validatesFullObject()).thenReturn((Object)true);
        db1.getValidators().add(validator);
        db2.getValidators().add(validator);
        this.comparisonUtils.compareCollections(reference, target, this.ctx);
        ((Results)Mockito.verify((Object)this.differences, (VerificationMode)Mockito.never())).add(Difference.Where.ONLY_IN_REFERENCE, new DbProperty(db1), null);
        ((Results)Mockito.verify((Object)this.differences, (VerificationMode)Mockito.never())).add(Difference.Where.ONLY_IN_TARGET, null, new DbProperty(db2));
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.ONLY_IN_REFERENCE, new DbProperty(db3), null);
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.ONLY_IN_TARGET, null, new DbProperty(db4));
    }

    @Test
    public void orderingFaultsWhenCollectionsSameSize() {
        ArrayList<Object> left = new ArrayList<Object>();
        Collections.addAll(left, 0, "one", 2, "3", "4_this", 5, "6_this", "seven");
        DbObjectWithCollection leftDbObj = new DbObjectWithCollection("left", left);
        DbProperty leftCollProp = new DbProperty(leftDbObj, "collection");
        ArrayList<Object> right = new ArrayList<Object>();
        Collections.addAll(right, 0, "one", 2, "3", "4_that", 5, "6_that", "seven");
        DbObjectWithCollection rightDbObj = new DbObjectWithCollection("right", right);
        DbProperty rightCollProp = new DbProperty(rightDbObj, "collection");
        this.comparisonUtils.compareSimpleOrderedLists(leftCollProp, rightCollProp, this.ctx);
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.IN_BOTH_NO_DIFFERENCE, this.dbPropForValue(leftDbObj, "collection[0]", 0), this.dbPropForValue(rightDbObj, "collection[0]", 0));
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.IN_BOTH_NO_DIFFERENCE, this.dbPropForValue(leftDbObj, "collection[1]", "one"), this.dbPropForValue(rightDbObj, "collection[1]", "one"));
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.IN_BOTH_NO_DIFFERENCE, this.dbPropForValue(leftDbObj, "collection[2]", 2), this.dbPropForValue(rightDbObj, "collection[2]", 2));
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.IN_BOTH_NO_DIFFERENCE, this.dbPropForValue(leftDbObj, "collection[3]", "3"), this.dbPropForValue(rightDbObj, "collection[3]", "3"));
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.IN_BOTH_BUT_DIFFERENCE, this.dbPropForValue(leftDbObj, "collection[4]", "4_this"), this.dbPropForValue(rightDbObj, "collection[4]", "4_that"));
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.IN_BOTH_NO_DIFFERENCE, this.dbPropForValue(leftDbObj, "collection[5]", 5), this.dbPropForValue(rightDbObj, "collection[5]", 5));
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.IN_BOTH_BUT_DIFFERENCE, this.dbPropForValue(leftDbObj, "collection[6]", "6_this"), this.dbPropForValue(rightDbObj, "collection[6]", "6_that"));
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.IN_BOTH_NO_DIFFERENCE, this.dbPropForValue(leftDbObj, "collection[7]", "seven"), this.dbPropForValue(rightDbObj, "collection[7]", "seven"));
    }

    @Test
    public void orderingFaultsWhenReferenceCollectionLonger() {
        ArrayList<Object> reference = new ArrayList<Object>();
        Collections.addAll(reference, "a", "z", "x", "1", "2");
        DbObjectWithCollection refDbObj = new DbObjectWithCollection("reference", reference);
        DbProperty refCollProp = new DbProperty(refDbObj, "collection");
        ArrayList<Object> target = new ArrayList<Object>();
        Collections.addAll(target, "a", "Q", "x");
        DbObjectWithCollection targetDbObj = new DbObjectWithCollection("target", target);
        DbProperty targetCollProp = new DbProperty(targetDbObj, "collection");
        this.comparisonUtils.compareSimpleOrderedLists(refCollProp, targetCollProp, this.ctx);
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.IN_BOTH_NO_DIFFERENCE, this.dbPropForValue(refDbObj, "collection[0]", "a"), this.dbPropForValue(targetDbObj, "collection[0]", "a"));
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.IN_BOTH_BUT_DIFFERENCE, this.dbPropForValue(refDbObj, "collection[1]", "z"), this.dbPropForValue(targetDbObj, "collection[1]", "Q"));
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.IN_BOTH_NO_DIFFERENCE, this.dbPropForValue(refDbObj, "collection[2]", "x"), this.dbPropForValue(targetDbObj, "collection[2]", "x"));
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.ONLY_IN_REFERENCE, this.dbPropForValue(refDbObj, "collection[3]", "1"), null);
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.ONLY_IN_REFERENCE, this.dbPropForValue(refDbObj, "collection[4]", "2"), null);
    }

    @Test
    public void orderingFaultsWhenTargetCollectionLonger() {
        ArrayList<Object> reference = new ArrayList<Object>();
        Collections.addAll(reference, "a", "z", "x");
        DbObjectWithCollection refDbObj = new DbObjectWithCollection("reference", reference);
        DbProperty refCollProp = new DbProperty(refDbObj, "collection");
        ArrayList<Object> target = new ArrayList<Object>();
        Collections.addAll(target, "a", "Q", "x", "1", "2");
        DbObjectWithCollection targetDbObj = new DbObjectWithCollection("target", target);
        DbProperty targetCollProp = new DbProperty(targetDbObj, "collection");
        this.comparisonUtils.compareSimpleOrderedLists(refCollProp, targetCollProp, this.ctx);
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.IN_BOTH_NO_DIFFERENCE, this.dbPropForValue(refDbObj, "collection[0]", "a"), this.dbPropForValue(targetDbObj, "collection[0]", "a"));
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.IN_BOTH_BUT_DIFFERENCE, this.dbPropForValue(refDbObj, "collection[1]", "z"), this.dbPropForValue(targetDbObj, "collection[1]", "Q"));
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.IN_BOTH_NO_DIFFERENCE, this.dbPropForValue(refDbObj, "collection[2]", "x"), this.dbPropForValue(targetDbObj, "collection[2]", "x"));
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.ONLY_IN_TARGET, null, this.dbPropForValue(targetDbObj, "collection[3]", "1"));
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.ONLY_IN_TARGET, null, this.dbPropForValue(targetDbObj, "collection[4]", "2"));
    }

    @Test
    public void compareSimpleCollections() {
        ArrayList<Object> leftCollection = new ArrayList<Object>();
        leftCollection.add(123);
        leftCollection.add("both");
        ArrayList<Object> subCollectionLeft = new ArrayList<Object>();
        subCollectionLeft.add(3);
        subCollectionLeft.add("my string");
        subCollectionLeft.add(10);
        subCollectionLeft.add("another");
        leftCollection.add(subCollectionLeft);
        leftCollection.add(456);
        leftCollection.add("left only");
        DbObjectWithCollection leftDbObj = new DbObjectWithCollection("left", leftCollection);
        DbProperty leftCollProp = new DbProperty(leftDbObj, "collection");
        ArrayList<Object> rightCollection = new ArrayList<Object>();
        rightCollection.add(123);
        rightCollection.add(789);
        ArrayList subCollectionRight = new ArrayList(subCollectionLeft);
        rightCollection.add(subCollectionRight);
        rightCollection.add("right only");
        rightCollection.add("both");
        rightCollection.add("one more right only");
        DbObjectWithCollection rightDbObj = new DbObjectWithCollection("right", rightCollection);
        DbProperty rightCollProp = new DbProperty(rightDbObj, "collection");
        this.comparisonUtils.compareSimpleCollections(leftCollProp, rightCollProp, this.ctx);
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.IN_BOTH_NO_DIFFERENCE, this.dbPropForValue(leftDbObj, "collection[0]", 123), this.dbPropForValue(rightDbObj, "collection[0]", 123));
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.IN_BOTH_NO_DIFFERENCE, this.dbPropForValue(leftDbObj, "collection[1]", "both"), this.dbPropForValue(rightDbObj, "collection[4]", "both"));
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.IN_BOTH_NO_DIFFERENCE, this.dbPropForValue(leftDbObj, "collection[2]", subCollectionLeft), this.dbPropForValue(rightDbObj, "collection[2]", subCollectionRight));
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.ONLY_IN_REFERENCE, this.dbPropForValue(leftDbObj, "collection[3]", 456), this.dbPropForValue(rightDbObj, "collection", rightCollection));
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.ONLY_IN_REFERENCE, this.dbPropForValue(leftDbObj, "collection[4]", "left only"), this.dbPropForValue(rightDbObj, "collection", rightCollection));
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.ONLY_IN_TARGET, this.dbPropForValue(leftDbObj, "collection", leftCollection), this.dbPropForValue(rightDbObj, "collection[1]", 789));
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.ONLY_IN_TARGET, this.dbPropForValue(leftDbObj, "collection", leftCollection), this.dbPropForValue(rightDbObj, "collection[3]", "right only"));
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.ONLY_IN_TARGET, this.dbPropForValue(leftDbObj, "collection", leftCollection), this.dbPropForValue(rightDbObj, "collection[5]", "one more right only"));
    }

    private DbProperty dbPropForValue(DbObject obj, String propName, Object propValue) {
        return new DbProperty(obj, propName, -1, true, propValue);
    }

    private List<DbObject> createMockDbObjects(int size) {
        ArrayList<DbObject> dbObjects = new ArrayList<DbObject>(size);
        for (int i = 0; i < size; ++i) {
            DbObject dbo = (DbObject)Mockito.mock(DbObject.class);
            Mockito.when((Object)dbo.toString()).thenReturn((Object)("Mock DbObject " + i));
            dbObjects.add(dbo);
        }
        return dbObjects;
    }

    public static class DatabaseObject
    extends AbstractDbObject {
        private DbObject[] equivalentObjects = new DbObject[0];

        public DatabaseObject(String name) {
            super(null, name);
        }

        public DatabaseObject(String name, DbObject ... equivalentObjects) {
            this(name);
            this.equivalentObjects = equivalentObjects;
        }

        @Override
        public void accept(DbObjectVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        protected void doDiff(DbObject right, DiffContext ctx) {
            DbProperty leftProp = new DbProperty(this);
            DbProperty rightProp = new DbProperty(right);
            ctx.getComparisonResults().add(Difference.Where.IN_BOTH_BUT_DIFFERENCE, leftProp, rightProp);
        }

        @Override
        public boolean sameAs(DbObject other) {
            for (DbObject o : this.equivalentObjects) {
                if (!other.equals(o)) continue;
                return true;
            }
            return super.sameAs(other);
        }
    }

    public static class DbObjectWithCollection
    extends AbstractDbObject {
        private Collection<Object> collection;

        public DbObjectWithCollection(String name, Collection<Object> collection) {
            super(null, name);
            this.collection = collection;
        }

        @Override
        public void accept(DbObjectVisitor visitor) {
        }

        public Collection<Object> getCollection() {
            return this.collection;
        }
    }
}

