/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.alfresco.util.TempFileProvider;
import org.alfresco.util.schemacomp.DbToXML;
import org.alfresco.util.schemacomp.MultiFileDumper;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class MultiFileDumperTest {
    @Mock
    private MultiFileDumper.DbToXMLFactory dbToXMLFactory;
    @Mock
    private DbToXML dbToXMLForA;
    @Mock
    private DbToXML dbToXMLForB;
    @Mock
    private DbToXML dbToXMLForC;

    @Test(expected=IllegalArgumentException.class)
    public void exceptionThrownWhenZeroPrefixesUsed() {
        new MultiFileDumper(new String[0], TempFileProvider.getTempDir(), "", this.dbToXMLFactory);
    }

    @Test(expected=IllegalArgumentException.class)
    public void exceptionThrownWhenNullPrefixListUsed() {
        new MultiFileDumper(null, TempFileProvider.getTempDir(), "", this.dbToXMLFactory);
    }

    @Test
    public void canDumpSchemaToFiles() {
        String[] prefixes = new String[]{"a_", "b_", "c_"};
        File directory = TempFileProvider.getTempDir();
        String fileNamePattern = "SchemaDump-MySQL-{0}-";
        MultiFileDumper dumper = new MultiFileDumper(prefixes, directory, fileNamePattern, this.dbToXMLFactory);
        Mockito.when((Object)this.dbToXMLFactory.create((File)Matchers.argThat(this.isFileNameStartingWith("SchemaDump-MySQL-a_-")), (String)Matchers.eq((Object)"a_"))).thenReturn((Object)this.dbToXMLForA);
        Mockito.when((Object)this.dbToXMLFactory.create((File)Matchers.argThat(this.isFileNameStartingWith("SchemaDump-MySQL-b_-")), (String)Matchers.eq((Object)"b_"))).thenReturn((Object)this.dbToXMLForB);
        Mockito.when((Object)this.dbToXMLFactory.create((File)Matchers.argThat(this.isFileNameStartingWith("SchemaDump-MySQL-c_-")), (String)Matchers.eq((Object)"c_"))).thenReturn((Object)this.dbToXMLForC);
        List<File> files = dumper.dumpFiles();
        Iterator<File> it = files.iterator();
        this.assertPathCorrect("SchemaDump-MySQL-a_-", directory, it.next());
        this.assertPathCorrect("SchemaDump-MySQL-b_-", directory, it.next());
        this.assertPathCorrect("SchemaDump-MySQL-c_-", directory, it.next());
        ((DbToXML)Mockito.verify((Object)this.dbToXMLForA)).execute();
        ((DbToXML)Mockito.verify((Object)this.dbToXMLForB)).execute();
        ((DbToXML)Mockito.verify((Object)this.dbToXMLForC)).execute();
    }

    @Test
    public void canDumpSchemaToFilesForDefaultDBPrefixes() {
        File directory = TempFileProvider.getTempDir();
        String fileNamePattern = "SchemaDump-MySQL-{0}-";
        MultiFileDumper dumper = new MultiFileDumper(directory, fileNamePattern, this.dbToXMLFactory);
        HashMap<String, DbToXML> xmlExporters = new HashMap<String, DbToXML>(MultiFileDumper.DEFAULT_PREFIXES.length);
        for (String prefix : MultiFileDumper.DEFAULT_PREFIXES) {
            DbToXML dbToXML = (DbToXML)Mockito.mock(DbToXML.class);
            xmlExporters.put(prefix, dbToXML);
            Mockito.when((Object)this.dbToXMLFactory.create((File)Matchers.any(File.class), (String)Matchers.eq((Object)prefix))).thenReturn((Object)dbToXML);
        }
        dumper.dumpFiles();
        for (DbToXML dbToXML : xmlExporters.values()) {
            ((DbToXML)Mockito.verify((Object)dbToXML)).execute();
        }
    }

    private ArgumentMatcher<File> isFileNameStartingWith(String startOfName) {
        return new FileNameBeginsWith(startOfName);
    }

    private void assertPathCorrect(String expectedFileNamePrefix, File expectedDirectory, File actualFile) {
        File expectedPath = new File(expectedDirectory, expectedFileNamePrefix);
        if (!actualFile.getAbsolutePath().startsWith(expectedPath.getAbsolutePath())) {
            String failureMsg = "File path " + actualFile.getAbsolutePath() + " does not start as expected: " + expectedPath.getAbsolutePath();
            Assert.fail((String)failureMsg);
        }
    }

    private static class FileNameBeginsWith
    extends ArgumentMatcher<File> {
        private final String startOfName;

        public FileNameBeginsWith(String startOfName) {
            this.startOfName = startOfName;
        }

        public boolean matches(Object arg) {
            if (arg != null) {
                File fileArg = (File)arg;
                return fileArg.getName().startsWith(this.startOfName);
            }
            return false;
        }
    }
}

