/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.test.junitrules;

import org.alfresco.util.test.junitrules.TemporaryMockOverride;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TemporaryMockOverrideTest {
    private static final String REAL_DATA = "Hello";
    private static final String MOCKED_DATA = "--";
    private final FooService realFooService = new FooServiceImpl();
    private final BarService realBarService = new BarServiceImpl();
    private final AbcService realAbcService = new AbcServiceImpl();

    @Before
    public void init() {
        FooServiceImpl fooServiceImpl = (FooServiceImpl)this.realFooService;
        fooServiceImpl.setBarService(this.realBarService);
        fooServiceImpl.setAbcService(this.realAbcService);
    }

    @Test
    public void mockFieldsWithinServiceAndThenEnsureTheProperFieldValuesAreRestoredAfterCleanup() throws Throwable {
        TemporaryMockOverride mockRule = new TemporaryMockOverride();
        mockRule.before();
        Assert.assertEquals((String)"Original BarService giving wrong data.", (Object)REAL_DATA, (Object)this.realFooService.getBarService().getString());
        Assert.assertEquals((String)"Original AbcService giving wrong data.", (Object)REAL_DATA, (Object)this.realFooService.getAbcService().getString());
        BarService mockedBarService = (BarService)Mockito.mock(BarService.class);
        Mockito.when((Object)mockedBarService.getString()).thenReturn((Object)MOCKED_DATA);
        AbcService mockedAbcService = (AbcService)Mockito.mock(AbcService.class);
        Mockito.when((Object)mockedAbcService.getString()).thenReturn((Object)MOCKED_DATA);
        FooServiceImpl fooServiceWithMockedServices = new FooServiceImpl();
        fooServiceWithMockedServices.setBarService(this.realBarService);
        fooServiceWithMockedServices.setAbcService(this.realAbcService);
        mockRule.setTemporaryField(fooServiceWithMockedServices, "barService", mockedBarService);
        mockRule.setTemporaryField(fooServiceWithMockedServices, "abcService", mockedAbcService);
        Assert.assertEquals((String)"Mocked BarService giving wrong data.", (Object)MOCKED_DATA, (Object)fooServiceWithMockedServices.getBarService().getString());
        Assert.assertEquals((String)"Mocked AbcService giving wrong data.", (Object)MOCKED_DATA, (Object)fooServiceWithMockedServices.getAbcService().getString());
        mockRule.after();
        Assert.assertEquals((String)"BarService giving wrong data.", (Object)REAL_DATA, (Object)fooServiceWithMockedServices.getBarService().getString());
        Assert.assertEquals((String)"AbcService giving wrong data.", (Object)REAL_DATA, (Object)fooServiceWithMockedServices.getAbcService().getString());
    }

    @Test(expected=IllegalArgumentException.class)
    public void mockNonExistentFieldsWithinService() throws Throwable {
        TemporaryMockOverride mockRule = new TemporaryMockOverride();
        mockRule.before();
        Assert.assertEquals((String)"Original BarService giving wrong data.", (Object)REAL_DATA, (Object)this.realFooService.getBarService().getString());
        BarService mockedBarService = (BarService)Mockito.mock(BarService.class);
        Mockito.when((Object)mockedBarService.getString()).thenReturn((Object)MOCKED_DATA);
        FooServiceImpl fooServiceWithMockedServices = new FooServiceImpl();
        fooServiceWithMockedServices.setBarService(this.realBarService);
        mockRule.setTemporaryField(fooServiceWithMockedServices, "noSuchService", mockedBarService);
        Assert.assertEquals((String)"Mocked BarService giving wrong data.", (Object)MOCKED_DATA, (Object)fooServiceWithMockedServices.getBarService().getString());
        mockRule.after();
        Assert.assertEquals((String)"BarService giving wrong data.", (Object)REAL_DATA, (Object)fooServiceWithMockedServices.getBarService().getString());
    }

    public class AbcServiceImpl
    implements AbcService {
        @Override
        public String getString() {
            return TemporaryMockOverrideTest.REAL_DATA;
        }
    }

    public static interface AbcService {
        public String getString();
    }

    public class BarServiceImpl
    implements BarService {
        @Override
        public String getString() {
            return TemporaryMockOverrideTest.REAL_DATA;
        }
    }

    public static interface BarService {
        public String getString();
    }

    public class FooServiceImpl
    implements FooService {
        private BarService barService;
        private AbcService abcService;

        @Override
        public BarService getBarService() {
            return this.barService;
        }

        public void setBarService(BarService barService) {
            this.barService = barService;
        }

        @Override
        public AbcService getAbcService() {
            return this.abcService;
        }

        public void setAbcService(AbcService abcService) {
            this.abcService = abcService;
        }
    }

    public static interface FooService {
        public BarService getBarService();

        public AbcService getAbcService();
    }
}

