/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.webproject.script;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.jscript.ScriptableHashMap;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.wcm.sandbox.SandboxInfo;
import org.alfresco.wcm.sandbox.SandboxService;
import org.alfresco.wcm.sandbox.script.Sandbox;
import org.alfresco.wcm.webproject.WebProjectInfo;
import org.alfresco.wcm.webproject.WebProjectService;
import org.alfresco.wcm.webproject.script.WebProjects;

public class WebProject
implements Serializable {
    public static final String ROLE_CONTENT_MANAGER = "ContentManager";
    public static final String ROLE_CONTENT_PUBLISHER = "ContentPublisher";
    public static final String ROLE_CONTENT_REVIEWER = "ContentReviewer";
    public static final String ROLE_CONTENT_CONTRIBUTOR = "ContentContributor";
    private static final long serialVersionUID = -2194205151549790079L;
    WebProjectInfo info;
    private String name;
    private String title;
    private String description;
    private boolean isTemplate;
    private String webProjectRef;
    private WebProjects webprojects;

    public WebProject(WebProjects webprojects, WebProjectInfo info) {
        this.info = info;
        this.name = info.getName();
        this.title = info.getTitle();
        this.description = info.getDescription();
        this.isTemplate = info.isTemplate();
        this.webProjectRef = info.getStoreId();
        this.webprojects = webprojects;
    }

    public void setName(String name) {
        this.name = name;
        if (this.info != null) {
            this.info.setName(name);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setTitle(String title) {
        this.title = title;
        if (this.info != null) {
            this.info.setTitle(title);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setDescription(String description) {
        this.description = description;
        if (this.info != null) {
            this.info.setDescription(description);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setTemplate(boolean isTemplate) {
        this.isTemplate = isTemplate;
        if (this.info != null) {
            this.info.setIsTemplate(isTemplate);
        }
    }

    public boolean isTemplate() {
        return this.isTemplate;
    }

    public void setWebProjectRef(String webProjectRef) {
        this.webProjectRef = webProjectRef;
    }

    public String getWebProjectRef() {
        return this.webProjectRef;
    }

    public NodeRef getNodeRef() {
        return this.info.getNodeRef();
    }

    public void deleteWebProject() {
        this.getWebProjectService().deleteWebProject(this.webProjectRef);
    }

    public void save() {
        this.getWebProjectService().updateWebProject(this.info);
    }

    public ScriptableHashMap<String, Sandbox> getSandboxes(String userName) {
        ScriptableHashMap<String, Sandbox> result = new ScriptableHashMap<String, Sandbox>();
        SandboxInfo si = this.getSandboxService().getAuthorSandbox(this.webProjectRef, userName);
        if (si != null) {
            Sandbox sandbox = new Sandbox(this, si);
            result.put(userName, sandbox);
        }
        return result;
    }

    public Sandbox createSandbox(String userName) {
        SandboxInfo si = this.getSandboxService().createAuthorSandbox(this.webProjectRef, userName);
        Sandbox sandbox = new Sandbox(this, si);
        return sandbox;
    }

    public Sandbox getSandbox(String sandboxRef) {
        SandboxInfo si = this.getSandboxService().getSandbox(sandboxRef);
        if (si != null) {
            Sandbox sandbox = new Sandbox(this, si);
            return sandbox;
        }
        return null;
    }

    public ScriptableHashMap<String, Sandbox> getSandboxes() {
        List<SandboxInfo> si = this.getSandboxService().listSandboxes(this.webProjectRef);
        ScriptableHashMap<String, Sandbox> result = new ScriptableHashMap<String, Sandbox>();
        for (SandboxInfo s : si) {
            Sandbox b = new Sandbox(this, s);
            result.put(b.getSandboxRef(), b);
        }
        return result;
    }

    public String getMembersRole(String userName) {
        return this.getWebProjectService().getWebUserRole(this.webProjectRef, userName);
    }

    public void addMembership(String userName, String role) {
        this.getWebProjectService().inviteWebUser(this.webProjectRef, userName, role);
    }

    public void removeMembership(String userName) {
        this.getWebProjectService().uninviteWebUser(this.webProjectRef, userName);
    }

    public ScriptableHashMap<String, String> listMembers() {
        Map<String, String> members = this.getWebProjectService().listWebUsers(this.webProjectRef);
        ScriptableHashMap<String, String> result = new ScriptableHashMap<String, String>();
        result.putAll(members);
        return result;
    }

    public ScriptableHashMap<String, String> getRoles() {
        ScriptableHashMap<String, String> result = new ScriptableHashMap<String, String>();
        result.put(ROLE_CONTENT_MANAGER, "Content Manager");
        result.put(ROLE_CONTENT_PUBLISHER, "Content Publisher");
        result.put(ROLE_CONTENT_REVIEWER, "Content Reviewer");
        result.put(ROLE_CONTENT_CONTRIBUTOR, "Content Contributor");
        return result;
    }

    public WebProjects getWebProjects() {
        return this.webprojects;
    }

    public SandboxService getSandboxService() {
        return this.getWebProjects().getSandboxService();
    }

    public WebProjectService getWebProjectService() {
        return this.getWebProjects().getWebProjectService();
    }
}

