/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.config.element;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.extensions.config.ConfigElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConfigElementAdapter
implements ConfigElement {
    private static final long serialVersionUID = -2301220755382165891L;
    protected String name;
    protected String value;
    protected Map<String, String> attributes;
    protected List<ConfigElement> children;

    public ConfigElementAdapter(String name) {
        this.name = name;
        this.attributes = new HashMap<String, String>();
        this.children = new ArrayList<ConfigElement>();
    }

    @Override
    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    @Override
    public int getAttributeCount() {
        return this.attributes.size();
    }

    @Override
    public List<ConfigElement> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public List<ConfigElement> getChildren(String name) {
        LinkedList<ConfigElement> result = new LinkedList<ConfigElement>();
        if (this.hasChildren()) {
            for (ConfigElement ce : this.children) {
                if (!ce.getName().equals(name)) continue;
                result.add(ce);
            }
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public ConfigElement getChild(String name) {
        ConfigElement child = null;
        if (this.hasChildren()) {
            for (ConfigElement ce : this.children) {
                if (!ce.getName().equals(name)) continue;
                child = ce;
                break;
            }
        }
        return child;
    }

    @Override
    public String getChildValue(String name) {
        ConfigElement ce = this.getChild(name);
        return ce != null ? ce.getValue() : null;
    }

    public Map<String, List<ConfigElement>> getChildrenMap() {
        LinkedHashMap<String, List<ConfigElement>> map = new LinkedHashMap<String, List<ConfigElement>>();
        if (this.hasChildren()) {
            for (ConfigElement ce : this.children) {
                List<ConfigElement> list;
                String name = ce.getName();
                if (map.containsKey(name)) {
                    list = (List)map.get(name);
                    list.add(ce);
                    continue;
                }
                list = new ArrayList();
                list.add(ce);
                map.put(name, list);
            }
        }
        return map;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.attributes.containsKey(name);
    }

    @Override
    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(super.toString());
        buffer.append(" (name=").append(this.name).append(")");
        return buffer.toString();
    }

    @Override
    public abstract ConfigElement combine(ConfigElement var1);
}

