/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.acl;

import org.alfresco.cmis.CMISAccessControlEntry;

public class CMISAccessControlEntryImpl
implements CMISAccessControlEntry {
    private String principalId;
    private String permission;
    private int position;
    private boolean direct;

    CMISAccessControlEntryImpl(String principalId, String permission, int position, boolean direct) {
        this.principalId = principalId;
        this.permission = permission;
        this.position = position;
        this.direct = direct;
    }

    CMISAccessControlEntryImpl(String principalId, String permission, int position) {
        this(principalId, permission, position, position == 0);
    }

    public CMISAccessControlEntryImpl(String principalId, String permission) {
        this(principalId, permission, 0);
    }

    @Override
    public boolean getDirect() {
        return this.direct;
    }

    @Override
    public String getPermission() {
        return this.permission;
    }

    @Override
    public String getPrincipalId() {
        return this.principalId;
    }

    public int getPosition() {
        return this.position;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.direct ? 1231 : 1237);
        result = 31 * result + (this.permission == null ? 0 : this.permission.hashCode());
        result = 31 * result + this.position;
        result = 31 * result + (this.principalId == null ? 0 : this.principalId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CMISAccessControlEntryImpl other = (CMISAccessControlEntryImpl)obj;
        if (this.direct != other.direct) {
            return false;
        }
        if (this.permission == null ? other.permission != null : !this.permission.equals(other.permission)) {
            return false;
        }
        if (this.position != other.position) {
            return false;
        }
        return !(this.principalId == null ? other.principalId != null : !this.principalId.equals(other.principalId));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(this.getPrincipalId()).append(", ");
        builder.append(this.getPermission()).append(", ");
        builder.append(this.getPosition()).append(", ");
        builder.append(this.getDirect()).append("]");
        return builder.toString();
    }
}

