/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.changelog;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.alfresco.cmis.CMISBaseObjectTypeIds;
import org.alfresco.cmis.CMISCapabilityChanges;
import org.alfresco.cmis.CMISChangeEvent;
import org.alfresco.cmis.CMISChangeLog;
import org.alfresco.cmis.CMISChangeLogService;
import org.alfresco.cmis.CMISChangeType;
import org.alfresco.cmis.CMISInvalidArgumentException;
import org.alfresco.cmis.changelog.CMISChangeEventImpl;
import org.alfresco.cmis.changelog.CMISChangeLogImpl;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.service.cmr.audit.AuditQueryParameters;
import org.alfresco.service.cmr.audit.AuditService;
import org.alfresco.service.cmr.repository.NodeRef;

public class CMISChangeLogServiceImpl
implements CMISChangeLogService {
    private static final String PATH_DELIMITER = "/";
    private static final int DEFAULT_RETURN_SIZE = 100;
    private AuditService auditService;
    private String cmisAuditApplicationName;
    private List<CMISBaseObjectTypeIds> changesOnTypeCapability;

    public void setAuditService(AuditService auditService) {
        this.auditService = auditService;
    }

    public void setCmisAuditApplicationName(String cmisAuditApplicationName) {
        this.cmisAuditApplicationName = cmisAuditApplicationName;
    }

    public void setChangesOnTypeCapability(List<CMISBaseObjectTypeIds> changesOnTypeCapability) {
        this.changesOnTypeCapability = changesOnTypeCapability;
    }

    @Override
    public CMISCapabilityChanges getCapability() {
        return this.auditService.isAuditEnabled(this.cmisAuditApplicationName, PATH_DELIMITER + this.cmisAuditApplicationName) ? CMISCapabilityChanges.OBJECTIDSONLY : CMISCapabilityChanges.NONE;
    }

    @Override
    public CMISChangeLog getChangeLogEvents(String changeLogToken, Integer maxItems) throws CMISInvalidArgumentException {
        Long from;
        if (!this.auditService.isAuditEnabled(this.cmisAuditApplicationName, PATH_DELIMITER + this.cmisAuditApplicationName)) {
            throw new AlfrescoRuntimeException("Auditing for " + this.cmisAuditApplicationName + " is disabled!");
        }
        CMISChangeLogImpl result = new CMISChangeLogImpl();
        final List<CMISChangeEvent> changeEvents = result.getChangeEvents();
        EntryIdCallback changeLogCollectingCallback = new EntryIdCallback(true){

            @Override
            public boolean handleAuditEntry(Long entryId, String user, long time, Map<String, Serializable> values) {
                List changeLogEvents = CMISChangeLogServiceImpl.this.convertValuesMapToChangeLogEvents(values, time);
                changeEvents.addAll(changeLogEvents);
                return super.handleAuditEntry(entryId, user, time, values);
            }
        };
        try {
            from = changeLogToken != null ? Long.valueOf(Long.parseLong(changeLogToken)) : null;
        }
        catch (NumberFormatException e) {
            throw new CMISInvalidArgumentException("Invalid change log token " + changeLogToken);
        }
        AuditQueryParameters params = new AuditQueryParameters();
        params.setApplicationName(this.cmisAuditApplicationName);
        params.setForward(true);
        params.setFromId(from);
        int maxAmount = null == maxItems || 0 == maxItems ? 0 : maxItems + 1;
        this.auditService.auditQuery(changeLogCollectingCallback, params, maxAmount);
        if (0 != maxAmount && changeEvents.size() > maxItems) {
            changeEvents.remove(changeEvents.size() - 1);
            result.setNextChangeToken(changeLogCollectingCallback.getEntryId().toString());
            result.setHasMoreItems(true);
        }
        return result;
    }

    @Override
    public boolean getChangesIncomplete() {
        return true;
    }

    @Override
    public String getLastChangeLogToken() {
        EntryIdCallback auditQueryCallback = new EntryIdCallback(false);
        AuditQueryParameters params = new AuditQueryParameters();
        params.setApplicationName(this.cmisAuditApplicationName);
        params.setForward(false);
        this.auditService.auditQuery(auditQueryCallback, params, 1);
        return auditQueryCallback.getEntryId();
    }

    @Override
    public String getPreviousPageChangeLogToken(String currentPageToken, Integer maxItems) {
        if (currentPageToken == null) {
            return null;
        }
        maxItems = maxItems == null ? 100 : maxItems;
        EntryIdCallback auditQueryCallback = new EntryIdCallback(false);
        AuditQueryParameters params = new AuditQueryParameters();
        params.setApplicationName(this.cmisAuditApplicationName);
        params.setForward(false);
        params.setToId(Long.parseLong(currentPageToken));
        this.auditService.auditQuery(auditQueryCallback, params, maxItems);
        return auditQueryCallback.getEntryId();
    }

    @Override
    public String getLastPageChangeLogToken(String currentPageToken, Integer maxItems) {
        maxItems = maxItems == null ? 100 : maxItems;
        PageStartEntryIdCallback auditQueryCallback = new PageStartEntryIdCallback(maxItems);
        AuditQueryParameters params = new AuditQueryParameters();
        params.setApplicationName(this.cmisAuditApplicationName);
        if (currentPageToken != null) {
            params.setFromId(Long.parseLong(currentPageToken));
        }
        this.auditService.auditQuery(auditQueryCallback, params, -1);
        return auditQueryCallback.getEntryId();
    }

    @Override
    public List<CMISBaseObjectTypeIds> getChangesOnTypeCapability() {
        if (null == this.changesOnTypeCapability) {
            this.changesOnTypeCapability = new LinkedList<CMISBaseObjectTypeIds>();
        }
        return this.changesOnTypeCapability;
    }

    private List<CMISChangeEvent> convertValuesMapToChangeLogEvents(Map<String, Serializable> values, long time) {
        ArrayList<CMISChangeEvent> result = new ArrayList<CMISChangeEvent>();
        if (values != null && values.size() > 0) {
            for (Map.Entry<String, Serializable> entry : values.entrySet()) {
                String path;
                CMISChangeType changeType;
                if (entry.getKey() == null || entry.getValue() == null || (changeType = this.getCMISChangeType(path = entry.getKey())) == null || !(entry.getValue() instanceof Map)) continue;
                Map valueMap = (Map)((Object)entry.getValue());
                result.add(new CMISChangeEventImpl(changeType, new Date(time), (NodeRef)valueMap.get("nodeRef"), (String)valueMap.get("objectId")));
            }
        }
        return result;
    }

    private CMISChangeType getCMISChangeType(String auditPath) {
        CMISChangeType result = null;
        if (auditPath != null) {
            if (auditPath.startsWith(PATH_DELIMITER)) {
                auditPath = auditPath.substring(PATH_DELIMITER.length());
            }
            if (auditPath.startsWith(this.cmisAuditApplicationName)) {
                auditPath = auditPath.substring(this.cmisAuditApplicationName.length());
            }
            if (auditPath.startsWith(PATH_DELIMITER)) {
                auditPath = auditPath.substring(PATH_DELIMITER.length());
            }
            auditPath = auditPath.toLowerCase();
            for (CMISChangeType changeType : CMISChangeType.values()) {
                if (!auditPath.startsWith(changeType.getLabel())) continue;
                result = changeType;
                break;
            }
        }
        return result;
    }

    private class PageStartEntryIdCallback
    extends EntryIdCallback {
        private final int pageSize;
        private int indexWithinPage;

        public PageStartEntryIdCallback(int pageSize) {
            super(false);
            this.pageSize = pageSize;
            this.indexWithinPage = -1;
        }

        @Override
        public boolean handleAuditEntry(Long entryId, String user, long time, Map<String, Serializable> values) {
            if (++this.indexWithinPage == this.pageSize) {
                this.indexWithinPage = 0;
                return super.handleAuditEntry(entryId, user, time, values);
            }
            return true;
        }
    }

    private class EntryIdCallback
    implements AuditService.AuditQueryCallback {
        private final boolean valuesRequired;
        private Long entryId;

        public EntryIdCallback(boolean valuesRequired) {
            this.valuesRequired = valuesRequired;
        }

        public String getEntryId() {
            return this.entryId == null ? null : this.entryId.toString();
        }

        @Override
        public boolean valuesRequired() {
            return this.valuesRequired;
        }

        @Override
        public final boolean handleAuditEntry(Long entryId, String applicationName, String user, long time, Map<String, Serializable> values) {
            if (applicationName.equals(CMISChangeLogServiceImpl.this.cmisAuditApplicationName)) {
                return this.handleAuditEntry(entryId, user, time, values);
            }
            return true;
        }

        public boolean handleAuditEntry(Long entryId, String user, long time, Map<String, Serializable> values) {
            this.entryId = entryId;
            return true;
        }

        @Override
        public boolean handleAuditEntryError(Long entryId, String errorMsg, Throwable error) {
            throw new AlfrescoRuntimeException(errorMsg, error);
        }
    }
}

