/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.mapping;

import org.alfresco.cmis.CMISAllowedActionEnum;
import org.alfresco.cmis.mapping.AbstractActionEvaluator;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;

public class PermissionActionEvaluator
extends AbstractActionEvaluator<NodeRef> {
    private String[] permissions;
    private PermissionService permissionService;

    protected PermissionActionEvaluator(ServiceRegistry serviceRegistry, CMISAllowedActionEnum action, String ... permission) {
        super(serviceRegistry, action);
        this.permissions = permission;
        this.permissionService = serviceRegistry.getPermissionService();
    }

    @Override
    public boolean isAllowed(NodeRef nodeRef) {
        for (String permission : this.permissions) {
            if (this.permissionService.hasPermission(nodeRef, permission) != AccessStatus.DENIED) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PermissionActionEvaluator[action=").append((Object)this.getAction());
        builder.append(", permissions=");
        for (String permission : this.permissions) {
            builder.append(permission).append(",");
        }
        builder.append("]");
        return builder.toString();
    }
}

