/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.search;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.alfresco.repo.search.impl.lucene.AnalysisMode;
import org.alfresco.repo.search.impl.parsers.CMIS_FTSLexer;
import org.alfresco.repo.search.impl.parsers.CMIS_FTSParser;
import org.alfresco.repo.search.impl.parsers.FTSQueryException;
import org.alfresco.repo.search.impl.querymodel.Column;
import org.alfresco.repo.search.impl.querymodel.Constraint;
import org.alfresco.repo.search.impl.querymodel.Function;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.LiteralArgument;
import org.alfresco.repo.search.impl.querymodel.QueryModelFactory;
import org.alfresco.repo.search.impl.querymodel.QueryOptions;
import org.alfresco.repo.search.impl.querymodel.Selector;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;

public class CMISFTSQueryParser {
    public static Constraint buildFTS(String ftsExpression, QueryModelFactory factory, FunctionEvaluationContext functionEvaluationContext, Selector selector, Map<String, Column> columnMap, String defaultField) {
        CMIS_FTSParser parser = null;
        try {
            ANTLRStringStream cs = new ANTLRStringStream(ftsExpression);
            CMIS_FTSLexer lexer = new CMIS_FTSLexer((CharStream)cs);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            parser = new CMIS_FTSParser((TokenStream)tokens);
            CommonTree ftsNode = (CommonTree)parser.cmisFtsQuery().getTree();
            return CMISFTSQueryParser.buildFTSConnective(ftsNode, factory, functionEvaluationContext, selector, columnMap, defaultField);
        }
        catch (RecognitionException e) {
            if (parser != null) {
                String[] tokenNames = parser.getTokenNames();
                String hdr = parser.getErrorHeader(e);
                String msg = parser.getErrorMessage(e, tokenNames);
                throw new FTSQueryException(hdr + "\n" + msg, (Throwable)e);
            }
            return null;
        }
    }

    private static Constraint buildFTSConnective(CommonTree node, QueryModelFactory factory, FunctionEvaluationContext functionEvaluationContext, Selector selector, Map<String, Column> columnMap, String defaultField) {
        QueryOptions.Connective connective;
        switch (node.getType()) {
            case 6: {
                connective = QueryOptions.Connective.OR;
                break;
            }
            case 4: {
                connective = QueryOptions.Connective.AND;
                break;
            }
            default: {
                throw new FTSQueryException("Invalid connective ..." + node.getText());
            }
        }
        ArrayList<Constraint> constraints = new ArrayList<Constraint>(node.getChildCount());
        for (int i = 0; i < node.getChildCount(); ++i) {
            Constraint constraint;
            CommonTree subNode = (CommonTree)node.getChild(i);
            switch (subNode.getType()) {
                case 4: 
                case 6: {
                    constraint = CMISFTSQueryParser.buildFTSConnective(subNode, factory, functionEvaluationContext, selector, columnMap, defaultField);
                    break;
                }
                case 5: {
                    CommonTree testNode = (CommonTree)subNode.getChild(0);
                    constraint = CMISFTSQueryParser.buildFTSTest(testNode, factory, functionEvaluationContext, selector, columnMap, defaultField);
                    constraint.setOccur(Constraint.Occur.DEFAULT);
                    break;
                }
                case 7: {
                    CommonTree testNode = (CommonTree)subNode.getChild(0);
                    constraint = CMISFTSQueryParser.buildFTSTest(testNode, factory, functionEvaluationContext, selector, columnMap, defaultField);
                    constraint.setOccur(Constraint.Occur.EXCLUDE);
                    break;
                }
                default: {
                    throw new FTSQueryException("Unsupported FTS option " + subNode.getText());
                }
            }
            constraints.add(constraint);
        }
        if (constraints.size() == 1) {
            return (Constraint)constraints.get(0);
        }
        if (connective == QueryOptions.Connective.OR) {
            return factory.createDisjunction(constraints);
        }
        return factory.createConjunction(constraints);
    }

    private static Constraint buildFTSTest(CommonTree argNode, QueryModelFactory factory, FunctionEvaluationContext functionEvaluationContext, Selector selector, Map<String, Column> columnMap, String defaultField) {
        CommonTree testNode = argNode;
        switch (testNode.getType()) {
            case 4: 
            case 6: {
                return CMISFTSQueryParser.buildFTSConnective(testNode, factory, functionEvaluationContext, selector, columnMap, defaultField);
            }
            case 16: {
                return CMISFTSQueryParser.buildTerm(testNode, factory, functionEvaluationContext, selector, columnMap);
            }
            case 14: {
                return CMISFTSQueryParser.buildPhrase(testNode, factory, functionEvaluationContext, selector, columnMap);
            }
        }
        throw new FTSQueryException("Unsupported FTS option " + testNode.getText());
    }

    private static Constraint buildPhrase(CommonTree testNode, QueryModelFactory factory, FunctionEvaluationContext functionEvaluationContext, Selector selector, Map<String, Column> columnMap) {
        String functionName = "FTSPhrase";
        Function function = factory.getFunction(functionName);
        LinkedHashMap<String, LiteralArgument> functionArguments = new LinkedHashMap<String, LiteralArgument>();
        LiteralArgument larg = factory.createLiteralArgument("Phrase", DataTypeDefinition.TEXT, (Serializable)((Object)CMISFTSQueryParser.getText(testNode.getChild(0))));
        functionArguments.put(larg.getName(), larg);
        larg = factory.createLiteralArgument("TokenisationMode", DataTypeDefinition.ANY, (Serializable)AnalysisMode.DEFAULT);
        functionArguments.put(larg.getName(), larg);
        return factory.createFunctionalConstraint(function, functionArguments);
    }

    private static Constraint buildTerm(CommonTree testNode, QueryModelFactory factory, FunctionEvaluationContext functionEvaluationContext, Selector selector, Map<String, Column> columnMap) {
        String functionName = "FTSTerm";
        Function function = factory.getFunction(functionName);
        LinkedHashMap<String, LiteralArgument> functionArguments = new LinkedHashMap<String, LiteralArgument>();
        LiteralArgument larg = factory.createLiteralArgument("Term", DataTypeDefinition.TEXT, (Serializable)((Object)CMISFTSQueryParser.getText(testNode.getChild(0))));
        functionArguments.put(larg.getName(), larg);
        larg = factory.createLiteralArgument("TokenisationMode", DataTypeDefinition.ANY, (Serializable)AnalysisMode.DEFAULT);
        functionArguments.put(larg.getName(), larg);
        return factory.createFunctionalConstraint(function, functionArguments);
    }

    private static String getText(Tree node) {
        String text = node.getText();
        switch (node.getType()) {
            case 9: {
                int index = text.indexOf(92);
                if (index == -1) {
                    return text;
                }
                return CMISFTSQueryParser.unescape(text);
            }
            case 8: {
                String phrase = text.substring(1, text.length() - 1);
                int index = phrase.indexOf(92);
                if (index == -1) {
                    return phrase;
                }
                return CMISFTSQueryParser.unescape(phrase);
            }
        }
        return text;
    }

    private static String unescape(String string) {
        StringBuilder builder = new StringBuilder(string.length());
        boolean lastWasEscape = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (lastWasEscape) {
                if (c == 'u') {
                    throw new UnsupportedOperationException(string);
                }
                builder.append(c);
                lastWasEscape = false;
                continue;
            }
            if (c == '\\') {
                lastWasEscape = true;
                continue;
            }
            builder.append(c);
        }
        if (lastWasEscape) {
            throw new FTSQueryException("Escape character at end of string " + string);
        }
        return builder.toString();
    }

    static class DefaultToken
    implements Token {
        DefaultToken() {
        }

        public int getChannel() {
            return 0;
        }

        public int getCharPositionInLine() {
            return 0;
        }

        public CharStream getInputStream() {
            return null;
        }

        public int getLine() {
            return 0;
        }

        public String getText() {
            return null;
        }

        public int getTokenIndex() {
            return 0;
        }

        public int getType() {
            return 5;
        }

        public void setChannel(int arg0) {
        }

        public void setCharPositionInLine(int arg0) {
        }

        public void setInputStream(CharStream arg0) {
        }

        public void setLine(int arg0) {
        }

        public void setText(String arg0) {
        }

        public void setTokenIndex(int arg0) {
        }

        public void setType(int arg0) {
        }
    }

    static class DisjunctionToken
    implements Token {
        DisjunctionToken() {
        }

        public int getChannel() {
            return 0;
        }

        public int getCharPositionInLine() {
            return 0;
        }

        public CharStream getInputStream() {
            return null;
        }

        public int getLine() {
            return 0;
        }

        public String getText() {
            return null;
        }

        public int getTokenIndex() {
            return 0;
        }

        public int getType() {
            return 6;
        }

        public void setChannel(int arg0) {
        }

        public void setCharPositionInLine(int arg0) {
        }

        public void setInputStream(CharStream arg0) {
        }

        public void setLine(int arg0) {
        }

        public void setText(String arg0) {
        }

        public void setTokenIndex(int arg0) {
        }

        public void setType(int arg0) {
        }
    }
}

