/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.search;

import java.util.ListIterator;
import org.alfresco.cmis.CMISResultSet;
import org.alfresco.cmis.CMISResultSetRow;

public class CMISResultSetRowIteratorImpl
implements ListIterator<CMISResultSetRow> {
    private CMISResultSet resultSet;
    private int position = -1;
    private int max;

    public CMISResultSetRowIteratorImpl(CMISResultSet resultSet) {
        this.resultSet = resultSet;
        this.max = resultSet.getLength();
    }

    public CMISResultSet getResultSet() {
        return this.resultSet;
    }

    @Override
    public boolean hasNext() {
        return this.position < this.max - 1;
    }

    public boolean allowsReverse() {
        return true;
    }

    @Override
    public boolean hasPrevious() {
        return this.position > 0;
    }

    @Override
    public CMISResultSetRow next() {
        return (CMISResultSetRow)this.resultSet.getRow(this.moveToNextPosition());
    }

    protected int moveToNextPosition() {
        return ++this.position;
    }

    @Override
    public CMISResultSetRow previous() {
        return (CMISResultSetRow)this.resultSet.getRow(this.moveToPreviousPosition());
    }

    protected int moveToPreviousPosition() {
        return --this.position;
    }

    @Override
    public int nextIndex() {
        return this.position + 1;
    }

    @Override
    public int previousIndex() {
        return this.position - 1;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(CMISResultSetRow o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(CMISResultSetRow o) {
        throw new UnsupportedOperationException();
    }
}

