/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.search;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.alfresco.cmis.CMISCardinalityEnum;
import org.alfresco.cmis.CMISDictionaryService;
import org.alfresco.cmis.CMISPropertyDefinition;
import org.alfresco.cmis.CMISQueryException;
import org.alfresco.cmis.CMISScope;
import org.alfresco.cmis.CMISTypeDefinition;
import org.alfresco.repo.search.impl.lucene.AbstractLuceneQueryParser;
import org.alfresco.repo.search.impl.lucene.LuceneFunction;
import org.alfresco.repo.search.impl.querymodel.FunctionArgument;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.PredicateMode;
import org.alfresco.repo.search.impl.querymodel.QueryModelException;
import org.alfresco.repo.search.impl.querymodel.Selector;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Query;

public class CmisFunctionEvaluationContext
implements FunctionEvaluationContext {
    private static HashSet<String> EXPOSED_FIELDS = new HashSet();
    public static CMISScope[] STRICT_SCOPES = new CMISScope[]{CMISScope.DOCUMENT, CMISScope.FOLDER};
    public static CMISScope[] ALFRESCO_SCOPES = new CMISScope[]{CMISScope.DOCUMENT, CMISScope.FOLDER, CMISScope.POLICY};
    private Map<String, NodeRef> nodeRefs;
    private Map<String, Float> scores;
    private NodeService nodeService;
    private CMISDictionaryService cmisDictionaryService;
    private CMISScope[] validScopes;
    private Float score;

    public void setNodeRefs(Map<String, NodeRef> nodeRefs) {
        this.nodeRefs = nodeRefs;
    }

    public void setScores(Map<String, Float> scores) {
        this.scores = scores;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setCmisDictionaryService(CMISDictionaryService cmisDictionaryService) {
        this.cmisDictionaryService = cmisDictionaryService;
    }

    public void setValidScopes(CMISScope[] validScopes) {
        this.validScopes = validScopes;
    }

    public Map<String, NodeRef> getNodeRefs() {
        return this.nodeRefs;
    }

    public NodeService getNodeService() {
        return this.nodeService;
    }

    public Serializable getProperty(NodeRef nodeRef, String propertyName) {
        CMISPropertyDefinition propertyDef = this.cmisDictionaryService.findProperty(propertyName, null);
        return propertyDef.getPropertyAccessor().getValue(nodeRef);
    }

    public Map<String, Float> getScores() {
        return this.scores;
    }

    public Float getScore() {
        return this.score;
    }

    public void setScore(Float score) {
        this.score = score;
    }

    public Query buildLuceneEquality(AbstractLuceneQueryParser lqp, String propertyName, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws ParseException {
        CMISPropertyDefinition propertyDef = this.cmisDictionaryService.findProperty(propertyName, null);
        return propertyDef.getPropertyLuceneBuilder().buildLuceneEquality(lqp, value, mode, luceneFunction);
    }

    public Query buildLuceneExists(AbstractLuceneQueryParser lqp, String propertyName, Boolean not) throws ParseException {
        CMISPropertyDefinition propertyDef = this.cmisDictionaryService.findProperty(propertyName, null);
        return propertyDef.getPropertyLuceneBuilder().buildLuceneExists(lqp, not);
    }

    public Query buildLuceneGreaterThan(AbstractLuceneQueryParser lqp, String propertyName, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws ParseException {
        CMISPropertyDefinition propertyDef = this.cmisDictionaryService.findProperty(propertyName, null);
        return propertyDef.getPropertyLuceneBuilder().buildLuceneGreaterThan(lqp, value, mode, luceneFunction);
    }

    public Query buildLuceneGreaterThanOrEquals(AbstractLuceneQueryParser lqp, String propertyName, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws ParseException {
        CMISPropertyDefinition propertyDef = this.cmisDictionaryService.findProperty(propertyName, null);
        return propertyDef.getPropertyLuceneBuilder().buildLuceneGreaterThanOrEquals(lqp, value, mode, luceneFunction);
    }

    public Query buildLuceneIn(AbstractLuceneQueryParser lqp, String propertyName, Collection<Serializable> values, Boolean not, PredicateMode mode) throws ParseException {
        CMISPropertyDefinition propertyDef = this.cmisDictionaryService.findProperty(propertyName, null);
        return propertyDef.getPropertyLuceneBuilder().buildLuceneIn(lqp, values, not, mode);
    }

    public Query buildLuceneInequality(AbstractLuceneQueryParser lqp, String propertyName, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws ParseException {
        CMISPropertyDefinition propertyDef = this.cmisDictionaryService.findProperty(propertyName, null);
        return propertyDef.getPropertyLuceneBuilder().buildLuceneInequality(lqp, value, mode, luceneFunction);
    }

    public Query buildLuceneLessThan(AbstractLuceneQueryParser lqp, String propertyName, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws ParseException {
        CMISPropertyDefinition propertyDef = this.cmisDictionaryService.findProperty(propertyName, null);
        return propertyDef.getPropertyLuceneBuilder().buildLuceneLessThan(lqp, value, mode, luceneFunction);
    }

    public Query buildLuceneLessThanOrEquals(AbstractLuceneQueryParser lqp, String propertyName, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws ParseException {
        CMISPropertyDefinition propertyDef = this.cmisDictionaryService.findProperty(propertyName, null);
        return propertyDef.getPropertyLuceneBuilder().buildLuceneLessThanOrEquals(lqp, value, mode, luceneFunction);
    }

    public Query buildLuceneLike(AbstractLuceneQueryParser lqp, String propertyName, Serializable value, Boolean not) throws ParseException {
        CMISPropertyDefinition propertyDef = this.cmisDictionaryService.findProperty(propertyName, null);
        return propertyDef.getPropertyLuceneBuilder().buildLuceneLike(lqp, value, not);
    }

    public String getLuceneSortField(AbstractLuceneQueryParser lqp, String propertyName) {
        CMISPropertyDefinition propertyDef = this.cmisDictionaryService.findProperty(propertyName, null);
        return propertyDef.getPropertyLuceneBuilder().getLuceneSortField(lqp);
    }

    public boolean isObjectId(String propertyName) {
        return "cmis:objectId".equalsIgnoreCase(propertyName);
    }

    public boolean isOrderable(String fieldName) {
        CMISPropertyDefinition propertyDef = this.cmisDictionaryService.findProperty(fieldName, null);
        if (propertyDef == null) {
            return false;
        }
        return propertyDef.isOrderable();
    }

    public boolean isQueryable(String fieldName) {
        CMISPropertyDefinition propertyDef = this.cmisDictionaryService.findProperty(fieldName, null);
        if (propertyDef == null) {
            return true;
        }
        return propertyDef.isQueryable();
    }

    public String getLuceneFieldName(String propertyName) {
        CMISPropertyDefinition propertyDef = this.cmisDictionaryService.findProperty(propertyName, null);
        if (propertyDef != null) {
            return propertyDef.getPropertyLuceneBuilder().getLuceneFieldName();
        }
        return propertyName;
    }

    public LuceneFunction getLuceneFunction(FunctionArgument functionArgument) {
        if (functionArgument == null) {
            return LuceneFunction.FIELD;
        }
        String functionName = functionArgument.getFunction().getName();
        if (functionName.equals("Upper")) {
            return LuceneFunction.UPPER;
        }
        if (functionName.equals("Lower")) {
            return LuceneFunction.LOWER;
        }
        throw new QueryModelException("Unsupported function: " + functionName);
    }

    public void checkFieldApplies(Selector selector, String propertyName) {
        CMISPropertyDefinition propDef = this.cmisDictionaryService.findPropertyByQueryName(propertyName);
        if (propDef == null) {
            if (EXPOSED_FIELDS.contains(propertyName)) {
                return;
            }
            throw new CMISQueryException("Unknown column/property " + propertyName);
        }
        CMISTypeDefinition typeDef = this.cmisDictionaryService.findTypeForClass(selector.getType(), this.validScopes);
        if (typeDef == null) {
            throw new CMISQueryException("Type unsupported in CMIS queries: " + selector.getAlias());
        }
        if (!typeDef.getPropertyDefinitions().containsKey(propDef.getPropertyId().getId())) {
            throw new CMISQueryException("Invalid column for " + typeDef.getQueryName() + "." + propertyName);
        }
    }

    public boolean isMultiValued(String propertyName) {
        CMISPropertyDefinition propDef = this.cmisDictionaryService.findPropertyByQueryName(propertyName);
        if (propDef == null) {
            throw new CMISQueryException("Unknown column/property " + propertyName);
        }
        return propDef.getCardinality() == CMISCardinalityEnum.MULTI_VALUED;
    }

    static {
        EXPOSED_FIELDS.add("PATH");
        EXPOSED_FIELDS.add("TEXT");
        EXPOSED_FIELDS.add("ID");
        EXPOSED_FIELDS.add("ISROOT");
        EXPOSED_FIELDS.add("ISNODE");
        EXPOSED_FIELDS.add("TX");
        EXPOSED_FIELDS.add("PARENT");
        EXPOSED_FIELDS.add("PRIMARYPARENT");
        EXPOSED_FIELDS.add("QNAME");
        EXPOSED_FIELDS.add("CLASS");
        EXPOSED_FIELDS.add("TYPE");
        EXPOSED_FIELDS.add("EXACTTYPE");
        EXPOSED_FIELDS.add("ASPECT");
        EXPOSED_FIELDS.add("EXACTASPECT");
        EXPOSED_FIELDS.add("ALL");
        EXPOSED_FIELDS.add("ISUNSET");
        EXPOSED_FIELDS.add("ISNULL");
        EXPOSED_FIELDS.add("ISNOTNULL");
        EXPOSED_FIELDS.add("FTSSTATUS");
        EXPOSED_FIELDS.add("ASSOCTYPEQNAME");
        EXPOSED_FIELDS.add("PRIMARYASSOCTYPEQNAME");
        EXPOSED_FIELDS.add("DBID");
        EXPOSED_FIELDS.add("TAG");
        EXPOSED_FIELDS.add("TENANT");
        EXPOSED_FIELDS.add("ANCESTOR");
        EXPOSED_FIELDS.add("d:" + DataTypeDefinition.ANY.getLocalName());
        EXPOSED_FIELDS.add("d:" + DataTypeDefinition.ASSOC_REF.getLocalName());
        EXPOSED_FIELDS.add("d:" + DataTypeDefinition.BOOLEAN.getLocalName());
        EXPOSED_FIELDS.add("d:" + DataTypeDefinition.CATEGORY.getLocalName());
        EXPOSED_FIELDS.add("d:" + DataTypeDefinition.CHILD_ASSOC_REF.getLocalName());
        EXPOSED_FIELDS.add("d:" + DataTypeDefinition.CONTENT.getLocalName());
        EXPOSED_FIELDS.add("d:" + DataTypeDefinition.DATE.getLocalName());
        EXPOSED_FIELDS.add("d:" + DataTypeDefinition.DATETIME.getLocalName());
        EXPOSED_FIELDS.add("d:" + DataTypeDefinition.DOUBLE.getLocalName());
        EXPOSED_FIELDS.add("d:" + DataTypeDefinition.FLOAT.getLocalName());
        EXPOSED_FIELDS.add("d:" + DataTypeDefinition.INT.getLocalName());
        EXPOSED_FIELDS.add("d:" + DataTypeDefinition.LOCALE.getLocalName());
        EXPOSED_FIELDS.add("d:" + DataTypeDefinition.LONG.getLocalName());
        EXPOSED_FIELDS.add("d:" + DataTypeDefinition.MLTEXT.getLocalName());
        EXPOSED_FIELDS.add("d:" + DataTypeDefinition.NODE_REF.getLocalName());
        EXPOSED_FIELDS.add("d:" + DataTypeDefinition.PATH.getLocalName());
        EXPOSED_FIELDS.add("d:" + DataTypeDefinition.PERIOD.getLocalName());
        EXPOSED_FIELDS.add("d:" + DataTypeDefinition.QNAME.getLocalName());
        EXPOSED_FIELDS.add("d:" + DataTypeDefinition.TEXT.getLocalName());
    }
}

