/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.encryption;

import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.Key;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.alfresco.encryption.DefaultEncryptor;
import org.alfresco.encryption.EncryptionKeysRegistry;
import org.alfresco.encryption.Encryptor;
import org.alfresco.encryption.KeyMap;
import org.alfresco.encryption.KeyProvider;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.attributes.AttributeService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EncryptionKeysRegistryImpl
implements EncryptionKeysRegistry {
    public static String TOP_LEVEL_KEY = "keyCheck";
    private static final Log logger = LogFactory.getLog(EncryptionKeysRegistryImpl.class);
    private TransactionService transactionService;
    private AttributeService attributeService;
    private String cipherAlgorithm;
    private String cipherProvider;

    public void setAttributeService(AttributeService attributeService) {
        this.attributeService = attributeService;
    }

    public void setCipherAlgorithm(String cipherAlgorithm) {
        this.cipherAlgorithm = cipherAlgorithm;
    }

    public void setCipherProvider(String cipherProvider) {
        this.cipherProvider = cipherProvider;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    protected Encryptor getEncryptor(final KeyMap keys) {
        DefaultEncryptor encryptor = new DefaultEncryptor();
        encryptor.setCipherAlgorithm(this.cipherAlgorithm);
        encryptor.setCipherProvider(this.cipherProvider);
        encryptor.setKeyProvider(new KeyProvider(){

            public Key getKey(String keyAlias) {
                return keys.getCachedKey(keyAlias).getKey();
            }
        });
        return encryptor;
    }

    public void init() {
    }

    public void registerKey(String keyAlias, Key key) {
        if (this.isKeyRegistered(keyAlias)) {
            throw new IllegalArgumentException("Key " + keyAlias + " is already registered");
        }
        String guid = GUID.generate();
        KeyMap keys = new KeyMap();
        keys.setKey(keyAlias, key);
        Encryptor encryptor = this.getEncryptor(keys);
        Serializable encrypted = encryptor.sealObject(keyAlias, null, (Serializable)((Object)guid));
        Pair keyCheck = new Pair((Object)guid, (Object)encrypted);
        this.attributeService.createAttribute((Serializable)keyCheck, new Serializable[]{TOP_LEVEL_KEY, keyAlias});
        logger.info((Object)("Registered key " + keyAlias));
    }

    public void unregisterKey(String keyAlias) {
        this.attributeService.removeAttribute(new Serializable[]{TOP_LEVEL_KEY, keyAlias});
    }

    public boolean isKeyRegistered(String keyAlias) {
        try {
            return this.attributeService.getAttribute(new Serializable[]{TOP_LEVEL_KEY, keyAlias}) != null;
        }
        catch (Throwable e) {
            this.attributeService.removeAttribute(new Serializable[]{TOP_LEVEL_KEY, keyAlias});
            return this.attributeService.getAttribute(new Serializable[]{TOP_LEVEL_KEY, keyAlias}) != null;
        }
    }

    public List<String> getRegisteredKeys(final Set<String> keyStoreKeys) {
        final ArrayList<String> registeredKeys = new ArrayList<String>();
        this.attributeService.getAttributes(new AttributeService.AttributeQueryCallback(){

            @Override
            public boolean handleAttribute(Long id, Serializable value, Serializable[] keys) {
                String keyAlias = (String)((Object)keys[1]);
                if (keyStoreKeys.contains(keyAlias)) {
                    registeredKeys.add(keyAlias);
                }
                return true;
            }
        }, new Serializable[]{TOP_LEVEL_KEY});
        return registeredKeys;
    }

    public EncryptionKeysRegistry.KEY_STATUS checkKey(String keyAlias, Key key) {
        Pair keyCheck = null;
        if (this.attributeService.exists(new Serializable[]{TOP_LEVEL_KEY, keyAlias})) {
            try {
                try {
                    keyCheck = (Pair)this.attributeService.getAttribute(new Serializable[]{TOP_LEVEL_KEY, keyAlias});
                }
                catch (Throwable e) {
                    this.attributeService.removeAttribute(new Serializable[]{TOP_LEVEL_KEY, keyAlias});
                    return EncryptionKeysRegistry.KEY_STATUS.MISSING;
                }
                if (keyCheck == null) {
                    return EncryptionKeysRegistry.KEY_STATUS.MISSING;
                }
                KeyMap keys = new KeyMap();
                keys.setKey(keyAlias, key);
                Encryptor encryptor = this.getEncryptor(keys);
                Serializable storedGUID = encryptor.unsealObject(keyAlias, (Serializable)keyCheck.getSecond());
                return EqualsHelper.nullSafeEquals((Object)storedGUID, (Object)keyCheck.getFirst()) ? EncryptionKeysRegistry.KEY_STATUS.OK : EncryptionKeysRegistry.KEY_STATUS.CHANGED;
            }
            catch (InvalidKeyException e) {
                return EncryptionKeysRegistry.KEY_STATUS.CHANGED;
            }
        }
        return EncryptionKeysRegistry.KEY_STATUS.MISSING;
    }

    public void removeRegisteredKeys(final Set<String> keys) {
        RetryingTransactionHelper retryingTransactionHelper = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> removeKeysCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                for (String keyAlias : keys) {
                    EncryptionKeysRegistryImpl.this.attributeService.removeAttribute(new Serializable[]{TOP_LEVEL_KEY, keyAlias});
                }
                return null;
            }
        };
        retryingTransactionHelper.doInTransaction(removeKeysCallback, false);
    }
}

