/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import junit.framework.TestCase;
import org.alfresco.jlan.ftp.FTPConfigSection;
import org.alfresco.jlan.server.config.ServerConfigurationAccessor;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.usage.ContentUsageImpl;
import org.alfresco.repo.usage.UserUsageTrackingComponent;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.PropertyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.PrintCommandListener;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.springframework.context.ApplicationContext;

public class FTPServerTest
extends TestCase {
    private static Log logger = LogFactory.getLog(FTPServerTest.class);
    private ApplicationContext applicationContext;
    private final String USER_ADMIN = "admin";
    private final String PASSWORD_ADMIN = "admin";
    private final String USER_ONE = "FTPServerTestOne";
    private final String USER_TWO = "FTPServerTestTwo";
    private final String USER_THREE = "FTPServerTestThree";
    private final String PASSWORD_ONE = "Password01";
    private final String PASSWORD_TWO = "Password02";
    private final String PASSWORD_THREE = "Password03";
    private final String HOSTNAME = "localhost";
    private NodeService nodeService;
    private PersonService personService;
    private MutableAuthenticationService authenticationService;
    private AuthenticationComponent authenticationComponent;
    private TransactionService transactionService;
    private Repository repositoryHelper;
    private PermissionService permissionService;
    private FTPConfigSection ftpConfigSection;

    protected void setUp() throws Exception {
        this.applicationContext = ApplicationContextHelper.getApplicationContext();
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        this.personService = (PersonService)this.applicationContext.getBean("personService");
        this.authenticationService = (MutableAuthenticationService)this.applicationContext.getBean("AuthenticationService");
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.transactionService = (TransactionService)this.applicationContext.getBean("transactionService");
        this.repositoryHelper = (Repository)this.applicationContext.getBean("repositoryHelper");
        this.permissionService = (PermissionService)this.applicationContext.getBean("permissionService");
        ServerConfigurationAccessor fileServerConfiguration = (ServerConfigurationAccessor)this.applicationContext.getBean("fileServerConfiguration");
        this.ftpConfigSection = (FTPConfigSection)fileServerConfiguration.getConfigSection("FTP");
        FTPServerTest.assertNotNull((String)"nodeService is null", (Object)this.nodeService);
        FTPServerTest.assertNotNull((String)"reporitoryHelper is null", (Object)this.repositoryHelper);
        FTPServerTest.assertNotNull((String)"personService is null", (Object)this.personService);
        FTPServerTest.assertNotNull((String)"authenticationService is null", (Object)this.authenticationService);
        FTPServerTest.assertNotNull((String)"authenticationComponent is null", (Object)this.authenticationComponent);
        this.authenticationComponent.setSystemUserAsCurrentUser();
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createUsersCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                FTPServerTest.this.createUser("FTPServerTestOne", "Password01", -1L);
                FTPServerTest.this.createUser("FTPServerTestTwo", "Password02", -1L);
                FTPServerTest.this.createUser("FTPServerTestThree", "Password03", 30L);
                return null;
            }
        };
        tran.doInTransaction(createUsersCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createTestDirCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                NodeRef userOneHome = FTPServerTest.this.repositoryHelper.getUserHome(FTPServerTest.this.personService.getPerson("FTPServerTestOne"));
                FTPServerTest.this.permissionService.setPermission(userOneHome, "FTPServerTestTwo", "Contributor", true);
                FTPServerTest.this.permissionService.setPermission(userOneHome, "FTPServerTestTwo", "Write", true);
                return null;
            }
        };
        tran.doInTransaction(createTestDirCB, false, true);
    }

    protected void tearDown() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFTPConnect() throws Exception {
        logger.debug((Object)"Start testFTPConnect");
        FTPClient ftp = this.connectClient();
        try {
            int reply = ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                FTPServerTest.fail((String)"FTP server refused connection.");
            }
            boolean login = ftp.login("admin", "admin");
            FTPServerTest.assertTrue((String)"admin login not successful", (boolean)login);
        }
        finally {
            ftp.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFTPConnectNegative() throws Exception {
        logger.debug((Object)"Start testFTPConnectNegative");
        FTPClient ftp = this.connectClient();
        try {
            int reply = ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                FTPServerTest.fail((String)"FTP server refused connection.");
            }
            boolean login = ftp.login("admin", "garbage");
            FTPServerTest.assertFalse((String)"admin login successful", (boolean)login);
            FTPFile[] files = ftp.listFiles();
            FTPServerTest.assertNotNull((Object)files);
            FTPServerTest.assertTrue((files.length == 0 ? 1 : 0) != 0);
            reply = ftp.getReplyCode();
            FTPServerTest.assertTrue((boolean)FTPReply.isNegativePermanent((int)reply));
        }
        finally {
            ftp.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCWD() throws Exception {
        logger.debug((Object)"Start testCWD");
        FTPClient ftp = this.connectClient();
        try {
            int reply = ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                FTPServerTest.fail((String)"FTP server refused connection.");
            }
            boolean login = ftp.login("admin", "admin");
            FTPServerTest.assertTrue((String)"admin login successful", (boolean)login);
            FTPFile[] files = ftp.listFiles();
            reply = ftp.getReplyCode();
            FTPServerTest.assertTrue((boolean)FTPReply.isPositiveCompletion((int)reply));
            FTPServerTest.assertTrue((files.length == 1 ? 1 : 0) != 0);
            boolean foundAVM = false;
            boolean foundAlfresco = false;
            for (FTPFile file : files) {
                logger.debug((Object)("file name=" + file.getName()));
                FTPServerTest.assertTrue((boolean)file.isDirectory());
                if (file.getName().equalsIgnoreCase("AVM")) {
                    foundAVM = true;
                }
                if (!file.getName().equalsIgnoreCase("Alfresco")) continue;
                foundAlfresco = true;
            }
            FTPServerTest.assertTrue((boolean)foundAlfresco);
            reply = ftp.cwd("/Alfresco");
            FTPServerTest.assertTrue((boolean)FTPReply.isPositiveCompletion((int)reply));
            reply = ftp.cwd("Data Dictionary");
            FTPServerTest.assertTrue((boolean)FTPReply.isPositiveCompletion((int)reply));
            reply = ftp.cwd("/Garbage");
            FTPServerTest.assertTrue((boolean)FTPReply.isNegativePermanent((int)reply));
            reply = ftp.cwd("/Alfresco/User Homes");
            FTPServerTest.assertTrue((boolean)FTPReply.isPositiveCompletion((int)reply));
            reply = ftp.cwd("/Alfresco/User*Homes");
            FTPServerTest.assertTrue((String)"unable to change to /Alfresco User*Homes/", (boolean)FTPReply.isPositiveCompletion((int)reply));
            reply = ftp.cwd("/Alfresco/Data Dictionary");
            FTPServerTest.assertTrue((String)"unable to change to /Alfresco/Data Dictionary", (boolean)FTPReply.isPositiveCompletion((int)reply));
            reply = ftp.cwd("..");
            FTPServerTest.assertTrue((String)"unable to change to ..", (boolean)FTPReply.isPositiveCompletion((int)reply));
            reply = ftp.pwd();
            ftp.getStatus();
            FTPServerTest.assertTrue((String)"unable to get status", (boolean)FTPReply.isPositiveCompletion((int)reply));
            reply = ftp.cwd("Data Dictionary");
            FTPServerTest.assertTrue((boolean)FTPReply.isPositiveCompletion((int)reply));
        }
        finally {
            ftp.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCRUD() throws Exception {
        String PATH1 = "FTPServerTest";
        String PATH2 = "Second part";
        logger.debug((Object)"Start testFTPCRUD");
        FTPClient ftp = this.connectClient();
        try {
            int reply = ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                FTPServerTest.fail((String)"FTP server refused connection.");
            }
            boolean login = ftp.login("admin", "admin");
            FTPServerTest.assertTrue((String)"admin login successful", (boolean)login);
            reply = ftp.cwd("/Alfresco/User Homes");
            FTPServerTest.assertTrue((boolean)FTPReply.isPositiveCompletion((int)reply));
            try {
                ftp.removeDirectory("FTPServerTest");
            }
            catch (IOException e) {
                // empty catch block
            }
            ftp.makeDirectory("FTPServerTest");
            ftp.cwd("FTPServerTest");
            ftp.makeDirectory("Second part");
            ftp.cwd("Second part");
            FTPFile[] files = ftp.listFiles();
            FTPServerTest.assertTrue((String)"files not empty", (files.length == 0 ? 1 : 0) != 0);
            String FILE1_CONTENT_1 = "test file 1 content";
            String FILE1_NAME = "testFile1.txt";
            ftp.appendFile(FILE1_NAME, (InputStream)new ByteArrayInputStream(FILE1_CONTENT_1.getBytes("UTF-8")));
            FTPFile[] files2 = ftp.listFiles();
            FTPServerTest.assertTrue((String)"files not one", (files2.length == 1 ? 1 : 0) != 0);
            InputStream is = ftp.retrieveFileStream(FILE1_NAME);
            String content = this.inputStreamToString(is);
            FTPServerTest.assertEquals((String)"Content is not as expected", (String)content, (String)FILE1_CONTENT_1);
            ftp.completePendingCommand();
            String FILE1_CONTENT_2 = "That's how it is says Pooh!";
            ftp.appendFile(FILE1_NAME, (InputStream)new ByteArrayInputStream(FILE1_CONTENT_2.getBytes("UTF-8")));
            InputStream is2 = ftp.retrieveFileStream(FILE1_NAME);
            String content2 = this.inputStreamToString(is2);
            FTPServerTest.assertEquals((String)"Content is not as expected", (String)FILE1_CONTENT_2, (String)content2);
            ftp.completePendingCommand();
            FTPServerTest.assertTrue((boolean)ftp.deleteFile(FILE1_NAME));
            FTPServerTest.assertFalse((boolean)ftp.deleteFile(FILE1_NAME));
        }
        finally {
            ftp.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPathNames() throws Exception {
        logger.debug((Object)"Start testPathNames");
        FTPClient ftp = this.connectClient();
        String PATH1 = "testPathNames";
        try {
            int reply = ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                FTPServerTest.fail((String)"FTP server refused connection.");
            }
            boolean login = ftp.login("admin", "admin");
            FTPServerTest.assertTrue((String)"admin login successful", (boolean)login);
            reply = ftp.cwd("/Alfresco/User*Homes");
            FTPServerTest.assertTrue((boolean)FTPReply.isPositiveCompletion((int)reply));
            try {
                ftp.removeDirectory(PATH1);
            }
            catch (IOException e) {
                // empty catch block
            }
            boolean success = ftp.makeDirectory(PATH1);
            FTPServerTest.assertTrue((String)("unable to make directory:" + PATH1), (boolean)success);
            success = ftp.changeWorkingDirectory(PATH1);
            FTPServerTest.assertTrue((String)("unable to change to working directory:" + PATH1), (boolean)success);
            FTPServerTest.assertTrue((String)"with a space", (boolean)ftp.makeDirectory("test space"));
            FTPServerTest.assertTrue((String)"with exclamation", (boolean)ftp.makeDirectory("space!"));
            FTPServerTest.assertTrue((String)"with dollar", (boolean)ftp.makeDirectory("space$"));
            FTPServerTest.assertTrue((String)"with brackets", (boolean)ftp.makeDirectory("space()"));
            FTPServerTest.assertTrue((String)"with hash curley  brackets", (boolean)ftp.makeDirectory("space{}"));
            FTPServerTest.assertTrue((String)"with pound sign", (boolean)ftp.makeDirectory("pound \u00a3.world"));
            FTPServerTest.assertTrue((String)"with yen sign", (boolean)ftp.makeDirectory("yen \u00a5.world"));
        }
        finally {
            ftp.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTwoUserUpdate() throws Exception {
        logger.debug((Object)"Start testFTPConnect");
        String TEST_DIR = "/Alfresco/User Homes/FTPServerTestOne";
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        FTPClient ftpOne = this.connectClient();
        FTPClient ftpTwo = this.connectClient();
        try {
            int reply = ftpOne.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                FTPServerTest.fail((String)"FTP server refused connection.");
            }
            if (!FTPReply.isPositiveCompletion((int)(reply = ftpTwo.getReplyCode()))) {
                FTPServerTest.fail((String)"FTP server refused connection.");
            }
            boolean login = ftpOne.login("FTPServerTestOne", "Password01");
            FTPServerTest.assertTrue((String)"user one login not successful", (boolean)login);
            login = ftpTwo.login("FTPServerTestTwo", "Password02");
            FTPServerTest.assertTrue((String)"user two login not successful", (boolean)login);
            boolean success = ftpOne.changeWorkingDirectory("Alfresco");
            FTPServerTest.assertTrue((String)"user one unable to cd to Alfreco", (boolean)success);
            success = ftpOne.changeWorkingDirectory("User*Homes");
            FTPServerTest.assertTrue((String)"user one unable to cd to User*Homes", (boolean)success);
            success = ftpOne.changeWorkingDirectory("FTPServerTestOne");
            FTPServerTest.assertTrue((String)"user one unable to cd to FTPServerTestOne", (boolean)success);
            success = ftpTwo.changeWorkingDirectory("Alfresco");
            FTPServerTest.assertTrue((String)"user two unable to cd to Alfreco", (boolean)success);
            success = ftpTwo.changeWorkingDirectory("User*Homes");
            FTPServerTest.assertTrue((String)"user two unable to cd to User*Homes", (boolean)success);
            success = ftpTwo.changeWorkingDirectory("FTPServerTestOne");
            FTPServerTest.assertTrue((String)"user two unable to cd FTPServerTestOne", (boolean)success);
            String FILE1_CONTENT_1 = "test file 1 content";
            String FILE1_NAME = "test.docx";
            success = ftpOne.appendFile(FILE1_NAME, (InputStream)new ByteArrayInputStream(FILE1_CONTENT_1.getBytes("UTF-8")));
            FTPServerTest.assertTrue((String)"user one unable to append file", (boolean)success);
            String FILE1_CONTENT_2 = "test file content updated";
            success = ftpTwo.appendFile(FILE1_NAME, (InputStream)new ByteArrayInputStream(FILE1_CONTENT_2.getBytes("UTF-8")));
            FTPServerTest.assertTrue((String)"user two unable to append file", (boolean)success);
            InputStream is1 = ftpOne.retrieveFileStream(FILE1_NAME);
            FTPServerTest.assertNotNull((String)"is1 is null", (Object)is1);
            String content1 = this.inputStreamToString(is1);
            FTPServerTest.assertEquals((String)"Content is not as expected", (String)FILE1_CONTENT_2, (String)content1);
            ftpOne.completePendingCommand();
            InputStream is2 = ftpTwo.retrieveFileStream(FILE1_NAME);
            FTPServerTest.assertNotNull((String)"is2 is null", (Object)is2);
            String content2 = this.inputStreamToString(is2);
            FTPServerTest.assertEquals((String)"Content is not as expected", (String)FILE1_CONTENT_2, (String)content2);
            ftpTwo.completePendingCommand();
            logger.debug((Object)"Test finished");
        }
        finally {
            ftpOne.dele("/Alfresco/User Homes/FTPServerTestOne");
            if (ftpOne != null) {
                ftpOne.disconnect();
            }
            if (ftpTwo != null) {
                ftpTwo.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFtpQuotaAndFtp() throws Exception {
        ContentUsageImpl contentUsage = (ContentUsageImpl)this.applicationContext.getBean("contentUsageImpl");
        contentUsage.setEnabled(true);
        contentUsage.init();
        UserUsageTrackingComponent userUsageTrackingComponent = (UserUsageTrackingComponent)this.applicationContext.getBean("userUsageTrackingComponent");
        userUsageTrackingComponent.setEnabled(true);
        userUsageTrackingComponent.bootstrapInternal();
        String TEST_DIR = "/Alfresco/User Homes/FTPServerTestThree";
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        FTPClient ftpOne = this.connectClient();
        try {
            int reply = ftpOne.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                FTPServerTest.fail((String)"FTP server refused connection.");
            }
            boolean login = ftpOne.login("FTPServerTestThree", "Password03");
            FTPServerTest.assertTrue((String)"user one login not successful", (boolean)login);
            boolean success = ftpOne.changeWorkingDirectory("Alfresco");
            FTPServerTest.assertTrue((String)"user one unable to cd to Alfreco", (boolean)success);
            success = ftpOne.changeWorkingDirectory("User*Homes");
            FTPServerTest.assertTrue((String)"user one unable to cd to User*Homes", (boolean)success);
            success = ftpOne.changeWorkingDirectory("FTPServerTestThree");
            FTPServerTest.assertTrue((String)"user one unable to cd to FTPServerTestThree", (boolean)success);
            String FILE3_CONTENT_3 = "test file 3 content that needs to be greater than 100 bytes to result in a quota exception being thrown";
            String FILE1_NAME = "test.docx";
            success = ftpOne.appendFile(FILE1_NAME, (InputStream)new ByteArrayInputStream(FILE3_CONTENT_3.getBytes("UTF-8")));
            FTPServerTest.assertFalse((String)"user one can ignore quota", (boolean)success);
            boolean deleted = ftpOne.deleteFile(FILE1_NAME);
            FTPServerTest.assertFalse((String)"quota exception expected", (boolean)deleted);
            logger.debug((Object)"test done");
        }
        finally {
            contentUsage.setEnabled(false);
            contentUsage.init();
            userUsageTrackingComponent.setEnabled(false);
            userUsageTrackingComponent.bootstrapInternal();
            ftpOne.dele("/Alfresco/User Homes/FTPServerTestThree");
            if (ftpOne != null) {
                ftpOne.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testModificationTime() throws Exception {
        String PATH1 = "FTPServerTest";
        String PATH2 = "ModificationTime";
        logger.debug((Object)"Start testModificationTime");
        FTPClient ftp = this.connectClient();
        try {
            int reply = ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                FTPServerTest.fail((String)"FTP server refused connection.");
            }
            boolean login = ftp.login("admin", "admin");
            FTPServerTest.assertTrue((String)"admin login successful", (boolean)login);
            reply = ftp.cwd("/Alfresco/User Homes");
            FTPServerTest.assertTrue((boolean)FTPReply.isPositiveCompletion((int)reply));
            try {
                ftp.removeDirectory("FTPServerTest");
            }
            catch (IOException e) {
                // empty catch block
            }
            ftp.makeDirectory("FTPServerTest");
            ftp.cwd("FTPServerTest");
            ftp.makeDirectory("ModificationTime");
            ftp.cwd("ModificationTime");
            FTPFile[] files = ftp.listFiles();
            FTPServerTest.assertTrue((String)"files not empty", (files.length == 0 ? 1 : 0) != 0);
            String FILE1_CONTENT_1 = "test file 1 content";
            String FILE1_NAME = "testFile1.txt";
            ftp.appendFile(FILE1_NAME, (InputStream)new ByteArrayInputStream(FILE1_CONTENT_1.getBytes("UTF-8")));
            String pathname = "/Alfresco/User Homes/FTPServerTest/ModificationTime/" + FILE1_NAME;
            logger.debug((Object)"set modification time");
            String olympicTime = "20120830123905";
            ftp.setModificationTime(pathname, olympicTime);
            String extractedTime = ftp.getModificationTime(pathname);
            FTPServerTest.assertTrue((String)"time not set correctly by explicit set time", (boolean)extractedTime.contains(olympicTime));
            FTPFile[] files2 = ftp.listFiles();
            FTPServerTest.assertTrue((String)"files not one", (files2.length == 1 ? 1 : 0) != 0);
            InputStream is = ftp.retrieveFileStream(FILE1_NAME);
            String content = this.inputStreamToString(is);
            FTPServerTest.assertEquals((String)"Content is not as expected", (String)content, (String)FILE1_CONTENT_1);
            ftp.completePendingCommand();
            String FILE1_CONTENT_2 = "That's how it is says Pooh!";
            ftp.appendFile(FILE1_NAME, (InputStream)new ByteArrayInputStream(FILE1_CONTENT_2.getBytes("UTF-8")));
            InputStream is2 = ftp.retrieveFileStream(FILE1_NAME);
            String content2 = this.inputStreamToString(is2);
            FTPServerTest.assertEquals((String)"Content is not as expected", (String)FILE1_CONTENT_2, (String)content2);
            ftp.completePendingCommand();
            extractedTime = ftp.getModificationTime(pathname);
            FTPServerTest.assertFalse((String)"time not moved on if time not explicitly set", (boolean)extractedTime.contains(olympicTime));
            FTPServerTest.assertTrue((boolean)ftp.deleteFile(FILE1_NAME));
            FTPServerTest.assertFalse((boolean)ftp.deleteFile(FILE1_NAME));
        }
        finally {
            ftp.disconnect();
        }
    }

    public void DISABLED_testQuota() throws Exception {
        FTPServerTest.fail((String)"not yet implemented");
    }

    private FTPClient connectClient() throws IOException {
        FTPClient ftp = new FTPClient();
        if (logger.isDebugEnabled()) {
            ftp.addProtocolCommandListener((ProtocolCommandListener)new PrintCommandListener(new PrintWriter(System.out)));
        }
        ftp.connect("localhost", this.ftpConfigSection.getFTPPort());
        return ftp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String inputStreamToString(InputStream is) throws IOException {
        if (is != null) {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[1024];
            try {
                int n;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((n = reader.read(buffer)) != -1) {
                    writer.write(buffer, 0, n);
                }
            }
            finally {
                is.close();
            }
            is.close();
            return writer.getBuffer().toString();
        }
        return "";
    }

    private void createUser(String userName, String password, long quota) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, password.toCharArray());
            PropertyMap ppOne = new PropertyMap(4);
            ppOne.put(ContentModel.PROP_USERNAME, userName);
            ppOne.put(ContentModel.PROP_FIRSTNAME, "firstName");
            ppOne.put(ContentModel.PROP_LASTNAME, "lastName");
            ppOne.put(ContentModel.PROP_EMAIL, "email@email.com");
            ppOne.put(ContentModel.PROP_JOBTITLE, "jobTitle");
            if (quota > 0L) {
                ppOne.put(ContentModel.PROP_SIZE_QUOTA, quota);
            }
            this.personService.createPerson(ppOne);
        }
    }
}

