/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.alfresco;

import java.util.Enumeration;
import java.util.Hashtable;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.filesys.AlfrescoConfigSection;
import org.alfresco.filesys.config.ServerConfigurationBean;
import org.alfresco.filesys.repo.ContentContext;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.auth.InvalidUserException;
import org.alfresco.jlan.server.config.ConfigurationListener;
import org.alfresco.jlan.server.config.InvalidConfigurationException;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.alfresco.jlan.server.core.DeviceInterface;
import org.alfresco.jlan.server.core.ShareMapper;
import org.alfresco.jlan.server.core.SharedDevice;
import org.alfresco.jlan.server.core.SharedDeviceList;
import org.alfresco.jlan.server.filesys.DiskDeviceContext;
import org.alfresco.jlan.server.filesys.DiskInterface;
import org.alfresco.jlan.server.filesys.DiskSharedDevice;
import org.alfresco.jlan.server.filesys.FilesystemsConfigSection;
import org.alfresco.jlan.server.filesys.SrvDiskInfo;
import org.alfresco.jlan.server.filesys.quota.QuotaManager;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.extensions.config.ConfigElement;

public class MultiTenantShareMapper
implements ShareMapper,
ConfigurationListener,
InitializingBean {
    private static final Log logger = LogFactory.getLog(MultiTenantShareMapper.class);
    private ServerConfiguration m_config;
    private FilesystemsConfigSection m_filesysConfig;
    private AlfrescoConfigSection m_alfrescoConfig;
    private String m_tenantShareName;
    private String m_rootPath;
    private String m_storeName;
    private Hashtable<String, SharedDeviceList> m_tenantShareLists;
    private QuotaManager m_quotaManager;
    private DiskInterface repoDiskInterface;

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"ServerConfiguration", (Object)this.m_config);
        PropertyCheck.mandatory((Object)this, (String)"Tenant share name", (Object)this.m_tenantShareName);
        PropertyCheck.mandatory((Object)this, (String)"repoDiskInterface", (Object)this.getRepoDiskInterface());
        PropertyCheck.mandatory((Object)this, (String)"Store name", (Object)this.m_storeName);
        PropertyCheck.mandatory((Object)this, (String)"Root Path", (Object)this.m_rootPath);
    }

    public void initializeMapper(ServerConfiguration config, ConfigElement params) throws InvalidConfigurationException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"initialiseMapper");
        }
        this.setServerConfiguration(config);
        this.afterPropertiesSet();
    }

    public void afterPropertiesSet() {
        this.m_filesysConfig = (FilesystemsConfigSection)this.m_config.getConfigSection("Filesystems");
        this.m_alfrescoConfig = (AlfrescoConfigSection)this.m_config.getConfigSection("Alfresco");
        if (this.m_filesysConfig == null || this.m_alfrescoConfig == null) {
            this.m_config.addListener((ConfigurationListener)this);
        }
        this.m_tenantShareLists = new Hashtable();
    }

    public SharedDevice findShare(String host, String name, int typ, SrvSession sess, boolean create) throws InvalidUserException {
        if (this.m_alfrescoConfig.getTenantService().isEnabled() && this.m_alfrescoConfig.getTenantService().isTenantUser() && typ != 3) {
            return this.findTenantShare(host, name, typ, sess, create);
        }
        SharedDevice share = this.m_filesysConfig.getShares().findShare(name, typ, false);
        if (share == null) {
            share = this.m_filesysConfig.getShares().findShare(name, typ, true);
        }
        if (share != null && share.getContext() != null && !share.getContext().isAvailable()) {
            share = null;
        }
        return share;
    }

    public void deleteShares(SrvSession sess) {
        if (!sess.hasDynamicShares()) {
            return;
        }
        SharedDeviceList shares = sess.getDynamicShareList();
        Enumeration enm = shares.enumerateShares();
        while (enm.hasMoreElements()) {
            SharedDevice shr = (SharedDevice)enm.nextElement();
            shr.getContext().CloseContext();
        }
    }

    public SharedDeviceList getShareList(String host, SrvSession sess, boolean allShares) {
        if (this.m_filesysConfig == null) {
            return null;
        }
        if (this.m_alfrescoConfig.getTenantService().isEnabled() && this.m_alfrescoConfig.getTenantService().isTenantUser()) {
            return this.getTenantShareList(host, sess, allShares);
        }
        SharedDeviceList shrList = new SharedDeviceList(this.m_filesysConfig.getShares());
        if (sess != null && sess.hasDynamicShares()) {
            shrList.addShares(sess.getDynamicShareList());
        }
        if (!allShares) {
            shrList.removeUnavailableShares();
        }
        return shrList;
    }

    public void closeMapper() {
    }

    public int configurationChanged(int id, ServerConfiguration config, Object newVal) throws InvalidConfigurationException {
        if (id == 0x10000001) {
            if (newVal instanceof FilesystemsConfigSection) {
                this.m_filesysConfig = (FilesystemsConfigSection)newVal;
            } else if (newVal instanceof AlfrescoConfigSection) {
                this.m_alfrescoConfig = (AlfrescoConfigSection)((Object)newVal);
            }
            return 1;
        }
        return 0;
    }

    private final SharedDevice findTenantShare(String host, String name, int typ, SrvSession sess, boolean create) throws InvalidUserException {
        SharedDeviceList shareList = this.getTenantShareList(host, sess, true);
        if (shareList == null) {
            return null;
        }
        return shareList.findShare(name, typ, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SharedDeviceList getTenantShareList(String host, SrvSession sess, boolean allShares) {
        String tenantDomain = this.m_alfrescoConfig.getTenantService().getCurrentUserDomain();
        SharedDeviceList shareList = null;
        if (this.m_tenantShareLists.containsKey(tenantDomain)) {
            shareList = this.m_tenantShareLists.get(tenantDomain);
        }
        Hashtable<String, SharedDeviceList> hashtable = this.m_tenantShareLists;
        synchronized (hashtable) {
            shareList = this.m_tenantShareLists.get(tenantDomain);
            if (shareList == null) {
                shareList = new SharedDeviceList();
                shareList.addShare((SharedDevice)this.createTenantShare(tenantDomain));
                this.m_tenantShareLists.put(tenantDomain, shareList);
            }
        }
        return shareList;
    }

    private final DiskSharedDevice createTenantShare(String tenantDomain) {
        logger.debug((Object)("create tenant share for domain " + tenantDomain));
        StoreRef storeRef = new StoreRef(this.getStoreName());
        NodeRef rootNodeRef = new NodeRef(storeRef.getProtocol(), storeRef.getIdentifier(), "dummy");
        rootNodeRef = this.m_alfrescoConfig.getTenantService().getRootNode(this.m_alfrescoConfig.getNodeService(), this.m_alfrescoConfig.getSearchService(), this.m_alfrescoConfig.getNamespaceService(), this.getRootPath(), rootNodeRef);
        DiskInterface diskDrv = this.getRepoDiskInterface();
        ContentContext diskCtx = new ContentContext(this.m_tenantShareName, this.getStoreName(), this.getRootPath(), rootNodeRef);
        if (this.m_quotaManager != null) {
            diskCtx.setQuotaManager(this.m_quotaManager);
        }
        if (!(this.m_config instanceof ServerConfigurationBean)) {
            throw new AlfrescoRuntimeException("configuration error, unknown configuration bean");
        }
        ServerConfigurationBean config = (ServerConfigurationBean)this.m_config;
        config.initialiseRuntimeContext("cifs.tenant." + tenantDomain, diskCtx);
        diskCtx.setDiskInformation(new SrvDiskInfo(2560, 64, 512, 2304));
        return new DiskSharedDevice(this.m_tenantShareName, (DeviceInterface)diskDrv, (DiskDeviceContext)diskCtx);
    }

    public void setServerConfiguration(ServerConfiguration config) {
        this.m_config = config;
    }

    public void setTenantShareName(String shareName) {
        this.m_tenantShareName = shareName;
    }

    public void setQuotaManager(QuotaManager quotaManager) {
        this.m_quotaManager = quotaManager;
    }

    public void setRootPath(String m_rootPath) {
        this.m_rootPath = m_rootPath;
    }

    public String getRootPath() {
        return this.m_rootPath;
    }

    public void setStoreName(String m_storeName) {
        this.m_storeName = m_storeName;
    }

    public String getStoreName() {
        return this.m_storeName;
    }

    public void setRepoDiskInterface(DiskInterface repoDiskInterface) {
        this.repoDiskInterface = repoDiskInterface;
    }

    public DiskInterface getRepoDiskInterface() {
        return this.repoDiskInterface;
    }
}

