/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.auth;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.jlan.server.auth.passthru.AuthSessionFactory;
import org.alfresco.jlan.server.auth.passthru.PassthruServers;
import org.alfresco.jlan.server.config.InvalidConfigurationException;
import org.alfresco.jlan.smb.Protocol;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class PassthruServerFactory
implements FactoryBean,
InitializingBean,
DisposableBean {
    private static final Log logger = LogFactory.getLog((String)"org.alfresco.smb.protocol.auth");
    public static final int DefaultSessionTmo = 5000;
    public static final int MinSessionTmo = 2000;
    public static final int MaxSessionTmo = 30000;
    public static final int MinCheckInterval = 10;
    public static final int MaxCheckInterval = 900;
    private Integer timeout;
    private boolean localServer;
    private String server;
    private String domain;
    private Integer offlineCheckInterval;
    private PassthruServers passthruServers;
    private boolean nullDomainUseAnyServer;

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setLocalServer(boolean localServer) {
        this.localServer = localServer;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setOfflineCheckInterval(Integer offlineCheckInterval) {
        this.offlineCheckInterval = offlineCheckInterval;
    }

    public final void setNullDomainUseAnyServer(boolean nullDomain) {
        this.nullDomainUseAnyServer = nullDomain;
    }

    public void setProtocolOrder(String protoOrder) {
        StringTokenizer tokens = new StringTokenizer(protoOrder, ",");
        int primaryProto = -1;
        int secondaryProto = -1;
        if (tokens.countTokens() > 2) {
            throw new AlfrescoRuntimeException("Invalid protocol order list, " + protoOrder);
        }
        if (tokens.hasMoreTokens()) {
            String primaryStr = tokens.nextToken();
            if (primaryStr.equalsIgnoreCase("TCPIP")) {
                primaryProto = 2;
            } else if (primaryStr.equalsIgnoreCase("NetBIOS")) {
                primaryProto = 1;
            } else {
                throw new AlfrescoRuntimeException("Invalid protocol type, " + primaryStr);
            }
            if (tokens.hasMoreTokens()) {
                String secondaryStr = tokens.nextToken();
                if (secondaryStr.equalsIgnoreCase("TCPIP") && primaryProto != 2) {
                    secondaryProto = 2;
                } else if (secondaryStr.equalsIgnoreCase("NetBIOS") && primaryProto != 1) {
                    secondaryProto = 1;
                } else {
                    throw new AlfrescoRuntimeException("Invalid secondary protocol, " + secondaryStr);
                }
            }
        }
        AuthSessionFactory.setProtocolOrder((int)primaryProto, (int)secondaryProto);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Protocol order primary=" + Protocol.asString((int)primaryProto) + ", secondary=" + Protocol.asString((int)secondaryProto)));
        }
    }

    public void afterPropertiesSet() throws InvalidConfigurationException {
        if (this.offlineCheckInterval != null) {
            if (this.offlineCheckInterval < 10 || this.offlineCheckInterval > 900) {
                throw new InvalidConfigurationException("Invalid offline check interval, valid range is 10 to 900");
            }
            this.passthruServers = new PassthruServers(this.offlineCheckInterval.intValue());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Using offline check interval of " + this.offlineCheckInterval + " seconds"));
            }
        } else {
            this.passthruServers = new PassthruServers();
        }
        if (logger.isDebugEnabled()) {
            this.passthruServers.setDebug(true);
        }
        if (this.timeout != null) {
            if (this.timeout < 2000 || this.timeout > 30000) {
                throw new InvalidConfigurationException("Invalid session timeout, valid range is 2000 to 30000");
            }
            this.passthruServers.setConnectionTimeout(this.timeout.intValue());
        }
        this.passthruServers.setNullDomainUseAnyServer(this.nullDomainUseAnyServer);
        String srvList = null;
        if (this.localServer) {
            try {
                StringBuilder addrStr;
                InetAddress[] localAddrs = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
                if (localAddrs != null && localAddrs.length > 0) {
                    addrStr = new StringBuilder();
                    for (InetAddress curAddr : localAddrs) {
                        if (curAddr.isLoopbackAddress()) continue;
                        addrStr.append(curAddr.getHostAddress());
                        addrStr.append(",");
                    }
                    if (addrStr.length() > 0) {
                        addrStr.setLength(addrStr.length() - 1);
                    }
                } else {
                    throw new AlfrescoRuntimeException("No local server address(es)");
                }
                srvList = addrStr.toString();
            }
            catch (UnknownHostException ex) {
                throw new AlfrescoRuntimeException("Failed to get local address list");
            }
        }
        if (this.server != null && this.server.length() > 0) {
            if (srvList != null) {
                throw new AlfrescoRuntimeException("Set passthru server via local server or specify name");
            }
            srvList = this.server;
        }
        if (srvList != null) {
            this.passthruServers.setServerList(srvList);
        } else {
            String domainName = null;
            if (this.domain != null && this.domain.length() > 0) {
                if (srvList != null) {
                    throw new AlfrescoRuntimeException("Specify server or domain name for passthru authentication");
                }
                domainName = this.domain;
            }
            if (domainName != null) {
                try {
                    this.passthruServers.setDomain(domainName);
                }
                catch (IOException ex) {
                    throw new AlfrescoRuntimeException("Error setting passthru domain, " + ex.getMessage());
                }
            }
        }
        if (this.passthruServers.getTotalServerCount() == 0) {
            throw new AlfrescoRuntimeException("No valid authentication servers found for passthru");
        }
    }

    public Object getObject() {
        return this.passthruServers;
    }

    public Class<?> getObjectType() {
        return PassthruServers.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() throws Exception {
        this.passthruServers.shutdown();
    }
}

