/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.avm;

import org.alfresco.jlan.server.filesys.FileName;

public class AVMPath {
    private static final int InvalidVersionId = -2;
    public static final String VersionNameHead = "HEAD";
    public static final String VersionsFolder = "VERSION";
    public static final String DataFolder = "DATA";
    public static final String MetaDataFolder = "METADATA";
    public static final String VersionFolderPrefix = "v";
    public static final char AVM_SEPERATOR = '/';
    public static final String AVM_SEPERATOR_STR = "/";
    private LevelId m_levelId = LevelId.Invalid;
    private String m_storeName;
    private int m_version = -2;
    private String m_path;
    private String m_avmPath;
    private boolean m_readOnly;

    public AVMPath() {
    }

    public AVMPath(String shrPath) {
        this.parsePath(shrPath);
    }

    public AVMPath(String storeName, int version, String path) {
        this.parsePath(storeName, version, path);
    }

    public LevelId isLevel() {
        return this.m_levelId;
    }

    public final boolean isReadOnlyAccess() {
        return this.m_readOnly;
    }

    public final String getStoreName() {
        return this.m_storeName;
    }

    public final boolean hasVersion() {
        return this.m_version != -2;
    }

    public final int getVersion() {
        return this.m_version;
    }

    public final String getVersionString() {
        if (this.m_version == -1) {
            return VersionNameHead;
        }
        return "" + this.m_version;
    }

    public final boolean hasRelativePath() {
        return this.m_path != null;
    }

    public final String getRelativePath() {
        return this.m_path;
    }

    public final String getAVMPath() {
        return this.m_avmPath;
    }

    public final boolean isValid() {
        return this.m_levelId != LevelId.Invalid;
    }

    public final boolean isPseudoPath() {
        return this.m_levelId != LevelId.Invalid && this.m_levelId != LevelId.StorePath && this.m_levelId != LevelId.StoreRootPath;
    }

    public final boolean isReadOnlyPseudoPath() {
        return this.isLevel() == LevelId.Root || this.isLevel() == LevelId.StoreRoot || this.isLevel() == LevelId.VersionRoot || this.isLevel() == LevelId.Head || this.isLevel() == LevelId.Version;
    }

    public final boolean isRootPath() {
        return this.m_levelId == LevelId.Root;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void parsePath(String path) {
        block19: {
            StringBuilder pathStr;
            int pathIdx;
            String[] paths;
            block18: {
                String folderName;
                block20: {
                    block21: {
                        this.m_storeName = null;
                        this.m_version = -2;
                        this.m_path = null;
                        this.m_avmPath = null;
                        paths = FileName.splitAllPaths((String)path);
                        if (paths == null || paths.length == 0) {
                            this.m_path = "\\";
                            this.m_levelId = LevelId.Root;
                            return;
                        }
                        this.m_storeName = paths[0];
                        this.m_levelId = LevelId.StoreRoot;
                        if (paths.length <= 1) break block19;
                        String levelStr = paths[1];
                        if (levelStr.equalsIgnoreCase(VersionNameHead)) {
                            this.m_version = -1;
                            this.m_levelId = LevelId.Head;
                        } else {
                            if (!levelStr.equalsIgnoreCase(VersionsFolder)) {
                                this.m_levelId = LevelId.Invalid;
                                return;
                            }
                            this.m_levelId = LevelId.VersionRoot;
                        }
                        if (paths.length <= 2) break block19;
                        folderName = paths[2];
                        pathIdx = 3;
                        if (this.isLevel() != LevelId.VersionRoot) break block20;
                        if (folderName == null || !folderName.startsWith(VersionFolderPrefix) || folderName.length() <= VersionFolderPrefix.length()) break block21;
                        try {
                            this.m_version = Integer.parseInt(folderName.substring(VersionFolderPrefix.length()));
                            this.m_levelId = LevelId.Version;
                            if (this.m_version < -1) {
                                this.m_levelId = LevelId.Invalid;
                                return;
                            }
                        }
                        catch (NumberFormatException ex) {
                            this.m_levelId = LevelId.Invalid;
                            return;
                        }
                        if (paths.length > 3) {
                            folderName = paths[3];
                            ++pathIdx;
                            if (folderName.equalsIgnoreCase(DataFolder)) {
                                this.m_levelId = LevelId.VersionData;
                                this.m_path = "\\";
                                break block18;
                            } else {
                                if (!folderName.equalsIgnoreCase(MetaDataFolder)) {
                                    this.m_levelId = LevelId.Invalid;
                                    return;
                                }
                                this.m_levelId = LevelId.VersionMetaData;
                                this.m_path = "\\";
                            }
                        }
                        break block18;
                    }
                    this.m_levelId = LevelId.Invalid;
                    return;
                }
                if (this.isLevel() == LevelId.Head) {
                    if (folderName.equalsIgnoreCase(DataFolder)) {
                        this.m_levelId = LevelId.HeadData;
                        this.m_path = "\\";
                    } else {
                        if (!folderName.equalsIgnoreCase(MetaDataFolder)) {
                            this.m_levelId = LevelId.Invalid;
                            return;
                        }
                        this.m_levelId = LevelId.HeadMetaData;
                        this.m_path = "\\";
                    }
                }
            }
            if (paths.length > pathIdx) {
                pathStr = new StringBuilder();
                for (int i = pathIdx; i < paths.length; ++i) {
                    pathStr.append('\\');
                    pathStr.append(paths[i]);
                }
                this.m_path = pathStr.toString();
                String lastPath = paths[paths.length - 1].toLowerCase();
                this.m_levelId = lastPath.equals("www") || lastPath.equals("avm_webapps") ? LevelId.StoreRootPath : LevelId.StorePath;
            }
            if (this.m_path != null) {
                pathStr = new StringBuilder();
                pathStr.append(this.m_storeName);
                pathStr.append(":");
                pathStr.append(this.m_path.replace('\\', '/'));
                this.m_avmPath = pathStr.toString();
            }
        }
    }

    public final void parsePath(String storeName, int version, String path) {
        this.m_levelId = LevelId.Invalid;
        this.m_storeName = null;
        this.m_version = -2;
        this.m_path = null;
        this.m_avmPath = null;
        this.m_storeName = storeName;
        this.m_version = version;
        this.m_path = path;
        StringBuilder avmPath = new StringBuilder();
        avmPath.append(this.m_storeName);
        if (storeName.indexOf(":") == -1) {
            avmPath.append(":");
        }
        if (path == null || path.length() == 0) {
            avmPath.append('/');
            this.m_path = "\\";
        } else {
            if (!path.startsWith("\\")) {
                avmPath.append('/');
            }
            avmPath.append(path.replace('\\', '/'));
        }
        this.m_avmPath = avmPath.toString();
        String lowerPath = path.toLowerCase();
        String[] paths = FileName.splitAllPaths((String)lowerPath);
        this.m_levelId = paths[paths.length - 1].equals("www") || paths[paths.length - 1].equals("avm_webapps") ? LevelId.StoreRootPath : LevelId.StorePath;
    }

    public final int generateFileId() {
        int fid = -1;
        if (this.isLevel() == LevelId.StorePath || this.isLevel() == LevelId.StoreRootPath) {
            fid = this.getRelativePath().hashCode();
        } else if (this.isPseudoPath()) {
            StringBuilder relStr = new StringBuilder();
            relStr.append('\\');
            switch (this.isLevel()) {
                case StoreRoot: {
                    relStr.append(this.getStoreName());
                    break;
                }
                case Head: {
                    relStr.append(this.getStoreName());
                    relStr.append('\\');
                    relStr.append(VersionNameHead);
                    break;
                }
                case HeadData: {
                    relStr.append(this.getStoreName());
                    relStr.append('\\');
                    relStr.append(VersionNameHead);
                    relStr.append('\\');
                    relStr.append(DataFolder);
                    break;
                }
                case HeadMetaData: {
                    relStr.append(this.getStoreName());
                    relStr.append('\\');
                    relStr.append(VersionNameHead);
                    relStr.append('\\');
                    relStr.append(MetaDataFolder);
                    break;
                }
                case VersionRoot: {
                    relStr.append(this.getStoreName());
                    relStr.append('\\');
                    relStr.append(VersionsFolder);
                    break;
                }
                case Version: {
                    relStr.append(this.getStoreName());
                    relStr.append('\\');
                    relStr.append(VersionsFolder);
                    relStr.append('\\');
                    relStr.append(VersionFolderPrefix);
                    relStr.append(this.getVersion());
                    break;
                }
                case VersionData: {
                    relStr.append(this.getStoreName());
                    relStr.append('\\');
                    relStr.append(VersionsFolder);
                    relStr.append('\\');
                    relStr.append(VersionFolderPrefix);
                    relStr.append(this.getVersion());
                    relStr.append('\\');
                    relStr.append(DataFolder);
                    break;
                }
                case VersionMetaData: {
                    relStr.append(this.getStoreName());
                    relStr.append('\\');
                    relStr.append(VersionsFolder);
                    relStr.append('\\');
                    relStr.append(VersionFolderPrefix);
                    relStr.append(this.getVersion());
                    relStr.append('\\');
                    relStr.append(MetaDataFolder);
                }
            }
            fid = relStr.toString().hashCode();
        }
        return fid;
    }

    public final void setReadOnlyAccess(boolean readOnly) {
        this.m_readOnly = readOnly;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        switch (this.m_levelId) {
            case Invalid: {
                str.append("[Invalid");
                break;
            }
            case Root: {
                str.append("[Root");
                break;
            }
            case StoreRoot: {
                str.append("[StoresRoot");
                break;
            }
            case Head: {
                str.append("[");
                str.append(this.getStoreName());
                str.append(":HEAD");
                break;
            }
            case HeadData: {
                str.append("[");
                str.append(this.getStoreName());
                str.append(":HEAD\\");
                str.append(DataFolder);
                break;
            }
            case HeadMetaData: {
                str.append("[");
                str.append(this.getStoreName());
                str.append(":HEAD\\");
                str.append(MetaDataFolder);
                break;
            }
            case VersionRoot: {
                str.append("[");
                str.append(this.getStoreName());
                str.append(":Versions");
                break;
            }
            case Version: {
                str.append("[");
                str.append(this.getStoreName());
                str.append(":");
                str.append(VersionFolderPrefix);
                str.append(this.getVersion());
                break;
            }
            case VersionData: {
                str.append("[");
                str.append(this.getStoreName());
                str.append(":");
                str.append(VersionFolderPrefix);
                str.append(this.getVersion());
                str.append("\\");
                str.append(DataFolder);
                break;
            }
            case VersionMetaData: {
                str.append("[");
                str.append(this.getStoreName());
                str.append(":");
                str.append(VersionFolderPrefix);
                str.append(this.getVersion());
                str.append("\\");
                str.append(MetaDataFolder);
                break;
            }
            case StoreRootPath: 
            case StorePath: {
                str.append("[");
                str.append(this.getStoreName());
                str.append(":");
                str.append(VersionFolderPrefix);
                str.append(this.getVersion());
                str.append(",");
                str.append(this.getRelativePath());
                str.append(":");
                str.append(this.getAVMPath());
            }
        }
        if (this.isReadOnlyAccess()) {
            str.append("-ReadOnly");
        }
        str.append("]");
        return str.toString();
    }

    public static enum LevelId {
        Invalid,
        Root,
        StoreRoot,
        Head,
        HeadData,
        HeadMetaData,
        VersionRoot,
        Version,
        VersionData,
        VersionMetaData,
        StoreRootPath,
        StorePath;

    }
}

