/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.alfresco.filesys.repo.ContentComparator;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.util.EqualsHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.EntryUtils;
import org.apache.poi.poifs.filesystem.FilteringDirectoryNode;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;

public class CIFSContentComparator
implements ContentComparator {
    private Map<String, ContentComparator> customComparators = new HashMap<String, ContentComparator>();
    private static final Log logger = LogFactory.getLog(CIFSContentComparator.class);

    public void init() {
        this.customComparators.put("application/vnd.ms-project", new MPPContentComparator());
        this.customComparators.put("application/vnd.ms-excel", new XLSContentComparator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isContentEqual(ContentReader existingContent, File newFile) {
        String mimetype = existingContent.getMimetype();
        logger.debug((Object)("isContentEqual mimetype=" + mimetype));
        long newSize = newFile.length();
        ContentComparator custom = this.customComparators.get(mimetype);
        if (custom == null) {
            if (existingContent.getSize() != newSize) {
                logger.debug((Object)"generic comparision, size is different - not equal");
                return false;
            }
            BufferedInputStream rightIs = null;
            InputStream leftIs = null;
            try {
                rightIs = new BufferedInputStream(new FileInputStream(newFile));
                leftIs = existingContent.getContentInputStream();
                boolean retVal = EqualsHelper.binaryStreamEquals((InputStream)leftIs, (InputStream)rightIs);
                rightIs = null;
                leftIs = null;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("generic comparision, binary content comparison equal=" + retVal));
                }
                boolean bl = retVal;
                return bl;
            }
            catch (IOException e) {
                logger.debug((Object)"Unable to compare contents", (Throwable)e);
                boolean bl = false;
                return bl;
            }
            finally {
                if (leftIs != null) {
                    try {
                        leftIs.close();
                    }
                    catch (IOException e) {}
                }
                if (rightIs != null) {
                    try {
                        ((InputStream)rightIs).close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return custom.isContentEqual(existingContent, newFile);
    }

    private class XLSContentComparator
    implements ContentComparator {
        private XLSContentComparator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isContentEqual(ContentReader existingContent, File newFile) {
            long newSize = newFile.length();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("comparing two excel files size:" + existingContent.getSize() + ", and " + newFile.length()));
            }
            if (existingContent.getSize() != newSize) {
                logger.debug((Object)"excel files are different size");
                return false;
            }
            InputStream leftIs = null;
            try {
                HashSet excludes = new HashSet();
                leftIs = existingContent.getContentInputStream();
                NPOIFSFileSystem fs2 = new NPOIFSFileSystem(leftIs);
                NPOIFSFileSystem fs1 = new NPOIFSFileSystem(newFile);
                DirectoryNode de1 = fs1.getRoot();
                DirectoryNode de2 = fs2.getRoot();
                FilteringDirectoryNode fs1Filtered = new FilteringDirectoryNode((DirectoryEntry)de1, excludes);
                FilteringDirectoryNode fs2Filtered = new FilteringDirectoryNode((DirectoryEntry)de2, excludes);
                boolean retVal = EntryUtils.areDirectoriesIdentical((DirectoryEntry)fs1Filtered, (DirectoryEntry)fs2Filtered);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("returning equal=" + retVal));
                }
                boolean bl = retVal;
                return bl;
            }
            catch (ContentIOException ce) {
                logger.debug((Object)"Unable to compare contents", (Throwable)ce);
                boolean bl = false;
                return bl;
            }
            catch (IOException e) {
                logger.debug((Object)"Unable to compare contents", (Throwable)e);
                boolean bl = false;
                return bl;
            }
            finally {
                if (leftIs != null) {
                    try {
                        leftIs.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    private class MPPContentComparator
    implements ContentComparator {
        private MPPContentComparator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isContentEqual(ContentReader existingContent, File newFile) {
            long newSize = newFile.length();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("comparing two project files size:" + existingContent.getSize() + ", and " + newFile.length()));
            }
            if (existingContent.getSize() != newSize) {
                logger.debug((Object)"project files are different size");
                return false;
            }
            InputStream leftIs = null;
            try {
                HashSet<String> excludes = new HashSet<String>();
                excludes.add("Props");
                excludes.add("Props12");
                excludes.add("Props9");
                leftIs = existingContent.getContentInputStream();
                NPOIFSFileSystem fs2 = new NPOIFSFileSystem(leftIs);
                NPOIFSFileSystem fs1 = new NPOIFSFileSystem(newFile);
                DirectoryNode de1 = fs1.getRoot();
                DirectoryNode de2 = fs2.getRoot();
                FilteringDirectoryNode fs1Filtered = new FilteringDirectoryNode((DirectoryEntry)de1, excludes);
                FilteringDirectoryNode fs2Filtered = new FilteringDirectoryNode((DirectoryEntry)de2, excludes);
                boolean retVal = EntryUtils.areDirectoriesIdentical((DirectoryEntry)fs1Filtered, (DirectoryEntry)fs2Filtered);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("returning equal=" + retVal));
                }
                boolean bl = retVal;
                return bl;
            }
            catch (ContentIOException ce) {
                logger.debug((Object)"Unable to compare contents", (Throwable)ce);
                boolean bl = false;
                return bl;
            }
            catch (IOException e) {
                logger.debug((Object)"Unable to compare contents", (Throwable)e);
                boolean bl = false;
                return bl;
            }
            finally {
                if (leftIs != null) {
                    try {
                        leftIs.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }
}

