/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import org.alfresco.filesys.alfresco.ExtendedDiskInterface;
import org.alfresco.filesys.repo.AlfrescoFolder;
import org.alfresco.filesys.repo.ContentContext;
import org.alfresco.filesys.repo.ContentNetworkFile;
import org.alfresco.filesys.repo.InFlightCorrectable;
import org.alfresco.filesys.repo.InFlightCorrectorImpl;
import org.alfresco.filesys.repo.NodeRefNetworkFile;
import org.alfresco.filesys.repo.TempNetworkFile;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.core.DeviceContext;
import org.alfresco.jlan.server.core.DeviceContextException;
import org.alfresco.jlan.server.filesys.FileAccessToken;
import org.alfresco.jlan.server.filesys.FileInfo;
import org.alfresco.jlan.server.filesys.FileOpenParams;
import org.alfresco.jlan.server.filesys.NetworkFile;
import org.alfresco.jlan.server.filesys.SearchContext;
import org.alfresco.jlan.server.filesys.TreeConnection;
import org.alfresco.jlan.server.filesys.cache.FileState;
import org.alfresco.jlan.server.filesys.cache.FileStateCache;
import org.alfresco.jlan.server.filesys.cache.NetworkFileStateInterface;
import org.alfresco.jlan.server.locking.OpLockInterface;
import org.alfresco.jlan.server.locking.OpLockManager;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.ConfigElement;

public class LegacyFileStateDriver
implements ExtendedDiskInterface {
    private ExtendedDiskInterface diskInterface;
    private static final Log logger = LogFactory.getLog(LegacyFileStateDriver.class);

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"diskInterface", (Object)this.diskInterface);
    }

    public void treeOpened(SrvSession sess, TreeConnection tree) {
        this.diskInterface.treeOpened(sess, tree);
    }

    public void treeClosed(SrvSession sess, TreeConnection tree) {
        this.diskInterface.treeClosed(sess, tree);
    }

    public NetworkFile createFile(SrvSession sess, TreeConnection tree, FileOpenParams params) throws IOException {
        FileState fstate;
        ContentContext tctx = (ContentContext)tree.getContext();
        FileAccessToken token = null;
        if (tctx.hasStateCache()) {
            FileStateCache cache = tctx.getStateCache();
            fstate = tctx.getStateCache().findFileState(params.getPath(), true);
            token = cache.grantFileAccess(params, fstate, 0);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("create file created lock token:" + token));
            }
        }
        try {
            NetworkFileStateInterface x;
            NetworkFile newFile = this.diskInterface.createFile(sess, tree, params);
            newFile.setAccessToken(token);
            if (tctx.hasStateCache()) {
                NetworkFileStateInterface x2;
                fstate = tctx.getStateCache().findFileState(params.getPath(), true);
                fstate.setProcessId(params.getProcessId());
                fstate.setSharedAccess(params.getSharedAccess());
                fstate.setFileStatus(newFile.isDirectory() ? 2 : 1);
                long allocationSize = params.getAllocationSize();
                if (allocationSize > 0L) {
                    fstate.setAllocationSize(allocationSize);
                    fstate.setFileSize(allocationSize);
                }
                if (newFile instanceof NodeRefNetworkFile) {
                    x2 = (NodeRefNetworkFile)newFile;
                    x2.setFileState(fstate);
                }
                if (newFile instanceof TempNetworkFile) {
                    x2 = (TempNetworkFile)newFile;
                    x2.setFileState(fstate);
                }
            }
            if (newFile instanceof NodeRefNetworkFile) {
                x = (NodeRefNetworkFile)newFile;
                x.setProcessId(params.getProcessId());
                x.setAccessToken(token);
            }
            if (newFile instanceof TempNetworkFile) {
                x = (TempNetworkFile)newFile;
                x.setAccessToken(token);
            }
            return newFile;
        }
        catch (IOException ie) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"create file exception caught", (Throwable)ie);
            }
            if (tctx.hasStateCache() && token != null) {
                FileStateCache cache = tctx.getStateCache();
                FileState fstate2 = tctx.getStateCache().findFileState(params.getPath(), false);
                if (fstate2 != null && token != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("create file release lock token:" + token));
                    }
                    cache.releaseFileAccess(fstate2, token);
                }
            }
            throw ie;
        }
    }

    public NetworkFile openFile(SrvSession sess, TreeConnection tree, FileOpenParams params) throws IOException {
        FileState fstate;
        ContentContext tctx = (ContentContext)tree.getContext();
        String path = params.getPath();
        FileAccessToken token = null;
        if (tctx.hasStateCache() && !params.isDirectory()) {
            FileStateCache cache = tctx.getStateCache();
            fstate = tctx.getStateCache().findFileState(params.getPath(), true);
            token = cache.grantFileAccess(params, fstate, -1);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("open file created lock token:" + token));
            }
        }
        try {
            NetworkFile openFile = this.diskInterface.openFile(sess, tree, params);
            openFile.setAccessToken(token);
            fstate = null;
            if (tctx.hasStateCache()) {
                fstate = tctx.getStateCache().findFileState(path, true);
                fstate.setProcessId(params.getProcessId());
                fstate.setSharedAccess(params.getSharedAccess());
                fstate.setFileSize(openFile.getFileSize());
                fstate.updateChangeDateTime(openFile.getModifyDate());
                fstate.updateModifyDateTime(openFile.getModifyDate());
            }
            if (openFile instanceof ContentNetworkFile) {
                ContentNetworkFile x = (ContentNetworkFile)openFile;
                x.setProcessId(params.getProcessId());
                if (fstate != null) {
                    x.setFileState(fstate);
                    fstate.setFileStatus(1);
                }
            } else if (openFile instanceof TempNetworkFile) {
                TempNetworkFile x = (TempNetworkFile)openFile;
                if (fstate != null) {
                    x.setFileState(fstate);
                    fstate.setFileStatus(1);
                }
            } else if (openFile instanceof AlfrescoFolder) {
                AlfrescoFolder x = (AlfrescoFolder)openFile;
                if (fstate != null) {
                    x.setFileState(fstate);
                    fstate.setFileStatus(2);
                }
            } else if (openFile instanceof NetworkFile) {
                NetworkFile x = openFile;
                if (fstate != null) {
                    fstate.setFileStatus(1);
                }
            }
            return openFile;
        }
        catch (IOException ie) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"open file exception caught", (Throwable)ie);
            }
            if (tctx.hasStateCache() && token != null) {
                FileStateCache cache = tctx.getStateCache();
                FileState fstate2 = tctx.getStateCache().findFileState(params.getPath(), false);
                if (fstate2 != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("open file release lock token:" + token));
                    }
                    cache.releaseFileAccess(fstate2, token);
                }
            }
            throw ie;
        }
    }

    public void closeFile(SrvSession sess, TreeConnection tree, NetworkFile param) throws IOException {
        ContentContext tctx = (ContentContext)tree.getContext();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("closeFile:" + param.getFullName() + ", accessToken:" + param.getAccessToken()));
        }
        try {
            if (param.hasOpLock()) {
                OpLockInterface flIface = (OpLockInterface)this;
                OpLockManager oplockMgr = flIface.getOpLockManager(sess, tree);
                oplockMgr.releaseOpLock(param.getOpLock().getPath());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Released oplock for closed file, file=" + param.getFullName()));
                }
            }
            this.diskInterface.closeFile(sess, tree, param);
            if (tctx.hasStateCache()) {
                FileStateCache cache = tctx.getStateCache();
                FileState fstate = cache.findFileState(param.getFullName(), true);
                if (fstate != null && param.getAccessToken() != null) {
                    FileAccessToken token = param.getAccessToken();
                    if (logger.isDebugEnabled() && token != null) {
                        logger.debug((Object)("close file, release access token:" + token));
                    }
                    cache.releaseFileAccess(fstate, token);
                }
                if (fstate.getOpenCount() == 0) {
                    logger.debug((Object)"fstate OpenCount == 0, reset in-flight state");
                    fstate.setAllocationSize(-1L);
                    fstate.setFileSize(-1L);
                    fstate.updateChangeDateTime(0L);
                    fstate.updateModifyDateTime(0L);
                }
                param.setAccessToken(null);
            }
        }
        catch (IOException ie) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"close file exception caught", (Throwable)ie);
            }
            throw ie;
        }
    }

    @Override
    public void registerContext(DeviceContext ctx) throws DeviceContextException {
        this.diskInterface.registerContext(ctx);
    }

    public void setDiskInterface(ExtendedDiskInterface diskInterface) {
        this.diskInterface = diskInterface;
    }

    public ExtendedDiskInterface getDiskInterface() {
        return this.diskInterface;
    }

    public void createDirectory(SrvSession sess, TreeConnection tree, FileOpenParams params) throws IOException {
        this.diskInterface.createDirectory(sess, tree, params);
    }

    public void deleteDirectory(SrvSession sess, TreeConnection tree, String dir) throws IOException {
        this.diskInterface.deleteDirectory(sess, tree, dir);
    }

    public void deleteFile(SrvSession sess, TreeConnection tree, String name) throws IOException {
        FileStateCache cache;
        FileState fstate;
        ContentContext tctx = (ContentContext)tree.getContext();
        this.diskInterface.deleteFile(sess, tree, name);
        if (tctx.hasStateCache() && (fstate = (cache = tctx.getStateCache()).findFileState(name, false)) != null) {
            fstate.setFileStatus(0);
            fstate.setOpenCount(0);
        }
    }

    public int fileExists(SrvSession sess, TreeConnection tree, String name) {
        return this.diskInterface.fileExists(sess, tree, name);
    }

    public void flushFile(SrvSession sess, TreeConnection tree, NetworkFile file) throws IOException {
        this.diskInterface.flushFile(sess, tree, file);
    }

    public FileInfo getFileInformation(SrvSession sess, TreeConnection tree, String name) throws IOException {
        return this.diskInterface.getFileInformation(sess, tree, name);
    }

    public boolean isReadOnly(SrvSession sess, DeviceContext ctx) throws IOException {
        return this.diskInterface.isReadOnly(sess, ctx);
    }

    public int readFile(SrvSession sess, TreeConnection tree, NetworkFile file, byte[] buf, int bufPos, int siz, long filePos) throws IOException {
        return this.diskInterface.readFile(sess, tree, file, buf, bufPos, siz, filePos);
    }

    public void renameFile(SrvSession sess, TreeConnection tree, String oldName, String newName) throws IOException {
        this.diskInterface.renameFile(sess, tree, oldName, newName);
    }

    public long seekFile(SrvSession sess, TreeConnection tree, NetworkFile file, long pos, int typ) throws IOException {
        return this.diskInterface.seekFile(sess, tree, file, pos, typ);
    }

    public void setFileInformation(SrvSession sess, TreeConnection tree, String name, FileInfo info) throws IOException {
        this.diskInterface.setFileInformation(sess, tree, name, info);
        ContentContext tctx = (ContentContext)tree.getContext();
        if (tctx.hasStateCache()) {
            FileStateCache cache = tctx.getStateCache();
            FileState fstate = cache.findFileState(name, true);
            if (info.hasSetFlag(8)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Set modification date in file state cache" + name + ", " + info.getModifyDateTime()));
                }
                Date modifyDate = new Date(info.getModifyDateTime());
                fstate.updateModifyDateTime(modifyDate.getTime());
            }
        }
    }

    public SearchContext startSearch(SrvSession sess, TreeConnection tree, String searchPath, int attrib) throws FileNotFoundException {
        InFlightCorrectorImpl t = new InFlightCorrectorImpl(tree);
        SearchContext ctx = this.diskInterface.startSearch(sess, tree, searchPath, attrib);
        if (ctx instanceof InFlightCorrectable) {
            InFlightCorrectable thingable = (InFlightCorrectable)ctx;
            thingable.setInFlightCorrector(t);
        }
        return ctx;
    }

    public void truncateFile(SrvSession sess, TreeConnection tree, NetworkFile file, long siz) throws IOException {
        this.diskInterface.truncateFile(sess, tree, file, siz);
    }

    public int writeFile(SrvSession sess, TreeConnection tree, NetworkFile file, byte[] buf, int bufoff, int siz, long fileoff) throws IOException {
        return this.diskInterface.writeFile(sess, tree, file, buf, bufoff, siz, fileoff);
    }

    public DeviceContext createContext(String shareName, ConfigElement args) throws DeviceContextException {
        return this.diskInterface.createContext(shareName, args);
    }
}

