/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo.rules;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.filesys.repo.rules.EvaluatorContext;
import org.alfresco.filesys.repo.rules.Operation;
import org.alfresco.filesys.repo.rules.Scenario;
import org.alfresco.filesys.repo.rules.ScenarioDeleteOnCloseRenameInstance;
import org.alfresco.filesys.repo.rules.ScenarioInstance;
import org.alfresco.filesys.repo.rules.operations.CloseFileOperation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScenarioDeleteOnCloseRename
implements Scenario {
    private static Log logger = LogFactory.getLog(ScenarioDeleteOnCloseRename.class);
    private Pattern pattern;
    private String strPattern;
    private long timeout = 30000L;
    private ScenarioInstance.Ranking ranking = ScenarioInstance.Ranking.HIGH;

    @Override
    public ScenarioInstance createInstance(EvaluatorContext ctx, Operation operation) {
        CloseFileOperation c;
        Matcher m;
        if (operation instanceof CloseFileOperation && (m = this.pattern.matcher((c = (CloseFileOperation)operation).getName())).matches() && c.getNetworkFile().hasDeleteOnClose()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("New Scenario ScenarioDeleteOnCloseRename strPattern:" + this.pattern));
            }
            ScenarioDeleteOnCloseRenameInstance instance = new ScenarioDeleteOnCloseRenameInstance();
            instance.setTimeout(this.timeout);
            instance.setRanking(this.ranking);
            return instance;
        }
        return null;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setPattern(String pattern) {
        this.pattern = Pattern.compile(pattern, 2);
        this.strPattern = pattern;
    }

    public String getPattern() {
        return this.strPattern;
    }

    public void setRanking(ScenarioInstance.Ranking ranking) {
        this.ranking = ranking;
    }

    public ScenarioInstance.Ranking getRanking() {
        return this.ranking;
    }
}

