/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo.rules;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.alfresco.filesys.repo.OpenFileMode;
import org.alfresco.filesys.repo.ResultCallback;
import org.alfresco.filesys.repo.TempNetworkFile;
import org.alfresco.filesys.repo.rules.Command;
import org.alfresco.filesys.repo.rules.DependentInstance;
import org.alfresco.filesys.repo.rules.Operation;
import org.alfresco.filesys.repo.rules.ScenarioDeleteOnCloseRenameInstance;
import org.alfresco.filesys.repo.rules.ScenarioDeleteRestoreInstance;
import org.alfresco.filesys.repo.rules.ScenarioInstance;
import org.alfresco.filesys.repo.rules.ScenarioResult;
import org.alfresco.filesys.repo.rules.commands.CloseFileCommand;
import org.alfresco.filesys.repo.rules.commands.CompoundCommand;
import org.alfresco.filesys.repo.rules.commands.CreateFileCommand;
import org.alfresco.filesys.repo.rules.commands.DoNothingCommand;
import org.alfresco.filesys.repo.rules.commands.OpenFileCommand;
import org.alfresco.filesys.repo.rules.commands.ReduceQuotaCommand;
import org.alfresco.filesys.repo.rules.commands.RemoveTempFileCommand;
import org.alfresco.filesys.repo.rules.commands.ReturnValueCommand;
import org.alfresco.filesys.repo.rules.operations.CloseFileOperation;
import org.alfresco.filesys.repo.rules.operations.CreateFileOperation;
import org.alfresco.filesys.repo.rules.operations.DeleteFileOperation;
import org.alfresco.filesys.repo.rules.operations.OpenFileOperation;
import org.alfresco.jlan.server.filesys.NetworkFile;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ScenarioOpenFileInstance
implements ScenarioInstance,
DependentInstance {
    private static Log logger = LogFactory.getLog(ScenarioOpenFileInstance.class);
    private Date startTime = new Date();
    private String name;
    InternalState state = InternalState.NONE;
    private NetworkFile fileHandleReadOnly;
    private int openReadOnlyCount = 0;
    private NetworkFile fileHandleReadWrite;
    private int openReadWriteCount = 0;
    private long timeout = 30000L;
    private boolean isComplete = false;
    private ScenarioInstance.Ranking ranking = ScenarioInstance.Ranking.HIGH;

    ScenarioOpenFileInstance() {
    }

    @Override
    public Command evaluate(Operation operation) {
        if (operation instanceof DeleteFileOperation) {
            DeleteFileOperation d = (DeleteFileOperation)operation;
            if (d.getName() == null) {
                return null;
            }
            if (this.name.equalsIgnoreCase(d.getName())) {
                logger.debug((Object)("Anti-Pattern - delete of the open file, scenario:" + this));
                this.isComplete = true;
                return null;
            }
        }
        switch (this.state) {
            case NONE: {
                OpenFileOperation o;
                if (operation instanceof CreateFileOperation) {
                    CreateFileOperation c = (CreateFileOperation)operation;
                    this.name = c.getName();
                    if (this.name != null) {
                        this.state = InternalState.OPENING;
                        logger.debug((Object)("Create File name:" + this.name));
                        ArrayList<Command> commands = new ArrayList<Command>();
                        ArrayList<Command> postCommitCommands = new ArrayList<Command>();
                        ArrayList<Command> postErrorCommands = new ArrayList<Command>();
                        commands.add(new CreateFileCommand(c.getName(), c.getRootNodeRef(), c.getPath(), c.getAllocationSize()));
                        postCommitCommands.add(this.newOpenFileCallbackCommand());
                        postErrorCommands.add(this.newOpenFileErrorCallbackCommand());
                        return new CompoundCommand(commands, postCommitCommands, postErrorCommands);
                    }
                } else if (operation instanceof OpenFileOperation) {
                    o = (OpenFileOperation)operation;
                    this.name = o.getName();
                    if (this.name != null) {
                        this.state = InternalState.OPENING;
                        logger.debug((Object)("Open File name:" + this.name));
                        ArrayList<Command> commands = new ArrayList<Command>();
                        commands.add(new OpenFileCommand(o.getName(), o.getMode(), o.isTruncate(), o.getRootNodeRef(), o.getPath()));
                        ArrayList<Command> postCommitCommands = new ArrayList<Command>();
                        ArrayList<Command> postErrorCommands = new ArrayList<Command>();
                        postCommitCommands.add(this.newOpenFileCallbackCommand());
                        postErrorCommands.add(this.newOpenFileErrorCallbackCommand());
                        return new CompoundCommand(commands, postCommitCommands, postErrorCommands);
                    }
                }
                logger.debug((Object)"Scenario not started - no name");
                this.isComplete = true;
                return null;
            }
            case OPENING: {
                Date now;
                OpenFileOperation o;
                if (operation instanceof OpenFileOperation) {
                    o = (OpenFileOperation)operation;
                    if (o.getName() == null) {
                        return null;
                    }
                    if (this.name.equalsIgnoreCase(o.getName())) {
                        logger.error((Object)("Second open while in opening state. :" + this.name));
                    }
                }
                if ((now = new Date()).getTime() > this.startTime.getTime() + this.getTimeout()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Instance in OPENING STATE timed out name" + this.name));
                    }
                    this.isComplete = true;
                }
                return null;
            }
            case ERROR: {
                logger.debug((Object)("Open has failed :" + this.name));
                this.isComplete = true;
                return null;
            }
            case OPEN: {
                if (operation instanceof CloseFileOperation) {
                    CloseFileOperation c = (CloseFileOperation)operation;
                    if (c.getName() == null) {
                        return null;
                    }
                    if (!this.name.equalsIgnoreCase(c.getName())) break;
                    NetworkFile file = c.getNetworkFile();
                    if (this.isReadOnly(file)) {
                        if (this.openReadOnlyCount == 1 || c.isForce()) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Close of last read only file handle:" + this));
                            }
                            this.openReadOnlyCount = 0;
                            if (this.openReadWriteCount <= 0) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("Scenario is complete:" + this));
                                }
                                this.isComplete = true;
                            }
                            if (file instanceof TempNetworkFile) {
                                logger.debug((Object)"this is the last close of a temp read only file");
                                ArrayList<Command> commands = new ArrayList<Command>();
                                ArrayList<Command> postCommitCommands = new ArrayList<Command>();
                                commands.add(new CloseFileCommand(c.getName(), file, c.getRootNodeRef(), c.getPath()));
                                postCommitCommands.add(new RemoveTempFileCommand((TempNetworkFile)file));
                                return new CompoundCommand(commands, postCommitCommands);
                            }
                            return new CloseFileCommand(c.getName(), file, c.getRootNodeRef(), c.getPath());
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Only decrement count of read only file handle:" + this));
                        }
                        --this.openReadOnlyCount;
                        return new DoNothingCommand();
                    }
                    if (this.openReadWriteCount == 1 || c.isForce()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Close of last read write file handle:" + this));
                        }
                        this.openReadWriteCount = 0;
                        if (this.openReadOnlyCount <= 0) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Scenario is complete:" + this));
                            }
                            this.isComplete = true;
                        }
                        ArrayList<Command> commands = new ArrayList<Command>();
                        ArrayList<Command> postCommitCommands = new ArrayList<Command>();
                        ArrayList<Command> postErrorCommands = new ArrayList<Command>();
                        commands.add(new CloseFileCommand(c.getName(), file, c.getRootNodeRef(), c.getPath()));
                        if (c.isDeleteOnClose()) {
                            postCommitCommands.add(new ReduceQuotaCommand(c.getName(), file, c.getRootNodeRef(), c.getPath()));
                        }
                        if (file instanceof TempNetworkFile) {
                            postCommitCommands.add(new RemoveTempFileCommand((TempNetworkFile)file));
                        }
                        return new CompoundCommand(commands, postCommitCommands, postErrorCommands);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Only decrement count of read write file handle:" + this));
                    }
                    --this.openReadWriteCount;
                    return new DoNothingCommand();
                }
                if (!(operation instanceof OpenFileOperation)) break;
                OpenFileOperation o = (OpenFileOperation)operation;
                if (o.getName() == null) {
                    return null;
                }
                if (this.name == null || !this.name.equalsIgnoreCase(o.getName())) break;
                if (o.getMode() == OpenFileMode.READ_WRITE) {
                    if (this.openReadWriteCount == 0) {
                        logger.debug((Object)("Open first read/write from scenario:" + this));
                        ArrayList<Command> commands = new ArrayList<Command>();
                        commands.add(new OpenFileCommand(o.getName(), o.getMode(), o.isTruncate(), o.getRootNodeRef(), o.getPath()));
                        ArrayList<Command> postCommitCommands = new ArrayList<Command>();
                        postCommitCommands.add(this.newOpenFileCallbackCommand());
                        return new CompoundCommand(commands, postCommitCommands);
                    }
                    ++this.openReadWriteCount;
                    logger.debug((Object)("Return already open read/write file handle from scenario:" + this));
                    return new ReturnValueCommand(this.fileHandleReadWrite);
                }
                if (this.openReadWriteCount > 0) {
                    ++this.openReadWriteCount;
                    logger.debug((Object)("Return already open read/write file handle from scenario:" + this));
                    return new ReturnValueCommand(this.fileHandleReadWrite);
                }
                if (this.openReadOnlyCount == 0) {
                    logger.debug((Object)("Open first read only from scenario:" + this));
                    ArrayList<Command> commands = new ArrayList<Command>();
                    commands.add(new OpenFileCommand(o.getName(), o.getMode(), o.isTruncate(), o.getRootNodeRef(), o.getPath()));
                    ArrayList<Command> postCommitCommands = new ArrayList<Command>();
                    postCommitCommands.add(this.newOpenFileCallbackCommand());
                    return new CompoundCommand(commands, postCommitCommands);
                }
                ++this.openReadOnlyCount;
                logger.debug((Object)("Return already open only file handle from scenario:" + this));
                return new ReturnValueCommand(this.fileHandleReadOnly);
            }
        }
        return null;
    }

    @Override
    public boolean isComplete() {
        return this.isComplete;
    }

    public String toString() {
        return "ScenarioOpenFileInstance name:" + this.name;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public ScenarioInstance.Ranking getRanking() {
        return this.ranking;
    }

    public void setRanking(ScenarioInstance.Ranking ranking) {
        this.ranking = ranking;
    }

    public String getName() {
        return this.name;
    }

    private ResultCallback newOpenFileCallbackCommand() {
        return new ResultCallback(){

            @Override
            public void execute(Object result) {
                if (result instanceof NetworkFile) {
                    NetworkFile fileHandle = (NetworkFile)result;
                    ScenarioOpenFileInstance.this.state = InternalState.OPEN;
                    if (ScenarioOpenFileInstance.this.isReadOnly(fileHandle)) {
                        ScenarioOpenFileInstance.this.openReadOnlyCount++;
                        ScenarioOpenFileInstance.this.fileHandleReadOnly = fileHandle;
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("file opened read only:" + result + ", name:" + ScenarioOpenFileInstance.this.name));
                        }
                    } else {
                        ScenarioOpenFileInstance.this.openReadWriteCount++;
                        ScenarioOpenFileInstance.this.fileHandleReadWrite = fileHandle;
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("file opened read write :" + result + ", name:" + ScenarioOpenFileInstance.this.name));
                        }
                    }
                }
            }

            @Override
            public AlfrescoTransactionSupport.TxnReadState getTransactionRequired() {
                return AlfrescoTransactionSupport.TxnReadState.TXN_NONE;
            }
        };
    }

    private ResultCallback newOpenFileErrorCallbackCommand() {
        return new ResultCallback(){

            @Override
            public void execute(Object result) {
                logger.debug((Object)("error handler - set state to error for name:" + ScenarioOpenFileInstance.this.name));
                ScenarioOpenFileInstance.this.isComplete = true;
                ScenarioOpenFileInstance.this.state = InternalState.ERROR;
            }

            @Override
            public AlfrescoTransactionSupport.TxnReadState getTransactionRequired() {
                return AlfrescoTransactionSupport.TxnReadState.TXN_NONE;
            }
        };
    }

    private boolean isReadOnly(NetworkFile file) {
        return file.getGrantedAccess() == 1;
    }

    @Override
    public Command win(List<ScenarioResult> results, Command command) {
        if (command instanceof CompoundCommand) {
            CompoundCommand c = (CompoundCommand)command;
            for (ScenarioResult looser : results) {
                if (looser.scenario instanceof ScenarioDeleteRestoreInstance) {
                    Command l = looser.command;
                    ArrayList<Command> commands = new ArrayList<Command>();
                    ArrayList<Command> postCommitCommands = new ArrayList<Command>();
                    ArrayList<Command> postErrorCommands = new ArrayList<Command>();
                    commands.add(l);
                    postCommitCommands.addAll(c.getPostCommitCommands());
                    postErrorCommands.addAll(c.getPostErrorCommands());
                    logger.debug((Object)"returning merged high priority executor");
                    return new CompoundCommand(commands, postCommitCommands, postErrorCommands);
                }
                if (!(looser.scenario instanceof ScenarioDeleteOnCloseRenameInstance)) continue;
                CompoundCommand l = (CompoundCommand)looser.command;
                ArrayList<Command> commands = new ArrayList<Command>();
                ArrayList<Command> postCommitCommands = new ArrayList<Command>();
                ArrayList<Command> postErrorCommands = new ArrayList<Command>();
                commands.addAll(c.getCommands());
                postCommitCommands.addAll(c.getPostCommitCommands());
                postCommitCommands.addAll(l.getPostCommitCommands());
                postErrorCommands.addAll(c.getPostErrorCommands());
                logger.debug((Object)"returning merged high priority executor");
                return new CompoundCommand(commands, postCommitCommands, postErrorCommands);
            }
        }
        return command;
    }

    static enum InternalState {
        NONE,
        OPENING,
        OPEN,
        ERROR;

    }
}

