/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jcr.item;

import java.util.List;
import javax.jcr.PathNotFoundException;
import org.alfresco.jcr.item.ItemImpl;
import org.alfresco.jcr.item.NodeImpl;
import org.alfresco.jcr.session.SessionImpl;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.search.SearchService;

public class ItemResolver {
    public static ItemImpl findItem(SessionImpl context, NodeRef from, String path) throws PathNotFoundException {
        NodeImpl item = null;
        NodeRef nodeRef = ItemResolver.getNodeRef(context, from, path);
        if (nodeRef != null) {
            item = new NodeImpl(context, nodeRef);
        }
        if (item == null) {
            throw new PathNotFoundException("Path " + path + " not found.");
        }
        return item;
    }

    public static NodeImpl findNode(SessionImpl context, NodeRef from, String path) throws PathNotFoundException {
        NodeRef nodeRef = ItemResolver.getNodeRef(context, from, path);
        if (nodeRef == null) {
            throw new PathNotFoundException("A node does not exist at path " + path + " relative to node " + from);
        }
        return new NodeImpl(context, nodeRef);
    }

    public static boolean itemExists(SessionImpl context, NodeRef from, String path) {
        boolean exists = ItemResolver.nodeExists(context, from, path);
        if (!exists) {
            // empty if block
        }
        return exists;
    }

    public static boolean nodeExists(SessionImpl context, NodeRef from, String path) {
        NodeRef nodeRef = ItemResolver.getNodeRef(context, from, path);
        return nodeRef != null;
    }

    public static NodeRef getNodeRef(SessionImpl context, NodeRef from, String path) {
        NodeRef nodeRef = null;
        SearchService search = context.getRepositoryImpl().getServiceRegistry().getSearchService();
        List nodeRefs = search.selectNodes(from, path, null, context.getNamespaceResolver(), false);
        if (nodeRefs != null && nodeRefs.size() > 0) {
            nodeRef = (NodeRef)nodeRefs.get(0);
        }
        return nodeRef;
    }
}

