/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jcr.item;

import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ItemVisitor;
import javax.jcr.MergeException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.VersionException;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.jcr.api.JCRNodeRef;
import org.alfresco.jcr.dictionary.ClassMap;
import org.alfresco.jcr.dictionary.NodeDefinitionImpl;
import org.alfresco.jcr.dictionary.NodeTypeImpl;
import org.alfresco.jcr.item.ChildAssocNodeIteratorImpl;
import org.alfresco.jcr.item.ItemImpl;
import org.alfresco.jcr.item.ItemResolver;
import org.alfresco.jcr.item.JCRPath;
import org.alfresco.jcr.item.JCRPatternMatch;
import org.alfresco.jcr.item.LockImpl;
import org.alfresco.jcr.item.PropertyImpl;
import org.alfresco.jcr.item.PropertyListIterator;
import org.alfresco.jcr.item.property.PropertyResolver;
import org.alfresco.jcr.session.SessionImpl;
import org.alfresco.jcr.util.JCRProxyFactory;
import org.alfresco.jcr.version.VersionHistoryImpl;
import org.alfresco.jcr.version.VersionImpl;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.ChildAssociationDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockStatus;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.springframework.extensions.surf.util.ParameterCheck;

public class NodeImpl
extends ItemImpl
implements Node {
    private NodeRef nodeRef;
    private Node proxy = null;

    public NodeImpl(SessionImpl context, NodeRef nodeRef) {
        super(context);
        this.nodeRef = nodeRef;
    }

    public Node getProxy() {
        if (this.proxy == null) {
            this.proxy = (Node)JCRProxyFactory.create(this, Node.class, this.session);
        }
        return this.proxy;
    }

    public Node addNode(String relPath) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        return this.addNode(relPath, null);
    }

    public Node addNode(String relPath, String primaryNodeTypeName) throws ItemExistsException, PathNotFoundException, NoSuchNodeTypeException, LockException, VersionException, ConstraintViolationException, RepositoryException {
        ParameterCheck.mandatoryString((String)"relPath", (String)relPath);
        NodeService nodeService = this.session.getRepositoryImpl().getServiceRegistry().getNodeService();
        DictionaryService dictionaryService = this.session.getRepositoryImpl().getServiceRegistry().getDictionaryService();
        Path path = new JCRPath(this.session.getNamespaceResolver(), relPath).getPath();
        QName nodeName = null;
        NodeRef parentRef = null;
        if (path.size() == 1) {
            parentRef = this.nodeRef;
            nodeName = ((JCRPath.SimpleElement)path.get(0)).getQName();
        } else {
            Path parentPath = path.subPath(path.size() - 2);
            parentRef = ItemResolver.getNodeRef(this.session, this.nodeRef, parentPath.toPrefixString(this.session.getNamespaceResolver()));
            if (parentRef == null) {
                throw new PathNotFoundException("Path '" + relPath + "' does not exist from node " + this.nodeRef);
            }
            nodeName = ((JCRPath.SimpleElement)path.get(path.size() - 1)).getQName();
        }
        if (nodeName.getLocalName().indexOf(91) != -1 || nodeName.getLocalName().indexOf(93) != -1) {
            throw new RepositoryException("Node name '" + nodeName + "' is invalid");
        }
        ChildAssociationDefinition childAssocDef = null;
        QName nodeType = null;
        if (primaryNodeTypeName == null || primaryNodeTypeName.length() == 0) {
            childAssocDef = this.getDefaultChildAssocDefForParent(nodeService, dictionaryService, parentRef);
            nodeType = childAssocDef.getTargetClass().getName();
        } else {
            nodeType = QName.createQName((String)primaryNodeTypeName, (NamespacePrefixResolver)this.session.getNamespaceResolver());
            childAssocDef = this.getNodeTypeChildAssocDefForParent(nodeService, dictionaryService, parentRef, nodeType);
        }
        if (nodeType.equals((Object)ContentModel.TYPE_BASE)) {
            throw new RepositoryException("Node type of node to add is " + nodeType.toPrefixString(this.session.getNamespaceResolver()) + " which is an abstract type");
        }
        ChildAssociationRef childRef = nodeService.createNode(parentRef, childAssocDef.getName(), nodeName, nodeType);
        NodeImpl nodeImpl = new NodeImpl(this.session, childRef.getChildRef());
        return nodeImpl.getProxy();
    }

    private ChildAssociationDefinition getDefaultChildAssocDefForParent(NodeService nodeService, DictionaryService dictionaryService, NodeRef nodeRef) {
        Set aspects;
        QName type = nodeService.getType(nodeRef);
        TypeDefinition classDef = dictionaryService.getAnonymousType(type, (Collection)(aspects = nodeService.getAspects(nodeRef)));
        Map childAssocs = classDef.getChildAssociations();
        if (childAssocs.size() != 1) {
            throw new AlfrescoRuntimeException("Cannot determine node type for child within parent " + nodeRef);
        }
        ChildAssociationDefinition childAssocDef = (ChildAssociationDefinition)childAssocs.values().iterator().next();
        return childAssocDef;
    }

    private ChildAssociationDefinition getNodeTypeChildAssocDefForParent(NodeService nodeService, DictionaryService dictionaryService, NodeRef nodeRef, QName nodeType) {
        QName targetClass;
        ChildAssociationDefinition nodeTypeChildAssocDef = null;
        QName type = nodeService.getType(nodeRef);
        Set aspects = nodeService.getAspects(nodeRef);
        TypeDefinition classDef = dictionaryService.getAnonymousType(type, (Collection)aspects);
        Map childAssocs = classDef.getChildAssociations();
        for (ChildAssociationDefinition childAssocDef : childAssocs.values()) {
            targetClass = childAssocDef.getTargetClass().getName();
            if (!nodeType.equals((Object)targetClass)) continue;
            nodeTypeChildAssocDef = childAssocDef;
            break;
        }
        if (nodeTypeChildAssocDef == null) {
            for (ChildAssociationDefinition childAssocDef : childAssocs.values()) {
                targetClass = childAssocDef.getTargetClass().getName();
                if (!dictionaryService.isSubClass(nodeType, targetClass)) continue;
                if (childAssocDef.getSourceClass().getName().equals((Object)type)) {
                    nodeTypeChildAssocDef = childAssocDef;
                    break;
                }
                if (nodeTypeChildAssocDef != null) {
                    throw new AlfrescoRuntimeException("Cannot determine child association for node type '" + nodeType + " within parent " + nodeRef);
                }
                nodeTypeChildAssocDef = childAssocDef;
            }
        }
        if (nodeTypeChildAssocDef == null) {
            throw new AlfrescoRuntimeException("Cannot determine child association for node type '" + nodeType + " within parent " + nodeRef);
        }
        return nodeTypeChildAssocDef;
    }

    public void remove() throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        NodeService nodeService = this.session.getRepositoryImpl().getServiceRegistry().getNodeService();
        ChildAssociationRef assocRef = nodeService.getPrimaryParent(this.nodeRef);
        NodeRef parentRef = assocRef.getParentRef();
        if (parentRef == null) {
            throw new ConstraintViolationException("Cannot remove the root node");
        }
        nodeService.removeChild(parentRef, this.nodeRef);
    }

    public void orderBefore(String srcChildRelPath, String destChildRelPath) throws UnsupportedRepositoryOperationException, VersionException, ConstraintViolationException, ItemNotFoundException, LockException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public Property setProperty(String name, Value value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        QName propertyName = QName.createQName((String)name, (NamespacePrefixResolver)this.session.getNamespaceResolver());
        PropertyImpl property = new PropertyImpl(this, propertyName);
        property.setPropertyValue(value, -1);
        return value == null ? null : property;
    }

    public Property setProperty(String name, Value value, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        QName propertyName = QName.createQName((String)name, (NamespacePrefixResolver)this.session.getNamespaceResolver());
        PropertyImpl property = new PropertyImpl(this, propertyName);
        property.setPropertyValue(value, type);
        return value == null ? null : property;
    }

    public Property setProperty(String name, Value[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        QName propertyName = QName.createQName((String)name, (NamespacePrefixResolver)this.session.getNamespaceResolver());
        PropertyImpl property = new PropertyImpl(this, propertyName);
        property.setPropertyValue(values, -1);
        return values == null ? null : property;
    }

    public Property setProperty(String name, Value[] values, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        QName propertyName = QName.createQName((String)name, (NamespacePrefixResolver)this.session.getNamespaceResolver());
        PropertyImpl property = new PropertyImpl(this, propertyName);
        property.setPropertyValue(values, type);
        return values == null ? null : property;
    }

    public Property setProperty(String name, String[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        QName propertyName = QName.createQName((String)name, (NamespacePrefixResolver)this.session.getNamespaceResolver());
        PropertyImpl property = new PropertyImpl(this, propertyName);
        property.setPropertyValue(values, -1);
        return values == null ? null : property;
    }

    public Property setProperty(String name, String[] values, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        QName propertyName = QName.createQName((String)name, (NamespacePrefixResolver)this.session.getNamespaceResolver());
        PropertyImpl property = new PropertyImpl(this, propertyName);
        property.setPropertyValue(values, type);
        return values == null ? null : property;
    }

    public Property setProperty(String name, String value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        QName propertyName = QName.createQName((String)name, (NamespacePrefixResolver)this.session.getNamespaceResolver());
        PropertyImpl property = new PropertyImpl(this, propertyName);
        property.setPropertyValue(value, -1);
        return value == null ? null : property;
    }

    public Property setProperty(String name, String value, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        QName propertyName = QName.createQName((String)name, (NamespacePrefixResolver)this.session.getNamespaceResolver());
        PropertyImpl property = new PropertyImpl(this, propertyName);
        property.setPropertyValue(value, type);
        return value == null ? null : property;
    }

    public Property setProperty(String name, InputStream value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        QName propertyName = QName.createQName((String)name, (NamespacePrefixResolver)this.session.getNamespaceResolver());
        PropertyImpl property = new PropertyImpl(this, propertyName);
        property.setPropertyValue(value, -1);
        return value == null ? null : property;
    }

    public Property setProperty(String name, boolean value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        QName propertyName = QName.createQName((String)name, (NamespacePrefixResolver)this.session.getNamespaceResolver());
        PropertyImpl property = new PropertyImpl(this, propertyName);
        property.setPropertyValue(value, -1);
        return property;
    }

    public Property setProperty(String name, double value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        QName propertyName = QName.createQName((String)name, (NamespacePrefixResolver)this.session.getNamespaceResolver());
        PropertyImpl property = new PropertyImpl(this, propertyName);
        property.setPropertyValue(value, -1);
        return property;
    }

    public Property setProperty(String name, long value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        QName propertyName = QName.createQName((String)name, (NamespacePrefixResolver)this.session.getNamespaceResolver());
        PropertyImpl property = new PropertyImpl(this, propertyName);
        property.setPropertyValue(value, -1);
        return property;
    }

    public Property setProperty(String name, Calendar value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        QName propertyName = QName.createQName((String)name, (NamespacePrefixResolver)this.session.getNamespaceResolver());
        PropertyImpl property = new PropertyImpl(this, propertyName);
        property.setPropertyValue(value == null ? null : value.getTime(), -1);
        return value == null ? null : property;
    }

    public Property setProperty(String name, Node value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        QName propertyName = QName.createQName((String)name, (NamespacePrefixResolver)this.session.getNamespaceResolver());
        PropertyImpl property = new PropertyImpl(this, propertyName);
        property.setPropertyValue(value == null ? null : JCRNodeRef.getNodeRef(value), -1);
        return value == null ? null : property;
    }

    public Node getNode(String relPath) throws PathNotFoundException, RepositoryException {
        NodeImpl nodeImpl = ItemResolver.findNode(this.session, this.nodeRef, relPath);
        return nodeImpl.getProxy();
    }

    public NodeIterator getNodes() throws RepositoryException {
        NodeService nodeService = this.session.getRepositoryImpl().getServiceRegistry().getNodeService();
        List childAssocs = nodeService.getChildAssocs(this.nodeRef);
        ChildAssocNodeIteratorImpl iterator = new ChildAssocNodeIteratorImpl(this.session, childAssocs);
        return iterator;
    }

    public NodeIterator getNodes(String namePattern) throws RepositoryException {
        NodeService nodeService = this.session.getRepositoryImpl().getServiceRegistry().getNodeService();
        JCRPatternMatch match = new JCRPatternMatch(namePattern, this.session.getNamespaceResolver());
        List childAssocs = nodeService.getChildAssocs(this.nodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)match);
        ChildAssocNodeIteratorImpl iterator = new ChildAssocNodeIteratorImpl(this.session, childAssocs);
        return iterator;
    }

    public Property getProperty(String relPath) throws PathNotFoundException, RepositoryException {
        JCRPath jcrPath = new JCRPath(this.session.getNamespaceResolver(), relPath);
        Path path = jcrPath.getPath();
        if (path.size() == 1) {
            QName propertyName = ((JCRPath.SimpleElement)path.get(0)).getQName();
            return PropertyResolver.createProperty(this, propertyName).getProxy();
        }
        ItemImpl itemImpl = ItemResolver.findItem(this.session, this.nodeRef, relPath);
        if (itemImpl == null || !(itemImpl instanceof PropertyImpl)) {
            throw new PathNotFoundException("Property path " + relPath + " not found from node " + this.nodeRef);
        }
        return ((PropertyImpl)itemImpl).getProxy();
    }

    public PropertyIterator getProperties() throws RepositoryException {
        List<PropertyImpl> properties = PropertyResolver.createProperties(this, null);
        PropertyListIterator iterator = new PropertyListIterator(properties);
        return iterator;
    }

    public PropertyIterator getProperties(String namePattern) throws RepositoryException {
        JCRPatternMatch match = new JCRPatternMatch(namePattern, this.session.getNamespaceResolver());
        List<PropertyImpl> properties = PropertyResolver.createProperties(this, match);
        PropertyListIterator iterator = new PropertyListIterator(properties);
        return iterator;
    }

    public Item getPrimaryItem() throws ItemNotFoundException, RepositoryException {
        throw new ItemNotFoundException();
    }

    public String getUUID() throws UnsupportedRepositoryOperationException, RepositoryException {
        return this.nodeRef.getId();
    }

    public int getIndex() throws RepositoryException {
        int index = 1;
        String name = this.getName();
        if (name != null) {
            NodeRef sibling;
            SearchService searchService = this.session.getRepositoryImpl().getServiceRegistry().getSearchService();
            List siblings = searchService.selectNodes(this.nodeRef, "../" + name, null, this.session.getNamespaceResolver(), false);
            Iterator i$ = siblings.iterator();
            while (i$.hasNext() && !(sibling = (NodeRef)i$.next()).equals((Object)this.nodeRef)) {
                ++index;
            }
        }
        return index;
    }

    public PropertyIterator getReferences() throws RepositoryException {
        return new PropertyListIterator(new ArrayList<PropertyImpl>());
    }

    public boolean hasNode(String relPath) throws RepositoryException {
        return ItemResolver.nodeExists(this.session, this.nodeRef, relPath);
    }

    public boolean hasProperty(String relPath) throws RepositoryException {
        JCRPath jcrPath = new JCRPath(this.session.getNamespaceResolver(), relPath);
        Path path = jcrPath.getPath();
        if (path.size() == 1) {
            QName propertyName = ((JCRPath.SimpleElement)path.get(0)).getQName();
            return PropertyResolver.hasProperty(this, propertyName);
        }
        return ItemResolver.itemExists(this.session, this.nodeRef, relPath);
    }

    public boolean hasNodes() throws RepositoryException {
        NodeService nodeService = this.session.getRepositoryImpl().getServiceRegistry().getNodeService();
        List childAssocs = nodeService.getChildAssocs(this.nodeRef);
        return childAssocs.size() > 0;
    }

    public boolean hasProperties() throws RepositoryException {
        return true;
    }

    public NodeType getPrimaryNodeType() throws RepositoryException {
        NodeService nodeService = this.session.getRepositoryImpl().getServiceRegistry().getNodeService();
        QName type = nodeService.getType(this.nodeRef);
        return this.session.getTypeManager().getNodeTypeImpl(type);
    }

    public NodeType[] getMixinNodeTypes() throws RepositoryException {
        NodeService nodeService = this.session.getRepositoryImpl().getServiceRegistry().getNodeService();
        Set aspects = nodeService.getAspects(this.nodeRef);
        NodeType[] nodeTypes = new NodeType[aspects.size() + 1];
        int i = 0;
        for (QName aspect : aspects) {
            nodeTypes[i++] = this.session.getTypeManager().getNodeTypeImpl(aspect);
            QName mixin = ClassMap.convertClassToType(aspect);
            if (mixin == null) continue;
            nodeTypes[i++] = this.session.getTypeManager().getNodeTypeImpl(mixin);
        }
        return nodeTypes;
    }

    public boolean isNodeType(String nodeTypeName) throws RepositoryException {
        QName type;
        QName nodeType = QName.createQName((String)nodeTypeName, (NamespacePrefixResolver)this.session.getNamespaceResolver());
        if (nodeType.equals((Object)NodeTypeImpl.MIX_REFERENCEABLE) || nodeType.equals((Object)NodeTypeImpl.NT_BASE)) {
            return true;
        }
        QName nodeClass = ClassMap.convertTypeToClass(nodeType);
        if (nodeClass == null) {
            nodeClass = nodeType;
        }
        NodeService nodeService = this.session.getRepositoryImpl().getServiceRegistry().getNodeService();
        DictionaryService dictionaryService = this.session.getRepositoryImpl().getServiceRegistry().getDictionaryService();
        if (dictionaryService.isSubClass(nodeClass, type = nodeService.getType(this.nodeRef))) {
            return true;
        }
        Set aspects = nodeService.getAspects(this.nodeRef);
        for (QName aspect : aspects) {
            if (!dictionaryService.isSubClass(nodeClass, aspect)) continue;
            return true;
        }
        return false;
    }

    public void addMixin(String mixinName) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        DictionaryService dictionaryService;
        AspectDefinition aspectDef;
        QName mixin = QName.createQName((String)mixinName, (NamespacePrefixResolver)this.session.getNamespaceResolver());
        QName aspect = ClassMap.convertTypeToClass(mixin);
        if (aspect == null) {
            aspect = mixin;
        }
        if ((aspectDef = (dictionaryService = this.session.getRepositoryImpl().getServiceRegistry().getDictionaryService()).getAspect(aspect)) == null) {
            throw new NoSuchNodeTypeException("Unknown mixin name '" + mixinName + "'");
        }
        ClassMap.AddMixin addMixin = ClassMap.getAddMixin(aspect);
        Map<QName, Serializable> initialProperties = addMixin.preAddMixin(this.session, this.nodeRef);
        NodeService nodeService = this.session.getRepositoryImpl().getServiceRegistry().getNodeService();
        nodeService.addAspect(this.nodeRef, aspect, initialProperties);
        addMixin.postAddMixin(this.session, this.nodeRef);
    }

    public void removeMixin(String mixinName) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        DictionaryService dictionaryService;
        AspectDefinition aspectDef;
        QName mixin = QName.createQName((String)mixinName, (NamespacePrefixResolver)this.session.getNamespaceResolver());
        QName aspect = ClassMap.convertTypeToClass(mixin);
        if (aspect == null) {
            aspect = mixin;
        }
        if ((aspectDef = (dictionaryService = this.session.getRepositoryImpl().getServiceRegistry().getDictionaryService()).getAspect(aspect)) == null) {
            throw new NoSuchNodeTypeException("Unknown mixin name '" + mixinName + "'");
        }
        NodeService nodeService = this.session.getRepositoryImpl().getServiceRegistry().getNodeService();
        Set nodeAspects = nodeService.getAspects(this.nodeRef);
        if (!nodeAspects.contains(aspect)) {
            throw new NoSuchNodeTypeException("Node " + this.nodeRef.getId() + " does not have the mixin " + mixin);
        }
        ClassMap.RemoveMixin removeMixin = ClassMap.getRemoveMixin(aspect);
        removeMixin.preRemoveMixin(this.session, this.nodeRef);
        nodeService.removeAspect(this.nodeRef, aspect);
        removeMixin.postRemoveMixin(this.session, this.nodeRef);
    }

    public boolean canAddMixin(String mixinName) throws NoSuchNodeTypeException, RepositoryException {
        DictionaryService dictionaryService;
        AspectDefinition aspectDef;
        QName mixin = QName.createQName((String)mixinName, (NamespacePrefixResolver)this.session.getNamespaceResolver());
        QName aspect = ClassMap.convertTypeToClass(mixin);
        if (aspect == null) {
            aspect = mixin;
        }
        if ((aspectDef = (dictionaryService = this.session.getRepositoryImpl().getServiceRegistry().getDictionaryService()).getAspect(aspect)) == null) {
            throw new NoSuchNodeTypeException("Unknown mixin name '" + mixinName + "'");
        }
        LockService lockService = this.session.getRepositoryImpl().getServiceRegistry().getLockService();
        LockStatus lockStatus = lockService.getLockStatus(this.nodeRef);
        return lockStatus != LockStatus.LOCKED;
    }

    public NodeDefinition getDefinition() throws RepositoryException {
        NodeService nodeService = this.session.getRepositoryImpl().getServiceRegistry().getNodeService();
        DictionaryService dictionaryService = this.session.getRepositoryImpl().getServiceRegistry().getDictionaryService();
        ChildAssociationRef childAssocRef = nodeService.getPrimaryParent(this.nodeRef);
        ChildAssociationDefinition childAssocDef = (ChildAssociationDefinition)dictionaryService.getAssociation(childAssocRef.getTypeQName());
        NodeDefinitionImpl nodeDef = new NodeDefinitionImpl(this.session.getTypeManager(), childAssocDef);
        return nodeDef;
    }

    public javax.jcr.version.Version checkin() throws VersionException, UnsupportedRepositoryOperationException, InvalidItemStateException, LockException, RepositoryException {
        NodeService nodeService = this.session.getRepositoryImpl().getServiceRegistry().getNodeService();
        if (!nodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE)) {
            throw new UnsupportedRepositoryOperationException("Node " + this.nodeRef + " is not versionable");
        }
        javax.jcr.version.Version version = null;
        if (!this.isCheckedOut()) {
            version = this.getBaseVersion();
        } else {
            VersionService versionService = this.session.getRepositoryImpl().getServiceRegistry().getVersionService();
            Version versionNode = versionService.createVersion(this.nodeRef, null);
            VersionHistory versionHistory = versionService.getVersionHistory(this.nodeRef);
            version = new VersionImpl(new VersionHistoryImpl(this.session, versionHistory), versionNode).getProxy();
            LockService lockService = this.session.getRepositoryImpl().getServiceRegistry().getLockService();
            lockService.lock(this.nodeRef, LockType.READ_ONLY_LOCK);
        }
        return version;
    }

    public void checkout() throws UnsupportedRepositoryOperationException, LockException, RepositoryException {
        NodeService nodeService = this.session.getRepositoryImpl().getServiceRegistry().getNodeService();
        if (!nodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE)) {
            throw new UnsupportedRepositoryOperationException("Node " + this.nodeRef + " is not versionable");
        }
        if (!this.isCheckedOut()) {
            LockService lockService = this.session.getRepositoryImpl().getServiceRegistry().getLockService();
            lockService.unlock(this.nodeRef);
        }
    }

    public void doneMerge(javax.jcr.version.Version version) throws VersionException, InvalidItemStateException, UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void cancelMerge(javax.jcr.version.Version version) throws VersionException, InvalidItemStateException, UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void update(String srcWorkspaceName) throws NoSuchWorkspaceException, AccessDeniedException, LockException, InvalidItemStateException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public NodeIterator merge(String srcWorkspace, boolean bestEffort) throws NoSuchWorkspaceException, AccessDeniedException, MergeException, LockException, InvalidItemStateException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public String getCorrespondingNodePath(String workspaceName) throws ItemNotFoundException, NoSuchWorkspaceException, AccessDeniedException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public boolean isCheckedOut() throws RepositoryException {
        NodeService nodeService = this.session.getRepositoryImpl().getServiceRegistry().getNodeService();
        if (!nodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE)) {
            return true;
        }
        LockService lockService = this.session.getRepositoryImpl().getServiceRegistry().getLockService();
        LockType lockType = lockService.getLockType(this.nodeRef);
        if (lockType == null) {
            return true;
        }
        return !lockType.equals((Object)LockType.READ_ONLY_LOCK);
    }

    public void restore(String versionName, boolean removeExisting) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        NodeService nodeService = this.session.getRepositoryImpl().getServiceRegistry().getNodeService();
        if (!nodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE)) {
            throw new UnsupportedRepositoryOperationException("Node " + this.nodeRef + " is not versionable");
        }
        VersionService versionService = this.session.getRepositoryImpl().getServiceRegistry().getVersionService();
        VersionHistory versionHistory = versionService.getVersionHistory(this.nodeRef);
        Version version = versionHistory.getVersion(versionName);
        if (version == null) {
            throw new VersionException("Version name " + versionName + " does not exist in the version history of node " + this.nodeRef);
        }
        LockService lockService = this.session.getRepositoryImpl().getServiceRegistry().getLockService();
        LockType lockType = lockService.getLockType(this.nodeRef);
        if (lockType != null) {
            lockService.unlock(this.nodeRef);
        }
        versionService.revert(this.nodeRef, version);
        lockService.lock(this.nodeRef, LockType.READ_ONLY_LOCK);
    }

    public void restore(javax.jcr.version.Version version, boolean removeExisting) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, RepositoryException {
        this.restore(version.getName(), removeExisting);
    }

    public void restore(javax.jcr.version.Version version, String relPath, boolean removeExisting) throws PathNotFoundException, ItemExistsException, VersionException, ConstraintViolationException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void restoreByLabel(String versionLabel, boolean removeExisting) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public javax.jcr.version.VersionHistory getVersionHistory() throws UnsupportedRepositoryOperationException, RepositoryException {
        NodeService nodeService = this.session.getRepositoryImpl().getServiceRegistry().getNodeService();
        if (!nodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE)) {
            throw new UnsupportedRepositoryOperationException("Node " + this.nodeRef + " is not versionable");
        }
        VersionService versionService = this.session.getRepositoryImpl().getServiceRegistry().getVersionService();
        VersionHistory versionHistory = versionService.getVersionHistory(this.nodeRef);
        return new VersionHistoryImpl(this.session, versionHistory).getProxy();
    }

    public javax.jcr.version.Version getBaseVersion() throws UnsupportedRepositoryOperationException, RepositoryException {
        NodeService nodeService = this.session.getRepositoryImpl().getServiceRegistry().getNodeService();
        if (!nodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE)) {
            throw new UnsupportedRepositoryOperationException("Node " + this.nodeRef + " is not versionable");
        }
        VersionService versionService = this.session.getRepositoryImpl().getServiceRegistry().getVersionService();
        VersionHistory versionHistory = versionService.getVersionHistory(this.nodeRef);
        Version version = null;
        if (versionHistory != null) {
            String versionLabel = (String)((Object)nodeService.getProperty(this.nodeRef, ContentModel.PROP_VERSION_LABEL));
            version = versionHistory.getVersion(versionLabel);
        }
        return new VersionImpl(new VersionHistoryImpl(this.session, versionHistory), version).getProxy();
    }

    public Lock lock(boolean isDeep, boolean isSessionScoped) throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        if (isSessionScoped) {
            throw new UnsupportedRepositoryOperationException("Session scope locking is not supported.");
        }
        NodeService nodeService = this.session.getRepositoryImpl().getServiceRegistry().getNodeService();
        if (!nodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_LOCKABLE)) {
            throw new LockException("Node " + this.nodeRef + " does is not lockable.");
        }
        LockService lockService = this.session.getRepositoryImpl().getServiceRegistry().getLockService();
        lockService.lock(this.nodeRef, LockType.WRITE_LOCK, 0, isDeep);
        return new LockImpl(this).getProxy();
    }

    public Lock getLock() throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, RepositoryException {
        NodeService nodeService = this.session.getRepositoryImpl().getServiceRegistry().getNodeService();
        if (!nodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_LOCKABLE)) {
            throw new LockException("Node " + this.nodeRef + " does is not lockable.");
        }
        return new LockImpl(this).getProxy();
    }

    public void unlock() throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        NodeService nodeService = this.session.getRepositoryImpl().getServiceRegistry().getNodeService();
        if (!nodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_LOCKABLE)) {
            throw new LockException("Node " + this.nodeRef + " does is not lockable.");
        }
        LockService lockService = this.session.getRepositoryImpl().getServiceRegistry().getLockService();
        lockService.unlock(this.nodeRef, true);
    }

    public boolean holdsLock() throws RepositoryException {
        return this.isLocked();
    }

    public boolean isLocked() throws RepositoryException {
        LockService lockService = this.session.getRepositoryImpl().getServiceRegistry().getLockService();
        LockStatus lockStatus = lockService.getLockStatus(this.getNodeRef());
        return lockStatus.equals((Object)LockStatus.LOCK_OWNER) || lockStatus.equals((Object)LockStatus.LOCKED);
    }

    public String getName() throws RepositoryException {
        NodeService nodeService = this.session.getRepositoryImpl().getServiceRegistry().getNodeService();
        ChildAssociationRef parentAssoc = nodeService.getPrimaryParent(this.nodeRef);
        QName childName = parentAssoc.getQName();
        return childName == null ? "" : childName.toPrefixString(this.session.getNamespaceResolver());
    }

    public boolean isNode() {
        return true;
    }

    public Node getParent() throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        NodeService nodeService = this.session.getRepositoryImpl().getServiceRegistry().getNodeService();
        ChildAssociationRef parentAssoc = nodeService.getPrimaryParent(this.nodeRef);
        if (parentAssoc == null || parentAssoc.getParentRef() == null) {
            throw new ItemNotFoundException("Parent of node " + this.nodeRef + " does not exist.");
        }
        NodeImpl nodeImpl = new NodeImpl(this.session, parentAssoc.getParentRef());
        return nodeImpl.getProxy();
    }

    public String getPath() throws RepositoryException {
        NodeService nodeService = this.session.getRepositoryImpl().getServiceRegistry().getNodeService();
        SearchService searchService = this.session.getRepositoryImpl().getServiceRegistry().getSearchService();
        Path path = nodeService.getPath(this.nodeRef);
        block0: for (int i = path.size() - 1; i >= 0; --i) {
            Path.Element pathElement = path.get(i);
            if (i <= 0 || !(pathElement instanceof Path.ChildAssocElement)) continue;
            int index = 1;
            String searchPath = path.subPath(i).toPrefixString(this.session.getNamespaceResolver());
            List siblings = searchService.selectNodes(this.nodeRef, searchPath, null, this.session.getNamespaceResolver(), false);
            if (siblings.size() <= 1) continue;
            ChildAssociationRef childAssoc = ((Path.ChildAssocElement)pathElement).getRef();
            NodeRef childRef = childAssoc.getChildRef();
            for (NodeRef sibling : siblings) {
                if (sibling.equals((Object)childRef)) {
                    childAssoc.setNthSibling(index);
                    continue block0;
                }
                ++index;
            }
        }
        return path.toPrefixString(this.session.getNamespaceResolver());
    }

    public int getDepth() throws RepositoryException {
        NodeService nodeService = this.session.getRepositoryImpl().getServiceRegistry().getNodeService();
        Path path = nodeService.getPath(this.nodeRef);
        return path.size() - 1;
    }

    public Item getAncestor(int depth) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        NodeService nodeService = this.session.getRepositoryImpl().getServiceRegistry().getNodeService();
        Path path = nodeService.getPath(this.nodeRef);
        if (depth < 0 || depth > path.size() - 1) {
            throw new ItemNotFoundException("Ancestor at depth " + depth + " not found for node " + this.nodeRef);
        }
        Path.Element element = path.get(depth);
        if (!(element instanceof Path.ChildAssocElement)) {
            throw new RepositoryException("Path element at depth " + depth + " is not a node");
        }
        Path.ChildAssocElement childAssocElement = (Path.ChildAssocElement)element;
        NodeRef ancestorNodeRef = childAssocElement.getRef().getChildRef();
        NodeImpl nodeImpl = new NodeImpl(this.session, ancestorNodeRef);
        return nodeImpl.getProxy();
    }

    public boolean isSame(Item otherItem) throws RepositoryException {
        return this.getProxy().equals(otherItem);
    }

    public void accept(ItemVisitor visitor) throws RepositoryException {
        visitor.visit(this.getProxy());
    }

    public NodeRef getNodeRef() {
        return this.nodeRef;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof NodeImpl)) {
            return false;
        }
        NodeImpl other = (NodeImpl)obj;
        return this.nodeRef.equals((Object)other.nodeRef);
    }

    public int hashCode() {
        return this.nodeRef.hashCode();
    }
}

