/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jcr.item.property;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.PathNotFoundException;
import org.alfresco.jcr.item.NodeImpl;
import org.alfresco.jcr.item.PropertyImpl;
import org.alfresco.jcr.item.property.JCRLockIsDeepProperty;
import org.alfresco.jcr.item.property.JCRLockOwnerProperty;
import org.alfresco.jcr.item.property.JCRMixinTypesProperty;
import org.alfresco.jcr.item.property.JCRPrimaryTypeProperty;
import org.alfresco.jcr.item.property.JCRUUIDProperty;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;

public class PropertyResolver {
    private static Map<QName, QName> virtualProperties = new HashMap<QName, QName>();

    public static List<PropertyImpl> createProperties(NodeImpl node, QNamePattern pattern) {
        NodeService nodeService = node.getSessionImpl().getRepositoryImpl().getServiceRegistry().getNodeService();
        Map properties = nodeService.getProperties(node.getNodeRef());
        ArrayList<PropertyImpl> propertyList = new ArrayList<PropertyImpl>(properties.size());
        for (Map.Entry entry : properties.entrySet()) {
            Serializable value;
            QName propertyName = (QName)entry.getKey();
            if (pattern != null && !pattern.isMatch(propertyName) || (value = (Serializable)entry.getValue()) == null) continue;
            PropertyImpl property = new PropertyImpl(node, propertyName);
            propertyList.add(property);
        }
        for (Map.Entry<Object, Object> entry : virtualProperties.entrySet()) {
            boolean addJCRProperty = false;
            addJCRProperty = entry.getValue() == null ? true : nodeService.hasAspect(node.getNodeRef(), (QName)entry.getValue());
            if (!addJCRProperty || pattern != null && !pattern.isMatch((QName)entry.getKey())) continue;
            propertyList.add(PropertyResolver.createVirtualProperty(node, (QName)entry.getKey()));
        }
        return propertyList;
    }

    public static PropertyImpl createProperty(NodeImpl node, QName propertyName) throws PathNotFoundException {
        if (PropertyResolver.hasVirtualProperty(node, propertyName)) {
            return PropertyResolver.createVirtualProperty(node, propertyName);
        }
        NodeService nodeService = node.getSessionImpl().getRepositoryImpl().getServiceRegistry().getNodeService();
        Serializable value = nodeService.getProperty(node.getNodeRef(), propertyName);
        if (value == null) {
            throw new PathNotFoundException("Property path " + propertyName + " not found from node " + node.getNodeRef());
        }
        PropertyImpl propertyImpl = new PropertyImpl(node, propertyName);
        return propertyImpl;
    }

    private static PropertyImpl createVirtualProperty(NodeImpl node, QName propertyName) {
        if (propertyName.equals((Object)JCRUUIDProperty.PROPERTY_NAME)) {
            return new JCRUUIDProperty(node);
        }
        if (propertyName.equals((Object)JCRPrimaryTypeProperty.PROPERTY_NAME)) {
            return new JCRPrimaryTypeProperty(node);
        }
        if (propertyName.equals((Object)JCRMixinTypesProperty.PROPERTY_NAME)) {
            return new JCRMixinTypesProperty(node);
        }
        if (propertyName.equals((Object)JCRLockOwnerProperty.PROPERTY_NAME)) {
            return new JCRLockOwnerProperty(node);
        }
        if (propertyName.equals((Object)JCRLockIsDeepProperty.PROPERTY_NAME)) {
            return new JCRLockIsDeepProperty(node);
        }
        return null;
    }

    public static boolean hasProperty(NodeImpl node, QName propertyName) {
        if (PropertyResolver.hasVirtualProperty(node, propertyName)) {
            return true;
        }
        NodeService nodeService = node.getSessionImpl().getRepositoryImpl().getServiceRegistry().getNodeService();
        Serializable value = nodeService.getProperty(node.getNodeRef(), propertyName);
        return value != null;
    }

    private static boolean hasVirtualProperty(NodeImpl node, QName propertyName) {
        if (virtualProperties.containsKey(propertyName)) {
            QName aspect = virtualProperties.get(propertyName);
            if (aspect == null) {
                return true;
            }
            NodeService nodeService = node.getSessionImpl().getRepositoryImpl().getServiceRegistry().getNodeService();
            return nodeService.hasAspect(node.getNodeRef(), aspect);
        }
        return false;
    }

    static {
        virtualProperties.put(JCRUUIDProperty.PROPERTY_NAME, null);
        virtualProperties.put(JCRPrimaryTypeProperty.PROPERTY_NAME, null);
        virtualProperties.put(JCRMixinTypesProperty.PROPERTY_NAME, null);
        virtualProperties.put(JCRLockOwnerProperty.PROPERTY_NAME, ContentModel.ASPECT_LOCKABLE);
        virtualProperties.put(JCRLockIsDeepProperty.PROPERTY_NAME, ContentModel.ASPECT_LOCKABLE);
    }
}

