/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jcr.query;

import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.alfresco.jcr.test.BaseJCRTest;

public class QueryManagerImplTest
extends BaseJCRTest {
    protected Session superuserSession;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        SimpleCredentials superuser = new SimpleCredentials("superuser", "".toCharArray());
        this.superuserSession = this.repository.login((Credentials)superuser, this.getWorkspace());
    }

    protected void tearDown() throws Exception {
        this.superuserSession.logout();
        super.tearDown();
    }

    public void testQuery() throws Exception {
        QueryManager queryMgr = this.superuserSession.getWorkspace().getQueryManager();
        String[] languages = queryMgr.getSupportedQueryLanguages();
        QueryManagerImplTest.assertEquals((int)1, (int)languages.length);
        QueryManagerImplTest.assertEquals((String)"xpath", (String)languages[0]);
        Query query = queryMgr.createQuery("//*", "xpath");
        QueryResult result = query.execute();
        String[] columnNames = result.getColumnNames();
        int rowCnt = 0;
        RowIterator rowIterator = result.getRows();
        while (rowIterator.hasNext()) {
            Row row = rowIterator.nextRow();
            for (String columnName : columnNames) {
                Value value = row.getValue(columnName);
                if (value == null) continue;
                String strValue = value.getString();
                QueryManagerImplTest.assertNotNull((Object)strValue);
            }
            ++rowCnt;
        }
        int nodeCnt = 0;
        NodeIterator nodeIterator = result.getNodes();
        while (nodeIterator.hasNext()) {
            Node node = nodeIterator.nextNode();
            Property property = node.getProperty("sys:node-uuid");
            Value value = property.getValue();
            String uuid = value.getString();
            QueryManagerImplTest.assertNotNull((Object)uuid);
            ++nodeCnt;
        }
        QueryManagerImplTest.assertEquals((int)rowCnt, (int)nodeCnt);
    }
}

