/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sf.acegisecurity.Authentication;
import org.alfresco.cmis.CMISInvalidArgumentException;
import org.alfresco.model.ContentModel;
import org.alfresco.opencmis.AlfrescoCmisService;
import org.alfresco.opencmis.CMISConnector;
import org.alfresco.opencmis.CMISNodeInfoImpl;
import org.alfresco.opencmis.dictionary.CMISNodeInfo;
import org.alfresco.opencmis.dictionary.CMISObjectVariant;
import org.alfresco.opencmis.dictionary.FolderTypeDefintionWrapper;
import org.alfresco.opencmis.dictionary.PropertyDefinitionWrapper;
import org.alfresco.opencmis.dictionary.TypeDefinitionWrapper;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.content.encoding.ContentCharsetFinder;
import org.alfresco.repo.node.getchildren.GetChildrenCannedQuery;
import org.alfresco.repo.search.QueryParameterDefImpl;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.Authorization;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.search.QueryParameterDefinition;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.cmr.version.VersionType;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.Pair;
import org.alfresco.util.TempFileProvider;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.FailedToDeleteData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderContainer;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderList;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.ObjectParentData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.DocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.ContentStreamAllowed;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.RelationshipDirection;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisContentAlreadyExistsException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStorageException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStreamNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisVersioningException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.FailedToDeleteDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectInFolderContainerImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectInFolderDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectInFolderListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectParentDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.TypeDefinitionContainerImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.TypeDefinitionListImpl;
import org.apache.chemistry.opencmis.commons.impl.server.AbstractCmisService;
import org.apache.chemistry.opencmis.commons.impl.server.ObjectInfoImpl;
import org.apache.chemistry.opencmis.commons.impl.server.RenditionInfoImpl;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.ObjectInfo;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AlfrescoCmisServiceImpl
extends AbstractCmisService
implements AlfrescoCmisService {
    private static Log logger = LogFactory.getLog(AlfrescoCmisService.class);
    private static final QName PARAM_PARENT = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"parent");
    private static final QName PARAM_USERNAME = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"username");
    private static final String LUCENE_QUERY_CHECKEDOUT = "+@cm\\:workingCopyOwner:${cm:username}";
    private static final String LUCENE_QUERY_CHECKEDOUT_IN_FOLDER = "+@cm\\:workingCopyOwner:${cm:username} +PARENT:\"${cm:parent}\"";
    private static final String MIN_FILTER = "cmis:name,cmis:baseTypeId,cmis:objectTypeId,cmis:createdBy,cmis:creationDate,cmis:lastModifiedBy,cmis:lastModificationDate,cmis:contentStreamLength,cmis:contentStreamMimeType,cmis:contentStreamFileName,cmis:contentStreamId";
    private CMISConnector connector;
    private CallContext context;
    private Authentication authentication;
    private Map<String, CMISNodeInfo> nodeInfoMap;
    private Map<String, ObjectInfo> objectInfoMap;

    public AlfrescoCmisServiceImpl(CMISConnector connector) {
        this.connector = connector;
        this.nodeInfoMap = new HashMap<String, CMISNodeInfo>();
        this.objectInfoMap = new HashMap<String, ObjectInfo>();
    }

    @Override
    public void beforeCall() {
        AuthenticationUtil.pushAuthentication();
        if (this.authentication != null) {
            AuthenticationUtil.setFullAuthentication((Authentication)this.authentication);
        } else {
            if (this.context == null) {
                return;
            }
            if (this.connector.openHttpSession()) {
                ((HttpServletRequest)this.context.get("httpServletRequest")).getSession();
            }
            if (this.authentication != null) {
                AuthenticationUtil.setFullAuthentication((Authentication)this.authentication);
            } else {
                String password;
                String user = this.context.getUsername();
                Authorization auth = new Authorization(user, password = this.context.getPassword());
                if (auth.isTicket()) {
                    this.connector.getAuthenticationService().validate(auth.getTicket());
                } else {
                    this.connector.getAuthenticationService().authenticate(auth.getUserName(), auth.getPasswordCharArray());
                }
                this.authentication = AuthenticationUtil.getFullAuthentication();
            }
        }
    }

    @Override
    public void afterCall() {
        AuthenticationUtil.popAuthentication();
    }

    @Override
    public void open(CallContext context) {
        this.context = context;
    }

    public void close() {
        this.context = null;
        this.authentication = null;
        this.nodeInfoMap.clear();
        this.objectInfoMap.clear();
    }

    protected CMISNodeInfoImpl createNodeInfo(NodeRef nodeRef) {
        return this.createNodeInfo(nodeRef, null);
    }

    protected CMISNodeInfoImpl createNodeInfo(NodeRef nodeRef, VersionHistory versionHistory) {
        CMISNodeInfoImpl result = this.connector.createNodeInfo(nodeRef, versionHistory);
        this.nodeInfoMap.put(result.getObjectId(), result);
        return result;
    }

    protected CMISNodeInfo createNodeInfo(AssociationRef assocRef) {
        CMISNodeInfoImpl result = this.connector.createNodeInfo(assocRef);
        this.nodeInfoMap.put(result.getObjectId(), result);
        return result;
    }

    protected CMISNodeInfo getOrCreateNodeInfo(String objectId) {
        CMISNodeInfo result = this.nodeInfoMap.get(objectId);
        if (result == null) {
            result = this.connector.createNodeInfo(objectId);
            this.nodeInfoMap.put(objectId, result);
        }
        return result;
    }

    protected CMISNodeInfo getOrCreateNodeInfo(String objectId, String what) {
        CMISNodeInfo result = this.getOrCreateNodeInfo(objectId);
        if (result instanceof CMISNodeInfoImpl) {
            ((CMISNodeInfoImpl)result).checkIfUseful(what);
        }
        return result;
    }

    protected CMISNodeInfo getOrCreateFolderInfo(String folderId, String what) {
        CMISNodeInfo result = this.getOrCreateNodeInfo(folderId);
        if (result instanceof CMISNodeInfoImpl) {
            ((CMISNodeInfoImpl)result).checkIfFolder(what);
        }
        return result;
    }

    protected CMISNodeInfo addNodeInfo(CMISNodeInfo info) {
        this.nodeInfoMap.put(info.getObjectId(), info);
        return info;
    }

    public List<RepositoryInfo> getRepositoryInfos(ExtensionsData extension) {
        return Collections.singletonList(this.connector.getRepositoryInfo());
    }

    public RepositoryInfo getRepositoryInfo(String repositoryId, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        return this.connector.getRepositoryInfo();
    }

    public TypeDefinitionList getTypeChildren(String repositoryId, String typeId, Boolean includePropertyDefinitions, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        List childrenList;
        this.checkRepositoryId(repositoryId);
        int max = maxItems == null ? Integer.MAX_VALUE : maxItems.intValue();
        int skip = skipCount == null || skipCount.intValue() < 0 ? 0 : skipCount.intValue();
        TypeDefinitionListImpl result = new TypeDefinitionListImpl();
        ArrayList<TypeDefinition> list = new ArrayList<TypeDefinition>();
        result.setList(list);
        if (typeId == null) {
            childrenList = this.connector.getOpenCMISDictionaryService().getBaseTypes();
        } else {
            TypeDefinitionWrapper tdw = this.connector.getOpenCMISDictionaryService().findType(typeId);
            if (tdw == null) {
                throw new CmisObjectNotFoundException("Type '" + typeId + "' is unknown!");
            }
            childrenList = tdw.getChildren();
        }
        if (max > 0) {
            int lastIndex = (max + skip > childrenList.size() ? childrenList.size() : max + skip) - 1;
            for (int i = skip; i <= lastIndex; ++i) {
                list.add(((TypeDefinitionWrapper)childrenList.get(i)).getTypeDefinition(includePropertyDefinitions.booleanValue()));
            }
        }
        result.setHasMoreItems(Boolean.valueOf(childrenList.size() - skip > result.getList().size()));
        result.setNumItems(BigInteger.valueOf(childrenList.size()));
        return result;
    }

    public TypeDefinition getTypeDefinition(String repositoryId, String typeId, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        TypeDefinitionWrapper tdw = this.connector.getOpenCMISDictionaryService().findType(typeId);
        if (tdw == null) {
            throw new CmisObjectNotFoundException("Type '" + typeId + "' is unknown!");
        }
        return tdw.getTypeDefinition(true);
    }

    public List<TypeDefinitionContainer> getTypeDescendants(String repositoryId, String typeId, BigInteger depth, Boolean includePropertyDefinitions, ExtensionsData extension) {
        ArrayList<TypeDefinitionContainer> result;
        block5: {
            int d;
            block4: {
                this.checkRepositoryId(repositoryId);
                result = new ArrayList<TypeDefinitionContainer>();
                int n = d = depth == null ? -1 : depth.intValue();
                if (d == 0) {
                    throw new CmisInvalidArgumentException("Depth must not be 0!");
                }
                if (typeId != null) break block4;
                for (TypeDefinitionWrapper tdw : this.connector.getOpenCMISDictionaryService().getBaseTypes()) {
                    result.add(this.getTypesDescendants(d, tdw, includePropertyDefinitions));
                }
                break block5;
            }
            TypeDefinitionWrapper tdw = this.connector.getOpenCMISDictionaryService().findType(typeId);
            if (tdw == null) {
                throw new CmisObjectNotFoundException("Type '" + typeId + "' is unknown!");
            }
            if (tdw.getChildren() == null) break block5;
            for (TypeDefinitionWrapper child : tdw.getChildren()) {
                result.add(this.getTypesDescendants(d, child, includePropertyDefinitions));
            }
        }
        return result;
    }

    private TypeDefinitionContainer getTypesDescendants(int depth, TypeDefinitionWrapper tdw, boolean includePropertyDefinitions) {
        TypeDefinitionContainerImpl result = new TypeDefinitionContainerImpl();
        result.setTypeDefinition(tdw.getTypeDefinition(includePropertyDefinitions));
        if (depth != 0 && tdw.getChildren() != null) {
            result.setChildren(new ArrayList());
            for (TypeDefinitionWrapper tdc : tdw.getChildren()) {
                result.getChildren().add(this.getTypesDescendants(depth < 0 ? -1 : depth - 1, tdc, includePropertyDefinitions));
            }
        }
        return result;
    }

    public ObjectInFolderList getChildren(String repositoryId, String folderId, String filter, String orderBy, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        long start = System.currentTimeMillis();
        this.checkRepositoryId(repositoryId);
        int max = maxItems == null ? Integer.MAX_VALUE : maxItems.intValue();
        int skip = skipCount == null || skipCount.intValue() < 0 ? 0 : skipCount.intValue();
        ObjectInFolderListImpl result = new ObjectInFolderListImpl();
        ArrayList<ObjectInFolderDataImpl> list = new ArrayList<ObjectInFolderDataImpl>();
        result.setObjects(list);
        NodeRef folderNodeRef = this.getOrCreateFolderInfo(folderId, "Folder").getNodeRef();
        ArrayList<Pair<QName, Boolean>> sortProps = null;
        if (orderBy != null) {
            sortProps = new ArrayList<Pair<QName, Boolean>>(1);
            String[] parts = orderBy.split(",");
            int len = parts.length;
            int origLen = len;
            if (origLen > 0) {
                int maxSortProps = 3;
                if (len > maxSortProps) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Too many sort properties in 'orderBy' - ignore those above max (max=" + maxSortProps + ",actual=" + len + ")"));
                    }
                    len = maxSortProps;
                }
                for (int i = 0; i < len; ++i) {
                    String[] sort = parts[i].split(" +");
                    if (sort.length <= 0) continue;
                    PropertyDefinitionWrapper propDef = this.connector.getOpenCMISDictionaryService().findPropertyByQueryName(sort[0]);
                    if (propDef != null) {
                        QName sortProp = null;
                        sortProp = propDef.getPropertyId().equals("cmis:baseTypeId") ? GetChildrenCannedQuery.SORT_QNAME_NODE_IS_FOLDER : propDef.getPropertyAccessor().getMappedProperty();
                        if (sortProp != null) {
                            boolean sortAsc = sort.length == 1 || sort[1].equalsIgnoreCase("asc");
                            sortProps.add((Pair<QName, Boolean>)new Pair((Object)sortProp, (Object)sortAsc));
                            continue;
                        }
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("Ignore sort property '" + sort[0] + " - mapping not found"));
                        continue;
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Ignore sort property '" + sort[0] + " - query name not found"));
                }
            }
            if (sortProps.size() < origLen) {
                logger.warn((Object)("Sort properties trimmed - either too many and/or not found: \n   orig:  " + orderBy + "\n" + "   final: " + sortProps));
            }
        }
        PagingRequest pageRequest = new PagingRequest(skip, max, null);
        pageRequest.setRequestTotalCountMax(skip + 10000);
        PagingResults<FileInfo> pageOfNodeInfos = this.connector.getFileFolderService().list(folderNodeRef, true, true, null, sortProps, pageRequest);
        if (max > 0) {
            for (FileInfo child : pageOfNodeInfos.getPage()) {
                try {
                    CMISNodeInfoImpl ni = this.createNodeInfo(child.getNodeRef());
                    if (this.getObjectInfo(repositoryId, ni.getObjectId()) == null) continue;
                    ObjectData object = this.connector.createCMISObject(ni, child, filter, includeAllowableActions, includeRelationships, renditionFilter, false, false);
                    if (this.context.isObjectInfoRequired()) {
                        this.getObjectInfo(repositoryId, ni.getObjectId(), includeRelationships);
                    }
                    ObjectInFolderDataImpl childData = new ObjectInFolderDataImpl();
                    childData.setObject(object);
                    if (includePathSegment.booleanValue()) {
                        childData.setPathSegment(child.getName());
                    }
                    list.add(childData);
                }
                catch (InvalidNodeRefException e) {
                }
                catch (CmisObjectNotFoundException e) {}
            }
        }
        result.setHasMoreItems(Boolean.valueOf(pageOfNodeInfos.hasMoreItems()));
        Pair totalCounts = pageOfNodeInfos.getTotalResultCount();
        if (totalCounts != null) {
            Integer totalCountLower = (Integer)totalCounts.getFirst();
            Integer totalCountUpper = (Integer)totalCounts.getSecond();
            if (totalCountLower != null && totalCountLower.equals(totalCountUpper)) {
                result.setNumItems(BigInteger.valueOf(totalCountLower.intValue()));
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getChildren: " + list.size() + " in " + (System.currentTimeMillis() - start) + " msecs"));
        }
        return result;
    }

    public List<ObjectInFolderContainer> getDescendants(String repositoryId, String folderId, BigInteger depth, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        ArrayList<ObjectInFolderContainer> result = new ArrayList<ObjectInFolderContainer>();
        this.getDescendantsTree(repositoryId, this.getOrCreateFolderInfo(folderId, "Folder").getNodeRef(), depth.intValue(), filter, includeAllowableActions, includeRelationships, renditionFilter, includePathSegment, false, result);
        return result;
    }

    public List<ObjectInFolderContainer> getFolderTree(String repositoryId, String folderId, BigInteger depth, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        ArrayList<ObjectInFolderContainer> result = new ArrayList<ObjectInFolderContainer>();
        this.getDescendantsTree(repositoryId, this.getOrCreateFolderInfo(folderId, "Folder").getNodeRef(), depth.intValue(), filter, includeAllowableActions, includeRelationships, renditionFilter, includePathSegment, true, result);
        return result;
    }

    private void getDescendantsTree(String repositoryId, NodeRef folderNodeRef, int depth, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, boolean foldersOnly, List<ObjectInFolderContainer> list) {
        List childrenList = this.connector.getNodeService().getChildAssocs(folderNodeRef);
        for (ChildAssociationRef child : childrenList) {
            try {
                TypeDefinitionWrapper type = this.connector.getType(child.getChildRef());
                if (type == null) continue;
                boolean isFolder = type instanceof FolderTypeDefintionWrapper;
                if (foldersOnly && !isFolder || isFolder && type.getAlfrescoClass().equals((Object)ContentModel.TYPE_SYSTEM_FOLDER)) continue;
                ObjectInFolderDataImpl object = new ObjectInFolderDataImpl();
                CMISNodeInfoImpl ni = this.createNodeInfo(child.getChildRef());
                object.setObject(this.connector.createCMISObject(ni, filter, includeAllowableActions, includeRelationships, renditionFilter, false, false));
                if (this.context.isObjectInfoRequired()) {
                    this.getObjectInfo(repositoryId, ni.getObjectId(), includeRelationships);
                }
                if (includePathSegment.booleanValue()) {
                    object.setPathSegment(this.connector.getName(child.getChildRef()));
                }
                ObjectInFolderContainerImpl container = new ObjectInFolderContainerImpl();
                container.setObject((ObjectInFolderData)object);
                if (depth != 1 && isFolder) {
                    container.setChildren(new ArrayList());
                    this.getDescendantsTree(repositoryId, child.getChildRef(), depth - 1, filter, includeAllowableActions, includeRelationships, renditionFilter, includePathSegment, foldersOnly, container.getChildren());
                }
                list.add((ObjectInFolderContainer)container);
            }
            catch (InvalidNodeRefException e) {
            }
            catch (CmisObjectNotFoundException e) {}
        }
    }

    public ObjectData getFolderParent(String repositoryId, String folderId, String filter, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        CMISNodeInfo info = this.getOrCreateFolderInfo(folderId, "Folder");
        if (info.isRootFolder()) {
            throw new CmisInvalidArgumentException("Root folder has no parent!");
        }
        List parentInfos = info.getParents();
        if (parentInfos.isEmpty()) {
            throw new CmisRuntimeException("Folder has no parent and is not the root folder?!");
        }
        CMISNodeInfo parentInfo = this.addNodeInfo((CMISNodeInfo)parentInfos.get(0));
        ObjectData result = this.connector.createCMISObject(parentInfo, filter, false, IncludeRelationships.NONE, "cmis:none", false, false);
        if (this.context.isObjectInfoRequired()) {
            this.getObjectInfo(repositoryId, parentInfo.getObjectId(), IncludeRelationships.NONE);
        }
        return result;
    }

    public List<ObjectParentData> getObjectParents(String repositoryId, String objectId, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includeRelativePathSegment, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        ArrayList<ObjectParentData> result = new ArrayList<ObjectParentData>();
        CMISNodeInfo info = this.getOrCreateNodeInfo(objectId, "Object");
        if (info.isRelationship()) {
            throw new CmisConstraintException("Relationships are not fileable!");
        }
        if (info.isFolder() && !info.isRootFolder()) {
            List parentInfos = info.getParents();
            if (!parentInfos.isEmpty()) {
                CMISNodeInfo parentInfo = this.addNodeInfo((CMISNodeInfo)parentInfos.get(0));
                ObjectData object = this.connector.createCMISObject(parentInfo, filter, includeAllowableActions, includeRelationships, renditionFilter, false, false);
                if (this.context.isObjectInfoRequired()) {
                    this.getObjectInfo(repositoryId, object.getId(), includeRelationships);
                }
                ObjectParentDataImpl objectParent = new ObjectParentDataImpl();
                objectParent.setObject(object);
                if (includeRelativePathSegment.booleanValue()) {
                    objectParent.setRelativePathSegment(info.getName());
                }
                result.add((ObjectParentData)objectParent);
            }
        } else if (info.isCurrentVersion() || info.isPWC()) {
            List parentInfos = info.getParents();
            for (CMISNodeInfo parentInfo : parentInfos) {
                this.addNodeInfo(parentInfo);
                ObjectData object = this.connector.createCMISObject(parentInfo, filter, includeAllowableActions, includeRelationships, renditionFilter, false, false);
                if (this.context.isObjectInfoRequired()) {
                    this.getObjectInfo(repositoryId, object.getId(), includeRelationships);
                }
                ObjectParentDataImpl objectParent = new ObjectParentDataImpl();
                objectParent.setObject(object);
                if (includeRelativePathSegment.booleanValue()) {
                    objectParent.setRelativePathSegment(info.getName());
                }
                result.add((ObjectParentData)objectParent);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectList getCheckedOutDocs(String repositoryId, String folderId, String filter, String orderBy, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        List nodeRefs;
        this.checkRepositoryId(repositoryId);
        int max = maxItems == null ? Integer.MAX_VALUE : maxItems.intValue();
        int skip = skipCount == null || skipCount.intValue() < 0 ? 0 : skipCount.intValue();
        SearchParameters params = new SearchParameters();
        params.setLanguage("lucene");
        QueryParameterDefImpl usernameDef = new QueryParameterDefImpl(PARAM_USERNAME, this.connector.getDictionaryService().getDataType(DataTypeDefinition.TEXT), true, AuthenticationUtil.getFullyAuthenticatedUser());
        params.addQueryParameterDefinition((QueryParameterDefinition)usernameDef);
        if (folderId == null) {
            params.setQuery(LUCENE_QUERY_CHECKEDOUT);
            params.addStore(this.connector.getRootStoreRef());
        } else {
            CMISNodeInfo folderInfo = this.getOrCreateFolderInfo(folderId, "Folder");
            params.setQuery(LUCENE_QUERY_CHECKEDOUT_IN_FOLDER);
            params.addStore(folderInfo.getNodeRef().getStoreRef());
            QueryParameterDefImpl parentDef = new QueryParameterDefImpl(PARAM_PARENT, this.connector.getDictionaryService().getDataType(DataTypeDefinition.NODE_REF), true, folderInfo.getNodeRef().toString());
            params.addQueryParameterDefinition((QueryParameterDefinition)parentDef);
        }
        if (orderBy != null) {
            String[] parts = orderBy.split(",");
            for (int i = 0; i < parts.length; ++i) {
                String[] sort = parts[i].split(" +");
                if (sort.length < 1) continue;
                PropertyDefinitionWrapper propDef = this.connector.getOpenCMISDictionaryService().findPropertyByQueryName(sort[0]);
                if (propDef != null) {
                    if (propDef.getPropertyDefinition().isOrderable().booleanValue()) {
                        QName sortProp = propDef.getPropertyAccessor().getMappedProperty();
                        if (sortProp != null) {
                            boolean sortAsc = sort.length == 1 || sort[1].equalsIgnoreCase("asc");
                            params.addSort(propDef.getPropertyLuceneBuilder().getLuceneFieldName(), sortAsc);
                            continue;
                        }
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("Ignore sort property '" + sort[0] + " - mapping not found"));
                        continue;
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Ignore sort property '" + sort[0] + " - not orderable"));
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Ignore sort property '" + sort[0] + " - query name not found"));
            }
        }
        ResultSet resultSet = null;
        try {
            resultSet = this.connector.getSearchService().query(params);
            nodeRefs = resultSet.getNodeRefs();
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        ObjectListImpl result = new ObjectListImpl();
        ArrayList<ObjectData> list = new ArrayList<ObjectData>();
        result.setObjects(list);
        int skipCounter = skip;
        if (max > 0) {
            for (NodeRef nodeRef : nodeRefs) {
                if (skipCounter > 0) {
                    --skipCounter;
                    continue;
                }
                if (list.size() == max) break;
                try {
                    CMISNodeInfoImpl ni = this.createNodeInfo(nodeRef);
                    ObjectData object = this.connector.createCMISObject(ni, filter, includeAllowableActions, includeRelationships, renditionFilter, false, false);
                    if (this.context.isObjectInfoRequired()) {
                        this.getObjectInfo(repositoryId, ni.getObjectId(), includeRelationships);
                    }
                    list.add(object);
                }
                catch (InvalidNodeRefException e) {
                }
                catch (CmisObjectNotFoundException e) {}
            }
        }
        result.setHasMoreItems(Boolean.valueOf(nodeRefs.size() - skip > list.size()));
        return result;
    }

    public String create(String repositoryId, Properties properties, String folderId, ContentStream contentStream, VersioningState versioningState, List<String> policies, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        if (properties == null || properties.getProperties() == null) {
            throw new CmisInvalidArgumentException("Properties must be set!");
        }
        String objectTypeId = this.connector.getObjectTypeIdProperty(properties);
        TypeDefinitionWrapper type = this.connector.getOpenCMISDictionaryService().findType(objectTypeId);
        if (type == null) {
            throw new CmisInvalidArgumentException("Type '" + objectTypeId + "' is unknown!");
        }
        String newId = null;
        switch (type.getBaseTypeId()) {
            case CMIS_DOCUMENT: {
                newId = this.createDocument(repositoryId, properties, folderId, contentStream, versioningState, policies, null, null, extension);
                break;
            }
            case CMIS_FOLDER: {
                newId = this.createFolder(repositoryId, properties, folderId, policies, null, null, extension);
                break;
            }
            case CMIS_POLICY: {
                newId = this.createPolicy(repositoryId, properties, folderId, policies, null, null, extension);
            }
        }
        if (newId == null) {
            throw new CmisRuntimeException("Creation failed!");
        }
        if (this.context.isObjectInfoRequired()) {
            try {
                this.getObjectInfo(repositoryId, newId, "*", IncludeRelationships.NONE);
            }
            catch (InvalidNodeRefException e) {
                throw new CmisRuntimeException("Creation failed! New object not found!");
            }
        }
        return newId;
    }

    public String createFolder(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        CMISNodeInfo parentInfo = this.getOrCreateFolderInfo(folderId, "Folder");
        String name = this.connector.getNameProperty(properties, null);
        String objectTypeId = this.connector.getObjectTypeIdProperty(properties);
        TypeDefinitionWrapper type = this.connector.getTypeForCreate(objectTypeId, BaseTypeId.CMIS_FOLDER);
        this.connector.checkChildObjectType(parentInfo, type.getTypeId());
        FileInfo fileInfo = this.connector.getFileFolderService().create(parentInfo.getNodeRef(), name, type.getAlfrescoClass());
        NodeRef nodeRef = fileInfo.getNodeRef();
        this.connector.setProperties(nodeRef, type, properties, "cmis:name", "cmis:objectTypeId");
        this.connector.applyPolicies(nodeRef, type, policies);
        this.connector.applyACL(nodeRef, type, addAces, removeAces);
        this.connector.getActivityPoster().postFileFolderAdded(fileInfo);
        return nodeRef.toString();
    }

    private String stripEncoding(String mimeType) {
        String ret = mimeType;
        int idx = mimeType.indexOf(";");
        if (idx != -1) {
            ret = mimeType.substring(0, idx);
        }
        return ret;
    }

    public String createDocument(String repositoryId, Properties properties, String folderId, ContentStream contentStream, VersioningState versioningState, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        CMISNodeInfo parentInfo = this.getOrCreateFolderInfo(folderId, "Parent folder");
        String name = this.connector.getNameProperty(properties, null);
        String objectTypeId = this.connector.getObjectTypeIdProperty(properties);
        TypeDefinitionWrapper type = this.connector.getTypeForCreate(objectTypeId, BaseTypeId.CMIS_DOCUMENT);
        this.connector.checkChildObjectType(parentInfo, type.getTypeId());
        DocumentTypeDefinition docType = (DocumentTypeDefinition)type.getTypeDefinition(false);
        if (docType.getContentStreamAllowed() == ContentStreamAllowed.NOTALLOWED && contentStream != null) {
            throw new CmisConstraintException("This document type does not support content!");
        }
        if (docType.getContentStreamAllowed() == ContentStreamAllowed.REQUIRED && contentStream == null) {
            throw new CmisConstraintException("This document type does requires content!");
        }
        if (docType.isVersionable().booleanValue() && versioningState == VersioningState.NONE) {
            throw new CmisConstraintException("This document type is versionable!");
        }
        if (!docType.isVersionable().booleanValue() && versioningState != VersioningState.NONE) {
            throw new CmisConstraintException("This document type is not versionable!");
        }
        File tempFile = this.copyToTempFile(contentStream);
        Charset encoding = tempFile == null ? null : this.getEncoding(tempFile, contentStream.getMimeType());
        FileInfo fileInfo = this.connector.getFileFolderService().create(parentInfo.getNodeRef(), name, type.getAlfrescoClass());
        NodeRef nodeRef = fileInfo.getNodeRef();
        this.connector.setProperties(nodeRef, type, properties, "cmis:name", "cmis:objectTypeId");
        this.connector.applyPolicies(nodeRef, type, policies);
        this.connector.applyACL(nodeRef, type, addAces, removeAces);
        if (contentStream != null) {
            ContentWriter writer = this.connector.getFileFolderService().getWriter(nodeRef);
            writer.setMimetype(this.stripEncoding(contentStream.getMimeType()));
            writer.setEncoding(encoding.name());
            writer.putContent(tempFile);
        }
        this.connector.applyVersioningState(nodeRef, versioningState);
        this.removeTempFile(tempFile);
        String objectId = this.connector.createObjectId(nodeRef);
        this.connector.getActivityPoster().postFileFolderAdded(fileInfo);
        return objectId;
    }

    public String createDocumentFromSource(String repositoryId, String sourceId, Properties properties, String folderId, VersioningState versioningState, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        CMISNodeInfo parentInfo = this.getOrCreateFolderInfo(folderId, "Parent folder");
        CMISNodeInfo info = this.getOrCreateNodeInfo(sourceId, "Source");
        if (info.isVariant(CMISObjectVariant.ASSOC)) {
            throw new CmisConstraintException("Source object is not a document!");
        }
        NodeRef sourceNodeRef = info.getNodeRef();
        if (!info.isDocument()) {
            throw new CmisConstraintException("Source object is not a document!");
        }
        String name = this.connector.getNameProperty(properties, info.getName());
        TypeDefinitionWrapper type = info.getType();
        this.connector.checkChildObjectType(parentInfo, type.getTypeId());
        try {
            FileInfo fileInfo = this.connector.getFileFolderService().copy(sourceNodeRef, parentInfo.getNodeRef(), name);
            NodeRef nodeRef = fileInfo.getNodeRef();
            this.connector.setProperties(nodeRef, type, properties, "cmis:name", "cmis:objectTypeId");
            this.connector.applyPolicies(nodeRef, type, policies);
            this.connector.applyACL(nodeRef, type, addAces, removeAces);
            this.connector.applyVersioningState(nodeRef, versioningState);
            this.connector.getActivityPoster().postFileFolderAdded(fileInfo);
            return this.connector.createObjectId(nodeRef);
        }
        catch (FileNotFoundException e) {
            throw new CmisContentAlreadyExistsException("An object with this name already exists!", (Throwable)e);
        }
    }

    public String createPolicy(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.getOrCreateFolderInfo(folderId, "Parent Folder");
        String objectTypeId = this.connector.getObjectTypeIdProperty(properties);
        this.connector.getTypeForCreate(objectTypeId, BaseTypeId.CMIS_POLICY);
        throw new CmisRuntimeException("Polcies cannot be created!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createRelationship(String repositoryId, Properties properties, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        String objectTypeId = this.connector.getObjectTypeIdProperty(properties);
        TypeDefinitionWrapper type = this.connector.getTypeForCreate(objectTypeId, BaseTypeId.CMIS_RELATIONSHIP);
        String sourceId = this.connector.getSourceIdProperty(properties);
        CMISNodeInfo sourceInfo = this.getOrCreateNodeInfo(sourceId, "Source");
        if (!sourceInfo.isVariant(CMISObjectVariant.CURRENT_VERSION) && !sourceInfo.isVariant(CMISObjectVariant.FOLDER)) {
            throw new CmisInvalidArgumentException("Source is not the latest version of a document or a folder object!");
        }
        NodeRef sourceNodeRef = sourceInfo.getNodeRef();
        String targetId = this.connector.getTargetIdProperty(properties);
        CMISNodeInfo targetInfo = this.getOrCreateNodeInfo(targetId, "Target");
        if (!targetInfo.isVariant(CMISObjectVariant.CURRENT_VERSION) && !targetInfo.isVariant(CMISObjectVariant.FOLDER)) {
            throw new CmisInvalidArgumentException("Target is not the latest version of a document or a folder object!!");
        }
        NodeRef targetNodeRef = targetInfo.getNodeRef();
        if (policies != null && !policies.isEmpty()) {
            throw new CmisConstraintException("Relationships are not policy controllable!");
        }
        if (addAces != null && addAces.getAces() != null && !addAces.getAces().isEmpty()) {
            throw new CmisConstraintException("Relationships are not ACL controllable!");
        }
        if (removeAces != null && removeAces.getAces() != null && !removeAces.getAces().isEmpty()) {
            throw new CmisConstraintException("Relationships are not ACL controllable!");
        }
        boolean wasEnabled = this.connector.disableBehaviour(ContentModel.ASPECT_AUDITABLE, sourceNodeRef);
        try {
            AssociationRef assocRef = this.connector.getNodeService().createAssociation(sourceNodeRef, targetNodeRef, type.getAlfrescoClass());
            String string = "assoc:" + assocRef.getId();
            return string;
        }
        finally {
            if (wasEnabled) {
                this.connector.enableBehaviour(ContentModel.ASPECT_AUDITABLE, sourceNodeRef);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContentStream(String repositoryId, Holder<String> objectId, Boolean overwriteFlag, Holder<String> changeToken, ContentStream contentStream, ExtensionsData extension) {
        boolean existed;
        this.checkRepositoryId(repositoryId);
        CMISNodeInfo info = this.getOrCreateNodeInfo((String)objectId.getValue(), "Object");
        if (!info.isVariant(CMISObjectVariant.CURRENT_VERSION) && !info.isVariant(CMISObjectVariant.PWC)) {
            throw new CmisStreamNotSupportedException("Content can only be set ondocuments!");
        }
        NodeRef nodeRef = info.getNodeRef();
        if (((DocumentTypeDefinition)info.getType().getTypeDefinition(false)).getContentStreamAllowed() == ContentStreamAllowed.NOTALLOWED) {
            throw new CmisStreamNotSupportedException("Document type doesn't allow content!");
        }
        boolean bl = existed = this.connector.getContentService().getReader(nodeRef, ContentModel.PROP_CONTENT) != null;
        if (existed && !overwriteFlag.booleanValue()) {
            throw new CmisContentAlreadyExistsException("Content already exists!");
        }
        if (contentStream == null || contentStream.getStream() == null) {
            throw new CmisInvalidArgumentException("No content!");
        }
        File tempFile = this.copyToTempFile(contentStream);
        Charset encoding = this.getEncoding(tempFile, contentStream.getMimeType());
        try {
            ContentWriter writer = this.connector.getFileFolderService().getWriter(nodeRef);
            writer.setMimetype(contentStream.getMimeType());
            writer.setEncoding(encoding.name());
            writer.putContent(tempFile);
        }
        finally {
            this.removeTempFile(tempFile);
        }
        objectId.setValue((Object)this.connector.createObjectId(nodeRef));
        this.connector.getActivityPoster().postFileFolderUpdated(info.isFolder(), nodeRef);
    }

    public void deleteContentStream(String repositoryId, Holder<String> objectId, Holder<String> changeToken, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        CMISNodeInfo info = this.getOrCreateNodeInfo((String)objectId.getValue(), "Object");
        if (!info.isVariant(CMISObjectVariant.CURRENT_VERSION) && !info.isVariant(CMISObjectVariant.PWC)) {
            throw new CmisStreamNotSupportedException("Content can only be deleted from ondocuments!");
        }
        NodeRef nodeRef = info.getNodeRef();
        if (((DocumentTypeDefinition)info.getType().getTypeDefinition(false)).getContentStreamAllowed() == ContentStreamAllowed.REQUIRED) {
            throw new CmisInvalidArgumentException("Document type requires content!");
        }
        this.connector.getNodeService().setProperty(nodeRef, ContentModel.PROP_CONTENT, null);
        this.connector.getActivityPoster().postFileFolderUpdated(info.isFolder(), nodeRef);
        objectId.setValue((Object)this.connector.createObjectId(nodeRef));
    }

    public void moveObject(String repositoryId, Holder<String> objectId, String targetFolderId, String sourceFolderId, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        CMISNodeInfo info = this.getOrCreateNodeInfo((String)objectId.getValue(), "Object");
        NodeRef nodeRef = info.getCurrentNodeNodeRef();
        CMISNodeInfo sourceInfo = this.getOrCreateFolderInfo(sourceFolderId, "Source Folder");
        CMISNodeInfo targetInfo = this.getOrCreateFolderInfo(targetFolderId, "Target Folder");
        this.connector.checkChildObjectType(targetInfo, info.getType().getTypeId());
        ChildAssociationRef primaryParentRef = this.connector.getNodeService().getPrimaryParent(nodeRef);
        if (primaryParentRef.getParentRef().equals((Object)sourceInfo.getNodeRef())) {
            this.connector.getNodeService().moveNode(nodeRef, targetInfo.getNodeRef(), primaryParentRef.getTypeQName(), primaryParentRef.getQName());
        } else {
            boolean found = false;
            for (ChildAssociationRef parent : this.connector.getNodeService().getParentAssocs(nodeRef, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL)) {
                if (!parent.getParentRef().equals((Object)sourceInfo.getNodeRef())) continue;
                this.connector.getNodeService().removeChildAssociation(parent);
                this.connector.getNodeService().addChild(targetInfo.getNodeRef(), nodeRef, ContentModel.ASSOC_CONTAINS, parent.getQName());
                found = true;
            }
            if (!found) {
                throw new IllegalArgumentException(new CMISInvalidArgumentException("Document is not a child of the source folder that was specified!"));
            }
        }
    }

    public void updateProperties(String repositoryId, Holder<String> objectId, Holder<String> changeToken, Properties properties, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        CMISNodeInfo info = this.getOrCreateNodeInfo((String)objectId.getValue(), "Object");
        if (info.isVariant(CMISObjectVariant.ASSOC)) {
            throw new CmisInvalidArgumentException("Relationship properties cannot be updated!");
        }
        if (info.isVariant(CMISObjectVariant.VERSION)) {
            throw new CmisInvalidArgumentException("Document is not the latest version!");
        }
        NodeRef nodeRef = info.getNodeRef();
        this.connector.setProperties(nodeRef, info.getType(), properties, new String[0]);
        objectId.setValue((Object)this.connector.createObjectId(nodeRef));
        if (this.context.isObjectInfoRequired()) {
            this.getObjectInfo(repositoryId, (String)objectId.getValue(), "*", IncludeRelationships.NONE);
        }
        this.connector.getActivityPoster().postFileFolderUpdated(info.isFolder(), nodeRef);
    }

    public void deleteObject(String repositoryId, String objectId, Boolean allVersions, ExtensionsData extension) {
        this.deleteObjectOrCancelCheckOut(repositoryId, objectId, allVersions, extension);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void deleteObjectOrCancelCheckOut(String repositoryId, String objectId, Boolean allVersions, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        CMISNodeInfo info = this.getOrCreateNodeInfo(objectId, "Object");
        if (info.isVariant(CMISObjectVariant.ASSOC)) {
            AssociationRef assocRef = info.getAssociationRef();
            this.connector.getNodeService().removeAssociation(assocRef.getSourceRef(), assocRef.getTargetRef(), assocRef.getTypeQName());
            return;
        }
        NodeRef nodeRef = info.getNodeRef();
        if (info.isVariant(CMISObjectVariant.PWC)) {
            this.connector.getCheckOutCheckInService().cancelCheckout(nodeRef);
            return;
        }
        if (info.isFolder()) {
            if (this.connector.getNodeService().getChildAssocs(nodeRef).size() > 0) {
                throw new CmisConstraintException("Could not delete folder with at least one child!");
            }
            this.connector.deleteNode(nodeRef, false);
            return;
        }
        if (allVersions.booleanValue()) {
            NodeRef workingCopy = this.connector.getCheckOutCheckInService().getWorkingCopy(nodeRef);
            if (workingCopy != null) {
                this.connector.getCheckOutCheckInService().cancelCheckout(workingCopy);
            }
        } else if (info.isVariant(CMISObjectVariant.VERSION)) {
            Version version = ((CMISNodeInfoImpl)info).getVersion();
            this.connector.getVersionService().deleteVersion(nodeRef, version);
            return;
        }
        if (info.isVariant(CMISObjectVariant.VERSION)) {
            nodeRef = info.getCurrentNodeNodeRef();
        }
        if (allVersions.booleanValue()) {
            this.connector.deleteNode(nodeRef, true);
            return;
        }
        CMISNodeInfoImpl infoImpl = (CMISNodeInfoImpl)info;
        Version version = infoImpl.getVersion();
        if (infoImpl.getVersionHistory().getPredecessor(version) == null) {
            this.connector.deleteNode(nodeRef, true);
            return;
        }
        this.connector.getVersionService().deleteVersion(nodeRef, version);
    }

    public FailedToDeleteData deleteTree(String repositoryId, String folderId, Boolean allVersions, UnfileObject unfileObjects, Boolean continueOnFailure, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        if (!allVersions.booleanValue()) {
            throw new CmisInvalidArgumentException("Only allVersions=true supported!");
        }
        if (unfileObjects == UnfileObject.UNFILE) {
            throw new CmisInvalidArgumentException("Unfiling not supported!");
        }
        NodeRef folderNodeRef = this.getOrCreateFolderInfo(folderId, "Folder").getNodeRef();
        FailedToDeleteDataImpl result = new FailedToDeleteDataImpl();
        result.setIds(this.deleteBranch(folderNodeRef, continueOnFailure));
        return result;
    }

    private List<String> deleteBranch(NodeRef nodeRef, boolean continueOnFailure) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            List childAssociations;
            List childrenList = this.connector.getNodeService().getChildAssocs(nodeRef);
            if (childrenList != null) {
                for (ChildAssociationRef child : childrenList) {
                    List<String> ftod = this.deleteBranch(child.getChildRef(), continueOnFailure);
                    if (ftod.isEmpty()) continue;
                    result.addAll(ftod);
                    if (continueOnFailure) continue;
                    return result;
                }
            }
            if ((childAssociations = this.connector.getNodeService().getParentAssocs(nodeRef)) != null) {
                for (ChildAssociationRef childAssoc : childAssociations) {
                    if (childAssoc.isPrimary()) continue;
                    this.connector.getNodeService().removeChildAssociation(childAssoc);
                }
            }
            this.connector.deleteNode(nodeRef, false);
        }
        catch (Exception e) {
            result.add(nodeRef.toString());
        }
        return result;
    }

    public ObjectData getObject(String repositoryId, String objectId, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        CMISNodeInfo info = this.getOrCreateNodeInfo(objectId, "Object");
        ObjectData object = this.connector.createCMISObject(info, filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl);
        if (this.context.isObjectInfoRequired()) {
            this.getObjectInfo(repositoryId, info.getObjectId(), includeRelationships);
        }
        return object;
    }

    public ObjectData getObjectByPath(String repositoryId, String path, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        NodeRef rootNodeRef = this.connector.getRootNodeRef();
        if (path.equals("/")) {
            return this.connector.createCMISObject(this.createNodeInfo(rootNodeRef), filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl);
        }
        try {
            FileInfo fileInfo = this.connector.getFileFolderService().resolveNamePath(rootNodeRef, Arrays.asList(path.substring(1).split("/")));
            CMISNodeInfoImpl info = this.createNodeInfo(fileInfo.getNodeRef());
            ObjectData object = this.connector.createCMISObject(info, fileInfo, filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl);
            if (this.context.isObjectInfoRequired()) {
                this.getObjectInfo(repositoryId, info.getObjectId(), includeRelationships);
            }
            return object;
        }
        catch (FileNotFoundException e) {
            throw new CmisObjectNotFoundException("Object not found: " + path);
        }
    }

    public Properties getProperties(String repositoryId, String objectId, String filter, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        CMISNodeInfo info = this.getOrCreateNodeInfo(objectId, "Object");
        if (this.context.isObjectInfoRequired()) {
            this.getObjectInfo(repositoryId, info.getObjectId(), IncludeRelationships.NONE);
        }
        if (info.isVariant(CMISObjectVariant.ASSOC)) {
            return this.connector.getAssocProperties(info, filter);
        }
        return this.connector.getNodeProperties(info, filter);
    }

    public AllowableActions getAllowableActions(String repositoryId, String objectId, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        CMISNodeInfo info = this.getOrCreateNodeInfo(objectId, "Object");
        return this.connector.getAllowableActions(info);
    }

    public ContentStream getContentStream(String repositoryId, String objectId, String streamId, BigInteger offset, BigInteger length, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        CMISNodeInfo info = this.getOrCreateNodeInfo(objectId, "Object");
        if (info.isVariant(CMISObjectVariant.ASSOC)) {
            throw new CmisInvalidArgumentException("Object is a relationship and cannot have content!");
        }
        return this.connector.getContentStream(info, streamId, offset, length);
    }

    public List<RenditionData> getRenditions(String repositoryId, String objectId, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        CMISNodeInfo info = this.getOrCreateNodeInfo(objectId, "Object");
        if (info.isVariant(CMISObjectVariant.ASSOC)) {
            return Collections.emptyList();
        }
        return this.connector.getRenditions(info.getNodeRef(), renditionFilter, maxItems, skipCount);
    }

    public void checkOut(String repositoryId, Holder<String> objectId, ExtensionsData extension, Holder<Boolean> contentCopied) {
        this.checkRepositoryId(repositoryId);
        CMISNodeInfo info = this.getOrCreateNodeInfo((String)objectId.getValue(), "Object");
        if (!info.isVariant(CMISObjectVariant.CURRENT_VERSION)) {
            if (info.isVariant(CMISObjectVariant.VERSION)) {
                throw new CmisInvalidArgumentException("Can't check out an old version of a document");
            }
            throw new CmisInvalidArgumentException("Only documents can be checked out! Object was a " + info.getObjectVariant().toString());
        }
        NodeRef nodeRef = info.getNodeRef();
        if (!((DocumentTypeDefinition)info.getType().getTypeDefinition(false)).isVersionable().booleanValue()) {
            throw new CmisConstraintException("Document is not versionable!");
        }
        NodeRef pwcNodeRef = this.connector.getCheckOutCheckInService().checkout(nodeRef);
        CMISNodeInfoImpl pwcNodeInfo = this.createNodeInfo(pwcNodeRef);
        objectId.setValue((Object)pwcNodeInfo.getObjectId());
        if (contentCopied != null) {
            contentCopied.setValue((Object)(this.connector.getFileFolderService().getReader(pwcNodeRef) != null ? 1 : 0));
        }
    }

    public void cancelCheckOut(String repositoryId, String objectId, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        CMISNodeInfo info = this.getOrCreateNodeInfo(objectId, "Object");
        if (!info.isVariant(CMISObjectVariant.PWC)) {
            throw new CmisVersioningException("Object is not a PWC!");
        }
        NodeRef nodeRef = info.getNodeRef();
        this.connector.getCheckOutCheckInService().cancelCheckout(nodeRef);
    }

    public void checkIn(String repositoryId, Holder<String> objectId, Boolean major, Properties properties, ContentStream contentStream, String checkinComment, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        CMISNodeInfo info = this.getOrCreateNodeInfo((String)objectId.getValue(), "Object");
        if (!info.isVariant(CMISObjectVariant.PWC)) {
            throw new CmisVersioningException("Object is not a PWC!");
        }
        NodeRef nodeRef = info.getNodeRef();
        TypeDefinitionWrapper type = info.getType();
        File tempFile = this.copyToTempFile(contentStream);
        Charset encoding = tempFile == null ? null : this.getEncoding(tempFile, contentStream.getMimeType());
        this.connector.setProperties(nodeRef, type, properties, "cmis:objectTypeId");
        this.connector.applyPolicies(nodeRef, type, policies);
        this.connector.applyACL(nodeRef, type, addAces, removeAces);
        if (contentStream != null) {
            ContentWriter writer = this.connector.getFileFolderService().getWriter(nodeRef);
            writer.setMimetype(contentStream.getMimeType());
            writer.setEncoding(encoding.name());
            writer.putContent(tempFile);
        }
        if (!this.connector.getNodeService().hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE)) {
            HashMap<QName, Boolean> props = new HashMap<QName, Boolean>();
            props.put(ContentModel.PROP_INITIAL_VERSION, false);
            props.put(ContentModel.PROP_AUTO_VERSION, false);
            this.connector.getNodeService().addAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE, props);
        }
        HashMap<String, Serializable> versionProperties = new HashMap<String, Serializable>(5);
        versionProperties.put("versionType", (Serializable)((Object)(major != false ? VersionType.MAJOR : VersionType.MINOR)));
        if (checkinComment != null) {
            versionProperties.put("description", (Serializable)((Object)checkinComment));
        }
        NodeRef newNodeRef = this.connector.getCheckOutCheckInService().checkin(nodeRef, versionProperties);
        objectId.setValue((Object)this.connector.createObjectId(newNodeRef));
        this.removeTempFile(tempFile);
    }

    public List<ObjectData> getAllVersions(String repositoryId, String objectId, String versionSeriesId, String filter, Boolean includeAllowableActions, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        if (versionSeriesId == null && objectId != null) {
            versionSeriesId = this.connector.getCurrentVersionId(objectId);
        }
        if (versionSeriesId == null) {
            throw new CmisInvalidArgumentException("Object Id or Object Series Id must be set!");
        }
        ArrayList<ObjectData> result = new ArrayList<ObjectData>();
        CMISNodeInfo info = this.getOrCreateNodeInfo(versionSeriesId, "Version Series");
        if (!info.isVariant(CMISObjectVariant.CURRENT_VERSION)) {
            throw new CmisInvalidArgumentException("Version Series does not exist!");
        }
        NodeRef nodeRef = info.getNodeRef();
        VersionHistory versionHistory = ((CMISNodeInfoImpl)info).getVersionHistory();
        if (versionHistory == null) {
            result.add(this.connector.createCMISObject(info, filter, includeAllowableActions, IncludeRelationships.NONE, "cmis:none", false, false));
            if (this.context.isObjectInfoRequired()) {
                this.getObjectInfo(repositoryId, info.getObjectId(), IncludeRelationships.NONE);
            }
        } else {
            if (info.hasPWC()) {
                CMISNodeInfoImpl pwcInfo = this.createNodeInfo(this.connector.getCheckOutCheckInService().getWorkingCopy(nodeRef));
                result.add(this.connector.createCMISObject(pwcInfo, filter, includeAllowableActions, IncludeRelationships.NONE, "cmis:none", false, false));
                if (this.context.isObjectInfoRequired()) {
                    this.getObjectInfo(repositoryId, pwcInfo.getObjectId(), IncludeRelationships.NONE);
                }
            }
            for (Version version : versionHistory.getAllVersions()) {
                CMISNodeInfoImpl versionInfo = this.createNodeInfo(version.getFrozenStateNodeRef(), versionHistory);
                result.add(this.connector.createCMISObject(versionInfo, filter, includeAllowableActions, IncludeRelationships.NONE, "cmis:none", false, false));
                if (!this.context.isObjectInfoRequired()) continue;
                this.getObjectInfo(repositoryId, versionInfo.getObjectId(), IncludeRelationships.NONE);
            }
        }
        return result;
    }

    public ObjectData getObjectOfLatestVersion(String repositoryId, String objectId, String versionSeriesId, Boolean major, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        if (objectId != null) {
            versionSeriesId = this.connector.getCurrentVersionId(objectId);
        }
        CMISNodeInfo info = this.getOrCreateNodeInfo(versionSeriesId, "Version Series");
        CMISNodeInfoImpl versionInfo = this.createNodeInfo(((CMISNodeInfoImpl)info).getLatestVersionNodeRef(major));
        ObjectData object = this.connector.createCMISObject(versionInfo, filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl);
        if (this.context.isObjectInfoRequired()) {
            this.getObjectInfo(repositoryId, info.getObjectId(), includeRelationships);
        }
        return object;
    }

    public Properties getPropertiesOfLatestVersion(String repositoryId, String objectId, String versionSeriesId, Boolean major, String filter, ExtensionsData extension) {
        CMISNodeInfo info;
        this.checkRepositoryId(repositoryId);
        if (objectId != null) {
            versionSeriesId = this.connector.getCurrentVersionId(objectId);
        }
        if ((info = this.getOrCreateNodeInfo(versionSeriesId, "Version Series")).isVariant(CMISObjectVariant.ASSOC)) {
            return this.connector.getAssocProperties(info, filter);
        }
        CMISNodeInfoImpl versionInfo = this.createNodeInfo(((CMISNodeInfoImpl)info).getLatestVersionNodeRef(major));
        this.addNodeInfo(versionInfo);
        return this.connector.getNodeProperties(versionInfo, filter);
    }

    public void addObjectToFolder(String repositoryId, String objectId, String folderId, Boolean allVersions, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        if (!allVersions.booleanValue()) {
            throw new CmisInvalidArgumentException("Only allVersions=true supported!");
        }
        CMISNodeInfo info = this.getOrCreateNodeInfo(objectId, "Object");
        if (!info.isDocument()) {
            throw new CmisInvalidArgumentException("Object is not a document!");
        }
        NodeRef nodeRef = info.getNodeRef();
        CMISNodeInfo folderInfo = this.getOrCreateFolderInfo(folderId, "Folder");
        this.connector.checkChildObjectType(folderInfo, info.getType().getTypeId());
        QName name = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)((String)((Object)this.connector.getNodeService().getProperty(nodeRef, ContentModel.PROP_NAME)))));
        this.connector.getNodeService().addChild(folderInfo.getNodeRef(), nodeRef, ContentModel.ASSOC_CONTAINS, name);
    }

    public void removeObjectFromFolder(String repositoryId, String objectId, String folderId, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        CMISNodeInfo info = this.getOrCreateNodeInfo(objectId, "Object");
        if (!info.isDocument()) {
            throw new CmisInvalidArgumentException("Object is not a document!");
        }
        NodeRef nodeRef = info.getNodeRef();
        NodeRef folderNodeRef = this.getOrCreateFolderInfo(folderId, "Folder").getNodeRef();
        if (this.connector.getNodeService().getPrimaryParent(nodeRef).getParentRef().equals((Object)folderNodeRef)) {
            throw new CmisConstraintException("Unfiling from primary parent folder is not supported! Use deleteObject() instead.");
        }
        this.connector.getNodeService().removeChild(folderNodeRef, nodeRef);
    }

    public ObjectList getContentChanges(String repositoryId, Holder<String> changeLogToken, Boolean includeProperties, String filter, Boolean includePolicyIds, Boolean includeAcl, BigInteger maxItems, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        return this.connector.getContentChanges(changeLogToken, maxItems);
    }

    public ObjectList query(String repositoryId, String statement, Boolean searchAllVersions, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        if (searchAllVersions.booleanValue()) {
            throw new CmisInvalidArgumentException("Search all version is not supported!");
        }
        return this.connector.query(statement, includeAllowableActions, includeRelationships, renditionFilter, maxItems, skipCount);
    }

    public ObjectList getObjectRelationships(String repositoryId, String objectId, Boolean includeSubRelationshipTypes, RelationshipDirection relationshipDirection, String typeId, String filter, Boolean includeAllowableActions, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        CMISNodeInfo info = this.getOrCreateNodeInfo(objectId, "Object");
        if (info.isVariant(CMISObjectVariant.ASSOC)) {
            throw new CmisInvalidArgumentException("Object is a relationship!");
        }
        if (info.isVariant(CMISObjectVariant.VERSION)) {
            throw new CmisInvalidArgumentException("Object is a document version!");
        }
        if (BaseTypeId.CMIS_RELATIONSHIP.value().equals(typeId)) {
            boolean isrt;
            boolean bl = isrt = includeSubRelationshipTypes == null ? false : includeSubRelationshipTypes;
            if (isrt) {
                typeId = null;
            } else {
                ObjectListImpl result = new ObjectListImpl();
                result.setHasMoreItems(Boolean.valueOf(false));
                result.setNumItems(BigInteger.ZERO);
                result.setObjects(new ArrayList());
                return result;
            }
        }
        return this.connector.getObjectRelationships(info.getNodeRef(), relationshipDirection, typeId, filter, includeAllowableActions, maxItems, skipCount);
    }

    public void applyPolicy(String repositoryId, String policyId, String objectId, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        CMISNodeInfo info = this.getOrCreateNodeInfo(objectId, "Object");
        TypeDefinitionWrapper type = info.getType();
        if (type == null) {
            throw new CmisObjectNotFoundException("No corresponding type found! Not a CMIS object?");
        }
        this.connector.applyPolicies(info.getNodeRef(), type, Collections.singletonList(policyId));
    }

    public void removePolicy(String repositoryId, String policyId, String objectId, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        CMISNodeInfo info = this.getOrCreateNodeInfo(objectId, "Object");
        TypeDefinitionWrapper type = info.getType();
        if (type == null) {
            throw new CmisObjectNotFoundException("No corresponding type found! Not a CMIS object?");
        }
        throw new CmisConstraintException("Object is not policy controllable!");
    }

    public List<ObjectData> getAppliedPolicies(String repositoryId, String objectId, String filter, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.getOrCreateNodeInfo(objectId, "Object");
        return Collections.emptyList();
    }

    public Acl applyAcl(String repositoryId, String objectId, Acl addAces, Acl removeAces, AclPropagation aclPropagation, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        CMISNodeInfo info = this.getOrCreateNodeInfo(objectId, "Object");
        if (info.isVariant(CMISObjectVariant.ASSOC)) {
            throw new CmisConstraintException("Relationships are not ACL controllable!");
        }
        NodeRef nodeRef = info.getCurrentNodeNodeRef();
        TypeDefinitionWrapper type = info.getType();
        this.connector.applyACL(nodeRef, type, addAces, removeAces);
        return this.connector.getACL(nodeRef, false);
    }

    public Acl applyAcl(String repositoryId, String objectId, Acl aces, AclPropagation aclPropagation) {
        this.checkRepositoryId(repositoryId);
        CMISNodeInfo info = this.getOrCreateNodeInfo(objectId, "Object");
        if (info.isVariant(CMISObjectVariant.ASSOC)) {
            throw new CmisConstraintException("Relationships are not ACL controllable!");
        }
        NodeRef nodeRef = info.getCurrentNodeNodeRef();
        TypeDefinitionWrapper type = info.getType();
        this.connector.applyACL(nodeRef, type, aces);
        return this.connector.getACL(nodeRef, false);
    }

    public Acl getAcl(String repositoryId, String objectId, Boolean onlyBasicPermissions, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        CMISNodeInfo info = this.getOrCreateNodeInfo(objectId, "Object");
        if (info.isVariant(CMISObjectVariant.ASSOC)) {
            return new AccessControlListImpl(Collections.EMPTY_LIST);
        }
        return this.connector.getACL(info.getCurrentNodeNodeRef(), onlyBasicPermissions);
    }

    public ObjectInfo getObjectInfo(String repositoryId, String objectId) {
        return this.getObjectInfo(repositoryId, objectId, null, IncludeRelationships.BOTH);
    }

    protected ObjectInfo getObjectInfo(String repositoryId, String objectId, IncludeRelationships includeRelationships) {
        return this.getObjectInfo(repositoryId, objectId, null, includeRelationships);
    }

    protected ObjectInfo getObjectInfo(String repositoryId, String objectId, String filter, IncludeRelationships includeRelationships) {
        ObjectInfo info = this.objectInfoMap.get(objectId);
        if (info == null) {
            CMISNodeInfo nodeInfo = this.getOrCreateNodeInfo(objectId);
            if (nodeInfo.getObjectVariant() == CMISObjectVariant.INVALID_ID || nodeInfo.getObjectVariant() == CMISObjectVariant.NOT_EXISTING || nodeInfo.getObjectVariant() == CMISObjectVariant.NOT_A_CMIS_OBJECT || nodeInfo.getObjectVariant() == CMISObjectVariant.PERMISSION_DENIED) {
                info = null;
            } else {
                try {
                    if (filter == null) {
                        filter = MIN_FILTER;
                    } else if (!filter.equals("*")) {
                        filter = filter + "," + MIN_FILTER;
                    }
                    ObjectData object = this.connector.createCMISObject(nodeInfo, filter, false, includeRelationships, null, false, false);
                    info = this.getObjectInfoIntern(repositoryId, object);
                    this.objectInfoMap.put(objectId, info);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    info = null;
                }
            }
        }
        return info;
    }

    protected ObjectInfo getObjectInfoIntern(String repositoryId, ObjectData object) {
        if (object.getProperties() == null || object.getProperties().getProperties() == null) {
            throw new CmisRuntimeException("No properties!");
        }
        CMISNodeInfo ni = this.getOrCreateNodeInfo(object.getId());
        ObjectInfoImpl info = new ObjectInfoImpl();
        info.setObject(object);
        info.setId(object.getId());
        info.setName(ni.getName());
        info.setCreatedBy(this.getStringProperty(object, "cmis:createdBy"));
        info.setCreationDate(this.getDateTimeProperty(object, "cmis:creationDate"));
        info.setLastModificationDate(this.getDateTimeProperty(object, "cmis:lastModificationDate"));
        info.setTypeId(this.getIdProperty(object, "cmis:objectTypeId"));
        info.setBaseType(object.getBaseTypeId());
        if (ni.isRelationship()) {
            info.setWorkingCopyId(null);
            info.setWorkingCopyOriginalId(null);
            info.setVersionSeriesId(null);
            info.setIsCurrentVersion(true);
            info.setWorkingCopyId(null);
            info.setWorkingCopyOriginalId(null);
            info.setHasContent(false);
            info.setContentType(null);
            info.setFileName(null);
            info.setHasParent(false);
            info.setSupportsRelationships(false);
            info.setSupportsPolicies(false);
            info.setRenditionInfos(null);
            info.setRelationshipSourceIds(null);
            info.setRelationshipTargetIds(null);
            info.setHasAcl(false);
            info.setSupportsDescendants(false);
            info.setSupportsFolderTree(false);
        } else if (ni.isFolder()) {
            info.setWorkingCopyId(null);
            info.setWorkingCopyOriginalId(null);
            info.setVersionSeriesId(null);
            info.setIsCurrentVersion(true);
            info.setWorkingCopyId(null);
            info.setWorkingCopyOriginalId(null);
            info.setHasContent(false);
            info.setContentType(null);
            info.setFileName(null);
            info.setHasParent(!ni.isRootFolder());
            info.setSupportsRelationships(true);
            info.setSupportsPolicies(true);
            info.setRenditionInfos(null);
            this.setRelaionshipsToObjectInfo(object, info);
            info.setHasAcl(true);
            info.setSupportsDescendants(true);
            info.setSupportsFolderTree(true);
        } else if (ni.isDocument()) {
            boolean hasContent;
            info.setWorkingCopyId(null);
            info.setWorkingCopyOriginalId(null);
            info.setVersionSeriesId(ni.getCurrentNodeId());
            if (ni.isPWC()) {
                info.setIsCurrentVersion(false);
                info.setWorkingCopyId(ni.getObjectId());
                info.setWorkingCopyOriginalId(ni.getCurrentObjectId());
            } else {
                info.setIsCurrentVersion(ni.isCurrentVersion());
                if (ni.hasPWC()) {
                    info.setWorkingCopyId(ni.getCurrentNodeId() + ';' + "pwc");
                    info.setWorkingCopyOriginalId(ni.getCurrentObjectId());
                } else {
                    info.setWorkingCopyId(null);
                    info.setWorkingCopyOriginalId(null);
                }
            }
            String fileName = this.getStringProperty(object, "cmis:contentStreamFileName");
            String mimeType = this.getStringProperty(object, "cmis:contentStreamMimeType");
            String streamId = this.getIdProperty(object, "cmis:contentStreamId");
            BigInteger length = this.getIntegerProperty(object, "cmis:contentStreamLength");
            boolean bl = hasContent = fileName != null || mimeType != null || streamId != null || length != null;
            if (hasContent) {
                info.setHasContent(hasContent);
                info.setContentType(mimeType);
                info.setFileName(fileName);
            } else {
                info.setHasContent(false);
                info.setContentType(null);
                info.setFileName(null);
            }
            info.setHasParent(ni.isCurrentVersion() || ni.isPWC());
            info.setSupportsRelationships(true);
            info.setSupportsPolicies(true);
            info.setRenditionInfos(null);
            List renditions = object.getRenditions();
            if (renditions != null && renditions.size() > 0) {
                ArrayList<RenditionInfoImpl> renditionInfos = new ArrayList<RenditionInfoImpl>();
                for (RenditionData rendition : renditions) {
                    RenditionInfoImpl renditionInfo = new RenditionInfoImpl();
                    renditionInfo.setId(rendition.getStreamId());
                    renditionInfo.setKind(rendition.getKind());
                    renditionInfo.setContentType(rendition.getMimeType());
                    renditionInfo.setTitle(rendition.getTitle());
                    renditionInfo.setLength(rendition.getBigLength());
                    renditionInfos.add(renditionInfo);
                }
                info.setRenditionInfos(renditionInfos);
            }
            this.setRelaionshipsToObjectInfo(object, info);
            info.setHasAcl(true);
            info.setSupportsDescendants(true);
            info.setSupportsFolderTree(true);
        }
        return info;
    }

    private void setRelaionshipsToObjectInfo(ObjectData object, ObjectInfoImpl info) {
        info.setRelationshipSourceIds(null);
        info.setRelationshipTargetIds(null);
        List relationships = object.getRelationships();
        if (relationships != null && relationships.size() > 0) {
            ArrayList<String> sourceIds = new ArrayList<String>();
            ArrayList<String> targetIds = new ArrayList<String>();
            for (ObjectData relationship : relationships) {
                String sourceId = this.getIdProperty(relationship, "cmis:sourceId");
                String targetId = this.getIdProperty(relationship, "cmis:targetId");
                if (object.getId().equals(sourceId)) {
                    sourceIds.add(relationship.getId());
                }
                if (!object.getId().equals(targetId)) continue;
                targetIds.add(relationship.getId());
            }
            if (sourceIds.size() > 0) {
                info.setRelationshipSourceIds(sourceIds);
            }
            if (targetIds.size() > 0) {
                info.setRelationshipTargetIds(targetIds);
            }
        }
    }

    private void checkRepositoryId(String repositoryId) {
        if (!this.connector.getRepositoryId().equals(repositoryId)) {
            throw new CmisObjectNotFoundException("Unknown repository '" + repositoryId + "'!");
        }
    }

    private Charset getEncoding(File tempFile, String mimeType) {
        Charset encoding = null;
        try {
            BufferedInputStream tfis = new BufferedInputStream(new FileInputStream(tempFile));
            ContentCharsetFinder charsetFinder = this.connector.getMimetypeService().getContentCharsetFinder();
            encoding = charsetFinder.getCharset((InputStream)tfis, mimeType);
            ((InputStream)tfis).close();
        }
        catch (Exception e) {
            throw new CmisStorageException("Unable to read content: " + e.getMessage(), (Throwable)e);
        }
        return encoding;
    }

    private File copyToTempFile(ContentStream contentStream) {
        File tempFile = null;
        if (contentStream == null) {
            return tempFile;
        }
        int bufferSize = 40560;
        long count = 0L;
        try {
            tempFile = TempFileProvider.createTempFile((String)"cmis", (String)"content");
            if (contentStream.getStream() != null) {
                int i;
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tempFile), bufferSize);
                InputStream in = contentStream.getStream();
                byte[] buffer = new byte[bufferSize];
                while ((i = in.read(buffer)) > -1) {
                    ((OutputStream)out).write(buffer, 0, i);
                    count += (long)i;
                }
                in.close();
                ((OutputStream)out).close();
            }
        }
        catch (Exception e) {
            this.removeTempFile(tempFile);
            throw new CmisStorageException("Unable to store content: " + e.getMessage(), (Throwable)e);
        }
        if (contentStream.getLength() > -1L && contentStream.getLength() != count) {
            this.removeTempFile(tempFile);
            throw new CmisStorageException("Expected " + contentStream.getLength() + " bytes but retrieved " + count + "bytes!");
        }
        return tempFile;
    }

    private void removeTempFile(File tempFile) {
        if (tempFile == null) {
            return;
        }
        try {
            tempFile.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

