/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis;

import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import net.sf.acegisecurity.AccessDeniedException;
import org.alfresco.model.ContentModel;
import org.alfresco.opencmis.ActivityPoster;
import org.alfresco.opencmis.ActivityPosterImpl;
import org.alfresco.opencmis.CMISNodeInfoImpl;
import org.alfresco.opencmis.CMISRenditionMapping;
import org.alfresco.opencmis.RangeInputStream;
import org.alfresco.opencmis.dictionary.CMISActionEvaluator;
import org.alfresco.opencmis.dictionary.CMISAllowedActionEnum;
import org.alfresco.opencmis.dictionary.CMISDictionaryService;
import org.alfresco.opencmis.dictionary.CMISNodeInfo;
import org.alfresco.opencmis.dictionary.CMISObjectVariant;
import org.alfresco.opencmis.dictionary.CMISPropertyAccessor;
import org.alfresco.opencmis.dictionary.DocumentTypeDefinitionWrapper;
import org.alfresco.opencmis.dictionary.PropertyDefinitionWrapper;
import org.alfresco.opencmis.dictionary.TypeDefinitionWrapper;
import org.alfresco.opencmis.mapping.DirectProperty;
import org.alfresco.opencmis.search.CMISQueryOptions;
import org.alfresco.opencmis.search.CMISQueryService;
import org.alfresco.opencmis.search.CMISResultSet;
import org.alfresco.opencmis.search.CMISResultSetColumn;
import org.alfresco.opencmis.search.CMISResultSetRow;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.model.filefolder.HiddenAspect;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.PermissionReference;
import org.alfresco.repo.security.permissions.impl.AccessPermissionImpl;
import org.alfresco.repo.security.permissions.impl.ModelDAO;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.tenant.TenantDeployer;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.audit.AuditQueryParameters;
import org.alfresco.service.cmr.audit.AuditService;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.InvalidAspectException;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.rendition.RenditionService;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.cmr.version.VersionType;
import org.alfresco.service.descriptor.Descriptor;
import org.alfresco.service.descriptor.DescriptorService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.FileFilterMode;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AclCapabilities;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.ChangeEventInfo;
import org.apache.chemistry.opencmis.commons.data.CmisExtensionElement;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.PermissionMapping;
import org.apache.chemistry.opencmis.commons.data.PolicyIdList;
import org.apache.chemistry.opencmis.commons.data.Principal;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.PropertyId;
import org.apache.chemistry.opencmis.commons.data.PropertyString;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.data.RepositoryCapabilities;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.DocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PermissionDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.CapabilityAcl;
import org.apache.chemistry.opencmis.commons.enums.CapabilityChanges;
import org.apache.chemistry.opencmis.commons.enums.CapabilityContentStreamUpdates;
import org.apache.chemistry.opencmis.commons.enums.CapabilityJoin;
import org.apache.chemistry.opencmis.commons.enums.CapabilityQuery;
import org.apache.chemistry.opencmis.commons.enums.CapabilityRenditions;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.enums.ChangeType;
import org.apache.chemistry.opencmis.commons.enums.ContentStreamAllowed;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.apache.chemistry.opencmis.commons.enums.RelationshipDirection;
import org.apache.chemistry.opencmis.commons.enums.SupportedPermissions;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisContentAlreadyExistsException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStreamNotSupportedException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractPropertyData;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlEntryImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlPrincipalDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AclCapabilitiesDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AllowableActionsImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ChangeEventInfoDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.CmisExtensionElementImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PermissionDefinitionDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PermissionMappingDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PolicyIdListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertiesImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyBooleanImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDateTimeImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDecimalImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyHtmlImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIdImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIntegerImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyStringImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyUriImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RepositoryCapabilitiesImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RepositoryInfoImpl;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationContextEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

public class CMISConnector
implements ApplicationContextAware,
ApplicationListener<ApplicationContextEvent>,
TenantDeployer {
    public static final char ID_SEPERATOR = ';';
    public static final String ASSOC_ID_PREFIX = "assoc:";
    public static final String PWC_VERSION_LABEL = "pwc";
    public static final String UNVERSIONED_VERSION_LABEL = "1.0";
    public static final String RENDITION_NONE = "cmis:none";
    public static final String CMIS_CHANGELOG_AUDIT_APPLICATION = "CMISChangeLog";
    public static final String ALFRESCO_EXTENSION_NAMESPACE = "http://www.alfresco.org";
    public static final String CMIS_NAMESPACE = "http://docs.oasis-open.org/ns/cmis/core/200908/";
    public static final String ASPECTS = "aspects";
    public static final String SET_ASPECTS = "setAspects";
    public static final String APPLIED_ASPECTS = "appliedAspects";
    public static final String ASPECTS_TO_ADD = "aspectsToAdd";
    public static final String ASPECTS_TO_REMOVE = "aspectsToRemove";
    public static final String PROPERTIES = "properties";
    private static final BigInteger TYPES_DEFAULT_MAX_ITEMS = BigInteger.valueOf(50L);
    private static final BigInteger TYPES_DEFAULT_DEPTH = BigInteger.valueOf(-1L);
    private static final BigInteger OBJECTS_DEFAULT_MAX_ITEMS = BigInteger.valueOf(200L);
    private static final BigInteger OBJECTS_DEFAULT_DEPTH = BigInteger.valueOf(10L);
    private static final String QUERY_NAME_OBJECT_ID = "cmis:objectId";
    private static final String QUERY_NAME_OBJECT_TYPE_ID = "cmis:objectTypeId";
    private static final String QUERY_NAME_BASE_TYPE_ID = "cmis:baseTypeId";
    private static final String CMIS_USER = "cmis:user";
    private ProcessorLifecycle lifecycle = new ProcessorLifecycle();
    private DescriptorService descriptorService;
    private NodeService nodeService;
    private VersionService versionService;
    private CheckOutCheckInService checkOutCheckInService;
    private LockService lockService;
    private ContentService contentService;
    private RenditionService renditionService;
    private FileFolderService fileFolderService;
    private TenantAdminService tenantAdminService;
    private TransactionService transactionService;
    private AuthenticationService authenticationService;
    private PermissionService permissionService;
    private ModelDAO permissionModelDao;
    private CMISDictionaryService cmisDictionaryService;
    private CMISQueryService cmisQueryService;
    private MimetypeService mimetypeService;
    private AuditService auditService;
    private NamespaceService namespaceService;
    private SearchService searchService;
    private DictionaryService dictionaryService;
    private SiteService siteService;
    private ActivityPoster activityPoster;
    private BehaviourFilter behaviourFilter;
    private HiddenAspect hiddenAspect;
    private StoreRef storeRef;
    private String rootPath;
    private Map<String, List<String>> kindToRenditionNames;
    private SimpleCache<String, Object> singletonCache;
    private final String KEY_CMIS_ROOT_NODEREF = "key.cmisRoot.noderef";
    private final String KEY_CMIS_RENDITION_MAPPING_NODEREF = "key.cmisRenditionMapping.noderef";
    private String proxyUser;
    private boolean openHttpSession = false;
    private BigInteger typesDefaultMaxItems = TYPES_DEFAULT_MAX_ITEMS;
    private BigInteger typesDefaultDepth = TYPES_DEFAULT_DEPTH;
    private BigInteger objectsDefaultMaxItems = OBJECTS_DEFAULT_MAX_ITEMS;
    private BigInteger objectsDefaultDepth = OBJECTS_DEFAULT_DEPTH;
    private List<PermissionDefinition> repositoryPermissions;
    private Map<String, PermissionMapping> permissionMappings;

    public void setStore(String store) {
        this.storeRef = new StoreRef(store);
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setActivityPoster(ActivityPoster activityPoster) {
        this.activityPoster = activityPoster;
    }

    public ActivityPoster getActivityPoster() {
        return this.activityPoster;
    }

    public void setHiddenAspect(HiddenAspect hiddenAspect) {
        this.hiddenAspect = hiddenAspect;
    }

    public boolean isHidden(NodeRef nodeRef) {
        FileFilterMode.Client client = FileFilterMode.getClient();
        return this.hiddenAspect.getVisibility(client, nodeRef) == HiddenAspect.Visibility.NotVisible;
    }

    public void setRootPath(String path) {
        this.rootPath = path;
    }

    public BigInteger getTypesDefaultMaxItems() {
        return this.typesDefaultMaxItems;
    }

    public void setTypesDefaultMaxItems(BigInteger typesDefaultMaxItems) {
        this.typesDefaultMaxItems = typesDefaultMaxItems;
    }

    public BigInteger getTypesDefaultDepth() {
        return this.typesDefaultDepth;
    }

    public void setTypesDefaultDepth(BigInteger typesDefaultDepth) {
        this.typesDefaultDepth = typesDefaultDepth;
    }

    public BigInteger getObjectsDefaultMaxItems() {
        return this.objectsDefaultMaxItems;
    }

    public void setObjectsDefaultMaxItems(BigInteger objectsDefaultMaxItems) {
        this.objectsDefaultMaxItems = objectsDefaultMaxItems;
    }

    public BigInteger getObjectsDefaultDepth() {
        return this.objectsDefaultDepth;
    }

    public void setObjectsDefaultDepth(BigInteger objectsDefaultDepth) {
        this.objectsDefaultDepth = objectsDefaultDepth;
    }

    public void setRenditionKindMapping(Map<String, List<String>> renditionKinds) {
        this.kindToRenditionNames = renditionKinds;
    }

    public void setOpenHttpSession(boolean openHttpSession) {
        this.openHttpSession = openHttpSession;
    }

    public boolean openHttpSession() {
        return this.openHttpSession;
    }

    public void setDescriptorService(DescriptorService descriptorService) {
        this.descriptorService = descriptorService;
    }

    public DescriptorService getDescriptorService() {
        return this.descriptorService;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public NodeService getNodeService() {
        return this.nodeService;
    }

    public void setVersionService(VersionService versionService) {
        this.versionService = versionService;
    }

    public VersionService getVersionService() {
        return this.versionService;
    }

    public void setCheckOutCheckInService(CheckOutCheckInService checkOutCheckInService) {
        this.checkOutCheckInService = checkOutCheckInService;
    }

    public CheckOutCheckInService getCheckOutCheckInService() {
        return this.checkOutCheckInService;
    }

    public LockService getLockService() {
        return this.lockService;
    }

    public void setLockService(LockService lockService) {
        this.lockService = lockService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setrenditionService(RenditionService renditionService) {
        this.renditionService = renditionService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public FileFolderService getFileFolderService() {
        return this.fileFolderService;
    }

    public void setTenantAdminService(TenantAdminService tenantAdminService) {
        this.tenantAdminService = tenantAdminService;
    }

    public void setSingletonCache(SimpleCache<String, Object> singletonCache) {
        this.singletonCache = singletonCache;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public TransactionService getTransactionService() {
        return this.transactionService;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setPermissionModelDao(ModelDAO permissionModelDao) {
        this.permissionModelDao = permissionModelDao;
    }

    public void setOpenCMISDictionaryService(CMISDictionaryService cmisDictionaryService) {
        this.cmisDictionaryService = cmisDictionaryService;
    }

    public CMISDictionaryService getOpenCMISDictionaryService() {
        return this.cmisDictionaryService;
    }

    public void setOpenCMISQueryService(CMISQueryService cmisQueryService) {
        this.cmisQueryService = cmisQueryService;
    }

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    public MimetypeService getMimetypeService() {
        return this.mimetypeService;
    }

    public void setAuditService(AuditService auditService) {
        this.auditService = auditService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public SearchService getSearchService() {
        return this.searchService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public DictionaryService getDictionaryService() {
        return this.dictionaryService;
    }

    public void setProxyUser(String proxyUser) {
        throw new UnsupportedOperationException("proxyUser setting not implemented.  Please raise a JIRA request.");
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public void init() {
        this.tenantAdminService.register(this);
        this.getRenditionMapping();
        this.getRootNodeRef();
        this.repositoryPermissions = this.getRepositoryPermissions();
        this.permissionMappings = this.getPermissionMappings();
    }

    public void destroy() {
        this.singletonCache.remove((Serializable)((Object)"key.cmisRoot.noderef"));
        this.singletonCache.remove((Serializable)((Object)"key.cmisRenditionMapping.noderef"));
    }

    public void onEnableTenant() {
        this.init();
    }

    public void onDisableTenant() {
        this.destroy();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.lifecycle.setApplicationContext(applicationContext);
    }

    public void onApplicationEvent(ApplicationContextEvent event) {
        this.lifecycle.onApplicationEvent((ApplicationEvent)event);
    }

    public SiteInfo getSite(NodeRef nodeRef) {
        return this.siteService.getSite(nodeRef);
    }

    public boolean disableBehaviour(QName className, NodeRef nodeRef) {
        boolean wasEnabled = this.behaviourFilter.isEnabled(nodeRef, className);
        if (wasEnabled) {
            this.behaviourFilter.disableBehaviour(nodeRef, className);
        }
        return wasEnabled;
    }

    public boolean enableBehaviour(QName className, NodeRef nodeRef) {
        boolean isEnabled = this.behaviourFilter.isEnabled(nodeRef, className);
        if (!isEnabled) {
            this.behaviourFilter.enableBehaviour(nodeRef, className);
        }
        return isEnabled;
    }

    public StoreRef getRootStoreRef() {
        return this.getRootNodeRef().getStoreRef();
    }

    public void deleteNode(NodeRef nodeRef, boolean postActivity) {
        ActivityPosterImpl.ActivityInfo activityInfo = null;
        if (postActivity &= this.hiddenAspect.getVisibility(FileFilterMode.Client.cmis, nodeRef) == HiddenAspect.Visibility.Visible) {
            activityInfo = this.activityPoster.getActivityInfo(nodeRef);
        }
        this.getNodeService().deleteNode(nodeRef);
        if (postActivity && activityInfo != null) {
            this.activityPoster.postFileFolderDeleted(activityInfo);
        }
    }

    public NodeRef getRootNodeRef() {
        NodeRef rootNodeRef = (NodeRef)this.singletonCache.get((Serializable)((Object)"key.cmisRoot.noderef"));
        if (rootNodeRef == null) {
            rootNodeRef = (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

                public NodeRef doWork() throws Exception {
                    return CMISConnector.this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

                        @Override
                        public NodeRef execute() throws Exception {
                            NodeRef root = CMISConnector.this.nodeService.getRootNode(CMISConnector.this.storeRef);
                            List rootNodes = CMISConnector.this.searchService.selectNodes(root, CMISConnector.this.rootPath, null, (NamespacePrefixResolver)CMISConnector.this.namespaceService, false);
                            if (rootNodes.size() != 1) {
                                throw new CmisRuntimeException("Unable to locate CMIS root path " + CMISConnector.this.rootPath);
                            }
                            return (NodeRef)rootNodes.get(0);
                        }
                    }, true);
                }
            }, (String)AuthenticationUtil.getSystemUserName());
            if (rootNodeRef == null) {
                throw new CmisObjectNotFoundException("Root folder path '" + this.rootPath + "' not found!");
            }
            this.singletonCache.put((Serializable)((Object)"key.cmisRoot.noderef"), (Object)rootNodeRef);
        }
        return rootNodeRef;
    }

    public String getName(NodeRef nodeRef) {
        try {
            Serializable name = this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME);
            return name instanceof String ? (String)((Object)name) : null;
        }
        catch (InvalidNodeRefException inre) {
            return null;
        }
    }

    public String getCurrentVersionId(String objectId) {
        if (objectId == null) {
            return null;
        }
        int sepIndex = objectId.lastIndexOf(59);
        if (sepIndex > -1) {
            return objectId.substring(0, sepIndex);
        }
        return objectId;
    }

    public CMISNodeInfoImpl createNodeInfo(String objectId) {
        return new CMISNodeInfoImpl(this, objectId);
    }

    public CMISNodeInfoImpl createNodeInfo(NodeRef nodeRef) {
        return this.createNodeInfo(nodeRef, null);
    }

    public CMISNodeInfoImpl createNodeInfo(NodeRef nodeRef, VersionHistory versionHistory) {
        return new CMISNodeInfoImpl(this, nodeRef, versionHistory);
    }

    public CMISNodeInfoImpl createNodeInfo(AssociationRef assocRef) {
        return new CMISNodeInfoImpl(this, assocRef);
    }

    public String createObjectId(NodeRef currentVersionNodeRef) {
        if (this.getFileFolderService().getFileInfo(currentVersionNodeRef).isFolder()) {
            return currentVersionNodeRef.toString();
        }
        Object versionLabel = this.getNodeService().getProperty(currentVersionNodeRef, ContentModel.PROP_VERSION_LABEL);
        if (versionLabel == null) {
            versionLabel = UNVERSIONED_VERSION_LABEL;
        }
        return currentVersionNodeRef.toString() + ';' + versionLabel;
    }

    public TypeDefinitionWrapper getType(NodeRef nodeRef) {
        try {
            QName typeQName = this.nodeService.getType(nodeRef);
            return this.getType(typeQName);
        }
        catch (InvalidNodeRefException inre) {
            return null;
        }
    }

    private TypeDefinitionWrapper getType(QName typeQName) {
        return this.cmisDictionaryService.findNodeType(typeQName);
    }

    public TypeDefinitionWrapper getType(AssociationRef assocRef) {
        QName typeQName = assocRef.getTypeQName();
        return this.cmisDictionaryService.findAssocType(typeQName);
    }

    public TypeDefinitionWrapper getType(String cmisTypeId) {
        return this.cmisDictionaryService.findType(cmisTypeId);
    }

    public TypeDefinitionWrapper getTypeForCreate(String cmisTypeId, BaseTypeId baseTypeId) {
        TypeDefinitionWrapper type = this.getType(cmisTypeId);
        if (type == null || type.getBaseTypeId() != baseTypeId) {
            switch (baseTypeId) {
                case CMIS_DOCUMENT: {
                    throw new CmisConstraintException("Type is not a document type!");
                }
                case CMIS_FOLDER: {
                    throw new CmisConstraintException("Type is not a folder type!");
                }
                case CMIS_RELATIONSHIP: {
                    throw new CmisConstraintException("Type is not a relationship type!");
                }
                case CMIS_POLICY: {
                    throw new CmisConstraintException("Type is not a policy type!");
                }
            }
        }
        if (!type.getTypeDefinition(false).isCreatable().booleanValue()) {
            throw new CmisConstraintException("Type is not creatable!");
        }
        return type;
    }

    public void applyVersioningState(NodeRef nodeRef, VersioningState versioningState) {
        if (versioningState == VersioningState.CHECKEDOUT) {
            if (!this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE)) {
                HashMap<QName, Boolean> props = new HashMap<QName, Boolean>();
                props.put(ContentModel.PROP_INITIAL_VERSION, false);
                props.put(ContentModel.PROP_AUTO_VERSION, false);
                this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE, props);
            }
            this.getCheckOutCheckInService().checkout(nodeRef);
        } else if (versioningState == VersioningState.MAJOR || versioningState == VersioningState.MINOR) {
            if (!this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE)) {
                HashMap<QName, Boolean> props = new HashMap<QName, Boolean>();
                props.put(ContentModel.PROP_INITIAL_VERSION, false);
                props.put(ContentModel.PROP_AUTO_VERSION, false);
                this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE, props);
            }
            HashMap<String, Serializable> versionProperties = new HashMap<String, Serializable>(5);
            versionProperties.put("versionType", (Serializable)((Object)(versioningState == VersioningState.MAJOR ? VersionType.MAJOR : VersionType.MINOR)));
            versionProperties.put("description", (Serializable)((Object)"Initial Version"));
            this.versionService.createVersion(nodeRef, versionProperties);
        }
    }

    public void checkChildObjectType(CMISNodeInfo folderInfo, String childType) {
        TypeDefinitionWrapper targetType = folderInfo.getType();
        PropertyDefinitionWrapper allowableChildObjectTypeProperty = targetType.getPropertyById("cmis:allowedChildObjectTypeIds");
        List childTypes = (List)((Object)allowableChildObjectTypeProperty.getPropertyAccessor().getValue(folderInfo));
        if (childTypes == null || childTypes.isEmpty()) {
            return;
        }
        if (!childTypes.contains(childType)) {
            throw new CmisConstraintException("Objects of type '" + childType + "' cannot be added to this folder!");
        }
    }

    public ObjectData createCMISObject(CMISNodeInfo info, FileInfo node, String filter, boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, boolean includePolicyIds, boolean includeAcl) {
        if (info.getType() == null) {
            throw new CmisObjectNotFoundException("No corresponding type found! Not a CMIS object?");
        }
        Properties nodeProps = this.getNodeProperties(info, node, filter, info.getType());
        return this.createCMISObjectImpl(info, nodeProps, filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl);
    }

    public ObjectData createCMISObject(CMISNodeInfo info, String filter, boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, boolean includePolicyIds, boolean includeAcl) {
        if (info.getType() == null) {
            throw new CmisObjectNotFoundException("No corresponding type found! Not a CMIS object?");
        }
        Properties nodeProps = info.isRelationship() ? this.getAssocProperties(info, filter) : this.getNodeProperties(info, filter);
        return this.createCMISObjectImpl(info, nodeProps, filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl);
    }

    private ObjectData createCMISObjectImpl(CMISNodeInfo info, Properties nodeProps, String filter, boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, boolean includePolicyIds, boolean includeAcl) {
        ObjectDataImpl result = new ObjectDataImpl();
        if (includeAllowableActions) {
            result.setAllowableActions(this.getAllowableActions(info));
        }
        if (includePolicyIds) {
            result.setPolicyIds((PolicyIdList)new PolicyIdListImpl());
        }
        if (info.isRelationship()) {
            result.setProperties(this.getAssocProperties(info, filter));
            if (includeAcl) {
                result.setAcl((Acl)new AccessControlListImpl(Collections.EMPTY_LIST));
            }
        } else {
            List<CmisExtensionElement> extensions;
            List<RenditionData> renditions;
            result.setProperties(nodeProps);
            if (includeRelationships != IncludeRelationships.NONE) {
                result.setRelationships(this.getRelationships(info.getNodeRef(), includeRelationships));
            }
            if (!RENDITION_NONE.equals(renditionFilter) && (renditions = this.getRenditions(info.getNodeRef(), renditionFilter, null, null)) != null && !renditions.isEmpty()) {
                result.setRenditions(renditions);
            }
            if (includeAcl) {
                result.setAcl(this.getACL(info.getCurrentNodeNodeRef(), false));
            }
            if (!(extensions = this.getAspectExtensions(info, filter, result.getProperties().getProperties().keySet())).isEmpty()) {
                result.getProperties().setExtensions(Collections.singletonList(new CmisExtensionElementImpl(ALFRESCO_EXTENSION_NAMESPACE, ASPECTS, null, extensions)));
            }
        }
        return result;
    }

    public String getPath(NodeRef nodeRef) {
        try {
            ChildAssociationRef assocRef;
            NodeRef node;
            Path.Element element;
            int i;
            Path path = this.nodeService.getPath(nodeRef);
            NodeRef rootNode = this.getRootNodeRef();
            for (i = 0; !(i >= path.size() || (element = path.get(i)) instanceof Path.ChildAssocElement && (node = (assocRef = ((Path.ChildAssocElement)element).getRef()).getChildRef()).equals((Object)rootNode)); ++i) {
            }
            StringBuilder displayPath = new StringBuilder(64);
            if (path.size() - i == 1) {
                displayPath.append("/");
            } else {
                ++i;
                while (i < path.size()) {
                    Path.Element element2 = path.get(i);
                    if (element2 instanceof Path.ChildAssocElement) {
                        ChildAssociationRef assocRef2 = ((Path.ChildAssocElement)element2).getRef();
                        NodeRef node2 = assocRef2.getChildRef();
                        displayPath.append("/");
                        displayPath.append(this.nodeService.getProperty(node2, ContentModel.PROP_NAME));
                    }
                    ++i;
                }
            }
            return displayPath.toString();
        }
        catch (InvalidNodeRefException inre) {
            return null;
        }
    }

    public ContentStream getContentStream(CMISNodeInfo info, String streamId, BigInteger offset, BigInteger length) {
        TypeDefinitionWrapper type = info.getType();
        this.checkDocumentTypeForContent(type);
        ContentStreamImpl result = new ContentStreamImpl();
        result.setFileName(info.getName());
        NodeRef streamNodeRef = info.getNodeRef();
        if (streamId != null && streamId.length() > 0) {
            CMISNodeInfoImpl streamInfo = this.createNodeInfo(streamId);
            if (!streamInfo.isVariant(CMISObjectVariant.CURRENT_VERSION)) {
                throw new CmisInvalidArgumentException("Stream id is invalid: " + streamId);
            }
            streamNodeRef = streamInfo.getNodeRef();
            type = streamInfo.getType();
            this.checkDocumentTypeForContent(type);
        }
        try {
            ContentReader contentReader = this.contentService.getReader(streamNodeRef, ContentModel.PROP_CONTENT);
            if (contentReader == null) {
                throw new CmisConstraintException("Document has no content!");
            }
            result.setMimeType(contentReader.getMimetype());
            if (offset == null && length == null) {
                result.setStream(contentReader.getContentInputStream());
                result.setLength(BigInteger.valueOf(contentReader.getSize()));
            } else {
                long len;
                long off = offset == null ? 0L : offset.longValue();
                long l = len = length == null ? contentReader.getSize() : length.longValue();
                if (off + len > contentReader.getSize()) {
                    len = contentReader.getSize() - off;
                }
                result.setStream((InputStream)new RangeInputStream(contentReader.getContentInputStream(), off, len));
                result.setLength(BigInteger.valueOf(len));
            }
        }
        catch (Exception e) {
            if (e instanceof CmisBaseException) {
                throw (CmisBaseException)e;
            }
            throw new CmisRuntimeException("Failed to retrieve content: " + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private void checkDocumentTypeForContent(TypeDefinitionWrapper type) {
        if (type == null) {
            throw new CmisObjectNotFoundException("No corresponding type found! Not a CMIS object?");
        }
        if (!(type instanceof DocumentTypeDefinitionWrapper)) {
            throw new CmisStreamNotSupportedException("Object is not a docuemnt!");
        }
        if (((DocumentTypeDefinition)type.getTypeDefinition(false)).getContentStreamAllowed() == ContentStreamAllowed.NOTALLOWED) {
            throw new CmisConstraintException("Document cannot have content!");
        }
    }

    public Properties getNodeProperties(CMISNodeInfo info, String filter) {
        PropertiesImpl result = new PropertiesImpl();
        Set<String> filterSet = this.splitFilter(filter);
        for (PropertyDefinitionWrapper propDef : info.getType().getProperties()) {
            if (!propDef.getPropertyId().equals(QUERY_NAME_OBJECT_ID) && filterSet != null && !filterSet.contains(propDef.getPropertyDefinition().getQueryName())) continue;
            Serializable value = propDef.getPropertyAccessor().getValue(info);
            result.addProperty(this.getProperty(propDef.getPropertyDefinition().getPropertyType(), propDef, value));
        }
        return result;
    }

    public Properties getNodeProperties(CMISNodeInfo info, FileInfo node, String filter, TypeDefinitionWrapper type) {
        PropertiesImpl result = new PropertiesImpl();
        Set<String> filterSet = this.splitFilter(filter);
        Map<QName, Serializable> nodeProps = node.getProperties();
        for (PropertyDefinitionWrapper propDef : type.getProperties()) {
            if (!propDef.getPropertyId().equals(QUERY_NAME_OBJECT_ID) && filterSet != null && !filterSet.contains(propDef.getPropertyDefinition().getQueryName())) continue;
            Serializable value = null;
            CMISPropertyAccessor accessor = propDef.getPropertyAccessor();
            value = accessor instanceof DirectProperty ? nodeProps.get(accessor.getMappedProperty()) : propDef.getPropertyAccessor().getValue(info);
            result.addProperty(this.getProperty(propDef.getPropertyDefinition().getPropertyType(), propDef, value));
        }
        return result;
    }

    public Properties getAssocProperties(CMISNodeInfo info, String filter) {
        PropertiesImpl result = new PropertiesImpl();
        Set<String> filterSet = this.splitFilter(filter);
        for (PropertyDefinitionWrapper propDefWrap : info.getType().getProperties()) {
            PropertyDefinition propDef = propDefWrap.getPropertyDefinition();
            if (filterSet != null && !filterSet.contains(propDef.getQueryName())) continue;
            CMISPropertyAccessor cmisPropertyAccessor = propDefWrap.getPropertyAccessor();
            Serializable value = cmisPropertyAccessor.getValue(info);
            PropertyType propType = propDef.getPropertyType();
            AbstractPropertyData<?> propertyData = this.getProperty(propType, propDefWrap, value);
            result.addProperty(propertyData);
        }
        return result;
    }

    public List<CmisExtensionElement> getAspectExtensions(CMISNodeInfo info, String filter, Set<String> alreadySetProperties) {
        ArrayList<CmisExtensionElement> extensions = new ArrayList<CmisExtensionElement>();
        HashSet<String> propertyIds = new HashSet<String>(alreadySetProperties);
        Set<String> filterSet = this.splitFilter(filter);
        Set aspects = this.nodeService.getAspects(info.getNodeRef());
        for (QName aspect : aspects) {
            TypeDefinitionWrapper aspectType = this.cmisDictionaryService.findNodeType(aspect);
            if (aspectType == null) continue;
            extensions.add((CmisExtensionElement)new CmisExtensionElementImpl(ALFRESCO_EXTENSION_NAMESPACE, APPLIED_ASPECTS, null, aspectType.getTypeId()));
            ArrayList<CmisExtensionElement> propertyExtensionList = new ArrayList<CmisExtensionElement>();
            for (PropertyDefinitionWrapper propDef : aspectType.getProperties()) {
                if (propertyIds.contains(propDef.getPropertyId()) || filterSet != null && !filterSet.contains(propDef.getPropertyDefinition().getQueryName())) continue;
                Serializable value = propDef.getPropertyAccessor().getValue(info);
                propertyExtensionList.add(this.createAspectPropertyExtension(propDef.getPropertyDefinition(), value));
                propertyIds.add(propDef.getPropertyId());
            }
            if (propertyExtensionList.isEmpty()) continue;
            CmisExtensionElementImpl propertiesExtension = new CmisExtensionElementImpl(ALFRESCO_EXTENSION_NAMESPACE, PROPERTIES, null, propertyExtensionList);
            extensions.addAll(Collections.singletonList(propertiesExtension));
        }
        return extensions;
    }

    private CmisExtensionElement createAspectPropertyExtension(PropertyDefinition<?> propertyDefintion, Object value) {
        String name;
        switch (propertyDefintion.getPropertyType()) {
            case BOOLEAN: {
                name = "propertyBoolean";
                break;
            }
            case DATETIME: {
                name = "propertyDateTime";
                break;
            }
            case DECIMAL: {
                name = "propertyDecimal";
                break;
            }
            case INTEGER: {
                name = "propertyInteger";
                break;
            }
            case ID: {
                name = "propertyId";
                break;
            }
            default: {
                name = "propertyString";
            }
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("propertyDefinitionId", propertyDefintion.getId());
        ArrayList<CmisExtensionElementImpl> propertyValues = new ArrayList<CmisExtensionElementImpl>();
        if (value != null) {
            if (value instanceof List) {
                for (Object o : (List)value) {
                    propertyValues.add(new CmisExtensionElementImpl(CMIS_NAMESPACE, "value", null, this.convertAspectPropertyValue(o)));
                }
            } else {
                propertyValues.add(new CmisExtensionElementImpl(CMIS_NAMESPACE, "value", null, this.convertAspectPropertyValue(value)));
            }
        }
        return new CmisExtensionElementImpl(CMIS_NAMESPACE, name, attributes, propertyValues);
    }

    private String convertAspectPropertyValue(Object value) {
        if (value instanceof Date) {
            GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
            cal.setTime((Date)value);
            value = cal;
        }
        if (value instanceof GregorianCalendar) {
            DatatypeFactory df;
            try {
                df = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException e) {
                throw new IllegalArgumentException("Aspect conversation exception: " + e.getMessage(), e);
            }
            return df.newXMLGregorianCalendar((GregorianCalendar)value).toXMLFormat();
        }
        return value.toString();
    }

    private AbstractPropertyData<?> getProperty(PropertyType propType, PropertyDefinitionWrapper propDef, Serializable value) {
        PropertyBooleanImpl result = null;
        switch (propType) {
            case BOOLEAN: {
                result = new PropertyBooleanImpl();
                if (value instanceof List) {
                    result.setValues((List)((Object)value));
                    break;
                }
                result.setValue((Object)((Boolean)value));
                break;
            }
            case DATETIME: {
                result = new PropertyDateTimeImpl();
                if (value instanceof List) {
                    ((PropertyDateTimeImpl)result).setValues((List)DefaultTypeConverter.INSTANCE.convert(GregorianCalendar.class, (Collection)((List)((Object)value))));
                    break;
                }
                ((PropertyDateTimeImpl)result).setValue(DefaultTypeConverter.INSTANCE.convert(GregorianCalendar.class, (Object)value));
                break;
            }
            case DECIMAL: {
                result = new PropertyDecimalImpl();
                if (value instanceof List) {
                    ((PropertyDecimalImpl)result).setValues((List)DefaultTypeConverter.INSTANCE.convert(BigDecimal.class, (Collection)((List)((Object)value))));
                    break;
                }
                ((PropertyDecimalImpl)result).setValue(DefaultTypeConverter.INSTANCE.convert(BigDecimal.class, (Object)value));
                break;
            }
            case HTML: {
                result = new PropertyHtmlImpl();
                if (value instanceof List) {
                    ((PropertyHtmlImpl)result).setValues((List)((Object)value));
                    break;
                }
                ((PropertyHtmlImpl)result).setValue((Object)((String)((Object)value)));
                break;
            }
            case ID: {
                result = new PropertyIdImpl();
                if (value instanceof List) {
                    ((PropertyIdImpl)result).setValues((List)((Object)value));
                    break;
                }
                if (value instanceof NodeRef) {
                    ((PropertyIdImpl)result).setValue((Object)value.toString());
                    break;
                }
                ((PropertyIdImpl)result).setValue((Object)((String)((Object)value)));
                break;
            }
            case INTEGER: {
                result = new PropertyIntegerImpl();
                if (value instanceof List) {
                    ((PropertyIntegerImpl)result).setValues((List)DefaultTypeConverter.INSTANCE.convert(BigInteger.class, (Collection)((List)((Object)value))));
                    break;
                }
                ((PropertyIntegerImpl)result).setValue(DefaultTypeConverter.INSTANCE.convert(BigInteger.class, (Object)value));
                break;
            }
            case STRING: {
                result = new PropertyStringImpl();
                if (value instanceof List) {
                    ((PropertyStringImpl)result).setValues((List)((Object)value));
                    break;
                }
                ((PropertyStringImpl)result).setValue((Object)((String)((Object)value)));
                break;
            }
            case URI: {
                result = new PropertyUriImpl();
                if (value instanceof List) {
                    ((PropertyUriImpl)result).setValues((List)((Object)value));
                    break;
                }
                ((PropertyUriImpl)result).setValue((Object)((String)((Object)value)));
                break;
            }
            default: {
                throw new RuntimeException("Unknown datatype! Spec change?");
            }
        }
        if (propDef != null) {
            result.setId(propDef.getPropertyDefinition().getId());
            result.setQueryName(propDef.getPropertyDefinition().getQueryName());
            result.setDisplayName(propDef.getPropertyDefinition().getDisplayName());
            result.setLocalName(propDef.getPropertyDefinition().getLocalName());
        }
        return result;
    }

    private Set<String> splitFilter(String filter) {
        if (filter == null) {
            return null;
        }
        if (filter.trim().length() == 0) {
            return null;
        }
        HashSet<String> result = new HashSet<String>();
        for (String s : filter.split(",")) {
            if ((s = s.trim()).equals("*")) {
                return null;
            }
            if (s.length() <= 0) continue;
            result.add(s);
        }
        result.add(QUERY_NAME_OBJECT_ID);
        result.add(QUERY_NAME_OBJECT_TYPE_ID);
        result.add(QUERY_NAME_BASE_TYPE_ID);
        return result;
    }

    public AllowableActions getAllowableActions(CMISNodeInfo info) {
        AllowableActionsImpl result = new AllowableActionsImpl();
        HashSet<Action> allowableActions = new HashSet<Action>();
        result.setAllowableActions(allowableActions);
        for (CMISActionEvaluator evaluator : info.getType().getActionEvaluators().values()) {
            if (!evaluator.isAllowed(info)) continue;
            allowableActions.add(evaluator.getAction());
        }
        return result;
    }

    public List<ObjectData> getRelationships(NodeRef nodeRef, IncludeRelationships includeRelationships) {
        ArrayList<ObjectData> result = new ArrayList<ObjectData>();
        if (nodeRef.getStoreRef().getProtocol().equals("versionStore")) {
            return result;
        }
        ArrayList assocs = new ArrayList();
        if (includeRelationships == IncludeRelationships.SOURCE || includeRelationships == IncludeRelationships.BOTH) {
            assocs.addAll(this.nodeService.getTargetAssocs(nodeRef, RegexQNamePattern.MATCH_ALL));
        }
        if (includeRelationships == IncludeRelationships.TARGET || includeRelationships == IncludeRelationships.BOTH) {
            assocs.addAll(this.nodeService.getSourceAssocs(nodeRef, RegexQNamePattern.MATCH_ALL));
        }
        for (AssociationRef assocRef : assocs) {
            TypeDefinitionWrapper assocTypeDef = this.cmisDictionaryService.findAssocType(assocRef.getTypeQName());
            if (assocTypeDef == null || this.getType(assocRef.getSourceRef()) == null || this.getType(assocRef.getTargetRef()) == null) continue;
            try {
                result.add(this.createCMISObject(this.createNodeInfo(assocRef), null, false, IncludeRelationships.NONE, RENDITION_NONE, false, false));
            }
            catch (CmisObjectNotFoundException e) {
            }
            catch (org.alfresco.repo.security.permissions.AccessDeniedException e) {
            }
            catch (AccessDeniedException e) {}
        }
        return result;
    }

    public ObjectList getObjectRelationships(NodeRef nodeRef, RelationshipDirection relationshipDirection, String typeId, String filter, Boolean includeAllowableActions, BigInteger maxItems, BigInteger skipCount) {
        ObjectListImpl result = new ObjectListImpl();
        result.setHasMoreItems(Boolean.valueOf(false));
        result.setNumItems(BigInteger.ZERO);
        result.setObjects(new ArrayList());
        if (nodeRef.getStoreRef().getProtocol().equals("versionStore")) {
            return result;
        }
        ArrayList assocs = new ArrayList();
        if (relationshipDirection == RelationshipDirection.SOURCE || relationshipDirection == RelationshipDirection.EITHER) {
            assocs.addAll(this.nodeService.getTargetAssocs(nodeRef, RegexQNamePattern.MATCH_ALL));
        }
        if (relationshipDirection == RelationshipDirection.TARGET || relationshipDirection == RelationshipDirection.EITHER) {
            assocs.addAll(this.nodeService.getSourceAssocs(nodeRef, RegexQNamePattern.MATCH_ALL));
        }
        int skip = skipCount == null ? 0 : skipCount.intValue();
        int max = maxItems == null ? Integer.MAX_VALUE : maxItems.intValue();
        int counter = 0;
        boolean hasMore = false;
        if (max > 0) {
            for (AssociationRef assocRef : assocs) {
                TypeDefinitionWrapper assocTypeDef = this.cmisDictionaryService.findAssocType(assocRef.getTypeQName());
                if (assocTypeDef == null || this.getType(assocRef.getSourceRef()) == null || this.getType(assocRef.getTargetRef()) == null || typeId != null && !assocTypeDef.getTypeId().equals(typeId)) continue;
                ++counter;
                if (skip > 0) {
                    --skip;
                    continue;
                }
                if (--max > 0) {
                    try {
                        result.getObjects().add(this.createCMISObject(this.createNodeInfo(assocRef), filter, includeAllowableActions, IncludeRelationships.NONE, RENDITION_NONE, false, false));
                    }
                    catch (CmisObjectNotFoundException e) {}
                    continue;
                }
                hasMore = true;
            }
        }
        result.setNumItems(BigInteger.valueOf(counter));
        result.setHasMoreItems(Boolean.valueOf(hasMore));
        return result;
    }

    public List<RenditionData> getRenditions(NodeRef nodeRef, String renditionFilter, BigInteger maxItems, BigInteger skipCount) {
        CMISRenditionMapping mapping = this.getRenditionMapping();
        return mapping.getRenditions(nodeRef, renditionFilter, maxItems, skipCount);
    }

    public Acl getACL(NodeRef nodeRef, boolean onlyBasicPermissions) {
        AccessControlListImpl result = new AccessControlListImpl();
        ArrayList ordered = new ArrayList(this.permissionService.getAllSetPermissions(nodeRef));
        Collections.sort(ordered, new AccessPermissionComparator());
        HashMap aceMap = new HashMap();
        for (AccessPermission entry : ordered) {
            HashMap<Boolean, AccessControlEntryImpl> directAce;
            if (entry.getAccessStatus() == AccessStatus.ALLOWED) {
                AccessControlEntryImpl ace;
                directAce = (HashMap<Boolean, AccessControlEntryImpl>)aceMap.get(entry.getAuthority());
                if (directAce == null) {
                    directAce = new HashMap<Boolean, AccessControlEntryImpl>();
                    aceMap.put(entry.getAuthority(), directAce);
                }
                if ((ace = (AccessControlEntryImpl)directAce.get(entry.isSetDirectly())) == null) {
                    ace = new AccessControlEntryImpl();
                    ace.setPrincipal((Principal)new AccessControlPrincipalDataImpl(entry.getAuthority()));
                    ace.setPermissions(new ArrayList());
                    ace.setDirect(entry.isSetDirectly());
                    directAce.put(entry.isSetDirectly(), ace);
                }
                ace.getPermissions().add(entry.getPermission());
                continue;
            }
            if (entry.getAccessStatus() != AccessStatus.DENIED || (directAce = (Map)aceMap.get(entry.getAuthority())) == null) continue;
            for (AccessControlEntryImpl ace : directAce.values()) {
                ace.getPermissions().remove(entry.getPermission());
            }
        }
        ArrayList<AccessControlEntryImpl> aces = new ArrayList<AccessControlEntryImpl>();
        result.setAces(aces);
        for (Map bothAces : aceMap.values()) {
            AccessControlEntryImpl indirectAce;
            AccessControlEntryImpl directAce = (AccessControlEntryImpl)bothAces.get(true);
            if (directAce != null && !directAce.getPermissions().isEmpty()) {
                directAce.setPermissions(this.translatePermmissionsToCMIS(directAce.getPermissions(), onlyBasicPermissions));
                aces.add(directAce);
            }
            if ((indirectAce = (AccessControlEntryImpl)bothAces.get(false)) == null || indirectAce.getPermissions().isEmpty()) continue;
            indirectAce.setPermissions(this.translatePermmissionsToCMIS(indirectAce.getPermissions(), onlyBasicPermissions));
            if (directAce != null && !directAce.getPermissions().isEmpty()) {
                indirectAce.getPermissions().removeAll(directAce.getPermissions());
            }
            aces.add(indirectAce);
        }
        result.setExact(Boolean.valueOf(!onlyBasicPermissions));
        return result;
    }

    private List<String> translatePermmissionsToCMIS(List<String> permissions, boolean onlyBasicPermissions) {
        TreeSet<String> result = new TreeSet<String>();
        for (String permission : permissions) {
            PermissionReference permissionReference = this.permissionModelDao.getPermissionReference(null, permission);
            if (this.permissionModelDao.hasFull(permissionReference)) {
                result.add("cmis:read");
                result.add("cmis:write");
                result.add("cmis:all");
            }
            Set<PermissionReference> longForms = this.permissionModelDao.getGranteePermissions(permissionReference);
            HashSet<String> shortForms = new HashSet<String>();
            for (PermissionReference longForm : longForms) {
                shortForms.add(this.permissionModelDao.isUnique(longForm) ? longForm.getName() : longForm.toString());
            }
            for (String perm : shortForms) {
                if ("Read".equals(perm)) {
                    result.add("cmis:read");
                    continue;
                }
                if ("Write".equals(perm)) {
                    result.add("cmis:write");
                    continue;
                }
                if (!"All".equals(perm)) continue;
                result.add("cmis:read");
                result.add("cmis:write");
                result.add("cmis:all");
            }
            if ("Read".equals(permission)) {
                result.add("cmis:read");
            } else if ("Write".equals(permission)) {
                result.add("cmis:write");
            } else if ("All".equals(permission)) {
                result.add("cmis:read");
                result.add("cmis:write");
                result.add("cmis:all");
            }
            if (onlyBasicPermissions) continue;
            if (permission.startsWith("{")) {
                result.add(permission);
                continue;
            }
            result.add(permissionReference.toString());
        }
        return new ArrayList<String>(result);
    }

    public void applyACL(NodeRef nodeRef, TypeDefinitionWrapper type, Acl addAces, Acl removeAces) {
        boolean hasRemove;
        boolean hasAdd = addAces != null && addAces.getAces() != null && !addAces.getAces().isEmpty();
        boolean bl = hasRemove = removeAces != null && removeAces.getAces() != null && !removeAces.getAces().isEmpty();
        if (!hasAdd && !hasRemove) {
            return;
        }
        if (!type.getTypeDefinition(false).isControllableAcl().booleanValue()) {
            throw new CmisConstraintException("Object is not ACL controllable!");
        }
        if (hasRemove) {
            Set permissions = this.permissionService.getAllSetPermissions(nodeRef);
            for (Ace ace : removeAces.getAces()) {
                String principalId = ace.getPrincipalId();
                if (CMIS_USER.equals(principalId)) {
                    principalId = AuthenticationUtil.getFullyAuthenticatedUser();
                }
                for (String permission : this.translatePermissionsFromCMIS(ace.getPermissions())) {
                    AccessPermissionImpl toCheck = new AccessPermissionImpl(permission, AccessStatus.ALLOWED, principalId, 0);
                    if (!permissions.contains(toCheck)) {
                        throw new CmisConstraintException("No matching ACE found to remove!");
                    }
                    this.permissionService.deletePermission(nodeRef, principalId, permission);
                }
            }
        }
        if (hasAdd) {
            for (Ace ace : addAces.getAces()) {
                String principalId = ace.getPrincipalId();
                if (CMIS_USER.equals(principalId)) {
                    principalId = AuthenticationUtil.getFullyAuthenticatedUser();
                }
                for (String permission : this.translatePermissionsFromCMIS(ace.getPermissions())) {
                    this.permissionService.setPermission(nodeRef, principalId, permission, true);
                }
            }
        }
    }

    public void applyACL(NodeRef nodeRef, TypeDefinitionWrapper type, Acl aces) {
        boolean hasAces;
        boolean bl = hasAces = aces != null && aces.getAces() != null && !aces.getAces().isEmpty();
        if (!hasAces) {
            return;
        }
        if (!type.getTypeDefinition(false).isControllableAcl().booleanValue()) {
            throw new CmisConstraintException("Object is not ACL controllable!");
        }
        Set currentAces = this.permissionService.getAllSetPermissions(nodeRef);
        this.permissionService.deletePermissions(nodeRef);
        for (Ace ace : aces.getAces()) {
            String principalId = ace.getPrincipalId();
            if (CMIS_USER.equals(principalId)) {
                principalId = AuthenticationUtil.getFullyAuthenticatedUser();
            }
            List<String> permissions = this.translatePermissionsFromCMIS(ace.getPermissions());
            this.normalisePermissions(currentAces, permissions);
            for (String permission : permissions) {
                this.permissionService.setPermission(nodeRef, principalId, permission, true);
            }
        }
    }

    private void normalisePermissions(Set<AccessPermission> currentAccessPermissions, List<String> newPermissions) {
        HashSet<String> currentPermissions = new HashSet<String>(currentAccessPermissions.size());
        for (AccessPermission accessPermission : currentAccessPermissions) {
            currentPermissions.add(accessPermission.getPermission());
        }
        if (currentPermissions.contains("Write") && !newPermissions.contains("cmis:write") && newPermissions.contains("Write")) {
            newPermissions.remove("Write");
        }
        if (currentPermissions.contains("Write") && !newPermissions.contains("Write") && newPermissions.contains("cmis:write")) {
            newPermissions.remove("cmis:write");
        }
        if (currentPermissions.contains("Read") && !newPermissions.contains("cmis:read") && newPermissions.contains("Read")) {
            newPermissions.remove("Read");
        }
        if (currentPermissions.contains("Read") && !newPermissions.contains("Read") && newPermissions.contains("cmis:read")) {
            newPermissions.remove("cmis:read");
        }
    }

    private List<String> translatePermissionsFromCMIS(List<String> permissions) {
        ArrayList<String> result = new ArrayList<String>();
        if (permissions == null) {
            return result;
        }
        for (String permission : permissions) {
            if (permission == null) {
                throw new CmisConstraintException("Invalid null permission!");
            }
            if ("cmis:read".equals(permission)) {
                result.add("Read");
                continue;
            }
            if ("cmis:write".equals(permission)) {
                result.add("Write");
                continue;
            }
            if ("cmis:all".equals(permission)) {
                result.add("All");
                continue;
            }
            if (!permission.startsWith("{")) {
                result.add(permission);
                continue;
            }
            int sepIndex = permission.lastIndexOf(46);
            if (sepIndex == -1) {
                result.add(permission);
                continue;
            }
            result.add(permission.substring(sepIndex + 1));
        }
        return result;
    }

    public void applyPolicies(NodeRef nodeRef, TypeDefinitionWrapper type, List<String> policies) {
        if (policies == null || policies.isEmpty()) {
            return;
        }
        if (!type.getTypeDefinition(false).isControllablePolicy().booleanValue()) {
            throw new CmisConstraintException("Object is not policy controllable!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectList query(String statement, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount) {
        ObjectListImpl result = new ObjectListImpl();
        result.setObjects(new ArrayList());
        CMISQueryOptions options = new CMISQueryOptions(statement, this.getRootStoreRef());
        options.setQueryMode(CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS);
        int skip = 0;
        if (skipCount != null && skipCount.intValue() >= 0) {
            skip = skipCount.intValue();
            options.setSkipCount(skip);
        }
        if (maxItems != null && maxItems.intValue() >= 0) {
            options.setMaxItems(maxItems.intValue());
        }
        boolean fetchObject = includeAllowableActions != false || includeRelationships != IncludeRelationships.NONE || !RENDITION_NONE.equals(renditionFilter);
        CMISResultSet rs = this.cmisQueryService.query(options);
        try {
            CMISResultSetColumn[] columns = rs.getMetaData().getColumns();
            Iterator<CMISResultSetRow> i$ = rs.iterator();
            while (i$.hasNext()) {
                CMISResultSetRow row = i$.next();
                ObjectDataImpl hit = new ObjectDataImpl();
                PropertiesImpl properties = new PropertiesImpl();
                hit.setProperties((Properties)properties);
                Map<String, Serializable> values = row.getValues();
                for (CMISResultSetColumn column : columns) {
                    AbstractPropertyData<?> property = this.getProperty(column.getCMISDataType(), column.getCMISPropertyDefinition(), values.get(column.getName()));
                    property.setQueryName(column.getName());
                    properties.addProperty(property);
                }
                if (fetchObject) {
                    List<RenditionData> renditions;
                    NodeRef nodeRef = row.getNodeRef();
                    TypeDefinitionWrapper type = this.getType(nodeRef);
                    if (type == null) continue;
                    if (includeAllowableActions.booleanValue()) {
                        hit.setAllowableActions(this.getAllowableActions(this.createNodeInfo(nodeRef)));
                    }
                    if (includeRelationships != IncludeRelationships.NONE) {
                        hit.setRelationships(this.getRelationships(nodeRef, includeRelationships));
                    }
                    if (!RENDITION_NONE.equals(renditionFilter) && (renditions = this.getRenditions(nodeRef, renditionFilter, null, null)) != null && !renditions.isEmpty()) {
                        hit.setRenditions(renditions);
                    }
                }
                result.getObjects().add(hit);
            }
            int length = rs.getLength();
            if (length != -1) {
                result.setNumItems(BigInteger.valueOf(length));
            }
            result.setHasMoreItems(Boolean.valueOf(rs.hasMore()));
        }
        finally {
            rs.close();
        }
        return result;
    }

    public void setProperties(NodeRef nodeRef, TypeDefinitionWrapper type, Properties properties, String ... exclude) {
        if (properties == null) {
            return;
        }
        for (PropertyData property : properties.getPropertyList()) {
            if (Arrays.binarySearch(exclude, property.getId()) >= 0) continue;
            this.setProperty(nodeRef, type, property);
        }
        List extensions = properties.getExtensions();
        if (extensions != null) {
            for (CmisExtensionElement extension : extensions) {
                if (!ALFRESCO_EXTENSION_NAMESPACE.equals(extension.getNamespace()) || !SET_ASPECTS.equals(extension.getName())) continue;
                this.setAspectProperties(nodeRef, extension);
                break;
            }
        }
    }

    private void setAspectProperties(NodeRef nodeRef, CmisExtensionElement aspectExtension) {
        if (aspectExtension.getChildren() == null) {
            return;
        }
        ArrayList<String> aspectsToAdd = new ArrayList<String>();
        ArrayList<String> aspectsToRemove = new ArrayList<String>();
        HashMap aspectProperties = new HashMap();
        for (CmisExtensionElement extension : aspectExtension.getChildren()) {
            if (!ALFRESCO_EXTENSION_NAMESPACE.equals(extension.getNamespace())) continue;
            if (ASPECTS_TO_ADD.equals(extension.getName()) && extension.getValue() != null) {
                aspectsToAdd.add(extension.getValue());
                continue;
            }
            if (ASPECTS_TO_REMOVE.equals(extension.getName()) && extension.getValue() != null) {
                aspectsToRemove.add(extension.getValue());
                continue;
            }
            if (!PROPERTIES.equals(extension.getName()) || extension.getChildren() == null) continue;
            for (CmisExtensionElement property : extension.getChildren()) {
                String propertyId;
                if (!property.getName().startsWith("property") || (propertyId = property.getAttributes() == null ? null : (String)property.getAttributes().get("propertyDefinitionId")) == null || property.getChildren() == null) continue;
                PropertyType propertyType = PropertyType.STRING;
                DatatypeFactory df = null;
                if (property.getName().equals("propertyBoolean")) {
                    propertyType = PropertyType.BOOLEAN;
                } else if (property.getName().equals("propertyInteger")) {
                    propertyType = PropertyType.INTEGER;
                } else if (property.getName().equals("propertyDateTime")) {
                    propertyType = PropertyType.DATETIME;
                    try {
                        df = DatatypeFactory.newInstance();
                    }
                    catch (DatatypeConfigurationException e) {
                        throw new CmisRuntimeException("Aspect conversation exception: " + e.getMessage(), (Throwable)e);
                    }
                } else if (property.getName().equals("propertyDecimal")) {
                    propertyType = PropertyType.DECIMAL;
                }
                ArrayList<Object> values = new ArrayList<Object>();
                if (property.getChildren() != null) {
                    try {
                        block15: for (CmisExtensionElement valueElement : property.getChildren()) {
                            if (!"value".equals(valueElement.getName())) continue;
                            switch (propertyType) {
                                case BOOLEAN: {
                                    values.add(Boolean.parseBoolean(valueElement.getValue()));
                                    continue block15;
                                }
                                case DATETIME: {
                                    values.add(df.newXMLGregorianCalendar(valueElement.getValue()).toGregorianCalendar());
                                    continue block15;
                                }
                                case INTEGER: {
                                    values.add(new BigInteger(valueElement.getValue()));
                                    continue block15;
                                }
                                case DECIMAL: {
                                    values.add(new BigDecimal(valueElement.getValue()));
                                    continue block15;
                                }
                            }
                            values.add(valueElement.getValue());
                        }
                    }
                    catch (Exception e) {
                        throw new CmisInvalidArgumentException("Invalid property aspect value: " + propertyId, (Throwable)e);
                    }
                }
                aspectProperties.put(QName.createQName((String)propertyId, (NamespacePrefixResolver)this.namespaceService), values);
            }
        }
        String aspectType = null;
        try {
            TypeDefinitionWrapper type;
            Iterator<Object> i$ = aspectsToRemove.iterator();
            while (i$.hasNext()) {
                String string;
                aspectType = string = (String)i$.next();
                type = this.getType(string);
                if (type == null) {
                    throw new CmisInvalidArgumentException("Invalid aspect: " + aspectType);
                }
                this.nodeService.removeAspect(nodeRef, type.getAlfrescoName());
            }
            i$ = aspectsToAdd.iterator();
            while (i$.hasNext()) {
                String string;
                aspectType = string = (String)i$.next();
                type = this.getType(string);
                if (type == null) {
                    throw new CmisInvalidArgumentException("Invalid aspect: " + aspectType);
                }
                this.nodeService.addAspect(nodeRef, type.getAlfrescoName(), Collections.emptyMap());
            }
        }
        catch (InvalidAspectException e) {
            throw new CmisInvalidArgumentException("Invalid aspect: " + aspectType);
        }
        catch (InvalidNodeRefException e) {
            throw new CmisInvalidArgumentException("Invalid node: " + nodeRef);
        }
        for (Map.Entry entry : aspectProperties.entrySet()) {
            if (((List)entry.getValue()).isEmpty()) {
                this.nodeService.removeProperty(nodeRef, (QName)entry.getKey());
                continue;
            }
            this.nodeService.setProperty(nodeRef, (QName)entry.getKey(), ((List)entry.getValue()).size() == 1 ? (Serializable)((List)entry.getValue()).get(0) : (Serializable)entry.getValue());
        }
    }

    public void setProperty(NodeRef nodeRef, TypeDefinitionWrapper type, PropertyData<?> property) {
        if (property == null) {
            throw new CmisInvalidArgumentException("Cannot process not null property!");
        }
        PropertyDefinitionWrapper propDef = type.getPropertyById(property.getId());
        if (propDef == null) {
            throw new CmisInvalidArgumentException("Property " + property.getId() + " is unknown!");
        }
        Updatability updatability = propDef.getPropertyDefinition().getUpdatability();
        if (updatability == Updatability.READONLY || updatability == Updatability.WHENCHECKEDOUT && !this.checkOutCheckInService.isWorkingCopy(nodeRef)) {
            throw new CmisInvalidArgumentException("Property " + property.getId() + " is read-only!");
        }
        QName propertyQName = propDef.getPropertyAccessor().getMappedProperty();
        if (propertyQName == null) {
            throw new CmisConstraintException("Unable to set property " + property.getId() + "!");
        }
        Serializable value = this.getValue(property, propDef.getPropertyDefinition().getCardinality() == Cardinality.MULTI);
        if (property.getId().equals("cmis:name")) {
            if (!(value instanceof String)) {
                throw new CmisInvalidArgumentException("Object name must be a string!");
            }
            try {
                this.fileFolderService.rename(nodeRef, value.toString());
            }
            catch (FileExistsException e) {
                throw new CmisContentAlreadyExistsException("An object with this name already exists!", (Throwable)e);
            }
            catch (FileNotFoundException e) {
                throw new CmisInvalidArgumentException("Object with id " + nodeRef.toString() + " not found!");
            }
        } else if (value == null) {
            this.nodeService.removeProperty(nodeRef, propertyQName);
        } else {
            this.nodeService.setProperty(nodeRef, propertyQName, value);
        }
    }

    private Serializable getValue(PropertyData<?> property, boolean isMultiValue) {
        if (property.getValues() == null || property.getValues().isEmpty()) {
            return null;
        }
        if (isMultiValue) {
            return (Serializable)((Object)property.getValues());
        }
        return (Serializable)property.getValues().get(0);
    }

    public ObjectList getContentChanges(Holder<String> changeLogToken, BigInteger maxItems) {
        final ObjectListImpl result = new ObjectListImpl();
        result.setObjects(new ArrayList());
        EntryIdCallback changeLogCollectingCallback = new EntryIdCallback(true){

            @Override
            public boolean handleAuditEntry(Long entryId, String user, long time, Map<String, Serializable> values) {
                result.getObjects().addAll(CMISConnector.this.createChangeEvents(time, values));
                return super.handleAuditEntry(entryId, user, time, values);
            }
        };
        Long from = null;
        if (changeLogToken != null && changeLogToken.getValue() != null) {
            try {
                from = Long.parseLong((String)changeLogToken.getValue());
            }
            catch (NumberFormatException e) {
                throw new CmisInvalidArgumentException("Invalid change log token: " + changeLogToken);
            }
        }
        AuditQueryParameters params = new AuditQueryParameters();
        params.setApplicationName(CMIS_CHANGELOG_AUDIT_APPLICATION);
        params.setForward(true);
        params.setFromId(from);
        int maxResults = maxItems == null ? 0 : maxItems.intValue();
        maxResults = maxResults < 1 ? 0 : maxResults + 1;
        this.auditService.auditQuery(changeLogCollectingCallback, params, maxResults);
        String newChangeLogToken = null;
        if (maxResults > 0) {
            if (result.getObjects().size() >= maxResults) {
                newChangeLogToken = ((ObjectData)result.getObjects().remove(result.getObjects().size() - 1)).getId();
                result.setHasMoreItems(Boolean.valueOf(true));
            } else {
                result.setHasMoreItems(Boolean.valueOf(false));
            }
        }
        if (changeLogToken != null) {
            changeLogToken.setValue(newChangeLogToken);
        }
        return result;
    }

    private List<ObjectData> createChangeEvents(long time, Map<String, Serializable> values) {
        ArrayList<ObjectData> result = new ArrayList<ObjectData>();
        if (values == null || values.size() == 0) {
            return result;
        }
        GregorianCalendar changeTime = new GregorianCalendar();
        changeTime.setTimeInMillis(time);
        String appPath = "/CMISChangeLog/";
        for (Map.Entry<String, Serializable> entry : values.entrySet()) {
            String path;
            if (entry.getKey() == null || !(entry.getValue() instanceof Map) || !(path = entry.getKey()).startsWith(appPath)) continue;
            ChangeType changeType = null;
            String changePath = path.substring(appPath.length()).toLowerCase();
            for (ChangeType c : ChangeType.values()) {
                if (!changePath.startsWith(c.value().toLowerCase())) continue;
                changeType = c;
                break;
            }
            if (changeType == null) continue;
            Map valueMap = (Map)((Object)entry.getValue());
            String objectId = (String)valueMap.get("objectId");
            ObjectDataImpl object = new ObjectDataImpl();
            result.add((ObjectData)object);
            PropertiesImpl properties = new PropertiesImpl();
            object.setProperties((Properties)properties);
            PropertyIdImpl objectIdProperty = new PropertyIdImpl(QUERY_NAME_OBJECT_ID, objectId);
            properties.addProperty((PropertyData)objectIdProperty);
            ChangeEventInfoDataImpl changeEvent = new ChangeEventInfoDataImpl();
            object.setChangeEventInfo((ChangeEventInfo)changeEvent);
            changeEvent.setChangeType(changeType);
            changeEvent.setChangeTime(changeTime);
        }
        return result;
    }

    public String getStringProperty(Properties properties, String propertyId) {
        if (properties == null || properties.getProperties() == null) {
            return null;
        }
        PropertyData property = (PropertyData)properties.getProperties().get(propertyId);
        if (!(property instanceof PropertyString)) {
            return null;
        }
        return (String)((PropertyString)property).getFirstValue();
    }

    public String getIdProperty(Properties properties, String propertyId) {
        if (properties == null || properties.getProperties() == null) {
            return null;
        }
        PropertyData property = (PropertyData)properties.getProperties().get(propertyId);
        if (!(property instanceof PropertyId)) {
            return null;
        }
        return (String)((PropertyId)property).getFirstValue();
    }

    public String getNameProperty(Properties properties, String fallback) {
        String name = this.getStringProperty(properties, "cmis:name");
        if (name == null || name.trim().length() == 0) {
            if (fallback == null) {
                throw new CmisInvalidArgumentException("Property cmis:name must be set!");
            }
            name = fallback;
        }
        return name;
    }

    public String getObjectTypeIdProperty(Properties properties) {
        String objectTypeId = this.getIdProperty(properties, QUERY_NAME_OBJECT_TYPE_ID);
        if (objectTypeId == null || objectTypeId.trim().length() == 0) {
            throw new CmisInvalidArgumentException("Property cmis:objectTypeId must be set!");
        }
        return objectTypeId;
    }

    public String getSourceIdProperty(Properties properties) {
        String id = this.getIdProperty(properties, "cmis:sourceId");
        if (id == null || id.trim().length() == 0) {
            throw new CmisInvalidArgumentException("Property cmis:sourceId must be set!");
        }
        return id;
    }

    public String getTargetIdProperty(Properties properties) {
        String id = this.getIdProperty(properties, "cmis:targetId");
        if (id == null || id.trim().length() == 0) {
            throw new CmisInvalidArgumentException("Property cmis:targetId must be set!");
        }
        return id;
    }

    public RepositoryInfo getRepositoryInfo() {
        return this.createRepositoryInfo();
    }

    public String getRepositoryId() {
        return this.descriptorService.getCurrentRepositoryDescriptor().getId();
    }

    private RepositoryInfo createRepositoryInfo() {
        Descriptor currentDescriptor = this.descriptorService.getCurrentRepositoryDescriptor();
        boolean auditEnabled = this.auditService.isAuditEnabled(CMIS_CHANGELOG_AUDIT_APPLICATION, "/CMISChangeLog");
        String latestChangeLogToken = null;
        if (auditEnabled) {
            EntryIdCallback auditQueryCallback = new EntryIdCallback(false);
            AuditQueryParameters params = new AuditQueryParameters();
            params.setApplicationName(CMIS_CHANGELOG_AUDIT_APPLICATION);
            params.setForward(false);
            this.auditService.auditQuery(auditQueryCallback, params, 1);
            latestChangeLogToken = auditQueryCallback.getEntryId();
        }
        RepositoryInfoImpl ri = new RepositoryInfoImpl();
        ri.setId(currentDescriptor.getId());
        ri.setName(currentDescriptor.getName());
        ri.setDescription(currentDescriptor.getName());
        ri.setVendorName("Alfresco");
        ri.setProductName("Alfresco Repository (" + currentDescriptor.getEdition() + ")");
        ri.setProductVersion(currentDescriptor.getVersion());
        ri.setRootFolder(this.getRootNodeRef().toString());
        ri.setCmisVersionSupported(UNVERSIONED_VERSION_LABEL);
        ri.setChangesIncomplete(Boolean.valueOf(true));
        ri.setChangesOnType(Arrays.asList(BaseTypeId.CMIS_DOCUMENT, BaseTypeId.CMIS_FOLDER));
        ri.setLatestChangeLogToken(latestChangeLogToken);
        ri.setPrincipalAnonymous(AuthenticationUtil.getGuestUserName());
        ri.setPrincipalAnyone("GROUP_EVERYONE");
        RepositoryCapabilitiesImpl repCap = new RepositoryCapabilitiesImpl();
        ri.setCapabilities((RepositoryCapabilities)repCap);
        repCap.setAllVersionsSearchable(Boolean.valueOf(false));
        repCap.setCapabilityAcl(CapabilityAcl.MANAGE);
        repCap.setCapabilityChanges(auditEnabled ? CapabilityChanges.OBJECTIDSONLY : CapabilityChanges.NONE);
        repCap.setCapabilityContentStreamUpdates(CapabilityContentStreamUpdates.ANYTIME);
        repCap.setCapabilityJoin(CapabilityJoin.NONE);
        repCap.setCapabilityQuery(CapabilityQuery.BOTHCOMBINED);
        repCap.setCapabilityRendition(CapabilityRenditions.READ);
        repCap.setIsPwcSearchable(Boolean.valueOf(false));
        repCap.setIsPwcUpdatable(Boolean.valueOf(true));
        repCap.setSupportsGetDescendants(Boolean.valueOf(true));
        repCap.setSupportsGetFolderTree(Boolean.valueOf(true));
        repCap.setSupportsMultifiling(Boolean.valueOf(true));
        repCap.setSupportsUnfiling(Boolean.valueOf(false));
        repCap.setSupportsVersionSpecificFiling(Boolean.valueOf(false));
        AclCapabilitiesDataImpl aclCap = new AclCapabilitiesDataImpl();
        ri.setAclCapabilities((AclCapabilities)aclCap);
        aclCap.setAclPropagation(AclPropagation.PROPAGATE);
        aclCap.setSupportedPermissions(SupportedPermissions.BOTH);
        aclCap.setPermissionDefinitionData(this.repositoryPermissions);
        aclCap.setPermissionMappingData(this.permissionMappings);
        return ri;
    }

    private List<PermissionDefinition> getRepositoryPermissions() {
        ArrayList<PermissionDefinition> result = new ArrayList<PermissionDefinition>();
        Set<PermissionReference> all = this.permissionModelDao.getAllExposedPermissions();
        for (PermissionReference pr : all) {
            result.add(this.createPermissionDefinition(pr));
        }
        PermissionReference allPermission = this.permissionModelDao.getPermissionReference(null, "All");
        result.add(this.createPermissionDefinition(allPermission));
        PermissionDefinitionDataImpl cmisPermission = new PermissionDefinitionDataImpl();
        cmisPermission.setPermission("cmis:read");
        cmisPermission.setDescription("CMIS Read");
        result.add((PermissionDefinition)cmisPermission);
        cmisPermission = new PermissionDefinitionDataImpl();
        cmisPermission.setPermission("cmis:write");
        cmisPermission.setDescription("CMIS Write");
        result.add((PermissionDefinition)cmisPermission);
        cmisPermission = new PermissionDefinitionDataImpl();
        cmisPermission.setPermission("cmis:all");
        cmisPermission.setDescription("CMIS All");
        result.add((PermissionDefinition)cmisPermission);
        return result;
    }

    private PermissionDefinition createPermissionDefinition(PermissionReference pr) {
        PermissionDefinitionDataImpl permission = new PermissionDefinitionDataImpl();
        permission.setPermission(pr.getQName().toString() + "." + pr.getName());
        permission.setDescription(permission.getId());
        return permission;
    }

    private Map<String, PermissionMapping> getPermissionMappings() {
        HashMap<String, PermissionMapping> result = new HashMap<String, PermissionMapping>();
        for (CMISAllowedActionEnum e : EnumSet.allOf(CMISAllowedActionEnum.class)) {
            for (Map.Entry<String, List<String>> m : e.getPermissionMapping().entrySet()) {
                PermissionMappingDataImpl mapping = new PermissionMappingDataImpl();
                mapping.setKey(m.getKey());
                mapping.setPermissions(m.getValue());
                result.put(mapping.getKey(), (PermissionMapping)mapping);
            }
        }
        return result;
    }

    private CMISRenditionMapping getRenditionMapping() {
        CMISRenditionMapping renditionMapping = (CMISRenditionMapping)this.singletonCache.get((Serializable)((Object)"key.cmisRenditionMapping.noderef"));
        if (renditionMapping == null) {
            renditionMapping = new CMISRenditionMapping(this.nodeService, this.contentService, this.renditionService, this.transactionService, this.kindToRenditionNames);
            this.singletonCache.put((Serializable)((Object)"key.cmisRenditionMapping.noderef"), (Object)renditionMapping);
        }
        return renditionMapping;
    }

    private class EntryIdCallback
    implements AuditService.AuditQueryCallback {
        private final boolean valuesRequired;
        private Long entryId;

        public EntryIdCallback(boolean valuesRequired) {
            this.valuesRequired = valuesRequired;
        }

        public String getEntryId() {
            return this.entryId == null ? null : this.entryId.toString();
        }

        @Override
        public boolean valuesRequired() {
            return this.valuesRequired;
        }

        @Override
        public final boolean handleAuditEntry(Long entryId, String applicationName, String user, long time, Map<String, Serializable> values) {
            if (applicationName.equals(CMISConnector.CMIS_CHANGELOG_AUDIT_APPLICATION)) {
                return this.handleAuditEntry(entryId, user, time, values);
            }
            return true;
        }

        public boolean handleAuditEntry(Long entryId, String user, long time, Map<String, Serializable> values) {
            this.entryId = entryId;
            return true;
        }

        @Override
        public boolean handleAuditEntryError(Long entryId, String errorMsg, Throwable error) {
            throw new CmisRuntimeException("Audit entry " + entryId + ": " + errorMsg, error);
        }
    }

    public static class AccessPermissionComparator
    implements Comparator<AccessPermission> {
        @Override
        public int compare(AccessPermission left, AccessPermission right) {
            if (left.getPosition() != right.getPosition()) {
                return right.getPosition() - left.getPosition();
            }
            if (left.getAccessStatus() != right.getAccessStatus()) {
                return left.getAccessStatus() == AccessStatus.DENIED ? -1 : 1;
            }
            int compare = left.getAuthority().compareTo(right.getAuthority());
            if (compare != 0) {
                return compare;
            }
            return left.getPermission().compareTo(right.getPermission());
        }
    }

    private class ProcessorLifecycle
    extends AbstractLifecycleBean {
        private ProcessorLifecycle() {
        }

        protected void onBootstrap(ApplicationEvent event) {
            CMISConnector.this.init();
        }

        protected void onShutdown(ApplicationEvent event) {
        }
    }
}

