/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis.mapping;

import java.io.Serializable;
import org.alfresco.opencmis.CMISConnector;
import org.alfresco.opencmis.dictionary.CMISNodeInfo;
import org.alfresco.opencmis.mapping.AbstractProperty;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.repository.NodeRef;

public class IsImmutableProperty
extends AbstractProperty {
    private LockService lockService;

    public IsImmutableProperty(ServiceRegistry serviceRegistry, CMISConnector connector) {
        super(serviceRegistry, connector, "cmis:isImmutable");
        this.lockService = serviceRegistry.getLockService();
    }

    @Override
    public Serializable getValueInternal(CMISNodeInfo nodeInfo) {
        NodeRef nodeRef = nodeInfo.getNodeRef();
        if (nodeInfo.isVersion() || nodeInfo.hasPWC() && !nodeInfo.isPWC() || this.lockService.getLockType(nodeRef) == LockType.READ_ONLY_LOCK) {
            return Boolean.valueOf(true);
        }
        return Boolean.valueOf(false);
    }
}

