/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.constraint;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.action.constraint.BaseParameterConstraint;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.namespace.QName;

public class TypeParameterConstraint
extends BaseParameterConstraint {
    public static final String NAME = "ac-types";
    private DictionaryService dictionaryService;

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    @Override
    protected Map<String, String> getAllowableValuesImpl() {
        Collection types = this.dictionaryService.getAllTypes();
        HashMap<String, String> result = new HashMap<String, String>(types.size());
        for (QName type : types) {
            TypeDefinition typeDef = this.dictionaryService.getType(type);
            if (typeDef == null || typeDef.getTitle() == null) continue;
            result.put(type.toPrefixString(), typeDef.getTitle());
        }
        return result;
    }
}

