/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.evaluator;

import java.io.Serializable;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionConditionImpl;
import org.alfresco.repo.action.evaluator.HasChildEvaluator;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.GUID;

public class HasChildEvaluatorTest
extends BaseSpringTest {
    private NodeService nodeService;
    private StoreRef testStoreRef;
    private NodeRef rootNodeRef;
    private NodeRef parentNodeRef;
    private NodeRef childNodeRef;
    private QName parentChildAssocName;
    private HasChildEvaluator evaluator;
    private static final String ID = GUID.generate();

    protected void onSetUpInTransaction() throws Exception {
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        this.testStoreRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(this.testStoreRef);
        this.parentNodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}testnode_p"), ContentModel.TYPE_CONTENT).getChildRef();
        this.parentChildAssocName = QName.createQName((String)"{test}testnode_c");
        this.childNodeRef = this.nodeService.createNode(this.parentNodeRef, ContentModel.ASSOC_CHILDREN, this.parentChildAssocName, ContentModel.TYPE_CONTENT).getChildRef();
        this.evaluator = (HasChildEvaluator)this.applicationContext.getBean("has-child");
    }

    public void testPass() {
        ActionConditionImpl condition = new ActionConditionImpl(ID, "has-child", null);
        HasChildEvaluatorTest.assertTrue((boolean)this.evaluator.evaluate(condition, this.parentNodeRef));
        condition.setParameterValue("assoc-type", (Serializable)ContentModel.ASSOC_CHILDREN);
        HasChildEvaluatorTest.assertTrue((boolean)this.evaluator.evaluate(condition, this.parentNodeRef));
        condition.setParameterValue("assoc-name", (Serializable)this.parentChildAssocName);
        HasChildEvaluatorTest.assertTrue((boolean)this.evaluator.evaluate(condition, this.parentNodeRef));
        condition = new ActionConditionImpl(ID, "has-child", null);
        condition.setParameterValue("assoc-name", (Serializable)this.parentChildAssocName);
        HasChildEvaluatorTest.assertTrue((boolean)this.evaluator.evaluate(condition, this.parentNodeRef));
    }

    public void testFail() {
        ActionConditionImpl condition = new ActionConditionImpl(ID, "has-child", null);
        HasChildEvaluatorTest.assertFalse((boolean)this.evaluator.evaluate(condition, this.childNodeRef));
        condition.setParameterValue("assoc-type", (Serializable)ContentModel.ASSOC_ATTACHMENTS);
        HasChildEvaluatorTest.assertFalse((boolean)this.evaluator.evaluate(condition, this.parentNodeRef));
        condition = new ActionConditionImpl(ID, "has-child", null);
        condition.setParameterValue("assoc-name", (Serializable)QName.createQName((String)"{foo}noSuchName"));
        HasChildEvaluatorTest.assertFalse((boolean)this.evaluator.evaluate(condition, this.parentNodeRef));
    }
}

