/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionImpl;
import org.alfresco.repo.action.ActionModel;
import org.alfresco.repo.action.AsynchronousActionExecutionQueuePolicies;
import org.alfresco.repo.action.executer.ContentMetadataExtracter;
import org.alfresco.repo.content.metadata.MetadataExtracterRegistry;
import org.alfresco.repo.content.metadata.TikaPoweredMetadataExtracter;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.tagging.TaggingServiceImplTest;
import org.alfresco.repo.tagging.UpdateTagScopesActionExecuter;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.audit.AuditService;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.tagging.TaggingService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.jpeg.JpegParser;
import org.springframework.context.ConfigurableApplicationContext;

public class ContentMetadataExtracterTagMappingTest
extends TestCase {
    private static ConfigurableApplicationContext ctx = (ConfigurableApplicationContext)ApplicationContextHelper.getApplicationContext();
    protected static final String TAGGING_AUDIT_APPLICATION_NAME = "Alfresco Tagging Service";
    protected static final String QUICK_FILENAME = "quickIPTC.jpg";
    protected static final String QUICK_KEYWORD = "fox";
    protected static final String TAG_1 = "tag one";
    protected static final String TAG_2 = "tag two";
    protected static final String TAG_3 = "Tag Three";
    private TaggingService taggingService;
    private NodeService nodeService;
    private ContentService contentService;
    private AuditService auditService;
    private TransactionService transactionService;
    private AuthenticationComponent authenticationComponent;
    private TaggingServiceImplTest.AsyncOccurs asyncOccurs;
    private static StoreRef storeRef;
    private static NodeRef rootNode;
    private NodeRef folder;
    private NodeRef document;
    private ContentMetadataExtracter executer;
    private TagMappingMetadataExtracter extractor;
    private static boolean init;
    private static final String ID;

    protected void setUp() throws Exception {
        if (AlfrescoTransactionSupport.getTransactionReadState() != AlfrescoTransactionSupport.TxnReadState.TXN_NONE) {
            throw new IllegalStateException("There should not be any transactions when starting test: " + AlfrescoTransactionSupport.getTransactionId() + " started at " + new Date(AlfrescoTransactionSupport.getTransactionStartTime()));
        }
        this.taggingService = (TaggingService)ctx.getBean("TaggingService");
        this.nodeService = (NodeService)ctx.getBean("NodeService");
        this.contentService = (ContentService)ctx.getBean("ContentService");
        this.transactionService = (TransactionService)ctx.getBean("transactionComponent");
        this.auditService = (AuditService)ctx.getBean("auditService");
        this.authenticationComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        this.executer = (ContentMetadataExtracter)ctx.getBean("extract-metadata");
        this.executer.setEnableStringTagging(true);
        this.executer.setTaggingService(this.taggingService);
        if (!init) {
            this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                @Override
                public Void execute() throws Throwable {
                    ContentMetadataExtracterTagMappingTest.this.authenticationComponent.setSystemUserAsCurrentUser();
                    storeRef = ContentMetadataExtracterTagMappingTest.this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
                    rootNode = ContentMetadataExtracterTagMappingTest.this.nodeService.getRootNode(storeRef);
                    NodeRef catContainer = ContentMetadataExtracterTagMappingTest.this.nodeService.createNode(rootNode, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"categoryContainer"), ContentModel.TYPE_CONTAINER).getChildRef();
                    NodeRef catRoot = ContentMetadataExtracterTagMappingTest.this.nodeService.createNode(catContainer, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"categoryRoot"), ContentModel.TYPE_CATEGORYROOT).getChildRef();
                    ContentMetadataExtracterTagMappingTest.this.nodeService.createNode(catRoot, ContentModel.ASSOC_CATEGORIES, ContentModel.ASPECT_TAGGABLE, ContentModel.TYPE_CATEGORY).getChildRef();
                    MetadataExtracterRegistry registry = (MetadataExtracterRegistry)ctx.getBean("metadataExtracterRegistry");
                    ContentMetadataExtracterTagMappingTest.this.extractor = new TagMappingMetadataExtracter();
                    ContentMetadataExtracterTagMappingTest.this.extractor.setRegistry(registry);
                    ContentMetadataExtracterTagMappingTest.this.extractor.register();
                    init = true;
                    return null;
                }
            });
        }
        this.asyncOccurs = new TaggingServiceImplTest.AsyncOccurs(new TaggingServiceImplTest());
        ((PolicyComponent)ctx.getBean("policyComponent")).bindClassBehaviour(AsynchronousActionExecutionQueuePolicies.OnAsyncActionExecute.QNAME, ActionModel.TYPE_ACTION, (Behaviour)new JavaBehaviour(this.asyncOccurs, "onAsyncActionExecute", Behaviour.NotificationFrequency.EVERY_EVENT));
        UpdateTagScopesActionExecuter updateTagsAction = (UpdateTagScopesActionExecuter)ctx.getBean("update-tagscope");
        updateTagsAction.setTrackStatus(true);
        this.createTestDocumentsAndFolders();
    }

    protected void tearDown() throws Exception {
        this.removeTestDocumentsAndFolders();
        if (AlfrescoTransactionSupport.getTransactionReadState() != AlfrescoTransactionSupport.TxnReadState.TXN_NONE) {
            ContentMetadataExtracterTagMappingTest.fail((String)"Test is not transaction-safe.  Fix up transaction handling and re-test.");
        }
    }

    private void createTestDocumentsAndFolders() throws Exception {
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ContentMetadataExtracterTagMappingTest.this.authenticationComponent.setSystemUserAsCurrentUser();
                String guid = GUID.generate();
                HashMap<QName, String> folderProps = new HashMap<QName, String>(1);
                folderProps.put(ContentModel.PROP_NAME, "testFolder" + guid);
                ContentMetadataExtracterTagMappingTest.this.folder = ContentMetadataExtracterTagMappingTest.this.nodeService.createNode(rootNode, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)("testFolder" + guid)), ContentModel.TYPE_FOLDER, folderProps).getChildRef();
                HashMap<QName, String> docProps = new HashMap<QName, String>(1);
                docProps.put(ContentModel.PROP_NAME, "testDocument" + guid + ".jpg");
                ContentMetadataExtracterTagMappingTest.this.document = ContentMetadataExtracterTagMappingTest.this.nodeService.createNode(ContentMetadataExtracterTagMappingTest.this.folder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)("testDocument" + guid + ".jpg")), ContentModel.TYPE_CONTENT, docProps).getChildRef();
                try {
                    ContentWriter cw = ContentMetadataExtracterTagMappingTest.this.contentService.getWriter(ContentMetadataExtracterTagMappingTest.this.document, ContentModel.PROP_CONTENT, true);
                    cw.setMimetype("image/jpeg");
                    cw.putContent(AbstractContentTransformerTest.loadNamedQuickTestFile(ContentMetadataExtracterTagMappingTest.QUICK_FILENAME));
                }
                catch (Exception e) {
                    Assert.fail((String)e.getMessage());
                }
                return null;
            }
        });
    }

    private void removeTestDocumentsAndFolders() throws Exception {
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                NodeRef[] nodes;
                ContentMetadataExtracterTagMappingTest.this.authenticationComponent.setSystemUserAsCurrentUser();
                for (NodeRef nodeRef : nodes = new NodeRef[]{ContentMetadataExtracterTagMappingTest.this.document, ContentMetadataExtracterTagMappingTest.this.folder}) {
                    if (!ContentMetadataExtracterTagMappingTest.this.taggingService.isTagScope(nodeRef)) continue;
                    ContentMetadataExtracterTagMappingTest.this.taggingService.removeTagScope(nodeRef);
                }
                for (NodeRef nodeRef : nodes) {
                    ContentMetadataExtracterTagMappingTest.this.nodeService.deleteNode(nodeRef);
                }
                ContentMetadataExtracterTagMappingTest.this.auditService.clearAudit(ContentMetadataExtracterTagMappingTest.TAGGING_AUDIT_APPLICATION_NAME, 0L, System.currentTimeMillis() + 1L);
                return null;
            }
        });
    }

    public void testTagMapping() {
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                NodeRef existingTagNodeRef = ContentMetadataExtracterTagMappingTest.this.taggingService.createTag(storeRef, ContentMetadataExtracterTagMappingTest.TAG_1);
                ContentMetadataExtracterTagMappingTest.this.extractor.setExistingTagNodeRef(existingTagNodeRef.toString());
                ActionImpl action = new ActionImpl(ContentMetadataExtracterTagMappingTest.this.document, ID, "extract-metadata", null);
                ContentMetadataExtracterTagMappingTest.this.executer.execute(action, ContentMetadataExtracterTagMappingTest.this.document);
                Assert.assertEquals((Object)"Gym class featuring a brown fox and lazy dog", (Object)ContentMetadataExtracterTagMappingTest.this.nodeService.getProperty(ContentMetadataExtracterTagMappingTest.this.document, ContentModel.PROP_DESCRIPTION));
                Assert.assertTrue((String)"storeRef tags should contain 'fox'", (boolean)ContentMetadataExtracterTagMappingTest.this.taggingService.getTags(storeRef).contains(ContentMetadataExtracterTagMappingTest.QUICK_KEYWORD));
                Assert.assertTrue((String)"document's tags should contain 'fox'", (boolean)ContentMetadataExtracterTagMappingTest.this.taggingService.getTags(ContentMetadataExtracterTagMappingTest.this.document).contains(ContentMetadataExtracterTagMappingTest.QUICK_KEYWORD));
                Assert.assertTrue((String)"tags should contain 'tag two'", (boolean)ContentMetadataExtracterTagMappingTest.this.taggingService.getTags(ContentMetadataExtracterTagMappingTest.this.document).contains(ContentMetadataExtracterTagMappingTest.TAG_2));
                Assert.assertTrue((String)"tags should contain 'tag one'", (boolean)ContentMetadataExtracterTagMappingTest.this.taggingService.getTags(ContentMetadataExtracterTagMappingTest.this.document).contains(ContentMetadataExtracterTagMappingTest.TAG_1));
                return null;
            }
        });
    }

    static {
        init = false;
        ID = GUID.generate();
    }

    private static class TagMappingMetadataExtracter
    extends TikaPoweredMetadataExtracter {
        private String existingTagNodeRef;

        public TagMappingMetadataExtracter() {
            super(Sets.newHashSet((Object[])new String[]{"image/jpeg"}));
            Properties mappingProperties = new Properties();
            mappingProperties.put("Keywords", ContentModel.PROP_TAGS.toString());
            mappingProperties.put("description", ContentModel.PROP_DESCRIPTION.toString());
            this.setMappingProperties(mappingProperties);
        }

        public void setExistingTagNodeRef(String existingTagNodeRef) {
            this.existingTagNodeRef = existingTagNodeRef;
        }

        @Override
        protected Map<String, Set<QName>> getDefaultMapping() {
            return new HashMap<String, Set<QName>>(0);
        }

        @Override
        public boolean isSupported(String sourceMimetype) {
            return sourceMimetype.equals("image/jpeg");
        }

        @Override
        protected Parser getParser() {
            return new JpegParser();
        }

        @Override
        public Map<String, Serializable> extractRaw(ContentReader reader) throws Throwable {
            Map<String, Serializable> rawMap = super.extractRaw(reader);
            ArrayList<String> keywords = new ArrayList<String>(Arrays.asList(this.existingTagNodeRef, ContentMetadataExtracterTagMappingTest.TAG_2, ContentMetadataExtracterTagMappingTest.TAG_3));
            Serializable extractedKeywords = rawMap.get("Keywords");
            if (extractedKeywords != null && extractedKeywords instanceof String) {
                keywords.add((String)((Object)extractedKeywords));
            } else if (extractedKeywords != null && extractedKeywords instanceof Collection) {
                keywords.addAll((Collection)((Object)extractedKeywords));
            }
            this.putRawValue("Keywords", keywords, rawMap);
            return rawMap;
        }
    }
}

