/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;

public class LinkCategoryActionExecuter
extends ActionExecuterAbstractBase {
    public static final String NAME = "link-category";
    public static final String PARAM_CATEGORY_ASPECT = "category-aspect";
    public static final String PARAM_CATEGORY_VALUE = "category-value";
    private NodeService nodeService;
    private DictionaryService dictionaryService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    @Override
    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add(new ParameterDefinitionImpl(PARAM_CATEGORY_ASPECT, DataTypeDefinition.QNAME, false, this.getParamDisplayLabel(PARAM_CATEGORY_ASPECT)));
        paramList.add(new ParameterDefinitionImpl(PARAM_CATEGORY_VALUE, DataTypeDefinition.NODE_REF, true, this.getParamDisplayLabel(PARAM_CATEGORY_VALUE)));
    }

    @Override
    protected void executeImpl(Action ruleAction, NodeRef actionedUponNodeRef) {
        if (this.nodeService.exists(actionedUponNodeRef)) {
            QName categoryAspect = (QName)ruleAction.getParameterValue(PARAM_CATEGORY_ASPECT);
            if (categoryAspect == null) {
                categoryAspect = ContentModel.ASPECT_GEN_CLASSIFIABLE;
            }
            NodeRef categoryValue = (NodeRef)ruleAction.getParameterValue(PARAM_CATEGORY_VALUE);
            if (this.dictionaryService.isSubClass(categoryAspect, ContentModel.ASPECT_CLASSIFIABLE)) {
                QName categoryProperty = null;
                Map propertyDefs = this.dictionaryService.getAspect(categoryAspect).getProperties();
                for (Map.Entry entry : propertyDefs.entrySet()) {
                    if (!DataTypeDefinition.CATEGORY.equals((Object)((PropertyDefinition)entry.getValue()).getDataType().getName())) continue;
                    categoryProperty = (QName)entry.getKey();
                    break;
                }
                if (categoryProperty == null) {
                    throw new AlfrescoRuntimeException("The category aspect " + categoryAspect.toPrefixString() + " does not have a category property to set.");
                }
                if (categoryAspect != null) {
                    if (!this.nodeService.hasAspect(actionedUponNodeRef, categoryAspect)) {
                        HashMap<QName, NodeRef> properties = new HashMap<QName, NodeRef>();
                        properties.put(categoryProperty, categoryValue);
                        this.nodeService.addAspect(actionedUponNodeRef, categoryAspect, properties);
                    } else {
                        Serializable value = this.nodeService.getProperty(actionedUponNodeRef, categoryProperty);
                        Collection categories = null;
                        if (value == null) {
                            categories = DefaultTypeConverter.INSTANCE.getCollection(NodeRef.class, (Object)categoryValue);
                        } else {
                            categories = DefaultTypeConverter.INSTANCE.getCollection(NodeRef.class, (Object)value);
                            if (!categories.contains(categoryValue)) {
                                categories.add(categoryValue);
                            }
                        }
                        this.nodeService.setProperty(actionedUponNodeRef, categoryProperty, (Serializable)((Object)categories));
                    }
                }
            }
        }
    }
}

