/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.activities;

import java.sql.SQLException;
import java.util.Date;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.activities.ActivityServiceImpl;
import org.alfresco.repo.domain.activities.ActivityPostDAO;
import org.alfresco.repo.domain.activities.ActivityPostEntity;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.activities.ActivityPostService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.extensions.surf.util.ParameterCheck;

public class ActivityPostServiceImpl
implements ActivityPostService {
    private static final Log logger = LogFactory.getLog(ActivityServiceImpl.class);
    private ActivityPostDAO postDAO;
    private TenantService tenantService;
    private int estGridSize = 1;
    private boolean userNamesAreCaseSensitive = false;

    public void setUserNamesAreCaseSensitive(boolean userNamesAreCaseSensitive) {
        this.userNamesAreCaseSensitive = userNamesAreCaseSensitive;
    }

    public void setPostDAO(ActivityPostDAO postDAO) {
        this.postDAO = postDAO;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setEstimatedGridSize(int estGridSize) {
        this.estGridSize = estGridSize;
    }

    @Override
    public void postActivity(String activityType, String siteId, String appTool, String activityData) {
        this.postActivity(activityType, siteId, appTool, activityData, ActivityPostEntity.STATUS.PENDING, this.getCurrentUser());
    }

    @Override
    public void postActivity(String activityType, String siteId, String appTool, String activityData, String userId) {
        this.postActivity(activityType, siteId, appTool, activityData, ActivityPostEntity.STATUS.PENDING, userId);
    }

    @Override
    public void postActivity(String activityType, String siteId, String appTool, NodeRef nodeRef) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        StringBuffer sb = new StringBuffer();
        sb.append("{").append("\"nodeRefL\":\"").append(nodeRef.toString()).append("\"").append("}");
        this.postActivity(activityType, siteId, appTool, sb.toString(), ActivityPostEntity.STATUS.PENDING, this.getCurrentUser());
    }

    @Override
    public void postActivity(String activityType, String siteId, String appTool, NodeRef nodeRef, String name) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        StringBuffer sb = new StringBuffer();
        sb.append("{").append("\"nodeRefL\":\"").append(nodeRef.toString()).append("\"").append(",").append("\"name\":\"").append(name).append("\"").append("}");
        this.postActivity(activityType, siteId, appTool, sb.toString(), ActivityPostEntity.STATUS.PENDING, this.getCurrentUser());
    }

    @Override
    public void postActivity(String activityType, String siteId, String appTool, NodeRef nodeRef, String name, QName typeQName, NodeRef parentNodeRef) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        ParameterCheck.mandatory((String)"typeQName", (Object)typeQName);
        ParameterCheck.mandatory((String)"parentNodeRef", (Object)parentNodeRef);
        StringBuffer sb = new StringBuffer();
        sb.append("{").append("\"nodeRefL\":\"").append(nodeRef.toString()).append("\"").append(",").append("\"name\":\"").append(name).append("\"").append(",").append("\"typeQName\":\"").append(typeQName.toPrefixString()).append("\"").append(",").append("\"parentNodeRef\":\"").append(parentNodeRef.toString()).append("\"").append("}");
        this.postActivity(activityType, siteId, appTool, sb.toString(), ActivityPostEntity.STATUS.PENDING, this.getCurrentUser());
    }

    private void postActivity(String activityType, String siteId, String appTool, String activityData, ActivityPostEntity.STATUS status, String userId) {
        try {
            if (siteId == null) {
                siteId = "";
            } else if (siteId.length() > 255) {
                throw new IllegalArgumentException("Invalid siteId - exceeds 255 chars: " + siteId);
            }
            if (appTool == null) {
                appTool = "";
            } else if (appTool.length() > 36) {
                throw new IllegalArgumentException("Invalid app tool - exceeds 36 chars: " + appTool);
            }
            ParameterCheck.mandatoryString((String)"activityType", (String)activityType);
            if (activityType.length() > 255) {
                throw new IllegalArgumentException("Invalid activity type - exceeds 255 chars: " + activityType);
            }
            if (activityData == null) {
                activityData = "";
            }
            try {
                if (activityData.length() > 0) {
                    String title;
                    JSONObject jo = new JSONObject(new JSONTokener(activityData));
                    if (AuthenticationUtil.isMtEnabled()) {
                        jo.put("tenantDomain", (Object)this.tenantService.getCurrentUserDomain());
                        activityData = jo.toString();
                    }
                    this.checkNodeRef(jo);
                    if (jo.has("title") && (title = jo.getString("title")).length() > 255) {
                        jo.put("title", (Object)title.substring(0, 255));
                        activityData = jo.toString();
                    }
                }
            }
            catch (JSONException e) {
                // empty catch block
            }
            if (activityData.length() > 1024) {
                throw new IllegalArgumentException("Invalid activity data - exceeds 1024 chars: " + activityData);
            }
            ParameterCheck.mandatoryString((String)"userId", (String)userId);
            if (userId.length() > 255) {
                throw new IllegalArgumentException("Invalid user - exceeds 255 chars: " + userId);
            }
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)e);
            throw new IllegalArgumentException("Failed to post activity: " + e, e);
        }
        try {
            Date postDate = new Date();
            ActivityPostEntity activityPost = new ActivityPostEntity();
            activityPost.setUserId(userId);
            activityPost.setSiteNetwork(this.tenantService.getName(siteId));
            activityPost.setAppTool(appTool);
            activityPost.setActivityData(activityData);
            activityPost.setActivityType(activityType);
            activityPost.setPostDate(postDate);
            activityPost.setStatus(status.toString());
            activityPost.setLastModified(postDate);
            int nodeCount = this.estGridSize;
            int userHashCode = userId.hashCode();
            int nodeHash = userHashCode % nodeCount + 1;
            activityPost.setJobTaskNode(nodeHash);
            try {
                long postId = this.postDAO.insertPost(activityPost);
                if (logger.isDebugEnabled()) {
                    activityPost.setId(postId);
                    logger.debug((Object)("Posted: " + activityPost));
                }
            }
            catch (SQLException e) {
                throw new AlfrescoRuntimeException("Failed to post activity: " + e, (Throwable)e);
            }
            catch (Throwable t) {
                throw new AlfrescoRuntimeException("Failed to post activity: " + t, t);
            }
        }
        catch (AlfrescoRuntimeException e) {
            logger.error((Object)e);
        }
    }

    private String getCurrentUser() {
        String userId = AuthenticationUtil.getRunAsUser();
        if (userId != null && !userId.equals("System") && !this.userNamesAreCaseSensitive) {
            userId = userId.toLowerCase();
        }
        return userId;
    }

    private void checkNodeRef(JSONObject jo) throws JSONException {
        String nodeRefStr = null;
        try {
            if (jo.has("nodeRef")) {
                nodeRefStr = jo.getString("nodeRef");
                new NodeRef(nodeRefStr);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid node ref: " + nodeRefStr);
        }
    }
}

