/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.activities;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import org.alfresco.repo.domain.activities.ActivityPostDAO;
import org.alfresco.repo.domain.activities.ActivityPostEntity;
import org.alfresco.repo.jscript.ClasspathScriptLocation;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.activities.ActivityService;
import org.alfresco.service.cmr.activities.FeedControl;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.ScriptService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;

public class ActivityServiceImplTest
extends TestCase {
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private ActivityService activityService;
    private ScriptService scriptService;
    private MutableAuthenticationService authenticationService;
    private SiteService siteService;
    private ActivityPostDAO postDAO;
    private static final String ADMIN_PW = "admin";
    private static final String USER_UN = "bob";
    private static final String USER_PW = "bob";
    private static final String TEST_RUN_ID = "" + System.currentTimeMillis();

    protected void setUp() throws Exception {
        this.activityService = (ActivityService)ctx.getBean("activityService");
        this.scriptService = (ScriptService)ctx.getBean("ScriptService");
        this.siteService = (SiteService)ctx.getBean("SiteService");
        this.postDAO = (ActivityPostDAO)ctx.getBean("postDAO");
        this.authenticationService = (MutableAuthenticationService)ctx.getBean("AuthenticationService");
        this.authenticationService.authenticate(AuthenticationUtil.getAdminUserName(), ADMIN_PW.toCharArray());
    }

    protected void tearDown() throws Exception {
        this.authenticationService.clearCurrentSecurityContext();
    }

    public void testPostValidActivities() throws Exception {
        this.activityService.postActivity("org.alfresco.testActivityType1", null, null, "");
        this.activityService.postActivity("org.alfresco.testActivityType2", "", "", "");
        this.activityService.postActivity("org.alfresco.testActivityType3", "site1", "appToolA", "{ \"var1\" : \"val1\" }");
    }

    public void testPostInvalidActivities() throws Exception {
        try {
            this.activityService.postActivity("", "", "", (NodeRef)null, "");
            ActivityServiceImplTest.fail((String)"invalid post activity");
        }
        catch (IllegalArgumentException iae) {
            ActivityServiceImplTest.assertTrue((boolean)iae.getMessage().contains("nodeRef is a mandatory parameter"));
        }
        try {
            this.activityService.postActivity("", "", "", "");
            ActivityServiceImplTest.fail((String)"invalid post activity");
        }
        catch (IllegalArgumentException iae) {
            ActivityServiceImplTest.assertTrue((boolean)iae.getMessage().contains("activityType is a mandatory parameter"));
        }
        try {
            this.activityService.postActivity("org.alfresco.testActivityType1", "", "", "{ \"nodeRef\" : \"notfound\" }");
            ActivityServiceImplTest.fail((String)"invalid post activity: bad nodeRef");
        }
        catch (IllegalArgumentException iae) {
            ActivityServiceImplTest.assertTrue((boolean)iae.getMessage().contains("Invalid node ref: notfound"));
        }
    }

    public void testGetEmptySiteFeed() throws Exception {
        if (!this.authenticationService.authenticationExists("bob")) {
            this.authenticationService.createAuthentication("bob", "bob".toCharArray());
        }
        this.authenticationService.clearCurrentSecurityContext();
        this.authenticationService.authenticate("bob", "bob".toCharArray());
        String siteId = "emptySite-" + TEST_RUN_ID;
        this.siteService.createSite("mypreset", siteId, "empty site title", "empty site description", SiteVisibility.PUBLIC);
        List<String> siteFeedEntries = this.activityService.getSiteFeedEntries(siteId, "json");
        ActivityServiceImplTest.assertNotNull(siteFeedEntries);
        ActivityServiceImplTest.assertTrue((boolean)siteFeedEntries.isEmpty());
        this.siteService.deleteSite(siteId);
    }

    public void testGetEmptyUserFeed() throws Exception {
        List<String> userFeedEntries = this.activityService.getUserFeedEntries("unknown user", "a format", null);
        ActivityServiceImplTest.assertNotNull(userFeedEntries);
        ActivityServiceImplTest.assertTrue((boolean)userFeedEntries.isEmpty());
        userFeedEntries = this.activityService.getUserFeedEntries("unknown user", "a format", "some site");
        ActivityServiceImplTest.assertNotNull(userFeedEntries);
        ActivityServiceImplTest.assertTrue((boolean)userFeedEntries.isEmpty());
        userFeedEntries = this.activityService.getUserFeedEntries("unknown user", "a format", "some site", true, false, null, null);
        ActivityServiceImplTest.assertNotNull(userFeedEntries);
        ActivityServiceImplTest.assertTrue((boolean)userFeedEntries.isEmpty());
        userFeedEntries = this.activityService.getUserFeedEntries("unknown user", "a format", "some site", false, true, null, null);
        ActivityServiceImplTest.assertNotNull(userFeedEntries);
        ActivityServiceImplTest.assertTrue((boolean)userFeedEntries.isEmpty());
        userFeedEntries = this.activityService.getUserFeedEntries("unknown user", "a format", "some site", true, true, null, null);
        ActivityServiceImplTest.assertNotNull(userFeedEntries);
        ActivityServiceImplTest.assertTrue((boolean)userFeedEntries.isEmpty());
    }

    public void testJSAPI() throws Exception {
        ClasspathScriptLocation location = new ClasspathScriptLocation("org/alfresco/repo/activities/script/test_activityService.js");
        String result = (String)this.scriptService.executeScript(location, new HashMap<String, Object>(0));
        if (result != null && result.length() != 0) {
            ActivityServiceImplTest.fail((String)("The activity service test JS script failed: " + result));
        }
    }

    public void testFeedControls() throws Exception {
        List<FeedControl> feedControls = this.activityService.getFeedControls("bob");
        ActivityServiceImplTest.assertNotNull(feedControls);
        ActivityServiceImplTest.assertTrue((boolean)feedControls.isEmpty());
        if (!this.authenticationService.authenticationExists("bob")) {
            this.authenticationService.createAuthentication("bob", "bob".toCharArray());
        }
        this.authenticationService.clearCurrentSecurityContext();
        this.authenticationService.authenticate("bob", "bob".toCharArray());
        feedControls = this.activityService.getFeedControls();
        ActivityServiceImplTest.assertNotNull(feedControls);
        ActivityServiceImplTest.assertTrue((boolean)feedControls.isEmpty());
        ActivityServiceImplTest.assertFalse((boolean)this.activityService.existsFeedControl(new FeedControl("mySite1", "appTool1")));
        this.activityService.setFeedControl(new FeedControl("mySite1", null));
        this.activityService.setFeedControl(new FeedControl("mySite1", "appTool1"));
        this.activityService.setFeedControl(new FeedControl(null, "appTool2"));
        feedControls = this.activityService.getFeedControls();
        ActivityServiceImplTest.assertEquals((int)3, (int)feedControls.size());
        feedControls = this.activityService.getFeedControls("bob");
        ActivityServiceImplTest.assertEquals((int)3, (int)feedControls.size());
        ActivityServiceImplTest.assertTrue((boolean)this.activityService.existsFeedControl(new FeedControl("mySite1", "appTool1")));
        this.activityService.unsetFeedControl(new FeedControl("mySite1", "appTool1"));
        ActivityServiceImplTest.assertFalse((boolean)this.activityService.existsFeedControl(new FeedControl("mySite1", "appTool1")));
        feedControls = this.activityService.getFeedControls();
        ActivityServiceImplTest.assertEquals((int)2, (int)feedControls.size());
        this.activityService.unsetFeedControl(new FeedControl("mySite1", null));
        this.activityService.unsetFeedControl(new FeedControl(null, "appTool2"));
        feedControls = this.activityService.getFeedControls();
        ActivityServiceImplTest.assertEquals((int)0, (int)feedControls.size());
    }

    public void testLongName_ALF_10362() throws Exception {
        byte[] namePattern = new byte[1024];
        Arrays.fill(namePattern, (byte)65);
        ActivityPostEntity params = new ActivityPostEntity();
        params.setStatus(ActivityPostEntity.STATUS.PENDING.toString());
        int cnt = this.postDAO.selectPosts(params).size();
        this.activityService.postActivity("org.alfresco.testActivityType4", "site2", "appToolA", "{\"title\":\"" + new String(namePattern, "UTF-8") + "\"}");
        ActivityServiceImplTest.assertEquals((int)(cnt + 1), (int)this.postDAO.selectPosts(params).size());
    }
}

