/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.activities.feed;

import java.io.Serializable;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.activities.feed.AbstractUserNotifier;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.repository.NodeRef;

public class ErrorProneUserNotifier
extends AbstractUserNotifier {
    private NodeRef failingPersonNodeRef;
    private ActionService actionService;

    public ErrorProneUserNotifier(NodeRef failingPersonNodeRef) {
        this.failingPersonNodeRef = failingPersonNodeRef;
    }

    public void setActionService(ActionService actionService) {
        this.actionService = actionService;
    }

    @Override
    protected boolean skipUser(NodeRef personNodeRef) {
        return false;
    }

    @Override
    protected Long getFeedId(NodeRef personNodeRef) {
        Map personProps = this.nodeService.getProperties(personNodeRef);
        Long emailFeedDBID = (Long)personProps.get(ContentModel.PROP_EMAIL_FEED_ID);
        if (emailFeedDBID != null) {
            Long l = emailFeedDBID;
            Long l2 = emailFeedDBID = Long.valueOf(emailFeedDBID + 1L);
        } else {
            emailFeedDBID = -1L;
        }
        return emailFeedDBID;
    }

    @Override
    protected void notifyUser(NodeRef personNodeRef, String subjectText, Map<String, Object> model, NodeRef templateNodeRef) {
        String userName = (String)((Object)this.nodeService.getProperty(personNodeRef, ContentModel.PROP_USERNAME));
        Action action = this.actionService.createAction("errorProneActionExecutor");
        action.setParameterValue("failingPersonNodeRef", (Serializable)this.failingPersonNodeRef);
        action.setParameterValue("personNodeRef", (Serializable)personNodeRef);
        action.setParameterValue("userName", (Serializable)((Object)userName));
        this.actionService.executeAction(action, null);
    }
}

