/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.activities.feed;

import java.util.BitSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.activities.feed.AbstractUserNotifier;
import org.alfresco.service.cmr.repository.NodeRef;

public class MockUserNotifier
extends AbstractUserNotifier {
    private BitSet notifiedPersonsTracker = new BitSet();
    private AtomicInteger count = new AtomicInteger(0);

    @Override
    protected boolean skipUser(NodeRef personNodeRef) {
        return false;
    }

    @Override
    protected Long getFeedId(NodeRef personNodeRef) {
        Map personProps = this.nodeService.getProperties(personNodeRef);
        Long emailFeedDBID = (Long)personProps.get(ContentModel.PROP_EMAIL_FEED_ID);
        if (emailFeedDBID != null) {
            Long l = emailFeedDBID;
            Long l2 = emailFeedDBID = Long.valueOf(emailFeedDBID + 1L);
        } else {
            emailFeedDBID = -1L;
        }
        return emailFeedDBID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void notifyUser(NodeRef personNodeRef, String subjectText, Map<String, Object> model, NodeRef templateNodeRef) {
        String username = (String)((Object)this.nodeService.getProperty(personNodeRef, ContentModel.PROP_USERNAME));
        if (username.startsWith("user")) {
            int id = Integer.parseInt(username.substring(4));
            boolean b = false;
            BitSet bitSet = this.notifiedPersonsTracker;
            synchronized (bitSet) {
                b = this.notifiedPersonsTracker.get(id);
            }
            if (b) {
                System.out.println("Already set: " + id);
            } else {
                bitSet = this.notifiedPersonsTracker;
                synchronized (bitSet) {
                    this.notifiedPersonsTracker.set(id);
                }
            }
        }
        this.count.incrementAndGet();
    }

    public int countNotifications() {
        return this.count.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int nextUserId() {
        BitSet bitSet = this.notifiedPersonsTracker;
        synchronized (bitSet) {
            return this.notifiedPersonsTracker.nextClearBit(1);
        }
    }
}

