/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch;

import java.util.Date;
import java.util.List;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.admin.patch.AppliedPatch;
import org.alfresco.repo.admin.patch.Patch;
import org.alfresco.repo.admin.patch.PatchService;
import org.alfresco.repo.admin.patch.SamplePatch;
import org.alfresco.repo.security.authentication.AuthenticationContext;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.service.cmr.admin.PatchException;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;

public class PatchTest
extends TestCase {
    private static final ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private TransactionService transactionService;
    private NamespaceService namespaceService;
    private NodeService nodeService;
    private SearchService searchService;
    private AuthenticationContext authenticationContext;
    private TenantAdminService tenantAdminService;
    private PatchService patchService;

    public PatchTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.transactionService = (TransactionService)ctx.getBean("transactionComponent");
        this.namespaceService = (NamespaceService)ctx.getBean("namespaceService");
        this.nodeService = (NodeService)ctx.getBean("nodeService");
        this.searchService = (SearchService)ctx.getBean("searchService");
        this.authenticationContext = (AuthenticationContext)ctx.getBean("authenticationContext");
        this.tenantAdminService = (TenantAdminService)ctx.getBean("tenantAdminService");
        this.patchService = (PatchService)ctx.getBean("PatchService");
        this.patchService.registerPatch((Patch)ctx.getBean("patch.sample.02"));
        this.patchService.registerPatch((Patch)ctx.getBean("patch.sample.01"));
        this.patchService.registerPatch((Patch)ctx.getBean("patch.sample.03"));
    }

    public void testSetup() throws Exception {
        PatchTest.assertNotNull((Object)this.transactionService);
        PatchTest.assertNotNull((Object)this.patchService);
    }

    private SamplePatch constructSamplePatch(boolean mustFail) {
        SamplePatch patch = new SamplePatch(mustFail, this.transactionService);
        patch.setNamespaceService(this.namespaceService);
        patch.setNodeService(this.nodeService);
        patch.setSearchService(this.searchService);
        patch.setAuthenticationContext(this.authenticationContext);
        patch.setTenantAdminService(this.tenantAdminService);
        patch.setApplicationEventPublisher((ApplicationEventPublisher)ctx);
        return patch;
    }

    public void testSimplePatchSuccess() throws Exception {
        SamplePatch patch = this.constructSamplePatch(false);
        String report = patch.apply();
        PatchTest.assertEquals((String)"Patch report incorrect", (String)"SamplePatch applied successfully", (String)report);
    }

    public void testPatchReapplication() {
        SamplePatch patch = this.constructSamplePatch(false);
        patch.apply();
        try {
            patch.apply();
            PatchTest.fail((String)"AbstractPatch failed to prevent reapplication");
        }
        catch (AlfrescoRuntimeException e) {
            // empty catch block
        }
        patch = this.constructSamplePatch(true);
        try {
            patch.apply();
            PatchTest.fail((String)"Failed patch didn't throw PatchException");
        }
        catch (PatchException e) {
            // empty catch block
        }
        try {
            patch.apply();
            PatchTest.fail((String)"Reapplication of failed patch didn't throw PatchException");
        }
        catch (PatchException patchException) {
            // empty catch block
        }
    }

    public void testApplyOutstandingPatches() throws Exception {
        boolean success = this.patchService.applyOutstandingPatches();
        PatchTest.assertTrue((boolean)success);
        List<AppliedPatch> appliedPatches = this.patchService.getPatches(null, null);
        boolean found01 = false;
        boolean found02 = false;
        boolean found03 = false;
        for (AppliedPatch appliedPatch : appliedPatches) {
            if (appliedPatch.getId().equals("Sample01")) {
                found01 = true;
                PatchTest.assertTrue((String)("Patch info didn't indicate success: " + appliedPatch), (boolean)appliedPatch.getSucceeded());
                continue;
            }
            if (appliedPatch.getId().equals("Sample02")) {
                found02 = true;
                PatchTest.assertTrue((String)("Patch info didn't indicate success: " + appliedPatch), (boolean)appliedPatch.getSucceeded());
                continue;
            }
            if (!appliedPatch.getId().equals("Sample03")) continue;
            found03 = true;
            PatchTest.assertTrue((String)("Patch info didn't indicate success: " + appliedPatch), (boolean)appliedPatch.getSucceeded());
        }
        PatchTest.assertTrue((String)"Sample 01 not in list of applied patches", (boolean)found01);
        PatchTest.assertTrue((String)"Sample 02 not in list of applied patches", (boolean)found02);
        PatchTest.assertTrue((String)"Sample 03 not in list of applied patches", (boolean)found03);
    }

    public void testGetPatchesByDate() throws Exception {
        this.testApplyOutstandingPatches();
        List<AppliedPatch> appliedPatches = this.patchService.getPatches(null, null);
        PatchTest.assertTrue((String)"Expected at least 2 applied patches", (appliedPatches.size() >= 2 ? 1 : 0) != 0);
        List<AppliedPatch> appliedPatchesAllDates = this.patchService.getPatches(null, null);
        PatchTest.assertEquals((String)"Applied patches by all dates doesn't match all applied patches", (int)appliedPatches.size(), (int)appliedPatchesAllDates.size());
        List<AppliedPatch> appliedPatchesFutureDates = this.patchService.getPatches(new Date(), new Date());
        PatchTest.assertEquals((String)"Query returned results for dates when no patches should exist", (int)0, (int)appliedPatchesFutureDates.size());
    }
}

