/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.domain.patch.PatchDAO;
import org.alfresco.repo.domain.permissions.AccessControlListDAO;
import org.alfresco.repo.domain.permissions.AclDAO;
import org.alfresco.repo.security.permissions.ACLType;
import org.alfresco.repo.security.permissions.impl.AclChange;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class FixAclInheritancePatch
extends AbstractPatch {
    private static final String MSG_SUCCESS = "patch.fixAclInheritance.result";
    private static Log logger = LogFactory.getLog(FixAclInheritancePatch.class);
    private AclDAO aclDAO;
    private PatchDAO patchDAO;
    private AccessControlListDAO accessControlListDao;
    private RetryingTransactionHelper retryingTransactionHelper;
    private long count = 0L;

    public void setAclDAO(AclDAO aclDAO) {
        this.aclDAO = aclDAO;
    }

    public void setPatchDAO(PatchDAO patchDAO) {
        this.patchDAO = patchDAO;
    }

    public void setAccessControlListDao(AccessControlListDAO accessControlListDao) {
        this.accessControlListDao = accessControlListDao;
    }

    public void setRetryingTransactionHelper(RetryingTransactionHelper retryingTransactionHelper) {
        this.retryingTransactionHelper = retryingTransactionHelper;
    }

    @Override
    protected String applyInternal() throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> cb;
        ACLType parentType;
        ACLType childType;
        Long childNodeId;
        Long primaryParentAclType;
        Long primaryParentAclId;
        Long childAclType;
        Long childAclId;
        List<Map<String, Object>> rows = this.retryingTransactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<List<Map<String, Object>>>(){

            @Override
            public List<Map<String, Object>> execute() throws Throwable {
                return FixAclInheritancePatch.this.patchDAO.getAclsThatInheritWithInheritanceUnset();
            }
        }, false, true);
        for (Map<String, Object> row : rows) {
            childAclId = (Long)row.get("childAclId");
            childAclType = (Long)row.get("childAclType");
            primaryParentAclId = (Long)row.get("primaryParentAclId");
            primaryParentAclType = (Long)row.get("primaryParentAclType");
            childNodeId = (Long)row.get("childNodeId");
            childType = ACLType.getACLTypeFromId(childAclType.intValue());
            parentType = ACLType.getACLTypeFromId(primaryParentAclType.intValue());
            cb = null;
            switch (childType) {
                case DEFINING: {
                    cb = new FixInherited(primaryParentAclId, childAclId);
                    this.retryingTransactionHelper.doInTransaction(cb, false, true);
                    ++this.count;
                    break;
                }
                case FIXED: {
                    break;
                }
                case GLOBAL: {
                    break;
                }
                case LAYERED: {
                    break;
                }
                case OLD: {
                    break;
                }
                case SHARED: {
                    cb = new FixSharedUnsetInheritanceCallback(childNodeId, primaryParentAclId, childAclId);
                    this.retryingTransactionHelper.doInTransaction(cb, false, true);
                    ++this.count;
                }
            }
        }
        rows = this.retryingTransactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<List<Map<String, Object>>>(){

            @Override
            public List<Map<String, Object>> execute() throws Throwable {
                return FixAclInheritancePatch.this.patchDAO.getSharedAclsThatDoNotInheritCorrectlyFromTheirDefiningAcl();
            }
        }, false, true);
        for (Map<String, Object> row : rows) {
            Long inheritedAclId = (Long)row.get("inheritedAclId");
            Long inheritedAclType = (Long)row.get("inheritedAclType");
            Long aclId = (Long)row.get("aclId");
            Long aclType = (Long)row.get("aclType");
            ACLType inheritedType = ACLType.getACLTypeFromId(inheritedAclType.intValue());
            ACLType type = ACLType.getACLTypeFromId(aclType.intValue());
            FixSharedAclCallback cb2 = new FixSharedAclCallback(inheritedAclId, aclId);
            this.retryingTransactionHelper.doInTransaction(cb2, false, true);
            ++this.count;
        }
        rows = this.retryingTransactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<List<Map<String, Object>>>(){

            @Override
            public List<Map<String, Object>> execute() throws Throwable {
                return FixAclInheritancePatch.this.patchDAO.getSharedAclsThatDoNotInheritCorrectlyFromThePrimaryParent();
            }
        }, false, true);
        for (Map<String, Object> row : rows) {
            childAclId = (Long)row.get("childAclId");
            childAclType = (Long)row.get("childAclType");
            primaryParentAclId = (Long)row.get("primaryParentAclId");
            primaryParentAclType = (Long)row.get("primaryParentAclType");
            childNodeId = (Long)row.get("childNodeId");
            childType = ACLType.getACLTypeFromId(childAclType.intValue());
            parentType = ACLType.getACLTypeFromId(primaryParentAclType.intValue());
            cb = new FixSharedAclCallback(primaryParentAclId, childAclId);
            this.retryingTransactionHelper.doInTransaction(cb, false, true);
            ++this.count;
        }
        rows = this.retryingTransactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<List<Map<String, Object>>>(){

            @Override
            public List<Map<String, Object>> execute() throws Throwable {
                return FixAclInheritancePatch.this.patchDAO.getDefiningAclsThatDoNotInheritCorrectlyFromThePrimaryParent();
            }
        }, false, true);
        Iterator<Map<String, Object>> i$ = rows.iterator();
        if (i$.hasNext()) {
            Map<String, Object> row;
            row = i$.next();
            childAclId = (Long)row.get("childAclId");
            childAclType = (Long)row.get("childAclType");
            primaryParentAclId = (Long)row.get("primaryParentAclId");
            primaryParentAclType = (Long)row.get("primaryParentAclType");
            childNodeId = (Long)row.get("childNodeId");
            childType = ACLType.getACLTypeFromId(childAclType.intValue());
            parentType = ACLType.getACLTypeFromId(primaryParentAclType.intValue());
            cb = new FixInherited(primaryParentAclId, childAclId);
            this.retryingTransactionHelper.doInTransaction(cb, false, true);
            ++this.count;
        }
        rows = this.retryingTransactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<List<Map<String, Object>>>(){

            @Override
            public List<Map<String, Object>> execute() throws Throwable {
                return FixAclInheritancePatch.this.patchDAO.getAclsThatInheritFromNonPrimaryParent();
            }
        }, false, true);
        for (Map<String, Object> row : rows) {
            childAclId = (Long)row.get("childAclId");
            childAclType = (Long)row.get("childAclType");
            primaryParentAclId = (Long)row.get("primaryParentAclId");
            primaryParentAclType = (Long)row.get("primaryParentAclType");
            childNodeId = (Long)row.get("childNodeId");
            childType = ACLType.getACLTypeFromId(childAclType.intValue());
            parentType = ACLType.getACLTypeFromId(primaryParentAclType.intValue());
            cb = null;
            switch (childType) {
                case DEFINING: {
                    cb = new FixInherited(primaryParentAclId, childAclId);
                    this.retryingTransactionHelper.doInTransaction(cb, false, true);
                    ++this.count;
                    break;
                }
                case FIXED: {
                    break;
                }
                case GLOBAL: {
                    break;
                }
                case LAYERED: {
                    break;
                }
                case OLD: {
                    break;
                }
                case SHARED: {
                    cb = new SetFixedAclsCallback(childNodeId, primaryParentAclId, childAclId);
                    this.retryingTransactionHelper.doInTransaction(cb, false, true);
                    ++this.count;
                }
            }
        }
        String msg = I18NUtil.getMessage((String)MSG_SUCCESS, (Object[])new Object[]{this.count});
        return msg;
    }

    private class FixInherited
    implements RetryingTransactionHelper.RetryingTransactionCallback<Void> {
        Long primaryParentAclId;
        Long childAclId;

        FixInherited(Long primaryParentAclId, Long childAclId) {
            this.primaryParentAclId = primaryParentAclId;
            this.childAclId = childAclId;
        }

        @Override
        public Void execute() throws Throwable {
            FixAclInheritancePatch.this.aclDAO.enableInheritance(this.childAclId, this.primaryParentAclId);
            return null;
        }
    }

    private class FixSharedAclCallback
    implements RetryingTransactionHelper.RetryingTransactionCallback<Void> {
        Long inheritedAclId;
        Long aclId;

        FixSharedAclCallback(Long inheritedAclId, Long aclId) {
            this.inheritedAclId = inheritedAclId;
            this.aclId = aclId;
        }

        @Override
        public Void execute() throws Throwable {
            FixAclInheritancePatch.this.aclDAO.fixSharedAcl(this.inheritedAclId, this.aclId);
            return null;
        }
    }

    private class SetFixedAclsCallback
    implements RetryingTransactionHelper.RetryingTransactionCallback<Void> {
        Long childNodeId;
        Long primaryParentAclId;
        Long childAclId;

        SetFixedAclsCallback(Long childNodeId, Long primaryParentAclId, Long childAclId) {
            this.childNodeId = childNodeId;
            this.primaryParentAclId = primaryParentAclId;
            this.childAclId = childAclId;
        }

        @Override
        public Void execute() throws Throwable {
            ArrayList<AclChange> changes = new ArrayList<AclChange>();
            FixAclInheritancePatch.this.accessControlListDao.setFixedAcls(this.childNodeId, this.primaryParentAclId, null, this.childAclId, changes, true);
            return null;
        }
    }

    private class FixSharedUnsetInheritanceCallback
    implements RetryingTransactionHelper.RetryingTransactionCallback<Void> {
        Long childNodeId;
        Long primaryParentAclId;
        Long childAclId;

        FixSharedUnsetInheritanceCallback(Long childNodeId, Long primaryParentAclId, Long childAclId) {
            this.childNodeId = childNodeId;
            this.primaryParentAclId = primaryParentAclId;
            this.childAclId = childAclId;
        }

        @Override
        public Void execute() throws Throwable {
            Long inheritedAclId = FixAclInheritancePatch.this.aclDAO.getInheritedAccessControlList(this.primaryParentAclId);
            if (inheritedAclId.equals(this.childAclId)) {
                FixAclInheritancePatch.this.aclDAO.fixSharedAcl(this.primaryParentAclId, this.childAclId);
            } else {
                ArrayList<AclChange> changes = new ArrayList<AclChange>();
                FixAclInheritancePatch.this.accessControlListDao.setFixedAcls(this.childNodeId, this.primaryParentAclId, null, this.childAclId, changes, true);
            }
            return null;
        }
    }
}

