/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.importer.ImporterBootstrap;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.cmr.admin.PatchException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class FixBpmPackagesPatch
extends AbstractPatch {
    private static final String MSG_SUCCESS = "patch.fixBpmPackages.result";
    private static final String ERR_MSG_INVALID_BOOTSTRAP_STORE = "patch.fixBpmPackages.invalidBootsrapStore";
    private static final String ERR_MSG_EMPTY_CONTAINER = "patch.fixBpmPackages.emptyContainer";
    private static final Log logger = LogFactory.getLog(FixBpmPackagesPatch.class);
    private ImporterBootstrap importerBootstrap;

    public void setImporterBootstrap(ImporterBootstrap importerBootstrap) {
        this.importerBootstrap = importerBootstrap;
    }

    @Override
    protected String applyInternal() throws Exception {
        String sysWorkflowContainer;
        QName sysWorkflowQName;
        String sysContainer;
        QName sysContainerQName;
        List refs;
        int packagesCount = 0;
        StoreRef store = this.importerBootstrap.getStoreRef();
        if (store == null) {
            throw new PatchException(ERR_MSG_INVALID_BOOTSTRAP_STORE);
        }
        NodeRef rootRef = this.nodeService.getRootNode(store);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("StoreRef:" + store + " RootNodeRef: " + rootRef));
        }
        if ((refs = this.nodeService.getChildAssocs(rootRef, (QNamePattern)ContentModel.ASSOC_CHILDREN, (QNamePattern)(sysContainerQName = QName.createQName((String)(sysContainer = this.importerBootstrap.getConfiguration().getProperty("system.system_container.childname")), (NamespacePrefixResolver)this.namespaceService)))) == null || refs.size() == 0) {
            throw new PatchException(ERR_MSG_EMPTY_CONTAINER, sysContainer);
        }
        NodeRef sysNodeRef = ((ChildAssociationRef)refs.get(0)).getChildRef();
        if ((refs = this.nodeService.getChildAssocs(sysNodeRef, (QNamePattern)ContentModel.ASSOC_CHILDREN, (QNamePattern)(sysWorkflowQName = QName.createQName((String)(sysWorkflowContainer = this.importerBootstrap.getConfiguration().getProperty("system.workflow_container.childname")), (NamespacePrefixResolver)this.namespaceService)))) == null || refs.size() == 0) {
            throw new PatchException(ERR_MSG_EMPTY_CONTAINER, sysWorkflowContainer);
        }
        NodeRef workflowContainerRef = ((ChildAssociationRef)refs.get(0)).getChildRef();
        if ((refs = this.nodeService.getChildAssocs(workflowContainerRef, (QNamePattern)ContentModel.ASSOC_CHILDREN, RegexQNamePattern.MATCH_ALL)) == null || refs.size() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("There are no any packages in the container " + sysWorkflowContainer));
            }
            return I18NUtil.getMessage((String)MSG_SUCCESS, (Object[])new Object[]{packagesCount});
        }
        NodeRef packagesContainerRef = ((ChildAssociationRef)refs.get(0)).getChildRef();
        refs = this.nodeService.getChildAssocs(packagesContainerRef, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Found " + refs.size() + " packages to convert"));
        }
        NodeRef packageRef = null;
        for (ChildAssociationRef assocRef : refs) {
            packageRef = assocRef.getChildRef();
            QName typeQname = this.nodeService.getType(packageRef);
            String name = (String)((Object)this.nodeService.getProperty(packageRef, ContentModel.PROP_NAME));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Package " + name + " type " + typeQname));
            }
            if (!this.nodeService.getType(packageRef).equals((Object)WorkflowModel.TYPE_PACKAGE)) {
                this.nodeService.setType(packageRef, WorkflowModel.TYPE_PACKAGE);
            }
            List packageItemsAssocs = this.nodeService.getChildAssocs(packageRef, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
            for (ChildAssociationRef itemAssoc : packageItemsAssocs) {
                NodeRef parentRef = itemAssoc.getParentRef();
                NodeRef childRef = itemAssoc.getChildRef();
                String itemName = (String)((Object)this.nodeService.getProperty(childRef, ContentModel.PROP_NAME));
                if (itemAssoc.isPrimary()) {
                    logger.error((Object)("Association between package: " + name + " and item: " + itemName + " is primary association, so removing this assiciation will result in child node deletion"));
                    continue;
                }
                if (itemAssoc.getTypeQName().equals((Object)WorkflowModel.ASSOC_PACKAGE_CONTAINS)) continue;
                boolean assocRemoved = this.nodeService.removeChildAssociation(itemAssoc);
                if (assocRemoved) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Association between package: " + name + " and item: " + itemName + " was removed"));
                    }
                } else {
                    if (!logger.isErrorEnabled()) continue;
                    logger.error((Object)("Association between package: " + name + " and item: " + itemName + " doesn't exist"));
                    continue;
                }
                this.nodeService.addChild(parentRef, childRef, WorkflowModel.ASSOC_PACKAGE_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)itemName)));
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("New association has been created between package: " + name + " and item: " + itemName));
            }
            ++packagesCount;
        }
        return I18NUtil.getMessage((String)MSG_SUCCESS, (Object[])new Object[]{packagesCount});
    }
}

