/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.WCMAppModel;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.repo.search.AVMSnapShotTriggeredIndexingMethodInterceptor;
import org.alfresco.repo.search.AVMSnapShotTriggeredIndexingMethodInterceptorImpl;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.avm.AVMStoreDescriptor;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.springframework.extensions.surf.util.I18NUtil;

public class MoveWCMToGroupBasedPermissionsPatch
extends AbstractPatch {
    public static final String[] PERMISSIONS = new String[]{"ContentManager", "ContentPublisher", "ContentContributor", "ContentReviewer"};
    protected static final String WCM_STORE_SEPARATOR = "--";
    private static final String MSG_SUCCESS = "patch.moveWCMToGroupBasedPermissionsPatch.result";
    AVMSnapShotTriggeredIndexingMethodInterceptor avmSnapShotTriggeredIndexingMethodInterceptor;
    AVMService avmService;
    PermissionService permissionService;
    AuthorityService authorityService;
    String replaceAllWith = "ContentManager";

    public void setAvmService(AVMService avmService) {
        this.avmService = avmService;
    }

    public void setAvmSnapShotTriggeredIndexingMethodInterceptor(AVMSnapShotTriggeredIndexingMethodInterceptor avmSnapShotTriggeredIndexingMethodInterceptor) {
        this.avmSnapShotTriggeredIndexingMethodInterceptor = avmSnapShotTriggeredIndexingMethodInterceptor;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setReplaceAllWith(String replaceAllWith) {
        this.replaceAllWith = replaceAllWith;
    }

    @Override
    protected String applyInternal() throws Exception {
        List<AVMStoreDescriptor> stores = this.avmService.getStores();
        for (AVMStoreDescriptor store : stores) {
            Map<QName, PropertyValue> storeProperties = this.avmService.getStoreProperties(store.getName());
            switch (AVMSnapShotTriggeredIndexingMethodInterceptorImpl.StoreType.getStoreType(store.getName(), store, storeProperties)) {
                case STAGING: {
                    this.fixAllPermissions(store);
                    this.setStagingAreaPermissions(store);
                    this.setStagingAreaMasks(store);
                    break;
                }
                case AUTHOR: 
                case AUTHOR_PREVIEW: 
                case AUTHOR_WORKFLOW: 
                case AUTHOR_WORKFLOW_PREVIEW: {
                    this.fixAllStagingPermissions(store);
                    this.setSandBoxMasks(store);
                    break;
                }
                case STAGING_PREVIEW: {
                    this.fixAllStagingPermissions(store);
                    this.setStagingAreaMasks(store);
                    break;
                }
                case WORKFLOW: 
                case WORKFLOW_PREVIEW: {
                    break;
                }
            }
        }
        String msg = I18NUtil.getMessage((String)MSG_SUCCESS);
        return msg;
    }

    private boolean isPermissionSet(NodeRef nodeRef, String authority, String permission) {
        Set set = this.permissionService.getAllSetPermissions(nodeRef);
        for (AccessPermission ap : set) {
            if (!ap.getAuthority().equals(authority) || !ap.isSetDirectly() || !ap.getPermission().equals(permission)) continue;
            return true;
        }
        return false;
    }

    private boolean isMaskSet(StoreRef storeRef, String authority, String permission) {
        Set set = this.permissionService.getAllSetPermissions(storeRef);
        for (AccessPermission ap : set) {
            if (!ap.getAuthority().equals(authority) || !ap.isSetDirectly() || !ap.getPermission().equals(permission)) continue;
            return true;
        }
        return false;
    }

    private void makeGroupsIfRequired(String stagingStoreName, NodeRef dirRef) {
        for (String permission : PERMISSIONS) {
            String shortName = stagingStoreName + "-" + permission;
            String group = this.authorityService.getName(AuthorityType.GROUP, shortName);
            if (this.authorityService.authorityExists(group)) continue;
            String newGroup = this.authorityService.createAuthority(AuthorityType.GROUP, shortName);
            this.permissionService.setPermission(dirRef, newGroup, permission, true);
        }
    }

    protected void addToGroupIfRequired(String stagingStoreName, String user, String permission) {
        String shortName = stagingStoreName + "-" + permission;
        String group = this.authorityService.getName(AuthorityType.GROUP, shortName);
        Set<String> members = this.authorityService.getContainedAuthorities(AuthorityType.USER, group, true);
        if (!members.contains(user)) {
            this.authorityService.addAuthority(group, user);
        }
    }

    private void fixAllPermissions(AVMStoreDescriptor store) {
        this.fixAllPermissionsImpl(store.getName());
    }

    private void fixAllStagingPermissions(AVMStoreDescriptor store) {
        String stagingAreaName = this.extractStagingAreaName(store.getName());
        this.fixAllPermissionsImpl(stagingAreaName);
    }

    private void fixAllPermissionsImpl(String stagingStoreName) {
        QName propQName = QName.createQName(null, (String)".web_project.noderef");
        PropertyValue pValue = this.avmService.getStoreProperty(stagingStoreName, propQName);
        if (pValue != null) {
            NodeRef webProjectNodeRef = (NodeRef)pValue.getValue(DataTypeDefinition.NODE_REF);
            List userInfoRefs = this.nodeService.getChildAssocs(webProjectNodeRef, (QNamePattern)WCMAppModel.ASSOC_WEBUSER, RegexQNamePattern.MATCH_ALL);
            for (ChildAssociationRef ref : userInfoRefs) {
                NodeRef userInfoRef = ref.getChildRef();
                String userrole = (String)((Object)this.nodeService.getProperty(userInfoRef, WCMAppModel.PROP_WEBUSERROLE));
                if (!userrole.equals("All")) continue;
                this.nodeService.setProperty(userInfoRef, WCMAppModel.PROP_WEBUSERROLE, (Serializable)((Object)this.replaceAllWith));
            }
        }
    }

    protected void setStagingAreaPermissions(AVMStoreDescriptor store) throws Exception {
        QName propQName = QName.createQName(null, (String)".web_project.noderef");
        NodeRef dirRef = AVMNodeConverter.ToNodeRef(-1, store.getName() + ":/www");
        this.makeGroupsIfRequired(store.getName(), dirRef);
        if (!this.isPermissionSet(dirRef, "GROUP_EVERYONE", "Read")) {
            this.permissionService.setPermission(dirRef, "GROUP_EVERYONE", "Read", true);
        }
        for (String permission : PERMISSIONS) {
            String cms = this.authorityService.getName(AuthorityType.GROUP, store.getName() + "-" + permission);
            this.permissionService.setPermission(dirRef, cms, permission, true);
        }
        PropertyValue pValue = this.avmService.getStoreProperty(store.getName(), propQName);
        if (pValue != null) {
            NodeRef webProjectNodeRef = (NodeRef)pValue.getValue(DataTypeDefinition.NODE_REF);
            List userInfoRefs = this.nodeService.getChildAssocs(webProjectNodeRef, (QNamePattern)WCMAppModel.ASSOC_WEBUSER, RegexQNamePattern.MATCH_ALL);
            for (ChildAssociationRef ref : userInfoRefs) {
                String userrole;
                NodeRef userInfoRef = ref.getChildRef();
                String username = (String)((Object)this.nodeService.getProperty(userInfoRef, WCMAppModel.PROP_WEBUSERNAME));
                if (this.isPermissionSet(dirRef, username, userrole = (String)((Object)this.nodeService.getProperty(userInfoRef, WCMAppModel.PROP_WEBUSERROLE)))) {
                    this.permissionService.deletePermission(dirRef, username, userrole);
                }
                this.addToGroupIfRequired(store.getName(), username, userrole);
            }
        }
    }

    protected void setStagingAreaMasks(AVMStoreDescriptor store) {
        NodeRef dirRef = AVMNodeConverter.ToNodeRef(-1, store.getName() + ":/www");
        if (!this.isMaskSet(dirRef.getStoreRef(), "GROUP_EVERYONE", "Read")) {
            this.permissionService.setPermission(dirRef.getStoreRef(), "GROUP_EVERYONE", "Read", true);
        }
        String cms = this.authorityService.getName(AuthorityType.GROUP, store.getName() + "-" + "ContentManager");
        if (!this.isMaskSet(dirRef.getStoreRef(), cms, "ChangePermissions")) {
            this.permissionService.setPermission(dirRef.getStoreRef(), cms, "ChangePermissions", true);
        }
        if (!this.isMaskSet(dirRef.getStoreRef(), cms, "ReadPermissions")) {
            this.permissionService.setPermission(dirRef.getStoreRef(), cms, "ReadPermissions", true);
        }
        QName propQName = QName.createQName(null, (String)".web_project.noderef");
        PropertyValue pValue = this.avmService.getStoreProperty(store.getName(), propQName);
        if (pValue != null) {
            NodeRef webProjectNodeRef = (NodeRef)pValue.getValue(DataTypeDefinition.NODE_REF);
            List userInfoRefs = this.nodeService.getChildAssocs(webProjectNodeRef, (QNamePattern)WCMAppModel.ASSOC_WEBUSER, RegexQNamePattern.MATCH_ALL);
            for (ChildAssociationRef ref : userInfoRefs) {
                NodeRef userInfoRef = ref.getChildRef();
                String username = (String)((Object)this.nodeService.getProperty(userInfoRef, WCMAppModel.PROP_WEBUSERNAME));
                String userrole = (String)((Object)this.nodeService.getProperty(userInfoRef, WCMAppModel.PROP_WEBUSERROLE));
                if (!userrole.equals("ContentManager")) continue;
                if (this.isMaskSet(dirRef.getStoreRef(), username, "ChangePermissions")) {
                    this.permissionService.deletePermission(dirRef.getStoreRef(), username, "ChangePermissions");
                }
                if (!this.isMaskSet(dirRef.getStoreRef(), username, "ReadPermissions")) continue;
                this.permissionService.deletePermission(dirRef.getStoreRef(), username, "ReadPermissions");
            }
        }
    }

    protected void setSandBoxMasks(AVMStoreDescriptor sandBoxStore) {
        String owner = this.extractOwner(sandBoxStore.getName());
        String stagingAreaName = this.extractStagingAreaName(sandBoxStore.getName());
        QName propQName = QName.createQName(null, (String)".web_project.noderef");
        NodeRef dirRef = AVMNodeConverter.ToNodeRef(-1, sandBoxStore.getName() + ":/www");
        PropertyValue pValue = this.avmService.getStoreProperty(stagingAreaName, propQName);
        if (!this.isMaskSet(dirRef.getStoreRef(), "GROUP_EVERYONE", "Read")) {
            this.permissionService.setPermission(dirRef.getStoreRef(), "GROUP_EVERYONE", "Read", true);
        }
        String cms = this.authorityService.getName(AuthorityType.GROUP, stagingAreaName + "-" + "ContentManager");
        if (!this.isMaskSet(dirRef.getStoreRef(), cms, "ContentManager")) {
            this.permissionService.setPermission(dirRef.getStoreRef(), cms, "ContentManager", true);
        }
        if (pValue != null) {
            NodeRef webProjectNodeRef = (NodeRef)pValue.getValue(DataTypeDefinition.NODE_REF);
            List userInfoRefs = this.nodeService.getChildAssocs(webProjectNodeRef, (QNamePattern)WCMAppModel.ASSOC_WEBUSER, RegexQNamePattern.MATCH_ALL);
            for (ChildAssociationRef ref : userInfoRefs) {
                NodeRef userInfoRef = ref.getChildRef();
                String username = (String)((Object)this.nodeService.getProperty(userInfoRef, WCMAppModel.PROP_WEBUSERNAME));
                String userrole = (String)((Object)this.nodeService.getProperty(userInfoRef, WCMAppModel.PROP_WEBUSERROLE));
                if (username.equals(owner)) {
                    this.permissionService.setPermission(dirRef.getStoreRef(), username, "All", true);
                    continue;
                }
                if (!userrole.equals("ContentManager") || !this.isMaskSet(dirRef.getStoreRef(), username, userrole)) continue;
                this.permissionService.deletePermission(dirRef.getStoreRef(), username, userrole);
            }
        }
    }

    private String extractOwner(String name) {
        int start = name.indexOf(WCM_STORE_SEPARATOR);
        if (start == -1) {
            throw new UnsupportedOperationException(name);
        }
        int end = name.indexOf(WCM_STORE_SEPARATOR, start + 1);
        if (end == -1) {
            return name.substring(start + 2);
        }
        return name.substring(start + 2, end);
    }

    protected String extractStagingAreaName(String name) {
        int index = name.indexOf(WCM_STORE_SEPARATOR);
        if (index == -1) {
            throw new UnsupportedOperationException(name);
        }
        return name.substring(0, index);
    }
}

