/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.site.SiteModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.springframework.extensions.surf.util.I18NUtil;

public class WebSiteAddModeratedPatch
extends AbstractPatch {
    private PermissionService permissionService;
    private SiteService siteService;
    private static final String MSG_SUCCESS = "patch.webSiteAddModerated.result";

    @Override
    protected String applyInternal() throws Exception {
        String nameFilter = null;
        String sitePresetFilter = null;
        List<SiteInfo> sites = this.getSiteService().listSites(nameFilter, sitePresetFilter);
        for (SiteInfo site : sites) {
            SiteVisibility visibility = SiteVisibility.PRIVATE;
            NodeRef siteNodeRef = site.getNodeRef();
            String visibilityValue = (String)((Object)this.nodeService.getProperty(siteNodeRef, SiteModel.PROP_SITE_VISIBILITY));
            if (visibilityValue != null) continue;
            Set permissions = this.permissionService.getAllSetPermissions(siteNodeRef);
            for (AccessPermission permission : permissions) {
                if (!permission.getAuthority().equals("GROUP_EVERYONE") || !permission.getPermission().equals("SiteConsumer")) continue;
                visibility = SiteVisibility.PUBLIC;
                break;
            }
            this.nodeService.setProperty(siteNodeRef, SiteModel.PROP_SITE_VISIBILITY, (Serializable)((Object)visibility.toString()));
        }
        String msg = I18NUtil.getMessage((String)MSG_SUCCESS);
        return msg;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public PermissionService getPermissionService() {
        return this.permissionService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }
}

