/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.audit;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.debug.NodeStoreInspector;
import org.springframework.context.ApplicationContext;

public class AuditableAspectTest
extends TestCase {
    private static final ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private TransactionService transactionService;
    private NodeService nodeService;
    private ContentService contentService;
    private BehaviourFilter behaviourFilter;
    private StoreRef storeRef;
    private NodeRef rootNodeRef;

    public void setUp() throws Exception {
        ServiceRegistry serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.transactionService = serviceRegistry.getTransactionService();
        this.nodeService = serviceRegistry.getNodeService();
        this.contentService = serviceRegistry.getContentService();
        this.behaviourFilter = (BehaviourFilter)ctx.getBean("policyBehaviourFilter");
        AuthenticationUtil.setRunAsUserSystem();
        this.storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(this.storeRef);
    }

    protected void tearDown() throws Exception {
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    public void testAudit() {
        ChildAssociationRef childAssocRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}testfolder"), ContentModel.TYPE_FOLDER);
        this.assertAuditableProperties(childAssocRef.getChildRef());
        System.out.println(NodeStoreInspector.dumpNodeStore(this.nodeService, this.storeRef));
    }

    public void testNoAudit() {
        HashMap<QName, Object> personProps = new HashMap<QName, Object>();
        personProps.put(ContentModel.PROP_USERNAME, "test person");
        personProps.put(ContentModel.PROP_HOMEFOLDER, this.rootNodeRef);
        personProps.put(ContentModel.PROP_FIRSTNAME, "test first name");
        personProps.put(ContentModel.PROP_LASTNAME, "test last name");
        personProps.put(ContentModel.PROP_SIZE_CURRENT, 0);
        ChildAssociationRef childAssocRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}testperson"), ContentModel.TYPE_PERSON, personProps);
        NodeRef nodeRef = childAssocRef.getChildRef();
        Set aspects = this.nodeService.getAspects(nodeRef);
        AuditableAspectTest.assertFalse((String)"cm:auditable must not be present.", (boolean)aspects.contains(ContentModel.ASPECT_AUDITABLE));
        Map properties = this.nodeService.getProperties(nodeRef);
        AuditableAspectTest.assertFalse((String)"cm:creator must not be present", (boolean)properties.containsKey(ContentModel.PROP_CREATOR));
        AuditableAspectTest.assertFalse((String)"cm:created must not be present", (boolean)properties.containsKey(ContentModel.PROP_CREATED));
        AuditableAspectTest.assertNull((String)"Didn't expect to get single auditable property", (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_CREATOR));
        System.out.println(NodeStoreInspector.dumpNodeStore(this.nodeService, this.storeRef));
    }

    public void testAddAudit() {
        HashMap<QName, Object> personProps = new HashMap<QName, Object>();
        personProps.put(ContentModel.PROP_USERNAME, "test person");
        personProps.put(ContentModel.PROP_HOMEFOLDER, this.rootNodeRef);
        personProps.put(ContentModel.PROP_FIRSTNAME, "test first name");
        personProps.put(ContentModel.PROP_LASTNAME, "test last name");
        personProps.put(ContentModel.PROP_SIZE_CURRENT, 0);
        ChildAssociationRef childAssocRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}testperson"), ContentModel.TYPE_PERSON, personProps);
        Set aspects = this.nodeService.getAspects(childAssocRef.getChildRef());
        AuditableAspectTest.assertFalse((boolean)aspects.contains(ContentModel.ASPECT_AUDITABLE));
        this.nodeService.addAspect(childAssocRef.getChildRef(), ContentModel.ASPECT_AUDITABLE, null);
        this.nodeService.addAspect(childAssocRef.getChildRef(), ContentModel.ASPECT_TITLED, null);
        aspects = this.nodeService.getAspects(childAssocRef.getChildRef());
        AuditableAspectTest.assertTrue((boolean)aspects.contains(ContentModel.ASPECT_AUDITABLE));
        this.assertAuditableProperties(childAssocRef.getChildRef());
        System.out.println(NodeStoreInspector.dumpNodeStore(this.nodeService, this.storeRef));
    }

    public synchronized void testAddAndRemoveAspect() throws Exception {
        HashMap<QName, Object> personProps = new HashMap<QName, Object>();
        personProps.put(ContentModel.PROP_USERNAME, "test person");
        personProps.put(ContentModel.PROP_HOMEFOLDER, this.rootNodeRef);
        personProps.put(ContentModel.PROP_FIRSTNAME, "test first name ");
        personProps.put(ContentModel.PROP_LASTNAME, "test last name");
        personProps.put(ContentModel.PROP_SIZE_CURRENT, 0);
        long t1 = System.currentTimeMillis();
        ((Object)((Object)this)).wait(100L);
        ChildAssociationRef childAssocRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}testperson"), ContentModel.TYPE_PERSON, personProps);
        NodeRef nodeRef = childAssocRef.getChildRef();
        this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_AUDITABLE, null);
        this.assertAuditableProperties(nodeRef);
        ((Object)((Object)this)).wait(100L);
        long t2 = System.currentTimeMillis();
        Date aspectCreatedDate1 = (Date)this.nodeService.getProperty(nodeRef, ContentModel.PROP_CREATED);
        Date aspectModifiedDate1 = (Date)this.nodeService.getProperty(nodeRef, ContentModel.PROP_MODIFIED);
        AuditableAspectTest.assertTrue((String)"Created date should be later than t1", (t1 < aspectCreatedDate1.getTime() ? 1 : 0) != 0);
        AuditableAspectTest.assertTrue((String)"Modified date must be after or on creation date", (aspectCreatedDate1.getTime() <= aspectModifiedDate1.getTime() && aspectModifiedDate1.getTime() < t2 ? 1 : 0) != 0);
        long t3 = System.currentTimeMillis();
        ((Object)((Object)this)).wait(100L);
        ((Object)((Object)this)).wait(1500L);
        this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_TITLED, null);
        Date aspectCreatedDate2 = (Date)this.nodeService.getProperty(nodeRef, ContentModel.PROP_CREATED);
        Date aspectModifiedDate2 = (Date)this.nodeService.getProperty(nodeRef, ContentModel.PROP_MODIFIED);
        AuditableAspectTest.assertEquals((String)"The created date must not change", (Object)aspectCreatedDate1, (Object)aspectCreatedDate2);
        AuditableAspectTest.assertTrue((String)"New modified date should be later than t3", (t3 < aspectModifiedDate2.getTime() ? 1 : 0) != 0);
        System.out.println(NodeStoreInspector.dumpNodeStore(this.nodeService, this.storeRef));
        this.nodeService.removeAspect(nodeRef, ContentModel.ASPECT_AUDITABLE);
        this.assertNotAuditableProperties(nodeRef);
        System.out.println(NodeStoreInspector.dumpNodeStore(this.nodeService, this.storeRef));
    }

    public void testCreateAndUpdateAuditableProperties() {
        HashMap<QName, Object> personProps = new HashMap<QName, Object>();
        personProps.put(ContentModel.PROP_USERNAME, "test person");
        personProps.put(ContentModel.PROP_HOMEFOLDER, this.rootNodeRef);
        personProps.put(ContentModel.PROP_FIRSTNAME, "test first name ");
        personProps.put(ContentModel.PROP_LASTNAME, "test last name");
        personProps.put(ContentModel.PROP_SIZE_CURRENT, 0);
        final HashMap<QName, Serializable> auditableProps = new HashMap<QName, Serializable>();
        auditableProps.put(ContentModel.PROP_CREATED, new Date(0L));
        auditableProps.put(ContentModel.PROP_CREATOR, (Serializable)((Object)"ZeroPerson"));
        auditableProps.put(ContentModel.PROP_MODIFIED, new Date(1L));
        auditableProps.put(ContentModel.PROP_MODIFIER, (Serializable)((Object)"OnePerson"));
        personProps.putAll(auditableProps);
        ChildAssociationRef childAssocRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}testperson"), ContentModel.TYPE_PERSON, personProps);
        final NodeRef nodeRef = childAssocRef.getChildRef();
        this.assertAuditableProperties(nodeRef, auditableProps);
        this.nodeService.setProperty(nodeRef, ContentModel.PROP_FIRSTNAME, (Serializable)((Object)("TEST-FIRST-NAME-" + System.currentTimeMillis())));
        String modifiedBy = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_MODIFIER));
        AuditableAspectTest.assertEquals((String)"The modifier should have changed to reflect the current user", (String)AuthenticationUtil.getRunAsUser(), (String)modifiedBy);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> setAuditableCallback1 = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                AuditableAspectTest.this.behaviourFilter.disableBehaviour(ContentModel.ASPECT_AUDITABLE);
                Long currentTime = System.currentTimeMillis();
                auditableProps.put(ContentModel.PROP_CREATOR, "Creator-" + currentTime);
                auditableProps.put(ContentModel.PROP_CREATED, new Date(currentTime - 1000L));
                auditableProps.put(ContentModel.PROP_MODIFIER, "Modifier-" + currentTime);
                auditableProps.put(ContentModel.PROP_MODIFIED, new Date(currentTime - 1000L));
                AuditableAspectTest.this.nodeService.addProperties(nodeRef, auditableProps);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction(setAuditableCallback1);
        this.assertAuditableProperties(nodeRef, auditableProps);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> setAuditableCallback2 = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                AuditableAspectTest.this.behaviourFilter.disableBehaviour(ContentModel.ASPECT_AUDITABLE);
                AuditableAspectTest.this.nodeService.setProperty(nodeRef, ContentModel.PROP_FIRSTNAME, (Serializable)((Object)("TEST-FIRST-NAME-" + System.currentTimeMillis())));
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction(setAuditableCallback2);
        this.assertAuditableProperties(nodeRef, auditableProps);
    }

    public void testPutContent() throws Exception {
        String fileName = "testContent";
        HashMap<QName, String> props = new HashMap<QName, String>();
        props.put(ContentModel.PROP_NAME, fileName);
        ChildAssociationRef childAssocRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQNameWithValidLocalName((String)"http://www.alfresco.org/model/content/1.0", (String)fileName), ContentModel.TYPE_CONTENT, props);
        final NodeRef nodeRef = childAssocRef.getChildRef();
        Date modified = (Date)this.nodeService.getProperty(nodeRef, ContentModel.PROP_MODIFIED);
        RetryingTransactionHelper.RetryingTransactionCallback<Date> dateCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Date>(){

            @Override
            public Date execute() throws Throwable {
                ContentWriter writer = AuditableAspectTest.this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
                writer.setMimetype("text/plain");
                writer.setEncoding("UTF-8");
                String text = "Test content";
                writer.putContent(text);
                return (Date)AuditableAspectTest.this.nodeService.getProperty(nodeRef, ContentModel.PROP_MODIFIED);
            }
        };
        final Date txnModified = this.transactionService.getRetryingTransactionHelper().doInTransaction(dateCallback);
        AuditableAspectTest.assertTrue((String)"Last modified date should be changed in individual transaction", (modified.getTime() < txnModified.getTime() ? 1 : 0) != 0);
        RetryingTransactionHelper.RetryingTransactionCallback<Integer> countCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Integer>(){

            @Override
            public Integer execute() throws Throwable {
                int count = 0;
                Date oldModified = txnModified;
                ContentWriter writer = AuditableAspectTest.this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
                writer.setMimetype("text/plain");
                writer.setEncoding("UTF-8");
                String text = "Test content update";
                writer.putContent(text);
                Date newModified = (Date)AuditableAspectTest.this.nodeService.getProperty(nodeRef, ContentModel.PROP_MODIFIED);
                if (newModified.getTime() > oldModified.getTime()) {
                    ++count;
                }
                oldModified = newModified;
                writer = AuditableAspectTest.this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
                writer.setMimetype("text/plain");
                writer.setEncoding("UTF-8");
                text = "Test content another update";
                writer.putContent(text);
                newModified = (Date)AuditableAspectTest.this.nodeService.getProperty(nodeRef, ContentModel.PROP_MODIFIED);
                if (newModified.getTime() > oldModified.getTime()) {
                    ++count;
                }
                return count;
            }
        };
        Integer count = this.transactionService.getRetryingTransactionHelper().doInTransaction(countCallback);
        AuditableAspectTest.assertTrue((String)"Repeated content uploads in the same transaction should only modify the cm:modified once.", (count == 1 ? 1 : 0) != 0);
    }

    private void assertAuditableProperties(NodeRef nodeRef) {
        this.assertAuditableProperties(nodeRef, null);
    }

    private void assertAuditableProperties(NodeRef nodeRef, Map<QName, Serializable> checkProps) {
        AuditableAspectTest.assertTrue((String)"Auditable aspect not present", (boolean)this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_AUDITABLE));
        Map props = this.nodeService.getProperties(nodeRef);
        AuditableAspectTest.assertNotNull(props.get(ContentModel.PROP_CREATED));
        AuditableAspectTest.assertNotNull(props.get(ContentModel.PROP_MODIFIED));
        AuditableAspectTest.assertNotNull(props.get(ContentModel.PROP_CREATOR));
        AuditableAspectTest.assertNotNull(props.get(ContentModel.PROP_MODIFIER));
        if (checkProps != null) {
            AuditableAspectTest.assertEquals((String)"PROP_CREATED not correct", (Object)checkProps.get(ContentModel.PROP_CREATED), props.get(ContentModel.PROP_CREATED));
            AuditableAspectTest.assertEquals((String)"PROP_MODIFIED not correct", (Object)checkProps.get(ContentModel.PROP_MODIFIED), props.get(ContentModel.PROP_MODIFIED));
            AuditableAspectTest.assertEquals((String)"PROP_CREATOR not correct", (Object)checkProps.get(ContentModel.PROP_CREATOR), props.get(ContentModel.PROP_CREATOR));
            AuditableAspectTest.assertEquals((String)"PROP_MODIFIER not correct", (Object)checkProps.get(ContentModel.PROP_MODIFIER), props.get(ContentModel.PROP_MODIFIER));
        }
    }

    private void assertNotAuditableProperties(NodeRef nodeRef) {
        Map props = this.nodeService.getProperties(nodeRef);
        AuditableAspectTest.assertNull(props.get(ContentModel.PROP_CREATED));
        AuditableAspectTest.assertNull(props.get(ContentModel.PROP_MODIFIED));
        AuditableAspectTest.assertNull(props.get(ContentModel.PROP_CREATOR));
        AuditableAspectTest.assertNull(props.get(ContentModel.PROP_MODIFIER));
    }
}

