/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm;

import java.util.ArrayList;
import net.sf.acegisecurity.Authentication;
import org.alfresco.repo.avm.AVMCrawler;
import org.alfresco.repo.avm.AVMServiceTestBase;
import org.alfresco.repo.avm.util.BulkLoader;
import org.alfresco.repo.security.authentication.AuthenticationUtil;

public class AVMCrawlTestP
extends AVMServiceTestBase {
    public void testCrawlB() {
        this.testCrawl(2, this.getSourceFolder() + "/org/alfresco/repo/avm/actions", 2, 30000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCrawl(int n, String fsPath, int m, long runTime) {
        try {
            Authentication authentication = AuthenticationUtil.setFullyAuthenticatedUser((String)"System");
            try {
                long now;
                if (m < 1) {
                    AVMCrawlTestP.fail((String)"Must have at least one 1 copy of content");
                }
                BulkLoader loader = new BulkLoader();
                loader.setAvmService(fService);
                for (int i = 0; i < m; ++i) {
                    fService.createStore("d" + i);
                    loader.recursiveLoad(fsPath, "d" + i + ":/");
                    fService.createSnapshot("d" + i, null, null);
                }
                long startTime = System.currentTimeMillis();
                ArrayList<AVMCrawler> crawlers = new ArrayList<AVMCrawler>();
                ArrayList<Thread> threads = new ArrayList<Thread>();
                for (int i = 0; i < n; ++i) {
                    crawlers.add(new AVMCrawler(fService, authentication));
                    threads.add(new Thread((Runnable)crawlers.get(i)));
                    ((Thread)threads.get(i)).start();
                }
                do {
                    try {
                        Thread.sleep(5000L);
                        for (AVMCrawler crawler : crawlers) {
                            if (!crawler.getError()) continue;
                            for (AVMCrawler craw : crawlers) {
                                craw.setDone();
                            }
                            for (Thread thread : threads) {
                                try {
                                    thread.join();
                                }
                                catch (InterruptedException ie) {}
                            }
                            System.err.println("Crawler error");
                        }
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                } while ((now = System.currentTimeMillis()) - startTime <= runTime);
                for (AVMCrawler crawler : crawlers) {
                    crawler.setDone();
                }
                for (Thread thread : threads) {
                    try {
                        thread.join();
                    }
                    catch (InterruptedException ie) {}
                }
                long ops = 0L;
                int errorCnt = 0;
                for (AVMCrawler crawler : crawlers) {
                    ops += (long)crawler.getOpCount();
                    errorCnt += crawler.getError() ? 1 : 0;
                }
                long time = System.currentTimeMillis() - startTime;
                System.out.println("Ops/Sec: " + ops * 1000L / time);
                if (errorCnt > 0) {
                    StringBuffer errorStack = new StringBuffer();
                    errorStack.append("Crawler errors: ").append(errorCnt).append(" out of ").append(crawlers.size()).append(" are in error state");
                    for (AVMCrawler crawler : crawlers) {
                        if (!crawler.getError()) continue;
                        errorStack.append("\n\n").append(crawler.getErrorStackTrace());
                    }
                    AVMCrawlTestP.fail((String)errorStack.toString());
                }
            }
            finally {
                for (int i = 0; i < m; ++i) {
                    if (fService.getStore("d" + i) == null) continue;
                    fService.purgeStore("d" + i);
                }
            }
        }
        finally {
            AuthenticationUtil.clearCurrentSecurityContext();
        }
    }
}

