/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.alfresco.repo.avm.AVMDAOs;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.avm.AVMRepository;
import org.alfresco.repo.avm.Lookup;
import org.alfresco.repo.avm.util.AVMUtil;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.repo.domain.permissions.Acl;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.ACLCopyMode;
import org.alfresco.service.cmr.avm.AVMBadArgumentException;
import org.alfresco.service.cmr.avm.AVMCycleException;
import org.alfresco.service.cmr.avm.AVMException;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMNotFoundException;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.avm.AVMStoreDescriptor;
import org.alfresco.service.cmr.avm.LayeringDescriptor;
import org.alfresco.service.cmr.avm.VersionDescriptor;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.FileNameValidator;
import org.alfresco.util.Pair;
import org.alfresco.util.TempFileProvider;
import org.alfresco.wcm.util.WCMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AVMServiceImpl
implements AVMService {
    private static final String MSG_CYCLE_ON_CREATE = "avm.cycle.create";
    public static final String SYSTEM = "system";
    private static Log logger = LogFactory.getLog(AVMServiceImpl.class);
    private AVMRepository fAVMRepository;

    public void setAvmRepository(AVMRepository avmRepository) {
        this.fAVMRepository = avmRepository;
    }

    @Override
    public InputStream getFileInputStream(int version, String path) {
        if (path == null) {
            throw new AVMBadArgumentException("Null path.");
        }
        return this.fAVMRepository.getInputStream(version, path);
    }

    @Override
    public InputStream getFileInputStream(AVMNodeDescriptor desc) {
        if (desc == null) {
            throw new AVMBadArgumentException("Illegal Null Argument.");
        }
        return this.fAVMRepository.getInputStream(desc);
    }

    @Override
    public OutputStream getFileOutputStream(String path) {
        if (path == null) {
            throw new AVMBadArgumentException("Null path.");
        }
        return this.fAVMRepository.getOutputStream(path);
    }

    @Override
    public ContentReader getContentReader(int version, String path) {
        if (path == null) {
            throw new AVMBadArgumentException("Null path.");
        }
        return this.fAVMRepository.getContentReader(version, path);
    }

    @Override
    public ContentWriter getContentWriter(String path, boolean update) {
        if (path == null) {
            throw new AVMBadArgumentException("Null path.");
        }
        return this.fAVMRepository.createContentWriter(path, update);
    }

    @Override
    public SortedMap<String, AVMNodeDescriptor> getDirectoryListing(int version, String path) {
        return this.getDirectoryListing(version, path, false);
    }

    @Override
    public SortedMap<String, AVMNodeDescriptor> getDirectoryListing(int version, String path, boolean includeDeleted) {
        if (path == null) {
            throw new AVMBadArgumentException("Null path.");
        }
        return this.fAVMRepository.getListing(version, path, includeDeleted);
    }

    @Override
    public AVMNodeDescriptor[] getDirectoryListingArray(int version, String path, boolean includeDeleted) {
        SortedMap<String, AVMNodeDescriptor> listing = this.getDirectoryListing(version, path, includeDeleted);
        AVMNodeDescriptor[] result = new AVMNodeDescriptor[listing.size()];
        int off = 0;
        for (AVMNodeDescriptor desc : listing.values()) {
            result[off++] = desc;
        }
        return result;
    }

    @Override
    public AVMNodeDescriptor[] getDirectoryListingArray(AVMNodeDescriptor dir, boolean includeDeleted) {
        SortedMap<String, AVMNodeDescriptor> listing = this.getDirectoryListing(dir, includeDeleted);
        AVMNodeDescriptor[] result = new AVMNodeDescriptor[listing.size()];
        int off = 0;
        for (AVMNodeDescriptor desc : listing.values()) {
            result[off++] = desc;
        }
        return result;
    }

    @Override
    public SortedMap<String, AVMNodeDescriptor> getDirectoryListingDirect(AVMNodeDescriptor dir, boolean includeDeleted) {
        if (dir == null) {
            throw new AVMBadArgumentException("Illegal null descriptor.");
        }
        return this.fAVMRepository.getListingDirect(dir, includeDeleted);
    }

    @Override
    public SortedMap<String, AVMNodeDescriptor> getDirectoryListingDirect(int version, String path) {
        return this.getDirectoryListingDirect(version, path, false);
    }

    @Override
    public SortedMap<String, AVMNodeDescriptor> getDirectoryListingDirect(int version, String path, boolean includeDeleted) {
        if (path == null) {
            throw new AVMBadArgumentException("Null path.");
        }
        return this.fAVMRepository.getListingDirect(version, path, includeDeleted);
    }

    @Override
    public SortedMap<String, AVMNodeDescriptor> getDirectoryListing(AVMNodeDescriptor dir) {
        return this.getDirectoryListing(dir, false);
    }

    @Override
    public SortedMap<String, AVMNodeDescriptor> getDirectoryListing(AVMNodeDescriptor dir, String childPattern) {
        return this.getDirectoryListing(dir, childPattern, false);
    }

    public SortedMap<String, AVMNodeDescriptor> getDirectoryListing(AVMNodeDescriptor dir, String childNamePattern, boolean includeDeleted) {
        if (dir == null) {
            throw new AVMBadArgumentException("Null descriptor.");
        }
        return this.fAVMRepository.getListing(dir, childNamePattern, includeDeleted);
    }

    @Override
    public SortedMap<String, AVMNodeDescriptor> getDirectoryListing(AVMNodeDescriptor dir, boolean includeDeleted) {
        if (dir == null) {
            throw new AVMBadArgumentException("Null descriptor.");
        }
        return this.fAVMRepository.getListing(dir, includeDeleted);
    }

    @Override
    public List<String> getDeleted(int version, String path) {
        if (path == null) {
            throw new AVMBadArgumentException("Null path.");
        }
        return this.fAVMRepository.getDeleted(version, path);
    }

    @Override
    public OutputStream createFile(String path, String name) {
        if (path == null || name == null || !FileNameValidator.isValid(name)) {
            throw new AVMBadArgumentException("Illegal argument.");
        }
        return this.fAVMRepository.createFile(path, name);
    }

    @Override
    public void createFile(String path, String name, InputStream in) {
        this.createFile(path, name, in, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createFile(String path, String name, InputStream in, List<QName> aspects, Map<QName, PropertyValue> properties) {
        File temp;
        if (path == null || name == null || in == null) {
            throw new AVMBadArgumentException("Illegal argument.");
        }
        if (!FileNameValidator.isValid(name)) {
            throw new AVMBadArgumentException("Illegal argument, name:" + name);
        }
        try {
            int read;
            temp = TempFileProvider.createTempFile((String)"alf", (String)"tmp");
            FileOutputStream out = new FileOutputStream(temp);
            byte[] buff = new byte[8192];
            while ((read = in.read(buff)) != -1) {
                ((OutputStream)out).write(buff, 0, read);
            }
            ((OutputStream)out).close();
            in.close();
        }
        catch (IOException ie) {
            throw new AVMException("I/O Error.");
        }
        try {
            this.fAVMRepository.createFile(path, name, temp, aspects, properties);
        }
        finally {
            temp.delete();
        }
    }

    @Override
    public void createDirectory(String path, String name) {
        this.createDirectory(path, name, null, null);
    }

    @Override
    public void createDirectory(String path, String name, List<QName> aspects, Map<QName, PropertyValue> properties) {
        if (path == null || name == null || !FileNameValidator.isValid(name)) {
            throw new AVMBadArgumentException("Illegal argument.");
        }
        this.fAVMRepository.createDirectory(path, name, aspects, properties);
    }

    @Override
    public void createLayeredFile(String srcPath, String parent, String name) {
        if (srcPath == null || parent == null || name == null || !FileNameValidator.isValid(name)) {
            throw new AVMBadArgumentException("Illegal argument.");
        }
        this.fAVMRepository.createLayeredFile(srcPath, parent, name);
    }

    @Override
    public void createLayeredDirectory(String srcPath, String parent, String name) {
        if (srcPath == null || parent == null || name == null || !FileNameValidator.isValid(name)) {
            throw new AVMBadArgumentException("Illegal argument.");
        }
        this.fAVMRepository.createLayeredDirectory(srcPath, parent, name);
        String[] pathParts = AVMUtil.splitPath(parent);
        if (WCMUtil.getWebProject(this, pathParts[0]) == null || !pathParts[1].equals("/") || !name.equals("www")) {
            long start = System.currentTimeMillis();
            if (this.checkForLDCycle(srcPath, AVMUtil.extendAVMPath(parent, name))) {
                throw new AVMCycleException(MSG_CYCLE_ON_CREATE);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("createLayeredDirectory: cycle check: " + parent + "/" + name + " -> " + srcPath + " (in " + (System.currentTimeMillis() - start) + " msecs)"));
            }
        }
    }

    private boolean checkForLDCycle(String srcPath, String dstDirPath) {
        boolean found = false;
        SortedMap<String, AVMNodeDescriptor> listing = this.getDirectoryListing(-1, dstDirPath, false);
        for (AVMNodeDescriptor node : listing.values()) {
            if (!node.isDirectory()) continue;
            if (node.isLayeredDirectory() && node.isPrimary() && node.getIndirection().equals(srcPath)) {
                return true;
            }
            if (!this.checkForLDCycle(srcPath, node.getPath())) continue;
            found = true;
            break;
        }
        return found;
    }

    @Override
    public void createStore(String name) {
        if (name == null || !FileNameValidator.isValid(name)) {
            throw new AVMBadArgumentException("Bad Name.");
        }
        this.fAVMRepository.createAVMStore(name);
    }

    @Override
    public void createStore(String name, Map<QName, PropertyValue> props) {
        if (name == null || !FileNameValidator.isValid(name)) {
            throw new AVMBadArgumentException("Bad Name.");
        }
        this.fAVMRepository.createAVMStore(name, props);
    }

    @Override
    public void createBranch(int version, String srcPath, String dstPath, String name) {
        if (srcPath == null || dstPath == null || name == null || !FileNameValidator.isValid(name)) {
            throw new AVMBadArgumentException("Illegal argument.");
        }
        this.fAVMRepository.createBranch(version, srcPath, dstPath, name);
    }

    @Override
    public void removeNode(String parent, String name) {
        if (parent == null || name == null) {
            throw new AVMBadArgumentException("Illegal null argument.");
        }
        this.fAVMRepository.remove(parent, name);
    }

    @Override
    public void removeNode(String path) {
        if (path == null) {
            throw new AVMBadArgumentException("Illegal null argument.");
        }
        String[] basePath = AVMNodeConverter.SplitBase(path);
        if (basePath[0] == null) {
            throw new AVMBadArgumentException("Cannot remove root node: " + path);
        }
        this.fAVMRepository.remove(basePath[0], basePath[1]);
    }

    @Override
    public void rename(String srcParent, String srcName, String dstParent, String dstName) {
        if (srcParent == null || srcName == null || dstParent == null || dstName == null || !FileNameValidator.isValid(dstName)) {
            throw new AVMBadArgumentException("Illegal argument.");
        }
        this.fAVMRepository.rename(srcParent, srcName, dstParent, dstName);
    }

    @Override
    public void uncover(String dirPath, String name) {
        if (dirPath == null || name == null) {
            throw new AVMBadArgumentException("Illegal null argument.");
        }
        this.fAVMRepository.uncover(dirPath, name);
    }

    @Override
    public void makeTransparent(String dirPath, String name) {
        if (dirPath == null || name == null) {
            throw new AVMBadArgumentException("Illegal null argument.");
        }
        this.fAVMRepository.flatten(dirPath, name);
    }

    @Override
    public int getNextVersionID(String repName) {
        if (repName == null) {
            throw new AVMBadArgumentException("Illegal null argument.");
        }
        return this.fAVMRepository.getLatestVersionID(repName);
    }

    @Override
    public int getLatestSnapshotID(String storeName) {
        if (storeName == null) {
            throw new AVMBadArgumentException("Illegal null argument.");
        }
        return this.fAVMRepository.getLatestSnapshotID(storeName);
    }

    @Override
    public Map<String, Integer> createSnapshot(String store, String tag, String description) {
        if (store == null) {
            throw new AVMBadArgumentException("Store is null.");
        }
        return this.fAVMRepository.createSnapshot(store, tag, description);
    }

    @Override
    public AVMNodeDescriptor lookup(int version, String path) {
        if (path == null) {
            throw new AVMBadArgumentException("Illegal null path.");
        }
        return this.lookup(version, path, false);
    }

    @Override
    public AVMNodeDescriptor lookup(int version, String path, boolean includeDeleted) {
        if (path == null) {
            throw new AVMBadArgumentException("Path is null.");
        }
        try {
            Lookup lookup = this.fAVMRepository.lookup(version, path, includeDeleted);
            if (lookup == null) {
                return null;
            }
            return lookup.getCurrentNode().getDescriptor(lookup);
        }
        catch (AVMNotFoundException e) {
            return null;
        }
    }

    @Override
    public AVMNodeDescriptor lookup(AVMNodeDescriptor dir, String name) {
        if (dir == null || name == null) {
            throw new AVMBadArgumentException("Illegal null argument.");
        }
        return this.lookup(dir, name, false);
    }

    @Override
    public AVMNodeDescriptor lookup(AVMNodeDescriptor dir, String name, boolean includeDeleted) {
        if (dir == null || name == null) {
            throw new AVMBadArgumentException("Illegal null argument.");
        }
        try {
            return this.fAVMRepository.lookup(dir, name, includeDeleted);
        }
        catch (AVMNotFoundException e) {
            return null;
        }
    }

    @Override
    public List<Pair<Integer, String>> getPaths(AVMNodeDescriptor desc) {
        if (desc == null) {
            throw new AVMBadArgumentException("Descriptor is null.");
        }
        return this.fAVMRepository.getPaths(desc);
    }

    @Override
    public Pair<Integer, String> getAPath(AVMNodeDescriptor desc) {
        if (desc == null) {
            throw new AVMBadArgumentException("Descriptor is null.");
        }
        return this.fAVMRepository.getAPath(desc);
    }

    @Override
    public List<Pair<Integer, String>> getHeadPaths(AVMNodeDescriptor desc) {
        if (desc == null) {
            throw new AVMBadArgumentException("Descriptor is null.");
        }
        return this.fAVMRepository.getHeadPaths(desc);
    }

    @Override
    public List<Pair<Integer, String>> getPathsInStoreHead(AVMNodeDescriptor desc, String store) {
        if (desc == null || store == null) {
            throw new AVMBadArgumentException("Illegal null argument.");
        }
        return this.fAVMRepository.getPathsInStoreHead(desc, store);
    }

    @Override
    public List<String> getPathsInStoreVersion(AVMNodeDescriptor desc, String store, int version) {
        if (desc == null || store == null || version < 1) {
            throw new AVMBadArgumentException("Illegal null argument or invalid version.");
        }
        return this.fAVMRepository.getPathsInStoreVersion(desc, store, version);
    }

    @Override
    public void purgeStore(String name) {
        if (name == null) {
            throw new AVMBadArgumentException("Name is null.");
        }
        this.fAVMRepository.purgeAVMStore(name);
    }

    @Override
    public void purgeVersion(int version, String name) {
        if (name == null) {
            throw new AVMBadArgumentException("Name is null.");
        }
        this.fAVMRepository.purgeVersion(name, version);
    }

    @Override
    public String getIndirectionPath(int version, String path) {
        if (path == null) {
            throw new AVMBadArgumentException("Path is null.");
        }
        return this.fAVMRepository.getIndirectionPath(version, path);
    }

    @Override
    public List<VersionDescriptor> getStoreVersions(String name) {
        if (name == null) {
            throw new AVMBadArgumentException("Name is null.");
        }
        return this.fAVMRepository.getAVMStoreVersions(name);
    }

    @Override
    public List<VersionDescriptor> getStoreVersions(String name, Date from, Date to) {
        if (name == null || from == null && to == null) {
            throw new AVMBadArgumentException("Illegal null argument.");
        }
        return this.fAVMRepository.getAVMStoreVersions(name, from, to);
    }

    @Override
    public void retargetLayeredDirectory(String path, String target) {
        if (path == null || target == null) {
            throw new AVMBadArgumentException("Illegal null argument.");
        }
        this.fAVMRepository.retargetLayeredDirectory(path, target);
    }

    @Override
    public void makePrimary(String path) {
        if (path == null) {
            throw new AVMBadArgumentException("Path is null.");
        }
        this.fAVMRepository.makePrimary(path);
    }

    @Override
    public List<AVMStoreDescriptor> getStores() {
        return this.fAVMRepository.getAVMStores();
    }

    @Override
    public AVMStoreDescriptor getStore(String name) {
        if (name == null) {
            throw new AVMBadArgumentException("Null Store Name.");
        }
        try {
            return this.fAVMRepository.getAVMStore(name);
        }
        catch (AVMNotFoundException e) {
            return null;
        }
    }

    @Override
    public AVMStoreDescriptor getSystemStore() {
        AVMStoreDescriptor store = this.getStore(SYSTEM);
        if (store == null) {
            this.createStore(SYSTEM);
            return this.getStore(SYSTEM);
        }
        return store;
    }

    @Override
    public AVMNodeDescriptor getStoreRoot(int version, String name) {
        if (name == null) {
            throw new AVMBadArgumentException("Name is null.");
        }
        return this.fAVMRepository.getAVMStoreRoot(version, name);
    }

    @Override
    public List<AVMNodeDescriptor> getHistory(AVMNodeDescriptor desc, int count) {
        if (desc == null) {
            throw new AVMBadArgumentException("Null descriptor.");
        }
        return this.fAVMRepository.getHistory(desc, count);
    }

    @Override
    public void setOpacity(String path, boolean opacity) {
        if (path == null) {
            throw new AVMBadArgumentException("Null path.");
        }
        this.fAVMRepository.setOpacity(path, opacity);
    }

    @Override
    public LayeringDescriptor getLayeringInfo(int version, String path) {
        if (path == null) {
            throw new AVMBadArgumentException("Null path: " + path);
        }
        return this.fAVMRepository.getLayeringInfo(version, path);
    }

    @Override
    public AVMNodeDescriptor getCommonAncestor(AVMNodeDescriptor left, AVMNodeDescriptor right) {
        if (left == null || right == null) {
            throw new AVMBadArgumentException("Null node descriptor.");
        }
        return this.fAVMRepository.getCommonAncestor(left, right);
    }

    @Override
    public void setNodeProperty(String path, QName name, PropertyValue value) {
        if (path == null || name == null || value == null) {
            throw new AVMBadArgumentException("Illegal null argument.");
        }
        this.fAVMRepository.setNodeProperty(path, name, value);
    }

    @Override
    public void setNodeProperties(String path, Map<QName, PropertyValue> properties) {
        if (path == null || properties == null) {
            throw new AVMBadArgumentException("Illegal null argument.");
        }
        this.fAVMRepository.setNodeProperties(path, properties);
    }

    @Override
    public PropertyValue getNodeProperty(int version, String path, QName name) {
        if (path == null || name == null) {
            throw new AVMBadArgumentException("Illegal null argument.");
        }
        return this.fAVMRepository.getNodeProperty(version, path, name);
    }

    @Override
    public Map<QName, PropertyValue> getNodeProperties(int version, String path) {
        if (path == null) {
            throw new AVMBadArgumentException("Null path.");
        }
        return this.fAVMRepository.getNodeProperties(version, path);
    }

    @Override
    public Map<QName, PropertyValue> getNodeProperties(AVMNodeDescriptor desc) {
        if (desc == null) {
            throw new AVMBadArgumentException("Null descriptor.");
        }
        return this.fAVMRepository.getNodeProperties(desc);
    }

    @Override
    public void deleteNodeProperty(String path, QName name) {
        if (path == null || name == null) {
            throw new AVMBadArgumentException("Illegal null argument.");
        }
        this.fAVMRepository.deleteNodeProperty(path, name);
    }

    @Override
    public void deleteNodeProperties(String path) {
        if (path == null) {
            throw new AVMBadArgumentException("Null path.");
        }
        this.fAVMRepository.deleteNodeProperties(path);
    }

    @Override
    public void setStoreProperty(String store, QName name, PropertyValue value) {
        if (store == null || name == null || value == null) {
            throw new AVMBadArgumentException("Illegal null argument.");
        }
        this.fAVMRepository.setStoreProperty(store, name, value);
    }

    @Override
    public void setStoreProperties(String store, Map<QName, PropertyValue> props) {
        if (store == null || props == null) {
            throw new AVMBadArgumentException("Illegal null argument.");
        }
        this.fAVMRepository.setStoreProperties(store, props);
    }

    @Override
    public PropertyValue getStoreProperty(String store, QName name) {
        if (store == null || name == null) {
            throw new AVMBadArgumentException("Illegal null argument.");
        }
        return this.fAVMRepository.getStoreProperty(store, name);
    }

    @Override
    public Map<QName, PropertyValue> queryStorePropertyKey(String store, QName keyPattern) {
        if (store == null || keyPattern == null) {
            throw new AVMBadArgumentException("Illegal null argument.");
        }
        return this.fAVMRepository.queryStorePropertyKey(store, keyPattern);
    }

    @Override
    public Map<String, Map<QName, PropertyValue>> queryStoresPropertyKeys(QName keyPattern) {
        if (keyPattern == null) {
            throw new AVMBadArgumentException("Illegal null argument.");
        }
        return this.fAVMRepository.queryStoresPropertyKeys(keyPattern);
    }

    @Override
    public Map<QName, PropertyValue> getStoreProperties(String store) {
        if (store == null) {
            throw new AVMBadArgumentException("Null store name.");
        }
        return this.fAVMRepository.getStoreProperties(store);
    }

    @Override
    public void deleteStoreProperty(String store, QName name) {
        if (store == null || name == null) {
            throw new AVMBadArgumentException("Invalid null argument.");
        }
        this.fAVMRepository.deleteStoreProperty(store, name);
    }

    @Override
    public ContentData getContentDataForRead(int version, String path) {
        if (path == null) {
            throw new AVMBadArgumentException("Null Path.");
        }
        return this.fAVMRepository.getContentDataForRead(version, path);
    }

    @Override
    public ContentData getContentDataForRead(AVMNodeDescriptor desc) {
        if (desc == null) {
            throw new AVMBadArgumentException("Null descriptor.");
        }
        return this.fAVMRepository.getContentDataForRead(desc);
    }

    @Override
    public ContentData getContentDataForWrite(String path) {
        if (path == null) {
            throw new AVMBadArgumentException("Null Path.");
        }
        return this.fAVMRepository.getContentDataForWrite(path);
    }

    @Override
    public void setContentData(String path, ContentData data) {
        if (path == null || data == null) {
            throw new AVMBadArgumentException("Null Path.");
        }
        this.fAVMRepository.setContentData(path, data);
    }

    @Override
    public void setMetaDataFrom(String path, AVMNodeDescriptor from) {
        if (path == null || from == null) {
            throw new AVMBadArgumentException("Illegal null argument.");
        }
        this.fAVMRepository.setMetaDataFrom(path, from);
    }

    @Override
    public void addAspect(String path, QName aspectName) {
        if (path == null || aspectName == null) {
            throw new AVMBadArgumentException("Illegal Null Argument.");
        }
        this.fAVMRepository.addAspect(path, aspectName);
    }

    @Override
    public Set<QName> getAspects(int version, String path) {
        if (path == null) {
            throw new AVMBadArgumentException("Null path.");
        }
        return this.fAVMRepository.getAspects(version, path);
    }

    @Override
    public Set<QName> getAspects(AVMNodeDescriptor desc) {
        if (desc == null) {
            throw new AVMBadArgumentException("Null descriptor: " + desc);
        }
        return this.fAVMRepository.getAspects(desc);
    }

    @Override
    public void removeAspect(String path, QName aspectName) {
        if (path == null || aspectName == null) {
            throw new AVMBadArgumentException("Null path.");
        }
        this.fAVMRepository.removeAspect(path, aspectName);
    }

    @Override
    public boolean hasAspect(int version, String path, QName aspectName) {
        if (path == null || aspectName == null) {
            throw new AVMBadArgumentException("Illegal Null Argument.");
        }
        return this.fAVMRepository.hasAspect(version, path, aspectName);
    }

    @Override
    public void link(String parentPath, String name, AVMNodeDescriptor toLink) {
        if (parentPath == null || name == null || toLink == null) {
            throw new AVMBadArgumentException("Illegal Null Argument.");
        }
        this.fAVMRepository.link(parentPath, name, toLink);
    }

    @Override
    public void updateLink(String parentPath, String name, AVMNodeDescriptor toLink) {
        if (parentPath == null || name == null || toLink == null) {
            throw new AVMBadArgumentException("Illegal Null Argument.");
        }
        this.fAVMRepository.updateLink(parentPath, name, toLink);
    }

    @Override
    public AVMNodeDescriptor forceCopy(String path) {
        if (path == null) {
            throw new AVMBadArgumentException("Null Path.");
        }
        return this.fAVMRepository.forceCopy(path);
    }

    @Override
    public void copy(int srcVersion, String srcPath, String dstPath, String name) {
        if (srcPath == null || dstPath == null) {
            throw new AVMBadArgumentException("Null Path.");
        }
        if (srcVersion < 0) {
            String canonicalSrc = (String)AVMNodeConverter.ToAVMVersionPath(AVMNodeConverter.ToNodeRef(srcVersion, srcPath)).getSecond();
            String canonicalDst = (String)AVMNodeConverter.ToAVMVersionPath(AVMNodeConverter.ToNodeRef(-1, dstPath)).getSecond();
            if (!canonicalSrc.endsWith("/")) {
                canonicalSrc = canonicalSrc + "/";
            }
            if (canonicalDst.indexOf(canonicalSrc) == 0) {
                throw new AVMBadArgumentException("Infinite Copy.");
            }
        }
        if (!FileNameValidator.isValid(name)) {
            throw new AVMBadArgumentException("Illegal name.");
        }
        AVMNodeDescriptor srcDesc = this.lookup(srcVersion, srcPath);
        this.recursiveCopy(srcVersion, srcDesc, dstPath, name);
    }

    private Acl getAclAsSystem(final int version, final String path) {
        return (Acl)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Acl>(){

            public Acl doWork() throws Exception {
                return AVMServiceImpl.this.fAVMRepository.getACL(version, path);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    private void setAclAsSystem(final String path, final Acl acl) {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                AVMServiceImpl.this.fAVMRepository.setACL(path, acl);
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    private void recursiveCopy(int version, AVMNodeDescriptor desc, String path, String name) {
        String newPath = path + '/' + name;
        AVMNodeDescriptor existing = this.lookup(-1, newPath);
        Acl parentAcl = this.getAclAsSystem(-1, path);
        Long parentAclId = null;
        if (parentAcl != null) {
            parentAclId = parentAcl.getId();
        }
        Acl acl = this.getAclAsSystem(version, desc.getPath());
        if (desc.isFile()) {
            InputStream in = this.getFileInputStream(version, desc.getPath());
            if (existing != null) {
                this.removeNode(newPath);
            }
            this.createFile(path, name, in);
            if (acl != null) {
                this.setAclAsSystem(newPath, AVMDAOs.Instance().fAclDAO.getAclCopy(acl.getId(), parentAclId, ACLCopyMode.COPY));
            }
            ContentData cd = this.getContentDataForRead(version, desc.getPath());
            this.setEncoding(newPath, cd.getEncoding());
            this.setMimeType(newPath, cd.getMimetype());
        } else {
            if (existing != null && !existing.isDirectory()) {
                this.removeNode(newPath);
                existing = null;
            }
            SortedMap<String, AVMNodeDescriptor> listing = this.getDirectoryListing(desc);
            if (existing == null) {
                this.createDirectory(path, name);
                if (acl != null) {
                    this.setAclAsSystem(newPath, AVMDAOs.Instance().fAclDAO.getAclCopy(acl.getId(), parentAclId, ACLCopyMode.COPY));
                }
            }
            for (Map.Entry entry : listing.entrySet()) {
                this.recursiveCopy(version, (AVMNodeDescriptor)entry.getValue(), newPath, (String)entry.getKey());
            }
        }
        Map<QName, PropertyValue> props = this.getNodeProperties(version, desc.getPath());
        this.setNodeProperties(newPath, props);
        Set<QName> aspects = this.getAspects(version, desc.getPath());
        for (QName aspect : aspects) {
            this.addAspect(newPath, aspect);
        }
    }

    @Override
    public void renameStore(String sourceName, String destName) {
        if (sourceName == null || destName == null) {
            throw new AVMBadArgumentException("Illegal Null Argument.");
        }
        this.fAVMRepository.renameStore(sourceName, destName);
    }

    @Override
    public void revert(String path, AVMNodeDescriptor toRevertTo) {
        if (path == null || toRevertTo == null) {
            throw new AVMBadArgumentException("Illegal Null Argument.");
        }
        String[] baseName = AVMNodeConverter.SplitBase(path);
        if (baseName.length != 2) {
            throw new AVMBadArgumentException("Cannot revert store root: " + path);
        }
        this.fAVMRepository.revert(baseName[0], baseName[1], toRevertTo);
    }

    @Override
    public void setGuid(String path, String guid) {
        if (path == null || guid == null) {
            throw new AVMBadArgumentException("Illegal Null Argument.");
        }
        this.fAVMRepository.setGuid(path, guid);
    }

    @Override
    public void setEncoding(String path, String encoding) {
        if (path == null || encoding == null) {
            throw new AVMBadArgumentException("Illegal Null Argument.");
        }
        this.fAVMRepository.setEncoding(path, encoding);
    }

    @Override
    public void setMimeType(String path, String mimeType) {
        if (path == null || mimeType == null) {
            throw new AVMBadArgumentException("Illegal Null Argument.");
        }
        this.fAVMRepository.setMimeType(path, mimeType);
    }

    @Override
    public List<VersionDescriptor> getStoreVersionsTo(String name, int version) {
        if (name == null) {
            throw new AVMBadArgumentException("Illegal null argument.");
        }
        return this.fAVMRepository.getAVMStoreVersionsTo(name, version);
    }

    @Override
    public List<VersionDescriptor> getStoreVersionsFrom(String name, int version) {
        if (name == null) {
            throw new AVMBadArgumentException("Illegal null argument.");
        }
        return this.fAVMRepository.getAVMStoreVersionsFrom(name, version);
    }

    @Override
    public List<VersionDescriptor> getStoreVersionsBetween(String name, int startVersion, int endVersion) {
        if (name == null) {
            throw new AVMBadArgumentException("Illegal null argument.");
        }
        return this.fAVMRepository.getAVMStoreVersionsBetween(name, startVersion, endVersion);
    }
}

