/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm;

import javax.transaction.UserTransaction;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.avm.AVMServiceTestBase;
import org.alfresco.repo.search.IndexMode;
import org.alfresco.repo.search.Indexer;
import org.alfresco.repo.search.impl.lucene.AVMLuceneIndexer;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.util.TriggerBeanSPI;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class AVMServiceIndexTest
extends AVMServiceTestBase {
    private static final long SLEEP = 20000L;
    private static final long START_DELAY_MSECS = 2000L;
    private static final long REPEAT_INTERVAL_MSECS = 2000L;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        DisposableBean dispBean = (DisposableBean)fContext.getBean("ftsIndexerTrigger");
        InitializingBean initBean = (InitializingBean)fContext.getBean("ftsIndexerTrigger");
        TriggerBeanSPI triggerBeanSPI = (TriggerBeanSPI)fContext.getBean("ftsIndexerTrigger");
        dispBean.destroy();
        triggerBeanSPI.setStartDelay(2000L);
        triggerBeanSPI.setRepeatInterval(2000L);
        initBean.afterPropertiesSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAsyncIndex() throws Exception {
        try {
            UserTransaction tx = fTransactionService.getUserTransaction();
            tx.begin();
            if (fService.getStore("avmAsynchronousTest") != null) {
                AVMServiceIndexTest.assertTrue((boolean)fIndexingInterceptor.hasIndexBeenCreated("avmAsynchronousTest"));
                fService.purgeStore("avmAsynchronousTest");
                AVMServiceIndexTest.assertTrue((boolean)fIndexingInterceptor.hasIndexBeenCreated("avmAsynchronousTest"));
                AVMServiceIndexTest.assertFalse((boolean)fIndexingInterceptor.hasIndexBeenCreated("bananaStoreWoof"));
            } else {
                AVMServiceIndexTest.assertFalse((boolean)fIndexingInterceptor.hasIndexBeenCreated("avmAsynchronousTest"));
            }
            StoreRef storeRef = AVMNodeConverter.ToStoreRef("avmAsynchronousTest");
            Indexer indexer = fIndexerAndSearcher.getIndexer(storeRef);
            if (indexer instanceof AVMLuceneIndexer) {
                AVMLuceneIndexer avmIndexer = (AVMLuceneIndexer)indexer;
                avmIndexer.deleteIndex("avmAsynchronousTest", IndexMode.SYNCHRONOUS);
            }
            tx.commit();
            tx = fTransactionService.getUserTransaction();
            tx.begin();
            AVMServiceIndexTest.assertEquals((int)-1, (int)fIndexingInterceptor.getLastIndexedSnapshot("bananaStoreWoof"));
            AVMServiceIndexTest.assertEquals((int)-1, (int)fIndexingInterceptor.getLastIndexedSnapshot("avmAsynchronousTest"));
            tx.commit();
            SearchService searchService = fIndexerAndSearcher.getSearcher(storeRef, true);
            ResultSet results = searchService.query(storeRef, "lucene", "PATH:\"//.\"");
            AVMServiceIndexTest.assertEquals((int)0, (int)results.length());
            results.close();
            fService.createStore("avmAsynchronousTest");
            tx = fTransactionService.getUserTransaction();
            tx.begin();
            AVMServiceIndexTest.assertEquals((int)0, (int)fIndexingInterceptor.getLastIndexedSnapshot("avmAsynchronousTest"));
            tx.commit();
            fService.createSnapshot("avmAsynchronousTest", null, null);
            tx = fTransactionService.getUserTransaction();
            tx.begin();
            AVMServiceIndexTest.assertEquals((int)0, (int)fIndexingInterceptor.getLastIndexedSnapshot("avmAsynchronousTest"));
            tx.commit();
            results = searchService.query(storeRef, "lucene", "PATH:\"//.\"");
            AVMServiceIndexTest.assertEquals((int)1, (int)results.length());
            results.close();
            fService.createDirectory("avmAsynchronousTest:/", "a");
            fService.createDirectory("avmAsynchronousTest:/a", "b");
            fService.createDirectory("avmAsynchronousTest:/a/b", "c");
            tx = fTransactionService.getUserTransaction();
            tx.begin();
            AVMServiceIndexTest.assertEquals((int)0, (int)fIndexingInterceptor.getLastIndexedSnapshot("avmAsynchronousTest"));
            AVMServiceIndexTest.assertTrue((boolean)fIndexingInterceptor.isIndexUpToDate("avmAsynchronousTest"));
            tx.commit();
            fService.createSnapshot("avmAsynchronousTest", null, null);
            tx = fTransactionService.getUserTransaction();
            tx.begin();
            AVMServiceIndexTest.assertEquals((int)1, (int)fIndexingInterceptor.getLastIndexedSnapshot("avmAsynchronousTest"));
            AVMServiceIndexTest.assertTrue((boolean)fIndexingInterceptor.isIndexUpToDate("avmAsynchronousTest"));
            AVMServiceIndexTest.assertFalse((boolean)fIndexingInterceptor.isIndexUpToDateAndSearchable("avmAsynchronousTest"));
            AVMServiceIndexTest.assertEquals((Object)((Object)IndexMode.ASYNCHRONOUS), (Object)((Object)fIndexingInterceptor.getIndexMode("avmAsynchronousTest")));
            AVMServiceIndexTest.assertEquals((Object)((Object)IndexMode.SYNCHRONOUS), (Object)((Object)fIndexingInterceptor.getIndexMode("main")));
            AVMServiceIndexTest.assertTrue((boolean)fIndexingInterceptor.isSnapshotIndexed("avmAsynchronousTest", 0));
            AVMServiceIndexTest.assertTrue((boolean)fIndexingInterceptor.isSnapshotIndexed("avmAsynchronousTest", 1));
            AVMServiceIndexTest.assertFalse((boolean)fIndexingInterceptor.isSnapshotIndexed("avmAsynchronousTest", 2));
            tx.commit();
            results = searchService.query(storeRef, "lucene", "PATH:\"//.\"");
            AVMServiceIndexTest.assertEquals((int)1, (int)results.length());
            results.close();
            Thread.sleep(20000L);
            results = searchService.query(storeRef, "lucene", "PATH:\"//.\"");
            AVMServiceIndexTest.assertEquals((int)4, (int)results.length());
            results.close();
            tx = fTransactionService.getUserTransaction();
            tx.begin();
            AVMServiceIndexTest.assertEquals((int)1, (int)fIndexingInterceptor.getLastIndexedSnapshot("avmAsynchronousTest"));
            AVMServiceIndexTest.assertTrue((boolean)fIndexingInterceptor.isIndexUpToDate("avmAsynchronousTest"));
            AVMServiceIndexTest.assertTrue((boolean)fIndexingInterceptor.isIndexUpToDateAndSearchable("avmAsynchronousTest"));
            tx.commit();
            fService.purgeStore("avmAsynchronousTest");
            results = searchService.query(storeRef, "lucene", "PATH:\"//.\"");
            AVMServiceIndexTest.assertEquals((int)0, (int)results.length());
            results.close();
            fService.createStore("avmAsynchronousTest");
            fService.createSnapshot("avmAsynchronousTest", null, null);
            fService.createDirectory("avmAsynchronousTest:/", "a");
            fService.createDirectory("avmAsynchronousTest:/a", "b");
            fService.createDirectory("avmAsynchronousTest:/a/b", "c");
            fService.createSnapshot("avmAsynchronousTest", null, null);
            fService.purgeStore("avmAsynchronousTest");
            fService.createStore("avmAsynchronousTest");
            fService.createSnapshot("avmAsynchronousTest", null, null);
            fService.createDirectory("avmAsynchronousTest:/", "a");
            fService.createDirectory("avmAsynchronousTest:/a", "b");
            fService.createDirectory("avmAsynchronousTest:/a/b", "c");
            fService.createSnapshot("avmAsynchronousTest", null, null);
            Thread.sleep(20000L);
            results = searchService.query(storeRef, "lucene", "PATH:\"//.\"");
            AVMServiceIndexTest.assertEquals((int)4, (int)results.length());
            results.close();
        }
        finally {
            fService.purgeStore("avmAsynchronousTest");
        }
    }
}

