/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.alfresco.model.ContentModel;
import org.alfresco.model.WCMModel;
import org.alfresco.repo.action.ActionImpl;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.avm.AVMServiceTestBase;
import org.alfresco.repo.avm.actions.AVMRevertListAction;
import org.alfresco.repo.avm.actions.AVMRevertStoreAction;
import org.alfresco.repo.avm.actions.AVMRevertToVersionAction;
import org.alfresco.repo.avm.actions.AVMUndoSandboxListAction;
import org.alfresco.repo.avm.actions.SimpleAVMPromoteAction;
import org.alfresco.repo.avm.actions.SimpleAVMSubmitAction;
import org.alfresco.repo.avm.util.BulkLoader;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.repo.search.impl.lucene.AbstractLuceneQueryParser;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.avm.AVMBadArgumentException;
import org.alfresco.service.cmr.avm.AVMCycleException;
import org.alfresco.service.cmr.avm.AVMException;
import org.alfresco.service.cmr.avm.AVMExistsException;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMNotFoundException;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.avm.AVMStoreDescriptor;
import org.alfresco.service.cmr.avm.LayeringDescriptor;
import org.alfresco.service.cmr.avm.VersionDescriptor;
import org.alfresco.service.cmr.avmsync.AVMDifference;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.remote.RepoRemote;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.CrossRepositoryCopyService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.alfresco.wcm.sandbox.SandboxConstants;

public class AVMServiceTest
extends AVMServiceTestBase {
    @Override
    public void testSetup() throws Exception {
        super.testSetup();
    }

    public void testSetupAndQueriesAgainstBasicTree() throws Exception {
        this.setupBasicTree();
        this.runQueriesAgainstBasicTree("main");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDiffOrder() throws IOException {
        try {
            fService.createStore("Bottom");
            fService.createStore("Top");
            fService.createDirectory("Bottom:/", "www");
            fService.createLayeredDirectory("Bottom:/www", "Top:/", "www");
            fService.createFile("Bottom:/www", "newInBottom").close();
            fService.createSnapshot("Bottom", null, null);
            fService.createFile("Top:/www", "newInTop").close();
            fService.createSnapshot("Top", null, null);
            fService.createFile("Bottom:/www", "file").close();
            fService.createSnapshot("Bottom", null, null);
            fService.forceCopy("Top:/www/file");
            fService.createSnapshot("Top", null, null);
            fService.forceCopy("Bottom:/www/file");
            fService.createSnapshot("Bottom", null, null);
            List<AVMDifference> diffs = fSyncService.compare(-1, "Top:/", -1, "Bottom:/", null);
            AVMServiceTest.assertEquals((int)2, (int)diffs.size());
            Collections.sort(diffs);
            AVMDifference last = null;
            for (AVMDifference current : diffs) {
                if (last != null) assert (last.getOrderValue() < current.getOrderValue());
                last = current;
            }
            diffs.add(new AVMDifference(1, null, -1, null, 0));
            diffs.add(new AVMDifference(1, null, -1, null, 1));
            diffs.add(new AVMDifference(1, null, -1, null, 2));
            diffs.add(new AVMDifference(1, null, -1, null, 3));
            diffs.add(new AVMDifference(1, null, -1, null, 4));
            diffs.add(new AVMDifference(1, null, -1, null, 5));
            diffs.add(new AVMDifference(1, null, -1, null, 6));
            Collections.sort(diffs);
            last = null;
            for (AVMDifference current : diffs) {
                if (last != null) assert (last.getOrderValue() < current.getOrderValue());
                last = current;
            }
        }
        finally {
            fService.purgeStore("Bottom");
            fService.purgeStore("Top");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDiffOfNewItems() throws Exception {
        try {
            this.performeDiffTesting(DiffActionEnum.CREATION);
        }
        finally {
            fService.purgeStore("testStore");
            fService.purgeStore("submitStore");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDiffOfModifiedItems() throws Exception {
        try {
            this.performeDiffTesting(DiffActionEnum.MODIFICATION);
        }
        finally {
            fService.purgeStore("testStore");
            fService.purgeStore("submitStore");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDiffOfDeletedItems() throws Exception {
        try {
            this.performeDiffTesting(DiffActionEnum.DELETION);
        }
        finally {
            fService.purgeStore("testStore");
            fService.purgeStore("submitStore");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDiffOfDeletedItemsInModifiedDirectory() throws Exception {
        try {
            this.performeDiffTesting(DiffActionEnum.DELETION_AND_MODIFICATION);
        }
        finally {
            fService.purgeStore("testStore");
            fService.purgeStore("submitStore");
        }
    }

    private void performeDiffTesting(DiffActionEnum action) throws IOException {
        int actualModificationsCount;
        fService.createStore("testStore");
        fService.createStore("submitStore");
        fService.createDirectory("submitStore:/", "root");
        fService.createLayeredDirectory("submitStore:/root", "testStore:/", "root");
        fService.createSnapshot("testStore", null, null);
        fService.createDirectory("testStore:/root", "test");
        for (int i = 0; i < 10; ++i) {
            fService.createFile("testStore:/root/test", "testFileN" + i + ".txt").close();
        }
        List<AVMDifference> diffs = fSyncService.compare(-1, "testStore:/root/", -1, "submitStore:/root/", null);
        if (DiffActionEnum.CREATION != action) {
            fSyncService.update(diffs, null, true, true, false, true, null, null);
            fSyncService.flatten("testStore:/root/", "submitStore:/root/");
            diffs = fSyncService.compare(-1, "testStore:/root/", -1, "submitStore:/root/", null);
        }
        List<AVMDifference> actual = fSyncService.compare(-1, "testStore:/root/", -1, "submitStore:/root/", null, true);
        if (DiffActionEnum.CREATION == action) {
            AVMServiceTest.assertEquals((int)11, (int)actual.size());
            AVMServiceTest.assertEquals((int)1, (int)diffs.size());
            List<AVMDifference> newDiff = fSyncService.compare(-1, "testStore:/root/", -1, "submitStore:/root/", null, false);
            AVMServiceTest.assertEquals((String)diffs.toString(), (String)newDiff.toString());
        } else {
            AVMServiceTest.assertEquals((int)0, (int)actual.size());
            AVMServiceTest.assertEquals((int)0, (int)diffs.size());
        }
        String parentPath = "testStore:/root/test/";
        if (DiffActionEnum.CREATION == action) {
            fService.createDirectory(parentPath, "inner");
            parentPath = parentPath + "inner/";
        }
        int start = DiffActionEnum.DELETION == action ? 1 : 0;
        int incrementingStep = start + 1;
        block5: for (int i = start; i < 10; i += incrementingStep) {
            String name = "testFileN" + i + ".txt";
            String path = parentPath + name;
            switch (action) {
                case CREATION: {
                    fService.createFile(parentPath, name).close();
                    continue block5;
                }
                case MODIFICATION: {
                    fService.setNodeProperty(path, WCMModel.PROP_REVERTED_ID, new PropertyValue(WCMModel.PROP_REVERTED_ID, null));
                    continue block5;
                }
                default: {
                    fService.removeNode(path);
                }
            }
        }
        int n = DiffActionEnum.DELETION == action ? 5 : (actualModificationsCount = DiffActionEnum.CREATION == action ? 22 : 10);
        int diffModificationsCount = DiffActionEnum.DELETION == action ? 5 : (DiffActionEnum.CREATION == action ? 1 : 10);
        actual = fSyncService.compare(-1, "testStore:/root", -1, "submitStore:/root", null, true);
        diffs = fSyncService.compare(-1, "testStore:/root", -1, "submitStore:/root", null);
        AVMServiceTest.assertEquals((int)actualModificationsCount, (int)actual.size());
        AVMServiceTest.assertEquals((int)diffModificationsCount, (int)diffs.size());
        if (DiffActionEnum.CREATION != action) {
            this.assertDiffsList(0, diffs);
            AVMServiceTest.assertEquals((String)diffs.toString(), (String)actual.toString());
        }
        if (DiffActionEnum.CREATION != action) {
            if (DiffActionEnum.DELETION == action) {
                fService.removeNode("testStore:/root/test");
            } else {
                fService.setNodeProperty("testStore:/root/test", WCMModel.PROP_REVERTED_ID, new PropertyValue(WCMModel.PROP_REVERTED_ID, null));
            }
            actual = fSyncService.compare(-1, "testStore:/root/", -1, "submitStore:/root/", null, true);
            diffs = fSyncService.compare(-1, "testStore:/root/", -1, "submitStore:/root/", null);
            actualModificationsCount = DiffActionEnum.DELETION == action ? 1 : actualModificationsCount + 1;
            AVMServiceTest.assertEquals((int)actualModificationsCount, (int)actual.size());
            AVMServiceTest.assertEquals((int)1, (int)diffs.size());
            this.assertDiffsList(0, actual);
            this.assertDiffsList(0, diffs);
        }
    }

    private void assertDiffsList(int expectedCode, List<AVMDifference> actual) {
        for (AVMDifference diff : actual) {
            AVMServiceTest.assertNotNull((Object)diff);
            AVMServiceTest.assertTrue((boolean)diff.isValid());
            AVMServiceTest.assertEquals((int)expectedCode, (int)diff.getDifferenceCode());
        }
    }

    public void test_ETWOTWO_570() throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> readOnlyCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                String storeName = "StagingArea-" + AVMServiceTest.this.getName() + "-" + System.currentTimeMillis();
                AVMServiceTestBase.fService.createStore(storeName);
                AVMServiceTestBase.fService.purgeStore(storeName);
                return null;
            }
        };
        fTransactionService.getRetryingTransactionHelper().doInTransaction(readOnlyCallback, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_WCM_949() throws Exception {
        try {
            fService.createStore("StagingArea");
            fService.createStore("SandBox");
            fService.createDirectory("StagingArea:/", "www");
            fService.createLayeredDirectory("StagingArea:/www", "SandBox:/", "www");
            fService.createDirectory("SandBox:/www", "TestFolder");
            fService.createFile("SandBox:/www/TestFolder", "test1").close();
            List<AVMDifference> diffs = fSyncService.compare(-1, "SandBox:/www", -1, "StagingArea:/www", null);
            AVMServiceTest.assertEquals((int)1, (int)diffs.size());
            AVMServiceTest.assertEquals((String)"[SandBox:/www/TestFolder[-1] > StagingArea:/www/TestFolder[-1]]", (String)diffs.toString());
            fSyncService.update(diffs, null, true, true, false, false, "one", "one");
            fSyncService.flatten("SandBox:/www", "StagingArea:/www");
            StoreRef storeRef = AVMNodeConverter.ToStoreRef("StagingArea");
            SearchService searchService = fIndexerAndSearcher.getSearcher(storeRef, true);
            ResultSet results = searchService.query(storeRef, "lucene", "@cm\\:name:test1");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            fService.removeNode("SandBox:/www/TestFolder");
            diffs = fSyncService.compare(-1, "SandBox:/www", -1, "StagingArea:/www", null);
            AVMServiceTest.assertEquals((int)1, (int)diffs.size());
            AVMServiceTest.assertEquals((String)"[SandBox:/www/TestFolder[-1] > StagingArea:/www/TestFolder[-1]]", (String)diffs.toString());
            fSyncService.update(diffs, null, true, true, false, false, "one", "one");
            fSyncService.flatten("SandBox:/www", "StagingArea:/www");
            results = searchService.query(storeRef, "lucene", "@cm\\:name:test1");
            AVMServiceTest.assertEquals((int)0, (int)results.length());
            results.close();
            fService.createDirectory("SandBox:/www", "TestFolder");
            fService.createFile("SandBox:/www/TestFolder", "test1").close();
            diffs = fSyncService.compare(-1, "SandBox:/www", -1, "StagingArea:/www", null);
            AVMServiceTest.assertEquals((int)1, (int)diffs.size());
            AVMServiceTest.assertEquals((String)"[SandBox:/www/TestFolder[-1] > StagingArea:/www/TestFolder[-1]]", (String)diffs.toString());
            fSyncService.update(diffs, null, true, true, false, false, "one", "one");
            fSyncService.flatten("SandBox:/www", "StagingArea:/www");
            results = searchService.query(storeRef, "lucene", "@cm\\:name:test1");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
        }
        finally {
            fService.purgeStore("StagingArea");
            fService.purgeStore("SandBox");
        }
    }

    public void testPathEncoding() throws Throwable {
        try {
            this.setupBasicTree();
            fService.createFile("main:/", "2007").close();
            fService.createFile("main:/", "meep meep").close();
            fService.createDirectory("main:/", "my space");
            fService.createFile("main:/my space", "my file").close();
            fService.createDirectory("main:/", "2001");
            fService.createFile("main:/2001", "2002").close();
            fService.createSnapshot("main", null, null);
            StoreRef storeRef = AVMNodeConverter.ToStoreRef("main");
            SearchService searchService = fIndexerAndSearcher.getSearcher(storeRef, true);
            ResultSet results = searchService.query(storeRef, "lucene", "PATH:\"/meep_x0020_meep\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            System.out.println(results.getNodeRef(0));
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/_x0032_007\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            System.out.println(results.getNodeRef(0));
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/my_x0020_space/my_x0020_file\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            System.out.println(results.getNodeRef(0));
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/_x0032_001/_x0032_002\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            System.out.println(results.getNodeRef(0));
            results.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void testSpacesInStoreNames() throws Exception {
        try {
            fService.createStore("I have spaces");
            fService.createFile("I have spaces:/", "in my name.txt").close();
            AVMServiceTest.assertNotNull((Object)fService.lookup(-1, "I have spaces:/in my name.txt"));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            fService.purgeStore("I have spaces");
        }
    }

    public void testHeadPathsInLayers() throws Exception {
        try {
            this.setupBasicTree();
            fService.createStore("user");
            fService.createLayeredDirectory("main:/a", "user:/", "a");
            fService.createStore("sandbox");
            fService.createLayeredDirectory("main:/a", "sandbox:/", "a");
            fService.createDirectory("user:/a/b", "newdir");
            fService.createFile("user:/a/b/newdir", "bibble.txt").close();
            List<AVMDifference> diffs = fSyncService.compare(-1, "user:/a", -1, "sandbox:/a", null);
            AVMServiceTest.assertEquals((int)1, (int)diffs.size());
            AVMServiceTest.assertEquals((String)"[user:/a/b/newdir[-1] > sandbox:/a/b/newdir[-1]]", (String)diffs.toString());
            fSyncService.update(diffs, null, false, false, false, false, null, null);
            AVMNodeDescriptor dir = fService.lookup(-1, "user:/a/b/newdir");
            List<Pair<Integer, String>> paths = fService.getHeadPaths(dir);
            System.out.println(paths);
            AVMNodeDescriptor file = fService.lookup(-1, "user:/a/b/newdir/bibble.txt");
            paths = fService.getHeadPaths(file);
            System.out.println(paths);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            fService.purgeStore("user");
            fService.purgeStore("sandbox");
        }
    }

    public void testVersionByDate() throws Exception {
        try {
            ArrayList<Long> times = new ArrayList<Long>();
            BulkLoader loader = new BulkLoader();
            loader.setAvmService(fService);
            AVMServiceTest.assertEquals((int)1, (int)fService.getStoreVersions("main").size());
            loader.recursiveLoad(this.getSourceFolder() + "/org/alfresco/repo/avm/actions", "main:/");
            long time = System.currentTimeMillis();
            times.add(time);
            while (System.currentTimeMillis() <= time) {
            }
            AVMServiceTest.assertEquals((int)1, (int)fService.createSnapshot("main", null, null).get("main"));
            loader.recursiveLoad(this.getSourceFolder() + "/org/alfresco/repo/avm/ibatis", "main:/");
            time = System.currentTimeMillis();
            times.add(time);
            while (System.currentTimeMillis() <= time) {
            }
            AVMServiceTest.assertEquals((int)2, (int)fService.createSnapshot("main", null, null).get("main"));
            loader.recursiveLoad(this.getSourceFolder() + "/org/alfresco/repo/avm/locking", "main:/");
            time = System.currentTimeMillis();
            times.add(time);
            while (System.currentTimeMillis() <= time) {
            }
            AVMServiceTest.assertEquals((int)3, (int)fService.createSnapshot("main", null, null).get("main"));
            AVMServiceTest.assertEquals((int)4, (int)fService.getStoreVersions("main").size());
            AVMServiceTest.assertEquals((int)1, (int)fService.getStoreVersions("main", null, new Date((Long)times.get(0))).size());
            AVMServiceTest.assertEquals((int)3, (int)fService.getStoreVersions("main", new Date((Long)times.get(0)), null).size());
            AVMServiceTest.assertEquals((int)2, (int)fService.getStoreVersions("main", new Date((Long)times.get(1)), new Date(System.currentTimeMillis())).size());
            AVMServiceTest.assertEquals((int)1, (int)fService.getStoreVersionsTo("main", 0).size());
            AVMServiceTest.assertEquals((int)0, (int)fService.getStoreVersionsTo("main", 0).get(0).getVersionID());
            AVMServiceTest.assertEquals((int)2, (int)fService.getStoreVersionsTo("main", 1).size());
            AVMServiceTest.assertEquals((int)0, (int)fService.getStoreVersionsTo("main", 1).get(0).getVersionID());
            AVMServiceTest.assertEquals((int)1, (int)fService.getStoreVersionsTo("main", 1).get(1).getVersionID());
            AVMServiceTest.assertEquals((int)3, (int)fService.getStoreVersionsTo("main", 2).size());
            AVMServiceTest.assertEquals((int)0, (int)fService.getStoreVersionsTo("main", 2).get(0).getVersionID());
            AVMServiceTest.assertEquals((int)1, (int)fService.getStoreVersionsTo("main", 2).get(1).getVersionID());
            AVMServiceTest.assertEquals((int)2, (int)fService.getStoreVersionsTo("main", 2).get(2).getVersionID());
            AVMServiceTest.assertEquals((int)4, (int)fService.getStoreVersionsTo("main", 3).size());
            AVMServiceTest.assertEquals((int)0, (int)fService.getStoreVersionsTo("main", 3).get(0).getVersionID());
            AVMServiceTest.assertEquals((int)1, (int)fService.getStoreVersionsTo("main", 3).get(1).getVersionID());
            AVMServiceTest.assertEquals((int)2, (int)fService.getStoreVersionsTo("main", 3).get(2).getVersionID());
            AVMServiceTest.assertEquals((int)3, (int)fService.getStoreVersionsTo("main", 3).get(3).getVersionID());
            AVMServiceTest.assertEquals((int)4, (int)fService.getStoreVersionsFrom("main", 0).size());
            AVMServiceTest.assertEquals((int)0, (int)fService.getStoreVersionsFrom("main", 0).get(0).getVersionID());
            AVMServiceTest.assertEquals((int)1, (int)fService.getStoreVersionsFrom("main", 0).get(1).getVersionID());
            AVMServiceTest.assertEquals((int)2, (int)fService.getStoreVersionsFrom("main", 0).get(2).getVersionID());
            AVMServiceTest.assertEquals((int)3, (int)fService.getStoreVersionsFrom("main", 0).get(3).getVersionID());
            AVMServiceTest.assertEquals((int)3, (int)fService.getStoreVersionsFrom("main", 1).size());
            AVMServiceTest.assertEquals((int)1, (int)fService.getStoreVersionsFrom("main", 1).get(0).getVersionID());
            AVMServiceTest.assertEquals((int)2, (int)fService.getStoreVersionsFrom("main", 1).get(1).getVersionID());
            AVMServiceTest.assertEquals((int)3, (int)fService.getStoreVersionsFrom("main", 1).get(2).getVersionID());
            AVMServiceTest.assertEquals((int)2, (int)fService.getStoreVersionsFrom("main", 2).size());
            AVMServiceTest.assertEquals((int)2, (int)fService.getStoreVersionsFrom("main", 2).get(0).getVersionID());
            AVMServiceTest.assertEquals((int)3, (int)fService.getStoreVersionsFrom("main", 2).get(1).getVersionID());
            AVMServiceTest.assertEquals((int)1, (int)fService.getStoreVersionsFrom("main", 3).size());
            AVMServiceTest.assertEquals((int)3, (int)fService.getStoreVersionsFrom("main", 3).get(0).getVersionID());
            AVMServiceTest.assertEquals((int)0, (int)fService.getStoreVersionsFrom("main", 4).size());
            AVMServiceTest.assertEquals((int)1, (int)fService.getStoreVersionsBetween("main", 0, 0).size());
            AVMServiceTest.assertEquals((int)0, (int)fService.getStoreVersionsBetween("main", 0, 0).get(0).getVersionID());
            AVMServiceTest.assertEquals((int)1, (int)fService.getStoreVersionsBetween("main", 1, 1).size());
            AVMServiceTest.assertEquals((int)1, (int)fService.getStoreVersionsBetween("main", 1, 1).get(0).getVersionID());
            AVMServiceTest.assertEquals((int)1, (int)fService.getStoreVersionsBetween("main", 2, 2).size());
            AVMServiceTest.assertEquals((int)2, (int)fService.getStoreVersionsBetween("main", 2, 2).get(0).getVersionID());
            AVMServiceTest.assertEquals((int)1, (int)fService.getStoreVersionsBetween("main", 3, 3).size());
            AVMServiceTest.assertEquals((int)3, (int)fService.getStoreVersionsBetween("main", 3, 3).get(0).getVersionID());
            AVMServiceTest.assertEquals((int)0, (int)fService.getStoreVersionsBetween("main", 4, 4).size());
            AVMServiceTest.assertEquals((int)2, (int)fService.getStoreVersionsBetween("main", 1, 2).size());
            AVMServiceTest.assertEquals((int)1, (int)fService.getStoreVersionsBetween("main", 1, 2).get(0).getVersionID());
            AVMServiceTest.assertEquals((int)2, (int)fService.getStoreVersionsBetween("main", 1, 2).get(1).getVersionID());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testProperties() throws Exception {
        try {
            this.setupBasicTree();
            StoreRef storeRef = AVMNodeConverter.ToStoreRef("main");
            SearchService searchService = fIndexerAndSearcher.getSearcher(storeRef, true);
            ResultSet results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)"@{silly.uri}SillyProperty") + ":\"Silly\"");
            AVMServiceTest.assertEquals((int)0, (int)results.length());
            results.close();
            QName name = QName.createQName((String)"silly.uri", (String)"SillyProperty");
            PropertyValue value = new PropertyValue(DataTypeDefinition.TEXT, (Serializable)((Object)"Silly Property Value"));
            fService.setNodeProperty("main:/a/b/c/foo", name, value);
            fService.createSnapshot("main", null, null);
            results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)"@{silly.uri}SillyProperty") + ":\"Silly\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            PropertyValue returned = fService.getNodeProperty(-1, "main:/a/b/c/foo", name);
            AVMServiceTest.assertEquals((String)value.toString(), (String)returned.toString());
            Map<QName, PropertyValue> props = fService.getNodeProperties(-1, "main:/a/b/c/foo");
            AVMServiceTest.assertEquals((int)1, (int)props.size());
            AVMServiceTest.assertEquals((String)value.toString(), (String)props.get(name).toString());
            props = new HashMap<QName, PropertyValue>();
            QName n1 = QName.createQName((String)"silly.uri", (String)"Prop1");
            PropertyValue p1 = new PropertyValue(DataTypeDefinition.DATETIME, new Date(System.currentTimeMillis()));
            props.put(n1, p1);
            QName n2 = QName.createQName((String)"silly.uri", (String)"Prop2");
            PropertyValue p2 = new PropertyValue(DataTypeDefinition.TEXT, (Serializable)((Object)"A String Property."));
            props.put(n2, p2);
            QName n3 = QName.createQName((String)"silly.uri", (String)"Prop3");
            PropertyValue p3 = new PropertyValue(DataTypeDefinition.INT, Integer.valueOf(42));
            props.put(n3, p3);
            QName n4 = QName.createQName((String)"silly.uri", (String)"Prop4");
            PropertyValue p4 = new PropertyValue(null, new Boolean(false));
            props.put(n4, p4);
            QName n5 = QName.createQName((String)"silly.uri", (String)"Prop5");
            ArrayList<String> strList = new ArrayList<String>(2);
            strList.add("hello");
            strList.add("world");
            PropertyValue p5 = new PropertyValue(DataTypeDefinition.TEXT, strList);
            props.put(n5, p5);
            fService.setNodeProperties("main:/a/b/c/bar", props);
            fService.createSnapshot("main", null, null);
            props = fService.getNodeProperties(-1, "main:/a/b/c/bar");
            AVMServiceTest.assertEquals((int)5, (int)props.size());
            AVMServiceTest.assertEquals((String)p1.toString(), (String)props.get(n1).toString());
            AVMServiceTest.assertEquals((String)p2.toString(), (String)props.get(n2).toString());
            AVMServiceTest.assertEquals((String)p3.toString(), (String)props.get(n3).toString());
            AVMServiceTest.assertEquals((String)p4.toString(), (String)props.get(n4).toString());
            AVMServiceTest.assertEquals((String)p5.toString(), (String)props.get(n5).toString());
            results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)"@{silly.uri}Prop1") + ":\"" + props.get(n1).getStringValue() + "\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)"@{silly.uri}Prop2") + ":\"" + props.get(n2).getStringValue() + "\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            props = new HashMap<QName, PropertyValue>();
            n1 = QName.createQName((String)"silly.uri", (String)"Prop1");
            p1 = new PropertyValue(DataTypeDefinition.DATETIME, new Date(System.currentTimeMillis()));
            props.put(n1, p1);
            n2 = QName.createQName((String)"silly.uri", (String)"Prop2");
            p2 = new PropertyValue(DataTypeDefinition.TEXT, (Serializable)((Object)"A String Property - updated."));
            props.put(n2, p2);
            n3 = QName.createQName((String)"silly.uri", (String)"Prop3");
            p3 = new PropertyValue(DataTypeDefinition.INT, Integer.valueOf(-42));
            props.put(n3, p3);
            n4 = QName.createQName((String)"silly.uri", (String)"Prop4");
            p4 = new PropertyValue(null, new Boolean(true));
            props.put(n4, p4);
            n5 = QName.createQName((String)"silly.uri", (String)"Prop5");
            strList = new ArrayList(2);
            strList.add("goodbye");
            strList.add("world");
            p5 = new PropertyValue(DataTypeDefinition.TEXT, strList);
            props.put(n5, p5);
            fService.setNodeProperties("main:/a/b/c/bar", props);
            fService.createSnapshot("main", null, null);
            props = fService.getNodeProperties(-1, "main:/a/b/c/bar");
            AVMServiceTest.assertEquals((int)5, (int)props.size());
            AVMServiceTest.assertEquals((String)p1.toString(), (String)props.get(n1).toString());
            AVMServiceTest.assertEquals((String)p2.toString(), (String)props.get(n2).toString());
            AVMServiceTest.assertEquals((String)p3.toString(), (String)props.get(n3).toString());
            AVMServiceTest.assertEquals((String)p4.toString(), (String)props.get(n4).toString());
            AVMServiceTest.assertEquals((String)p5.toString(), (String)props.get(n5).toString());
            fService.deleteNodeProperty("main:/a/b/c/bar", n1);
            fService.createSnapshot("main", null, null);
            results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)"@{silly.uri}Prop1") + ":\"" + props.get(n1).getStringValue() + "\"");
            AVMServiceTest.assertEquals((int)0, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)"@{silly.uri}Prop2") + ":\"" + props.get(n2).getStringValue() + "\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            props = fService.getNodeProperties(-1, "main:/a/b/c/bar");
            AVMServiceTest.assertEquals((int)4, (int)props.size());
            AVMServiceTest.assertEquals((String)p2.toString(), (String)props.get(n2).toString());
            AVMServiceTest.assertEquals((String)p3.toString(), (String)props.get(n3).toString());
            AVMServiceTest.assertEquals((String)p4.toString(), (String)props.get(n4).toString());
            AVMServiceTest.assertEquals((String)p5.toString(), (String)props.get(n5).toString());
            fService.deleteNodeProperties("main:/a/b/c/bar");
            fService.createSnapshot("main", null, null);
            results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)"@{silly.uri}Prop1") + ":\"" + p1.getStringValue() + "\"");
            AVMServiceTest.assertEquals((int)0, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)"@{silly.uri}Prop2") + ":\"" + props.get(n2).getStringValue() + "\"");
            AVMServiceTest.assertEquals((int)0, (int)results.length());
            results.close();
            props = fService.getNodeProperties(-1, "main:/a/b/c/bar");
            AVMServiceTest.assertEquals((int)0, (int)props.size());
            fService.removeNode("main:/a/b/c/foo");
            AVMServiceTest.assertEquals((int)1, (int)fService.getNodeProperties(-1, "main:/a/b/c/foo").size());
            fService.setNodeProperty("main:/a/b/c/foo", QName.createQName((String)"silly.uri", (String)"Prop1"), new PropertyValue(null, Integer.valueOf(42)));
            AVMServiceTest.assertEquals((int)2, (int)fService.getNodeProperties(-1, "main:/a/b/c/foo").size());
            fService.createSnapshot("main", null, null);
            results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)"@{silly.uri}Prop1") + ":\"" + p1.getStringValue() + "\"");
            AVMServiceTest.assertEquals((int)0, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)"@{silly.uri}Prop2") + ":\"" + p2.getStringValue() + "\"");
            AVMServiceTest.assertEquals((int)0, (int)results.length());
            results.close();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testGetStoreVersionRootPaths() throws Exception {
        try {
            this.setupBasicTree();
            AVMNodeDescriptor desc = fService.lookup(-1, "main:/a/b/c/foo");
            List<String> paths = fService.getPathsInStoreVersion(desc, "main", 1);
            AVMServiceTest.assertEquals((int)1, (int)paths.size());
            AVMServiceTest.assertEquals((String)"main:/a/b/c/foo", (String)paths.get(0));
            fService.getFileOutputStream("main:/a/b/c/foo").close();
            fService.createSnapshot("main", null, null);
            fService.getFileOutputStream("main:/a/b/c/foo").close();
            fService.createSnapshot("main", null, null);
            fService.getFileOutputStream("main:/a/b/c/foo").close();
            fService.createSnapshot("main", null, null);
            fService.getFileOutputStream("main:/a/b/c/foo").close();
            fService.createSnapshot("main", null, null);
            fService.getFileOutputStream("main:/a/b/c/foo").close();
            fService.createSnapshot("main", null, null);
            fService.getFileOutputStream("main:/a/b/c/foo").close();
            fService.createSnapshot("main", null, null);
            fService.getFileOutputStream("main:/a/b/c/foo").close();
            fService.createSnapshot("main", null, null);
            fService.getFileOutputStream("main:/a/b/c/foo").close();
            fService.createSnapshot("main", null, null);
            paths = fService.getPathsInStoreVersion(desc, "main", 1);
            AVMServiceTest.assertEquals((int)1, (int)paths.size());
            AVMServiceTest.assertEquals((String)"main:/a/b/c/foo", (String)paths.get(0));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void testForceCopyDeleted() throws Exception {
        try {
            this.setupBasicTree();
            fService.removeNode("main:/a/b/c/foo");
            fService.createSnapshot("main", null, null);
            AVMNodeDescriptor desc = fService.forceCopy("main:/a/b/c/foo");
            AVMServiceTest.assertTrue((boolean)desc.isDeleted());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void testLayerSnapshots() throws Exception {
        try {
            this.setupBasicTree();
            AVMServiceTest.assertEquals((int)1, (int)fService.createSnapshot("main", null, null).get("main"));
            this.runQueriesAgainstBasicTree("main");
            fService.createStore("layer");
            fService.createLayeredDirectory("main:/a", "layer:/", "a");
            fService.createSnapshot("layer", null, null);
            this.runQueriesAgainstBasicTree("main");
            fService.createFile("main:/a", "Xander").close();
            fService.createSnapshot("layer", null, null);
            AVMServiceTest.assertEquals((int)2, (int)fService.lookup(2, "layer:/a").getIndirectionVersion());
            SortedMap<String, AVMNodeDescriptor> listing = fService.getDirectoryListing(2, "layer:/");
            AVMServiceTest.assertEquals((int)1, (int)listing.size());
            AVMServiceTest.assertEquals((int)2, (int)((AVMNodeDescriptor)listing.values().iterator().next()).getIndirectionVersion());
            AVMServiceTest.assertEquals((long)fService.lookup(2, "main:/a/Xander").getId(), (long)fService.lookup(2, "layer:/a/Xander").getId());
            AVMServiceTest.assertNull((Object)fService.lookup(1, "layer:/a/Xander"));
            listing = fService.getDirectoryListing(1, "layer:/");
            AVMServiceTest.assertEquals((int)1, (int)listing.size());
            AVMServiceTest.assertEquals((int)1, (int)((AVMNodeDescriptor)listing.values().iterator().next()).getIndirectionVersion());
            AVMServiceTest.assertEquals((int)-1, (int)fService.lookup(-1, "layer:/a").getIndirectionVersion());
            listing = fService.getDirectoryListing(-1, "layer:/");
            AVMServiceTest.assertEquals((int)1, (int)listing.size());
            AVMServiceTest.assertEquals((int)-1, (int)((AVMNodeDescriptor)listing.values().iterator().next()).getIndirectionVersion());
            AVMServiceTest.assertEquals((long)fService.lookup(-1, "main:/a/Xander").getId(), (long)fService.lookup(-1, "layer:/a/Xander").getId());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            fService.purgeStore("layer");
        }
    }

    public void testBranchLayerSnapshot() throws Exception {
        try {
            this.setupBasicTree();
            fService.createStore("layer");
            fService.createDirectory("layer:/", "root");
            fService.createLayeredDirectory("main:/a", "layer:/root", "layer");
            fService.createSnapshot("layer", null, null);
            fService.createFile("main:/a", "dummy").close();
            fService.createFile("layer:/root/layer", "pygmy").close();
            fService.createSnapshot("layer", null, null);
            fService.createStore("branch");
            fService.createBranch(1, "layer:/root", "branch:/", "branch");
            fService.createSnapshot("branch", null, null);
            fService.getFileOutputStream("main:/a/b/c/foo").close();
            System.out.println("main 1");
            System.out.println(this.recursiveList("main", 1, true));
            System.out.println("branch 1");
            System.out.println(this.recursiveList("branch", 1, true));
            AVMServiceTest.assertEquals((long)fService.lookup(1, "main:/a/b/c/foo").getId(), (long)fService.lookup(1, "branch:/branch/layer/b/c/foo").getId());
            System.out.println("main -1");
            System.out.println(this.recursiveList("main", -1, true));
            System.out.println("branch -1");
            System.out.println(this.recursiveList("branch", -1, true));
            AVMServiceTest.assertEquals((long)fService.lookup(-1, "main:/a/b/c/foo").getId(), (long)fService.lookup(-1, "branch:/branch/layer/b/c/foo").getId());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            fService.purgeStore("layer");
            fService.purgeStore("branch");
        }
    }

    protected void runQueriesForCreateAndDeploy(String store) throws Exception {
        StoreRef storeRef = AVMNodeConverter.ToStoreRef(store);
        SearchService searchService = fIndexerAndSearcher.getSearcher(AVMNodeConverter.ToStoreRef(store), true);
        ResultSet results = searchService.query(storeRef, "lucene", "TEXT:\"I am main\"");
        AVMServiceTest.assertEquals((int)2, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_NAME)) + ":\"foo\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_NAME)) + ":foo");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_NAME)) + ":biz");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_CREATOR)) + ":admin");
        AVMServiceTest.assertEquals((int)7, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_MODIFIER)) + ":admin");
        AVMServiceTest.assertEquals((int)7, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_OWNER)) + ":admin");
        AVMServiceTest.assertEquals((int)7, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_NODE_UUID)) + ":unknown");
        AVMServiceTest.assertEquals((int)7, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_STORE_PROTOCOL)) + ":avm");
        AVMServiceTest.assertEquals((int)7, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_STORE_IDENTIFIER)) + ":" + store);
        AVMServiceTest.assertEquals((int)7, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a/b\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a/b/biz\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a/b/c\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a/b/c/foo\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a/b/c/bar\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/d\"");
        AVMServiceTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/d/e\"");
        AVMServiceTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/d/e/f\"");
        AVMServiceTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"//.\"");
        AVMServiceTest.assertEquals((int)7, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"//*\"");
        AVMServiceTest.assertEquals((int)6, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a//.\"");
        AVMServiceTest.assertEquals((int)6, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a//*\"");
        AVMServiceTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a/*\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a/b/*\"");
        AVMServiceTest.assertEquals((int)2, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"//c/*\"");
        AVMServiceTest.assertEquals((int)2, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/*\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/*/*\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/*/*/*\"");
        AVMServiceTest.assertEquals((int)2, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/*/*/*/*\"");
        AVMServiceTest.assertEquals((int)2, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/*/*/*/*/*\"");
        AVMServiceTest.assertEquals((int)0, (int)results.length());
        results.close();
    }

    protected void runQueriesForRemoveAndDelpoy(String store) {
        StoreRef storeRef = AVMNodeConverter.ToStoreRef(store);
        SearchService searchService = fIndexerAndSearcher.getSearcher(AVMNodeConverter.ToStoreRef(store), true);
        ResultSet results = searchService.query(storeRef, "lucene", "TEXT:\"I am main\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_NAME)) + ":\"foo\"");
        AVMServiceTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_NAME)) + ":foo");
        AVMServiceTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_NAME)) + ":biz");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_CREATOR)) + ":admin");
        AVMServiceTest.assertEquals((int)6, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_MODIFIER)) + ":admin");
        AVMServiceTest.assertEquals((int)6, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_OWNER)) + ":admin");
        AVMServiceTest.assertEquals((int)6, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_NODE_UUID)) + ":unknown");
        AVMServiceTest.assertEquals((int)6, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_STORE_PROTOCOL)) + ":avm");
        AVMServiceTest.assertEquals((int)6, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_STORE_IDENTIFIER)) + ":" + store);
        AVMServiceTest.assertEquals((int)6, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a/b\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a/b/biz\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a/b/c\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a/b/c/foo\"");
        AVMServiceTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a/b/c/bar\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/d\"");
        AVMServiceTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/d/e\"");
        AVMServiceTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/d/e/f\"");
        AVMServiceTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"//.\"");
        AVMServiceTest.assertEquals((int)6, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"//*\"");
        AVMServiceTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a//.\"");
        AVMServiceTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a//*\"");
        AVMServiceTest.assertEquals((int)4, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a/*\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a/b/*\"");
        AVMServiceTest.assertEquals((int)2, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"//c/*\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/*\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/*/*\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/*/*/*\"");
        AVMServiceTest.assertEquals((int)2, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/*/*/*/*\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/*/*/*/*/*\"");
        AVMServiceTest.assertEquals((int)0, (int)results.length());
        results.close();
    }

    protected void runQueriesForRemoveFileAndCreateDirectoryAndDeploy(String store) {
        StoreRef storeRef = AVMNodeConverter.ToStoreRef(store);
        SearchService searchService = fIndexerAndSearcher.getSearcher(AVMNodeConverter.ToStoreRef(store), true);
        ResultSet results = searchService.query(storeRef, "lucene", "TEXT:\"I am main\"");
        AVMServiceTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_NAME)) + ":\"foo\"");
        AVMServiceTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_NAME)) + ":\"bar\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_NAME)) + ":foo");
        AVMServiceTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_NAME)) + ":biz");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_CREATOR)) + ":admin");
        AVMServiceTest.assertEquals((int)6, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_MODIFIER)) + ":admin");
        AVMServiceTest.assertEquals((int)6, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_OWNER)) + ":admin");
        AVMServiceTest.assertEquals((int)6, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_NODE_UUID)) + ":unknown");
        AVMServiceTest.assertEquals((int)6, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_STORE_PROTOCOL)) + ":avm");
        AVMServiceTest.assertEquals((int)6, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_STORE_IDENTIFIER)) + ":" + store);
        AVMServiceTest.assertEquals((int)6, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a/b\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a/b/biz\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a/b/c\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a/b/c/foo\"");
        AVMServiceTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a/b/c/bar\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/d\"");
        AVMServiceTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/d/e\"");
        AVMServiceTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/d/e/f\"");
        AVMServiceTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"//.\"");
        AVMServiceTest.assertEquals((int)6, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"//*\"");
        AVMServiceTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a//.\"");
        AVMServiceTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a//*\"");
        AVMServiceTest.assertEquals((int)4, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a/*\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a/b/*\"");
        AVMServiceTest.assertEquals((int)2, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"//c/*\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/*\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/*/*\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/*/*/*\"");
        AVMServiceTest.assertEquals((int)2, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/*/*/*/*\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/*/*/*/*/*\"");
        AVMServiceTest.assertEquals((int)0, (int)results.length());
        results.close();
    }

    public void testGuids() throws Exception {
        try {
            this.setupBasicTree();
            System.out.println(fService.lookup(-1, "main:/a/b/c/foo").getGuid());
            String guid = GUID.generate();
            fService.setGuid("main:/a/b/c/foo", guid);
            AVMServiceTest.assertEquals((String)guid, (String)fService.lookup(-1, "main:/a/b/c/foo").getGuid());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void testRevertToVersionAction() throws Exception {
        try {
            this.setupBasicTree();
            ContentWriter writer = fService.getContentWriter("main:/a/b/c/foo", true);
            writer.setEncoding("UTF-8");
            writer.setMimetype("text/plain");
            writer.putContent("I am main:/a/b/c/foo V1");
            fService.createSnapshot("main", "v1", null);
            writer = fService.getContentWriter("main:/a/b/c/foo", true);
            writer.setEncoding("UTF-8");
            writer.setMimetype("text/plain");
            writer.putContent("I am main:/a/b/c/foo V2");
            fService.createSnapshot("main", "v2", null);
            writer = fService.getContentWriter("main:/a/b/c/foo", true);
            writer.setEncoding("UTF-8");
            writer.setMimetype("text/plain");
            writer.putContent("I am main:/a/b/c/foo V3");
            fService.createSnapshot("main", "v3", null);
            writer = fService.getContentWriter("main:/a/b/c/foo", true);
            writer.setEncoding("UTF-8");
            writer.setMimetype("text/plain");
            writer.putContent("I am main:/a/b/c/foo V4");
            fService.createSnapshot("main", "v4", null);
            writer = fService.getContentWriter("main:/a/b/c/foo", true);
            writer.setEncoding("UTF-8");
            writer.setMimetype("text/plain");
            writer.putContent("I am main:/a/b/c/foo V5");
            fService.createSnapshot("main", "v5", null);
            writer = fService.getContentWriter("main:/a/b/c/foo", true);
            writer.setEncoding("UTF-8");
            writer.setMimetype("text/plain");
            writer.putContent("I am main:/a/b/c/foo HEAD");
            StoreRef storeRef = AVMNodeConverter.ToStoreRef("main");
            SearchService searchService = fIndexerAndSearcher.getSearcher(storeRef, true);
            ResultSet results = searchService.query(storeRef, "lucene", "TEXT:\"HEAD\"");
            AVMServiceTest.assertEquals((int)0, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "TEXT:\"V5\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "TEXT:\"V2\"");
            AVMServiceTest.assertEquals((int)0, (int)results.length());
            results.close();
            AVMNodeDescriptor desc = fService.lookup(-1, "main:/a/b/c/foo");
            List<AVMNodeDescriptor> history = fService.getHistory(desc, 100);
            AVMNodeDescriptor toRevert = history.get(3);
            final ActionImpl action = new ActionImpl(null, GUID.generate(), "avm-revert-to-version");
            action.setParameterValue("to-revert", toRevert);
            final AVMRevertToVersionAction revert = (AVMRevertToVersionAction)fContext.getBean("avm-revert-to-version");
            TransactionService transactionService = (TransactionService)fContext.getBean("transactionService");
            class TxnWork
            implements RetryingTransactionHelper.RetryingTransactionCallback<Object> {
                TxnWork() {
                }

                @Override
                public Object execute() throws Exception {
                    revert.execute(action, AVMNodeConverter.ToNodeRef(-1, "main:/a/b/c/foo"));
                    return null;
                }
            }
            transactionService.getRetryingTransactionHelper().doInTransaction(new TxnWork());
            results = searchService.query(storeRef, "lucene", "TEXT:\"HEAD\"");
            AVMServiceTest.assertEquals((int)0, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "TEXT:\"V5\"");
            AVMServiceTest.assertEquals((int)0, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "TEXT:\"V2\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void testVersionNumbering() throws Exception {
        try {
            this.setupBasicTree();
            AVMNodeDescriptor desc = fService.lookup(-1, "main:/a/b/c/foo");
            AVMServiceTest.assertEquals((int)1, (int)desc.getVersionID());
            fService.getFileOutputStream("main:/a/b/c/foo").close();
            desc = fService.lookup(-1, "main:/a/b/c/foo");
            AVMServiceTest.assertEquals((int)2, (int)desc.getVersionID());
            desc = fService.lookup(-1, "main:/a/b");
            AVMServiceTest.assertEquals((int)2, (int)desc.getVersionID());
            fService.createSnapshot("main", null, null);
            fService.createLayeredDirectory("main:/a", "main:/", "layer");
            fService.createSnapshot("main", null, null);
            fService.getFileOutputStream("main:/layer/b/c/bar").close();
            desc = fService.lookup(-1, "main:/layer/b/c/bar");
            AVMServiceTest.assertEquals((int)2, (int)desc.getVersionID());
            desc = fService.lookup(-1, "main:/layer/b/c");
            AVMServiceTest.assertEquals((int)3, (int)desc.getVersionID());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void testHistoryRelink() throws Exception {
        try {
            this.setupBasicTree();
            fService.createStore("branch");
            fService.createBranch(-1, "main:/a", "branch:/", "a");
            fService.removeNode("branch:/a/b/c/foo");
            List<AVMDifference> diffs = fSyncService.compare(-1, "branch:/a", -1, "main:/a", null);
            AVMServiceTest.assertEquals((int)1, (int)diffs.size());
            AVMServiceTest.assertEquals((int)0, (int)diffs.get(0).getDifferenceCode());
            AVMServiceTest.assertEquals((String)"[branch:/a/b/c/foo[-1] > main:/a/b/c/foo[-1]]", (String)diffs.toString());
            fService.createFile("branch:/a/b/c", "foo").close();
            diffs = fSyncService.compare(-1, "branch:/a", -1, "main:/a", null);
            AVMServiceTest.assertEquals((int)1, (int)diffs.size());
            AVMServiceTest.assertEquals((int)0, (int)diffs.get(0).getDifferenceCode());
            AVMServiceTest.assertEquals((String)"[branch:/a/b/c/foo[-1] > main:/a/b/c/foo[-1]]", (String)diffs.toString());
            fSyncService.update(diffs, null, false, false, false, false, null, null);
            fService.removeNode("branch:/a/b/c/bar");
            fService.createFile("branch:/a/b/c", "pismo").close();
            fService.rename("branch:/a/b/c", "pismo", "branch:/a/b/c", "bar");
            diffs = fSyncService.compare(-1, "branch:/a", -1, "main:/a", null);
            AVMServiceTest.assertEquals((int)1, (int)diffs.size());
            AVMServiceTest.assertEquals((int)0, (int)diffs.get(0).getDifferenceCode());
            AVMServiceTest.assertEquals((String)"[branch:/a/b/c/bar[-1] > main:/a/b/c/bar[-1]]", (String)diffs.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            fService.purgeStore("branch");
        }
    }

    public void testRenameStore() throws Exception {
        try {
            this.setupBasicTree();
            AVMServiceTest.assertNotNull((Object)fService.lookup(-1, "main:/a/b"));
            fService.renameStore("main", "foo");
            AVMServiceTest.assertNotNull((Object)fService.getStore("foo"));
            AVMServiceTest.assertNotNull((Object)fService.lookup(-1, "foo:/a/b"));
            this.runQueriesAgainstBasicTree("foo");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            fService.purgeStore("foo");
        }
    }

    public void testCopy() throws Exception {
        try {
            this.setupBasicTree();
            fService.copy(-1, "main:/a/b/c/foo", "main:/d", "fooCopy");
            AVMNodeDescriptor desc = fService.lookup(-1, "main:/d/fooCopy");
            AVMServiceTest.assertTrue((boolean)desc.isFile());
            fService.createSnapshot("main", null, null);
            this.runQueriesAgainstBasicTreePlusFileCopy("main");
            fService.copy(-1, "main:/a", "main:/d/e", "aCopy");
            desc = fService.lookup(-1, "main:/d/e/aCopy");
            AVMServiceTest.assertTrue((boolean)desc.isDirectory());
            desc = fService.lookup(-1, "main:/a/b/c/bar");
            AVMNodeDescriptor desc2 = fService.lookup(-1, "main:/d/e/aCopy/b/c/bar");
            AVMServiceTest.assertTrue((boolean)desc2.isFile());
            AVMServiceTest.assertEquals((long)desc.getLength(), (long)desc2.getLength());
            fService.createSnapshot("main", null, null);
            this.runQueriesAgainstBasicTreePlusFileCopyAndDirectoryCopy("main");
            try {
                fService.copy(-1, "main:/", "main://d/e", "illegal");
                AVMServiceTest.fail();
            }
            catch (AVMException ae) {
                // empty catch block
            }
            StoreRef storeRef = AVMNodeConverter.ToStoreRef("main");
            SearchService searchService = fIndexerAndSearcher.getSearcher(storeRef, true);
            ResultSet results = searchService.query(storeRef, "lucene", "@" + AbstractLuceneQueryParser.escape((String)ContentModel.PROP_NAME.toString()) + ":\"guest\"");
            AVMServiceTest.assertEquals((int)0, (int)results.length());
            results.close();
            CrossRepositoryCopyService copyService = (CrossRepositoryCopyService)fContext.getBean("CrossRepositoryCopyService");
            RepoRemote remoteService = (RepoRemote)fContext.getBean("RepoRemoteService");
            Pair<NodeRef, Boolean> toCopy = remoteService.lookup(remoteService.getRoot(), "Guest Home");
            copyService.copy((NodeRef)toCopy.getFirst(), AVMNodeConverter.ToNodeRef(-1, "main:/"), "Guest Home");
            desc = fService.lookup(-1, "main:/Guest Home");
            AVMServiceTest.assertTrue((boolean)desc.isDirectory());
            System.out.println(this.recursiveList("main", -1, true));
            fService.createSnapshot("main", null, null);
            searchService = fIndexerAndSearcher.getSearcher(storeRef, true);
            results = searchService.query(storeRef, "lucene", "@" + AbstractLuceneQueryParser.escape((String)ContentModel.PROP_NAME.toString()) + ":\"guest\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            StoreRef spacesStore = new StoreRef("workspace", "SpacesStore");
            searchService = fIndexerAndSearcher.getSearcher(spacesStore, true);
            results = searchService.query(spacesStore, "lucene", "PATH:\"//.\"");
            int count = results.length();
            results.close();
            copyService.copy(AVMNodeConverter.ToNodeRef(-1, "main:/a"), (NodeRef)toCopy.getFirst(), "a");
            Pair<NodeRef, Boolean> theCopy = remoteService.lookup((NodeRef)toCopy.getFirst(), "a");
            AVMServiceTest.assertTrue((boolean)((Boolean)theCopy.getSecond()));
            results = searchService.query(spacesStore, "lucene", "PATH:\"//.\"");
            AVMServiceTest.assertEquals((int)(count + 5), (int)results.length());
            results.close();
            results = searchService.query(spacesStore, "lucene", "PATH:\"//.\"");
            AVMServiceTest.assertEquals((int)(count + 5), (int)results.length());
            results.close();
            results = searchService.query(spacesStore, "lucene", "@cm\\:name:foo");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            remoteService.removeNode((NodeRef)theCopy.getFirst());
            results = searchService.query(spacesStore, "lucene", "PATH:\"//.\"");
            AVMServiceTest.assertEquals((int)count, (int)results.length());
            results.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void testCopy_ALF_835() throws Exception {
        try {
            fService.createStore("mainA");
            fService.createDirectory("mainA:/", "a");
            fService.createDirectory("mainA:/a", "www");
            AVMNodeDescriptor desc = fService.lookup(-1, "mainA:/a/www");
            AVMServiceTest.assertTrue((boolean)desc.isDirectory());
            desc = fService.lookup(-1, "mainA:/a/www/www");
            AVMServiceTest.assertNull((Object)desc);
            fService.copy(-1, "mainA:/a/www", "mainA:/a/www", "www");
            desc = fService.lookup(-1, "mainA:/a/www/www");
            AVMServiceTest.assertTrue((boolean)desc.isDirectory());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
        finally {
            fService.purgeStore("mainA");
        }
    }

    protected void runQueriesAgainstBasicTreePlusFileCopy(String store) {
        StoreRef storeRef = AVMNodeConverter.ToStoreRef(store);
        SearchService searchService = fIndexerAndSearcher.getSearcher(storeRef, true);
        ResultSet results = searchService.query(storeRef, "lucene", "TEXT:\"I am main\"");
        AVMServiceTest.assertEquals((int)3, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_NAME)) + ":\"foo\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_NAME)) + ":foo");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_NAME)) + ":\"fooCopy\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_CREATOR)) + ":admin");
        AVMServiceTest.assertEquals((int)10, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_MODIFIER)) + ":admin");
        AVMServiceTest.assertEquals((int)10, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_OWNER)) + ":admin");
        AVMServiceTest.assertEquals((int)10, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_NODE_UUID)) + ":unknown");
        AVMServiceTest.assertEquals((int)10, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_STORE_PROTOCOL)) + ":avm");
        AVMServiceTest.assertEquals((int)10, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_STORE_IDENTIFIER)) + ":" + store);
        AVMServiceTest.assertEquals((int)10, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a/b\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a/b/c\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a/b/c/foo\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a/b/c/bar\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/d\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/d/fooCopy\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/d/e\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/d/e/f\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"//.\"");
        AVMServiceTest.assertEquals((int)10, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"//*\"");
        AVMServiceTest.assertEquals((int)9, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a//.\"");
        AVMServiceTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a//*\"");
        AVMServiceTest.assertEquals((int)4, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a/*\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"//c/*\"");
        AVMServiceTest.assertEquals((int)2, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/*\"");
        AVMServiceTest.assertEquals((int)2, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/*/*\"");
        AVMServiceTest.assertEquals((int)3, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/*/*/*\"");
        AVMServiceTest.assertEquals((int)2, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/*/*/*/*\"");
        AVMServiceTest.assertEquals((int)2, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/*/*/*/*/*\"");
        AVMServiceTest.assertEquals((int)0, (int)results.length());
        results.close();
    }

    protected void runQueriesAgainstBasicTreePlusFileCopyAndDirectoryCopy(String store) {
        StoreRef storeRef = AVMNodeConverter.ToStoreRef(store);
        SearchService searchService = fIndexerAndSearcher.getSearcher(storeRef, true);
        ResultSet results = searchService.query(storeRef, "lucene", "TEXT:\"I am main\"");
        AVMServiceTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_NAME)) + ":\"foo\"");
        AVMServiceTest.assertEquals((int)2, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_NAME)) + ":foo");
        AVMServiceTest.assertEquals((int)2, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_NAME)) + ":\"fooCopy\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_CREATOR)) + ":admin");
        AVMServiceTest.assertEquals((int)15, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_MODIFIER)) + ":admin");
        AVMServiceTest.assertEquals((int)15, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_OWNER)) + ":admin");
        AVMServiceTest.assertEquals((int)15, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_NODE_UUID)) + ":unknown");
        AVMServiceTest.assertEquals((int)15, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_STORE_PROTOCOL)) + ":avm");
        AVMServiceTest.assertEquals((int)15, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_STORE_IDENTIFIER)) + ":" + store);
        AVMServiceTest.assertEquals((int)15, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a/b\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a/b/c\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a/b/c/foo\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a/b/c/bar\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/d\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/d/fooCopy\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/d/e\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/d/e/f\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/d/e/aCopy\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/d/e/aCopy/b\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/d/e/aCopy/b/c\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/d/e/aCopy/b/c/foo\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/d/e/aCopy/b/c/bar\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"//.\"");
        AVMServiceTest.assertEquals((int)15, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"//*\"");
        AVMServiceTest.assertEquals((int)14, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a//.\"");
        AVMServiceTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a//*\"");
        AVMServiceTest.assertEquals((int)4, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a/*\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"//c/*\"");
        AVMServiceTest.assertEquals((int)4, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/*\"");
        AVMServiceTest.assertEquals((int)2, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/*/*\"");
        AVMServiceTest.assertEquals((int)3, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/*/*/*\"");
        AVMServiceTest.assertEquals((int)3, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/*/*/*/*\"");
        AVMServiceTest.assertEquals((int)3, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/*/*/*/*/*\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/*/*/*/*/*/*\"");
        AVMServiceTest.assertEquals((int)2, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/*/*/*/*/*/*/*\"");
        AVMServiceTest.assertEquals((int)0, (int)results.length());
        results.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCircularLayering() throws Exception {
        try {
            fService.createLayeredDirectory("main:/c", "main:/", "b");
            fService.createLayeredDirectory("main:/b", "main:/", "c");
            AVMServiceTest.fail();
        }
        catch (AVMCycleException e) {
            // empty catch block
        }
        try {
            fService.createDirectory("main:/", "a");
            fService.createDirectory("main:/a", "b");
            fService.createLayeredDirectory("main:/a", "main:/a/b", "c");
            AVMServiceTest.fail();
        }
        catch (AVMCycleException e) {
            // empty catch block
        }
        try {
            fService.createStore("a");
            fService.createStore("b");
            fService.createDirectory("a:/", "a");
            fService.createDirectory("b:/", "a");
            fService.createLayeredDirectory("a:/a/b", "b:/a", "b");
            fService.createLayeredDirectory("b:/a/b", "a:/a", "b");
            AVMServiceTest.fail();
        }
        catch (AVMCycleException e) {
        }
        finally {
            fService.purgeStore("a");
            fService.purgeStore("b");
        }
        try {
            fService.createStore("test1");
            fService.createStore("test2");
            fService.createDirectory("test1:/", "test1folder");
            fService.createDirectory("test2:/", "test2folder");
            fService.createLayeredDirectory("test2:/test2folder", "test1:/test1folder", "test2");
            fService.createLayeredDirectory("test1:/test1folder", "test2:/test2folder", "test1");
            AVMServiceTest.fail();
        }
        catch (AVMCycleException e) {
        }
        finally {
            fService.purgeStore("test1");
            fService.purgeStore("test2");
        }
        try {
            fService.createStore("a");
            fService.createStore("b");
            fService.createStore("c");
            fService.createDirectory("a:/", "a");
            fService.createDirectory("b:/", "a");
            fService.createLayeredDirectory("a:/a/b", "b:/a", "b");
            fService.createDirectory("c:/", "a");
            fService.createLayeredDirectory("b:/a/b", "c:/a", "b");
            fService.createLayeredDirectory("c:/a/b", "a:/a", "b");
            AVMServiceTest.fail();
        }
        catch (AVMCycleException e) {
        }
        finally {
            fService.purgeStore("a");
            fService.purgeStore("b");
            fService.purgeStore("c");
        }
        try {
            fService.createStore("a");
            fService.createStore("b");
            fService.createDirectory("a:/", "a");
            fService.createDirectory("a:/a", "b");
            fService.createDirectory("b:/", "a");
            fService.createLayeredDirectory("a:/a", "b:/a", "b");
            fService.createLayeredDirectory("b:/a", "a:/a/b", "c");
            AVMServiceTest.fail();
        }
        catch (AVMCycleException aVMCycleException) {
        }
        finally {
            fService.purgeStore("a");
            fService.purgeStore("b");
        }
    }

    public void testGetPaths() throws Exception {
        try {
            this.setupBasicTree();
            fService.createBranch(-1, "main:/a", "main:/", "abranch");
            fService.createSnapshot("main", null, null);
            fService.createBranch(-1, "main:/a/b", "main:/", "bbranch");
            List<Pair<Integer, String>> paths = fService.getPaths(fService.lookup(-1, "main:/a/b/c/foo"));
            for (Pair<Integer, String> path : paths) {
                System.out.println(path.getFirst() + " " + (String)path.getSecond());
            }
            paths = fService.getHeadPaths(fService.lookup(-1, "main:/a/b/c/foo"));
            System.out.println("------------------------------");
            for (Pair<Integer, String> path : paths) {
                System.out.println(path.getFirst() + " " + (String)path.getSecond());
            }
            paths = fService.getPathsInStoreHead(fService.lookup(-1, "main:/a/b/c/foo"), "main");
            System.out.println("------------------------------");
            for (Pair<Integer, String> path : paths) {
                System.out.println(path.getFirst() + " " + (String)path.getSecond());
            }
            AVMServiceTest.assertNotNull(fService.getAPath(fService.lookup(-1, "main:/a/b/c/foo")));
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testGetIndirection() throws Exception {
        try {
            this.setupBasicTree();
            fService.createStore("layer");
            fService.createLayeredDirectory("main:/a", "layer:/", "layer");
            fService.createFile("layer:/layer/b", "figs").close();
            AVMServiceTest.assertEquals((String)"main:/a", (String)fService.getIndirectionPath(-1, "layer:/layer"));
            AVMServiceTest.assertEquals((String)"main:/a/b", (String)fService.getIndirectionPath(-1, "layer:/layer/b"));
            AVMServiceTest.assertEquals((String)"main:/a/b/c", (String)fService.getIndirectionPath(-1, "layer:/layer/b/c"));
            AVMServiceTest.assertEquals((String)"main:/a/b/c/foo", (String)fService.getIndirectionPath(-1, "layer:/layer/b/c/foo"));
            fService.createLayeredDirectory("main:/d", "layer:/layer/b", "dlayer");
            AVMServiceTest.assertEquals((String)"main:/d", (String)fService.getIndirectionPath(-1, "layer:/layer/b/dlayer"));
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
        finally {
            fService.purgeStore("layer");
        }
    }

    public void testRevertListAction() throws Exception {
        try {
            this.setupBasicTree();
            fService.createStore("area");
            fService.createLayeredDirectory("main:/a", "area:/", "a");
            fService.getFileOutputStream("area:/a/b/c/foo").close();
            List<AVMDifference> diffs = fSyncService.compare(-1, "area:/a", -1, "main:/a", null);
            AVMServiceTest.assertEquals((int)1, (int)diffs.size());
            AVMServiceTest.assertEquals((String)"[area:/a/b/c/foo[-1] > main:/a/b/c/foo[-1]]", (String)diffs.toString());
            fSyncService.update(diffs, null, false, false, false, false, null, null);
            fService.getFileOutputStream("area:/a/b/c/bar").close();
            diffs = fSyncService.compare(-1, "area:/a", -1, "main:/a", null);
            AVMServiceTest.assertEquals((int)1, (int)diffs.size());
            AVMServiceTest.assertEquals((String)"[area:/a/b/c/bar[-1] > main:/a/b/c/bar[-1]]", (String)diffs.toString());
            final ActionImpl action = new ActionImpl(null, GUID.generate(), "avm-revert-list");
            ArrayList<String> paths = new ArrayList<String>();
            paths.add("area:/a/b");
            action.setParameterValue("version", Integer.valueOf(fService.getLatestSnapshotID("area")));
            action.setParameterValue("node-list", paths);
            final AVMRevertListAction revert = (AVMRevertListAction)fContext.getBean("avm-revert-list");
            TransactionService transactionService = (TransactionService)fContext.getBean("transactionService");
            class TxnWork
            implements RetryingTransactionHelper.RetryingTransactionCallback<Object> {
                TxnWork() {
                }

                @Override
                public Object execute() throws Exception {
                    revert.execute(action, null);
                    return null;
                }
            }
            transactionService.getRetryingTransactionHelper().doInTransaction(new TxnWork());
            diffs = fSyncService.compare(-1, "area:/a", -1, "main:/a", null);
            AVMServiceTest.assertEquals((int)0, (int)diffs.size());
            System.out.println(this.recursiveList("area", -1, true));
            System.out.println(this.recursiveList("main", -1, true));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            fService.purgeStore("area");
        }
    }

    public void testRevertStoreAction() throws Exception {
        try {
            this.setupBasicTree();
            fService.createStore("area");
            fService.createLayeredDirectory("main:/a", "area:/", "a");
            fService.getFileOutputStream("area:/a/b/c/foo").close();
            List<AVMDifference> diffs = fSyncService.compare(-1, "area:/a", -1, "main:/a", null);
            AVMServiceTest.assertEquals((int)1, (int)diffs.size());
            AVMServiceTest.assertEquals((String)"[area:/a/b/c/foo[-1] > main:/a/b/c/foo[-1]]", (String)diffs.toString());
            fSyncService.update(diffs, null, false, false, false, false, null, null);
            diffs = fSyncService.compare(-1, "area:/a", -1, "main:/a", null);
            AVMServiceTest.assertEquals((int)0, (int)diffs.size());
            fService.getFileOutputStream("area:/a/b/c/bar").close();
            diffs = fSyncService.compare(-1, "area:/a", -1, "main:/a", null);
            AVMServiceTest.assertEquals((int)1, (int)diffs.size());
            AVMServiceTest.assertEquals((String)"[area:/a/b/c/bar[-1] > main:/a/b/c/bar[-1]]", (String)diffs.toString());
            final ActionImpl action = new ActionImpl(null, GUID.generate(), "avm-revert-store");
            action.setParameterValue("version", Integer.valueOf(fService.getLatestSnapshotID("area")));
            final AVMRevertStoreAction revert = (AVMRevertStoreAction)fContext.getBean("avm-revert-store");
            TransactionService transactionService = (TransactionService)fContext.getBean("transactionService");
            class TxnWork
            implements RetryingTransactionHelper.RetryingTransactionCallback<Object> {
                TxnWork() {
                }

                @Override
                public Object execute() throws Exception {
                    revert.execute(action, AVMNodeConverter.ToNodeRef(-1, "area:/"));
                    return null;
                }
            }
            transactionService.getRetryingTransactionHelper().doInTransaction(new TxnWork());
            diffs = fSyncService.compare(-1, "area:/a", -1, "main:/a", null);
            AVMServiceTest.assertEquals((int)0, (int)diffs.size());
            System.out.println(this.recursiveList("area", -1, true));
            System.out.println(this.recursiveList("main", -1, true));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            fService.purgeStore("area");
        }
    }

    public void testUndoListAction() throws Exception {
        try {
            this.setupBasicTree();
            fService.createStore("area");
            fService.createLayeredDirectory("main:/a", "area:/", "a");
            fService.getFileOutputStream("area:/a/b/c/foo").close();
            List<AVMDifference> diffs = fSyncService.compare(-1, "area:/a", -1, "main:/a", null);
            AVMServiceTest.assertEquals((int)1, (int)diffs.size());
            AVMServiceTest.assertEquals((String)"[area:/a/b/c/foo[-1] > main:/a/b/c/foo[-1]]", (String)diffs.toString());
            fSyncService.update(diffs, null, false, false, false, false, null, null);
            fService.getFileOutputStream("area:/a/b/c/bar").close();
            diffs = fSyncService.compare(-1, "area:/a", -1, "main:/a", null);
            AVMServiceTest.assertEquals((int)1, (int)diffs.size());
            AVMServiceTest.assertEquals((String)"[area:/a/b/c/bar[-1] > main:/a/b/c/bar[-1]]", (String)diffs.toString());
            final ActionImpl action = new ActionImpl(null, GUID.generate(), "avm-undo-list");
            ArrayList<Pair> versionPaths = new ArrayList<Pair>();
            versionPaths.add(new Pair((Object)-1, (Object)"area:/a/b/c/bar"));
            action.setParameterValue("node-list", versionPaths);
            final AVMUndoSandboxListAction revert = (AVMUndoSandboxListAction)fContext.getBean("avm-undo-list");
            TransactionService transactionService = (TransactionService)fContext.getBean("transactionService");
            class TxnWork
            implements RetryingTransactionHelper.RetryingTransactionCallback<Object> {
                TxnWork() {
                }

                @Override
                public Object execute() throws Exception {
                    revert.execute(action, null);
                    return null;
                }
            }
            transactionService.getRetryingTransactionHelper().doInTransaction(new TxnWork());
            diffs = fSyncService.compare(-1, "area:/a", -1, "main:/a", null);
            AVMServiceTest.assertEquals((int)0, (int)diffs.size());
            System.out.println(this.recursiveList("area", -1, true));
            System.out.println(this.recursiveList("main", -1, true));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            fService.purgeStore("area");
        }
    }

    public void testPromoteAction() throws Exception {
        try {
            this.setupBasicTree();
            fService.createDirectory("main:/", "www");
            fService.rename("main:/", "a", "main:/www", "a");
            fService.rename("main:/", "d", "main:/www", "d");
            fService.createSnapshot("main", null, null);
            fService.createStore("source");
            fService.createLayeredDirectory("main:/www", "source:/", "www");
            fService.getFileOutputStream("source:/www/a/b/c/foo").close();
            final ActionImpl action = new ActionImpl(AVMNodeConverter.ToNodeRef(-1, "source:/www/a"), GUID.generate(), "simple-avm-promote");
            action.setParameterValue("target-store", (Serializable)((Object)"main"));
            final SimpleAVMPromoteAction promote = (SimpleAVMPromoteAction)fContext.getBean("simple-avm-promote");
            TransactionService transactionService = (TransactionService)fContext.getBean("transactionService");
            class TxnWork
            implements RetryingTransactionHelper.RetryingTransactionCallback<Object> {
                TxnWork() {
                }

                @Override
                public Object execute() throws Exception {
                    promote.execute(action, AVMNodeConverter.ToNodeRef(-1, "source:/www/a"));
                    return null;
                }
            }
            transactionService.getRetryingTransactionHelper().doInTransaction(new TxnWork());
            AVMServiceTest.assertEquals((int)0, (int)fSyncService.compare(-1, "source:/www", -1, "main:/www", null).size());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
        finally {
            fService.purgeStore("source");
        }
    }

    public void testSubmitAction() throws Exception {
        String STAGING = "foo";
        String SANDBOX = "foo--sandbox";
        try {
            fService.createStore("foo");
            fService.createDirectory("foo:/", "www");
            fService.createDirectory("foo:/www", "a");
            fService.createDirectory("foo:/www/a", "b");
            fService.createDirectory("foo:/www/a/b", "c");
            fService.createFile("foo:/www/a/b/c", "foo").close();
            fService.createFile("foo:/www/a/b/c", "bar").close();
            fService.createStore("foo--sandbox");
            fService.setStoreProperty("foo--sandbox", SandboxConstants.PROP_WEBSITE_NAME, new PropertyValue(null, (Serializable)((Object)"foo")));
            fService.createLayeredDirectory("foo:/www", "foo--sandbox:/", "www");
            fService.createFile("foo--sandbox:/www", "figs").close();
            fService.getFileOutputStream("foo--sandbox:/www/a/b/c/foo").close();
            fService.removeNode("foo--sandbox:/www/a/b/c/bar");
            List<AVMDifference> diffs = fSyncService.compare(-1, "foo--sandbox:/www", -1, "foo:/www", null);
            AVMServiceTest.assertEquals((int)3, (int)diffs.size());
            AVMServiceTest.assertEquals((String)"[foo--sandbox:/www/a/b/c/bar[-1] > foo:/www/a/b/c/bar[-1], foo--sandbox:/www/a/b/c/foo[-1] > foo:/www/a/b/c/foo[-1], foo--sandbox:/www/figs[-1] > foo:/www/figs[-1]]", (String)diffs.toString());
            final SimpleAVMSubmitAction action = (SimpleAVMSubmitAction)fContext.getBean("simple-avm-submit");
            TransactionService transactionService = (TransactionService)fContext.getBean("transactionService");
            class TxnWork
            implements RetryingTransactionHelper.RetryingTransactionCallback<Object> {
                TxnWork() {
                }

                @Override
                public Object execute() throws Exception {
                    action.execute(null, AVMNodeConverter.ToNodeRef(-1, "foo--sandbox:/www"));
                    return null;
                }
            }
            transactionService.getRetryingTransactionHelper().doInTransaction(new TxnWork());
            diffs = fSyncService.compare(-1, "foo--sandbox:/www", -1, "foo:/www", null);
            AVMServiceTest.assertEquals((int)0, (int)diffs.size());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
        finally {
            fService.purgeStore("foo");
            fService.purgeStore("foo--sandbox");
        }
    }

    public void testOneArgRemove() throws Exception {
        try {
            this.setupBasicTree();
            fService.removeNode("main:/a/b/c/foo/");
            fService.removeNode("main:/d");
            fService.createSnapshot("main", null, null);
            StoreRef storeRef = AVMNodeConverter.ToStoreRef("main");
            SearchService searchService = fIndexerAndSearcher.getSearcher(storeRef, true);
            ResultSet results = searchService.query(storeRef, "lucene", "TEXT:\"I am main\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_NAME)) + ":\"foo\"");
            AVMServiceTest.assertEquals((int)0, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_NAME)) + ":foo");
            AVMServiceTest.assertEquals((int)0, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_CREATOR)) + ":admin");
            if (results.length() == 7) {
                for (ResultSetRow row : results) {
                    System.out.println(row.getNodeRef());
                }
            }
            AVMServiceTest.assertEquals((int)5, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_MODIFIER)) + ":admin");
            AVMServiceTest.assertEquals((int)5, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_OWNER)) + ":admin");
            AVMServiceTest.assertEquals((int)5, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_NODE_UUID)) + ":unknown");
            AVMServiceTest.assertEquals((int)5, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_STORE_PROTOCOL)) + ":avm");
            AVMServiceTest.assertEquals((int)5, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_STORE_IDENTIFIER)) + ":" + "main");
            AVMServiceTest.assertEquals((int)5, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/a\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/a/b\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/a/b/c\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/a/b/c/foo\"");
            AVMServiceTest.assertEquals((int)0, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/a/b/c/bar\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/d\"");
            AVMServiceTest.assertEquals((int)0, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/d/e\"");
            AVMServiceTest.assertEquals((int)0, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/d/e/f\"");
            AVMServiceTest.assertEquals((int)0, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"//.\"");
            AVMServiceTest.assertEquals((int)5, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"//*\"");
            AVMServiceTest.assertEquals((int)4, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/a//.\"");
            AVMServiceTest.assertEquals((int)4, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/a//*\"");
            AVMServiceTest.assertEquals((int)3, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/a/*\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"//c/*\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/*\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/*/*\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/*/*/*\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/*/*/*/*\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/*/*/*/*/*\"");
            AVMServiceTest.assertEquals((int)0, (int)results.length());
            results.close();
            try {
                fService.removeNode("main://");
                AVMServiceTest.fail();
            }
            catch (AVMException e) {}
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public void testVersionUpdate() throws Exception {
        String LOAD_DIR1 = this.getSourceFolder() + "/org/alfresco/repo/avm/actions";
        String LOAD_DIR2 = this.getSourceFolder() + "/org/alfresco/repo/avm/ibatis";
        String[] split1 = LOAD_DIR1.split("/");
        String DIR1 = split1[split1.length - 1];
        String[] split2 = LOAD_DIR2.split("/");
        String DIR2 = split2[split2.length - 1];
        try {
            BulkLoader loader = new BulkLoader();
            loader.setAvmService(fService);
            fService.createStore("source");
            fService.createStore("dest");
            loader.recursiveLoad(LOAD_DIR1, "source:/");
            int version1 = fService.createSnapshot("source", null, null).get("source");
            loader.recursiveLoad(LOAD_DIR2, "source:/");
            int version2 = fService.createSnapshot("source", null, null).get("source");
            List<AVMDifference> diffs = fSyncService.compare(version1, "source:/", -1, "dest:/", null);
            fService.createSnapshot("dest", null, null);
            AVMServiceTest.assertEquals((int)1, (int)diffs.size());
            AVMServiceTest.assertEquals((String)("[source:/" + DIR1 + "[1] > dest:/" + DIR1 + "[-1]]"), (String)diffs.toString());
            fSyncService.update(diffs, null, false, false, false, false, null, null);
            diffs = fSyncService.compare(version1, "source:/", -1, "dest:/", null);
            AVMServiceTest.assertEquals((int)0, (int)diffs.size());
            diffs = fSyncService.compare(version2, "source:/", -1, "dest:/", null);
            AVMServiceTest.assertEquals((int)1, (int)diffs.size());
            AVMServiceTest.assertEquals((String)("[source:/" + DIR2 + "[2] > dest:/" + DIR2 + "[-1]]"), (String)diffs.toString());
            fSyncService.update(diffs, null, false, false, false, false, null, null);
            fService.createSnapshot("dest", null, null);
            diffs = fSyncService.compare(version2, "source:/", -1, "dest:/", null);
            AVMServiceTest.assertEquals((int)0, (int)diffs.size());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
        finally {
            fService.purgeStore("source");
            fService.purgeStore("dest");
        }
    }

    public void testBranchSnapshot() throws Exception {
        try {
            this.setupBasicTree();
            fService.getFileOutputStream("main:/a/b/c/foo").close();
            fService.createBranch(-1, "main:/a", "main:/", "abranch");
            AVMServiceTest.assertEquals((long)fService.lookup(-1, "main:/a/b/c/foo").getId(), (long)fService.lookup(-1, "main:/abranch/b/c/foo").getId());
            fService.getFileOutputStream("main:/a/b/c/foo").close();
            AVMServiceTest.assertTrue((fService.lookup(-1, "main:/a/b/c/foo").getId() != fService.lookup(-1, "main:/abranch/b/c/foo").getId() ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testDescriptorIndirection() throws Exception {
        try {
            this.setupBasicTree();
            fService.createLayeredDirectory("main:/a", "main:/", "layer");
            fService.createFile("main:/layer/b/c", "bambino").close();
            AVMNodeDescriptor desc = fService.lookup(-1, "main:/layer");
            AVMServiceTest.assertEquals((String)"main:/a", (String)desc.getIndirection());
            SortedMap<String, AVMNodeDescriptor> list = fService.getDirectoryListing(-1, "main:/");
            AVMServiceTest.assertEquals((String)"main:/a", (String)((AVMNodeDescriptor)list.get("layer")).getIndirection());
            desc = fService.lookup(-1, "main:/layer/b");
            AVMServiceTest.assertEquals((String)"main:/a/b", (String)desc.getIndirection());
            list = fService.getDirectoryListing(-1, "main:/layer");
            AVMServiceTest.assertEquals((String)"main:/a/b", (String)((AVMNodeDescriptor)list.get("b")).getIndirection());
            list = fService.getDirectoryListingDirect(-1, "main:/layer");
            AVMServiceTest.assertEquals((String)"main:/a/b", (String)((AVMNodeDescriptor)list.get("b")).getIndirection());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testLink() throws Exception {
        try {
            this.setupBasicTree();
            fService.link("main:/a/b", "foo", fService.lookup(-1, "main:/a/b/c/foo"));
            AVMServiceTest.assertEquals((long)fService.lookup(-1, "main:/a/b/c/foo").getId(), (long)fService.lookup(-1, "main:/a/b/foo").getId());
            System.out.println(this.recursiveList("main", -1, true));
            try {
                fService.link("main:/a/b", "foo", fService.lookup(-1, "main:/a/b/c/bar"));
                AVMServiceTest.fail();
            }
            catch (AVMExistsException e) {
                // empty catch block
            }
            fService.removeNode("main:/a/b", "foo");
            fService.link("main:/a/b", "foo", fService.lookup(-1, "main:/a/b/c/foo"));
            AVMServiceTest.assertEquals((long)fService.lookup(-1, "main:/a/b/c/foo").getId(), (long)fService.lookup(-1, "main:/a/b/foo").getId());
            fService.removeNode("main:/a/b", "foo");
            System.out.println(this.recursiveList("main", -1, true));
            fService.createSnapshot("main", null, null);
            fService.createLayeredDirectory("main:/a", "main:/", "layer");
            fService.link("main:/layer/b", "bar", fService.lookup(-1, "main:/layer/b/c/bar"));
            AVMServiceTest.assertEquals((long)fService.lookup(-1, "main:/layer/b/c/bar").getId(), (long)fService.lookup(-1, "main:/layer/b/bar").getId());
            System.out.println(this.recursiveList("main", -1, true));
            fService.link("main:/layer/b", "foo", fService.lookup(-1, "main:/layer/b/c/foo"));
            AVMServiceTest.assertEquals((long)fService.lookup(-1, "main:/layer/b/c/foo").getId(), (long)fService.lookup(-1, "main:/layer/b/foo").getId());
            AVMServiceTest.assertTrue((boolean)fService.lookup(-1, "main:/a/b/foo", true).isDeleted());
            System.out.println(this.recursiveList("main", -1, true));
            try {
                fService.link("main:/layer/b", "bar", fService.lookup(-1, "main:/layer/b/c/bar"));
                AVMServiceTest.fail();
            }
            catch (AVMExistsException e) {
                // empty catch block
            }
            try {
                fService.link("main:/", "frinx", fService.lookup(-1, "main:/layer/b"));
                AVMServiceTest.fail();
            }
            catch (AVMBadArgumentException ba) {
                // empty catch block
            }
            fService.removeNode("main:/layer/b", "bar");
            fService.link("main:/layer/b", "bar", fService.lookup(-1, "main:/layer/b/c/bar"));
            AVMServiceTest.assertEquals((long)fService.lookup(-1, "main:/layer/b/c/bar").getId(), (long)fService.lookup(-1, "main:/layer/b/bar").getId());
            System.out.println(this.recursiveList("main", -1, true));
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testGoofyPaths() throws Exception {
        try {
            this.setupBasicTree();
            fService.getFileInputStream(-1, "main://a/b/c/foo").close();
            fService.getDirectoryListing(-1, "main:/a/");
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testGetDeleted() throws Exception {
        try {
            this.setupBasicTree();
            fService.createLayeredDirectory("main:/a", "main:/", "layer");
            fService.createSnapshot("main", null, null);
            List<String> deleted = fService.getDeleted(-1, "main:/layer/b/c");
            AVMServiceTest.assertEquals((int)0, (int)deleted.size());
            fService.removeNode("main:/a/b/c", "foo");
            fService.createSnapshot("main", null, null);
            deleted = fService.getDeleted(-1, "main:/a/b/c");
            AVMServiceTest.assertEquals((int)0, (int)deleted.size());
            fService.removeNode("main:/layer/b/c", "bar");
            fService.createSnapshot("main", null, null);
            deleted = fService.getDeleted(-1, "main:/layer/b/c");
            AVMServiceTest.assertEquals((int)1, (int)deleted.size());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testListingDirect() throws Exception {
        try {
            this.setupBasicTree();
            fService.createLayeredDirectory("main:/a", "main:/", "layer");
            fService.createSnapshot("main", null, null);
            SortedMap<String, AVMNodeDescriptor> listing = fService.getDirectoryListingDirect(-1, "main:/layer");
            AVMServiceTest.assertEquals((int)0, (int)listing.size());
            listing = fService.getDirectoryListingDirect(-1, "main:/layer/b");
            AVMServiceTest.assertEquals((int)0, (int)listing.size());
            fService.createFile("main:/layer/b/c", "sigmoid").close();
            fService.createSnapshot("main", null, null);
            listing = fService.getDirectoryListingDirect(-1, "main:/layer");
            AVMServiceTest.assertEquals((int)1, (int)listing.size());
            fService.createFile("main:/layer", "lepton").close();
            fService.createSnapshot("main", null, null);
            listing = fService.getDirectoryListingDirect(-1, "main:/layer");
            AVMServiceTest.assertEquals((int)2, (int)listing.size());
            listing = fService.getDirectoryListingDirect(-1, "main:/layer/b/c");
            AVMServiceTest.assertEquals((int)1, (int)listing.size());
            listing = fService.getDirectoryListingDirect(-1, "main:/a/b/c");
            AVMServiceTest.assertEquals((int)2, (int)listing.size());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testLayeringInfo() throws Exception {
        try {
            this.setupBasicTree();
            fService.createStore("layer");
            fService.createLayeredDirectory("main:/a", "layer:/", "alayer");
            fService.createSnapshot("layer", null, null);
            LayeringDescriptor info = fService.getLayeringInfo(-1, "layer:/alayer");
            AVMServiceTest.assertFalse((boolean)info.isBackground());
            AVMServiceTest.assertEquals((String)"layer", (String)info.getPathAVMStore().getName());
            AVMServiceTest.assertEquals((String)"layer", (String)info.getNativeAVMStore().getName());
            info = fService.getLayeringInfo(-1, "layer:/alayer/b/c");
            AVMServiceTest.assertTrue((boolean)info.isBackground());
            AVMServiceTest.assertEquals((String)"layer", (String)info.getPathAVMStore().getName());
            AVMServiceTest.assertEquals((String)"main", (String)info.getNativeAVMStore().getName());
            fService.createFile("layer:/alayer/b", "figs").close();
            fService.createSnapshot("layer", null, null);
            info = fService.getLayeringInfo(-1, "layer:/alayer/b/figs");
            AVMServiceTest.assertFalse((boolean)info.isBackground());
            AVMServiceTest.assertEquals((String)"layer", (String)info.getPathAVMStore().getName());
            AVMServiceTest.assertEquals((String)"layer", (String)info.getNativeAVMStore().getName());
            info = fService.getLayeringInfo(-1, "layer:/alayer/b/c");
            AVMServiceTest.assertTrue((boolean)info.isBackground());
            AVMServiceTest.assertEquals((String)"layer", (String)info.getPathAVMStore().getName());
            AVMServiceTest.assertEquals((String)"main", (String)info.getNativeAVMStore().getName());
            fService.createLayeredDirectory("layer:/alayer/b", "layer:/", "blayer");
            fService.createSnapshot("layer", null, null);
            System.err.println(this.recursiveList("main", -1, true));
            System.err.println(this.recursiveList("layer", -1, true));
            info = fService.getLayeringInfo(-1, "layer:/blayer/c");
            AVMServiceTest.assertEquals((String)"main", (String)info.getNativeAVMStore().getName());
            info = fService.getLayeringInfo(-1, "layer:/blayer/figs");
            AVMServiceTest.assertEquals((String)"layer", (String)info.getNativeAVMStore().getName());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
        finally {
            fService.purgeStore("layer");
        }
    }

    public void testRenameLayer2() throws Exception {
        try {
            TreeMap<Integer, String> history = new TreeMap<Integer, String>();
            fService.createDirectory("main:/", "a");
            fService.createDirectory("main:/a", "b");
            fService.createDirectory("main:/a", "c");
            fService.createFile("main:/a/b", "foo", new ByteArrayInputStream("I am foo.".getBytes()));
            fService.createFile("main:/a/c", "bar", new ByteArrayInputStream("I am bar.".getBytes()));
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            fService.createLayeredDirectory("main:/a", "main:/", "layer");
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            AVMServiceTest.assertEquals((String)this.recursiveContents("main:/a", -1, true), (String)this.recursiveContents("main:/layer", -1, true));
            fService.rename("main:/layer/c", "bar", "main:/layer/b", "bar");
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            SortedMap<String, AVMNodeDescriptor> listing = fService.getDirectoryListing(-1, "main:/layer/c");
            AVMServiceTest.assertEquals((int)0, (int)listing.size());
            listing = fService.getDirectoryListing(-1, "main:/layer/b");
            AVMServiceTest.assertEquals((int)2, (int)listing.size());
            ArrayList list = new ArrayList(listing.keySet());
            AVMServiceTest.assertEquals((String)"bar", (String)((String)list.get(0)));
            AVMServiceTest.assertEquals((String)"foo", (String)((String)list.get(1)));
            listing = fService.getDirectoryListing(-1, "main:/a/b");
            AVMServiceTest.assertEquals((int)1, (int)listing.size());
            list = new ArrayList(listing.keySet());
            AVMServiceTest.assertEquals((String)"foo", (String)((String)list.get(0)));
            listing = fService.getDirectoryListing(-1, "main:/a/c");
            AVMServiceTest.assertEquals((int)1, (int)listing.size());
            list = new ArrayList(listing.keySet());
            AVMServiceTest.assertEquals((String)"bar", (String)((String)list.get(0)));
            fService.createFile("main:/a/b", "baz").close();
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            listing = fService.getDirectoryListing(-1, "main:/a/b");
            AVMServiceTest.assertEquals((int)2, (int)listing.size());
            list = new ArrayList(listing.keySet());
            AVMServiceTest.assertEquals((String)"baz", (String)((String)list.get(0)));
            AVMServiceTest.assertEquals((String)"foo", (String)((String)list.get(1)));
            listing = fService.getDirectoryListing(-1, "main:/layer/b");
            System.out.println(this.recursiveList("main", -1, true));
            AVMServiceTest.assertEquals((int)3, (int)listing.size());
            list = new ArrayList(listing.keySet());
            AVMServiceTest.assertEquals((String)"bar", (String)((String)list.get(0)));
            AVMServiceTest.assertEquals((String)"baz", (String)((String)list.get(1)));
            AVMServiceTest.assertEquals((String)"foo", (String)((String)list.get(2)));
            fService.removeNode("main:/layer/b", "baz");
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            System.out.println(this.recursiveList("main", -1, true));
            listing = fService.getDirectoryListing(-1, "main:/layer/b");
            AVMServiceTest.assertEquals((int)2, (int)listing.size());
            list = new ArrayList(listing.keySet());
            AVMServiceTest.assertEquals((String)"bar", (String)((String)list.get(0)));
            AVMServiceTest.assertEquals((String)"foo", (String)((String)list.get(1)));
            listing = fService.getDirectoryListing(-1, "main:/a/b");
            AVMServiceTest.assertEquals((int)2, (int)listing.size());
            list = new ArrayList(listing.keySet());
            AVMServiceTest.assertEquals((String)"baz", (String)((String)list.get(0)));
            AVMServiceTest.assertEquals((String)"foo", (String)((String)list.get(1)));
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testRenameLayer3() throws Exception {
        try {
            TreeMap<Integer, String> history = new TreeMap<Integer, String>();
            fService.createDirectory("main:/", "a");
            fService.createDirectory("main:/a", "b");
            fService.createFile("main:/a/b", "foo").close();
            fService.createFile("main:/a/b", "bar").close();
            fService.createDirectory("main:/", "c");
            fService.createDirectory("main:/c", "d");
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            fService.createLayeredDirectory("main:/a", "main:/", "layer");
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            fService.rename("main:/c", "d", "main:/layer", "d");
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            fService.createFile("main:/layer/d", "baz").close();
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            fService.createDirectory("main:/a", "d");
            fService.createFile("main:/a/d", "figs").close();
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            SortedMap<String, AVMNodeDescriptor> listing = fService.getDirectoryListing(-1, "main:/layer/d");
            AVMServiceTest.assertEquals((int)2, (int)listing.size());
            ArrayList list = new ArrayList(listing.keySet());
            AVMServiceTest.assertEquals((String)"baz", (String)((String)list.get(0)));
            AVMServiceTest.assertEquals((String)"figs", (String)((String)list.get(1)));
            for (String val : history.values()) {
                System.out.println(val);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testUncover() throws Exception {
        try {
            TreeMap<Integer, String> history = new TreeMap<Integer, String>();
            fService.createDirectory("main:/", "a");
            fService.createDirectory("main:/a/", "b");
            fService.createFile("main:/a/b", "foo").close();
            fService.createFile("main:/a/b", "bar").close();
            fService.createDirectory("main:/", "c");
            fService.createDirectory("main:/c", "d");
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            fService.createLayeredDirectory("main:/a", "main:/", "layer");
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            fService.rename("main:/c", "d", "main:/layer", "d");
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            fService.createFile("main:/layer/d", "baz").close();
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            fService.createDirectory("main:/a", "d");
            fService.createFile("main:/a/d", "figs").close();
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            SortedMap<String, AVMNodeDescriptor> listing = fService.getDirectoryListing(-1, "main:/layer/d");
            AVMServiceTest.assertEquals((int)2, (int)listing.size());
            ArrayList list = new ArrayList(listing.keySet());
            AVMServiceTest.assertEquals((String)"baz", (String)((String)list.get(0)));
            AVMServiceTest.assertEquals((String)"figs", (String)((String)list.get(1)));
            System.out.println(this.recursiveContents("main:/", -1, true));
            fService.rename("main:/layer", "d", "main:/layer", "e");
            fService.uncover("main:/layer", "d");
            fService.createSnapshot("main", null, null);
            System.out.println(this.recursiveContents("main:/", -1, true));
            this.checkHistory(history, "main");
            listing = fService.getDirectoryListing(-1, "main:/layer/d");
            AVMServiceTest.assertEquals((int)1, (int)listing.size());
            list = new ArrayList(listing.keySet());
            AVMServiceTest.assertEquals((String)"figs", (String)((String)list.get(0)));
            listing = fService.getDirectoryListing(-1, "main:/layer/e");
            AVMServiceTest.assertEquals((int)2, (int)listing.size());
            list = new ArrayList(listing.keySet());
            AVMServiceTest.assertEquals((String)"baz", (String)((String)list.get(0)));
            AVMServiceTest.assertEquals((String)"figs", (String)((String)list.get(1)));
            for (String val : history.values()) {
                System.out.println(val);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testRenameLayer4() throws Exception {
        try {
            TreeMap<Integer, String> history = new TreeMap<Integer, String>();
            fService.createDirectory("main:/", "a");
            fService.createDirectory("main:/a", "b");
            fService.createFile("main:/a/b", "foo").close();
            fService.createFile("main:/a/b", "bar").close();
            fService.createDirectory("main:/", "c");
            fService.createDirectory("main:/c", "d");
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            fService.createLayeredDirectory("main:/a", "main:/", "layer");
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            fService.rename("main:/layer", "b", "main:/", "b");
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            fService.createFile("main:/a/b", "baz").close();
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            SortedMap<String, AVMNodeDescriptor> listing = fService.getDirectoryListing(-1, "main:/b");
            AVMServiceTest.assertEquals((int)3, (int)listing.size());
            ArrayList list = new ArrayList(listing.keySet());
            AVMServiceTest.assertEquals((String)"bar", (String)((String)list.get(0)));
            AVMServiceTest.assertEquals((String)"baz", (String)((String)list.get(1)));
            AVMServiceTest.assertEquals((String)"foo", (String)((String)list.get(2)));
            fService.createFile("main:/a", "figs").close();
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            listing = fService.getDirectoryListing(-1, "main:/layer");
            AVMServiceTest.assertEquals((int)1, (int)listing.size());
            list = new ArrayList(listing.keySet());
            AVMServiceTest.assertEquals((String)"figs", (String)((String)list.get(0)));
            for (String val : history.values()) {
                System.out.println(val);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testBranchesInBranches() throws Exception {
        try {
            TreeMap<Integer, String> history = new TreeMap<Integer, String>();
            this.setupBasicTree();
            this.checkHistory(history, "main");
            fService.createBranch(-1, "main:/a", "main:/", "abranch");
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            fService.createBranch(-1, "main:/a/b", "main:/a", "bbranch");
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            int version = fService.getNextVersionID("main");
            AVMServiceTest.assertEquals((String)this.recursiveContents("main:/abranch", version - 1, true), (String)this.recursiveContents("main:/abranch", version - 2, true));
            fService.createBranch(-1, "main:/abranch/b/c", "main:/abranch/b", "cbranch");
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            version = fService.getNextVersionID("main");
            AVMServiceTest.assertEquals((String)this.recursiveContents("main:/a", version - 1, true), (String)this.recursiveContents("main:/a", version - 2, true));
            fService.createBranch(-1, "main:/d", "main:/abranch", "dbranch");
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            fService.createFile("main:/abranch/dbranch/e/f", "baz").close();
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            version = fService.getNextVersionID("main");
            AVMServiceTest.assertEquals((String)this.recursiveContents("main:/d", version - 1, true), (String)this.recursiveContents("main:/d", version - 2, true));
            for (String val : history.values()) {
                System.out.println(val);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testLayersInLayers() throws Exception {
        try {
            TreeMap<Integer, String> history = new TreeMap<Integer, String>();
            this.setupBasicTree();
            this.checkHistory(history, "main");
            fService.createLayeredDirectory("main:/a", "main:/", "layer");
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            fService.createLayeredDirectory("main:/d", "main:/layer", "under");
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            fService.createFile("main:/layer/under/e/f", "baz").close();
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            fService.createFile("main:/d/e", "bow").close();
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            SortedMap<String, AVMNodeDescriptor> listing = fService.getDirectoryListing(-1, "main:/layer/under/e");
            AVMServiceTest.assertEquals((int)2, (int)listing.size());
            ArrayList list = new ArrayList(listing.keySet());
            AVMServiceTest.assertEquals((String)"bow", (String)((String)list.get(0)));
            AVMServiceTest.assertEquals((String)"f", (String)((String)list.get(1)));
            fService.createDirectory("main:/", "g");
            fService.createDirectory("main:/g", "h");
            fService.createDirectory("main:/g/h", "i");
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            fService.createLayeredDirectory("main:/g", "main:/d", "gover");
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            AVMServiceTest.assertEquals((String)this.recursiveContents("main:/d/gover", -1, true), (String)this.recursiveContents("main:/layer/under/gover", -1, true));
            fService.createFile("main:/layer/under/gover/h/i", "moo").close();
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            int version = fService.getNextVersionID("main");
            fService.createFile("main:/d/gover/h/i", "cow").close();
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            version = fService.getNextVersionID("main");
            AVMServiceTest.assertEquals((String)this.recursiveContents("main:/g", version - 1, true), (String)this.recursiveContents("main:/g", version - 2, true));
            listing = fService.getDirectoryListing(-1, "main:/layer/under/gover/h/i");
            AVMServiceTest.assertEquals((int)2, (int)listing.size());
            list = new ArrayList(listing.keySet());
            AVMServiceTest.assertEquals((String)"cow", (String)((String)list.get(0)));
            AVMServiceTest.assertEquals((String)"moo", (String)((String)list.get(1)));
            fService.rename("main:/layer/under", "gover", "main:/layer/b", "gover");
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            listing = fService.getDirectoryListing(-1, "main:/layer/b/gover/h/i");
            AVMServiceTest.assertEquals((int)1, (int)listing.size());
            list = new ArrayList(listing.keySet());
            AVMServiceTest.assertEquals((String)"moo", (String)((String)list.get(0)));
            fService.createFile("main:/layer/b/gover/h/i", "oink").close();
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            listing = fService.getDirectoryListing(-1, "main:/layer/b/gover/h/i");
            AVMServiceTest.assertEquals((int)2, (int)listing.size());
            list = new ArrayList(listing.keySet());
            AVMServiceTest.assertEquals((String)"moo", (String)((String)list.get(0)));
            AVMServiceTest.assertEquals((String)"oink", (String)((String)list.get(1)));
            for (String val : history.values()) {
                System.out.println(val);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testLayerAndBranch() throws Exception {
        try {
            TreeMap<Integer, String> history = new TreeMap<Integer, String>();
            fService.createDirectory("main:/", "a");
            fService.createDirectory("main:/a", "b");
            fService.createDirectory("main:/a/b", "c");
            fService.createFile("main:/a/b/c", "foo").close();
            fService.createFile("main:/a/b/c", "bar").close();
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            fService.createLayeredDirectory("main:/a", "main:/", "layer");
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            AVMServiceTest.assertEquals((String)this.recursiveContents("main:/a", -1, true), (String)this.recursiveContents("main:/layer", -1, true));
            fService.createFile("main:/layer/b", "baz").close();
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            fService.createBranch(-1, "main:/layer", "main:/", "branch");
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            AVMServiceTest.assertEquals((String)this.recursiveContents("main:/layer/b", -1, true), (String)this.recursiveContents("main:/branch/b", -1, true));
            fService.createFile("main:/branch/b/c", "baz").close();
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            int version = fService.getNextVersionID("main");
            AVMServiceTest.assertEquals((String)this.recursiveContents("main:/layer", version - 1, true), (String)this.recursiveContents("main:/layer", version - 2, true));
            fService.createFile("main:/layer/b/c", "fig").close();
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            version = fService.getNextVersionID("main");
            AVMServiceTest.assertEquals((String)this.recursiveContents("main:/branch", version - 1, true), (String)this.recursiveContents("main:/branch", version - 2, true));
            fService.createLayeredDirectory("main:/a", "main:/", "layer2");
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            fService.createBranch(-1, "main:/layer2/b", "main:/", "branch2");
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            fService.createFile("main:/branch2", "goofy").close();
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            version = fService.getNextVersionID("main");
            AVMServiceTest.assertEquals((String)this.recursiveContents("main:/layer2", version - 1, true), (String)this.recursiveContents("main:/layer2", version - 2, true));
            fService.removeNode("main:/layer2/b/c", "foo");
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            version = fService.getNextVersionID("main");
            AVMServiceTest.assertEquals((String)this.recursiveContents("main:/branch2", version - 1, true), (String)this.recursiveContents("main:/branch2", version - 2, true));
            AVMServiceTest.assertEquals((String)this.recursiveContents("main:/a", version - 1, true), (String)this.recursiveContents("main:/a", version - 2, true));
            for (String val : history.values()) {
                System.out.println(val);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testRenameLayerToLayer() throws Exception {
        try {
            TreeMap<Integer, String> history = new TreeMap<Integer, String>();
            fService.createDirectory("main:/", "a");
            fService.createDirectory("main:/a", "b");
            fService.createDirectory("main:/a/b", "c");
            fService.createFile("main:/a/b/c", "foo").close();
            fService.createFile("main:/a/b/c", "bar").close();
            fService.createDirectory("main:/", "d");
            fService.createDirectory("main:/d", "e");
            fService.createDirectory("main:/d/e", "f");
            fService.createFile("main:/d/e/f", "moo").close();
            fService.createFile("main:/d/e/f", "cow").close();
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            fService.createLayeredDirectory("main:/a", "main:/", "la");
            fService.createLayeredDirectory("main:/d", "main:/", "ld");
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            fService.rename("main:/la/b", "c", "main:/ld/e", "c");
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            fService.createFile("main:/ld/e/c", "baz").close();
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            AVMServiceTest.assertEquals((String)"main:/a/b/c", (String)fService.lookup(-1, "main:/ld/e/c").getIndirection());
            for (String val : history.values()) {
                System.out.println(val);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testNothing() throws Exception {
    }

    public void testCreateDirectory() throws Exception {
        try {
            fService.createDirectory("main:/", "testdir");
            fService.createSnapshot("main", null, null);
            AVMServiceTest.assertEquals((int)2, (int)fService.lookup(-1, "main:/").getType());
            StoreRef storeRef = AVMNodeConverter.ToStoreRef("main");
            SearchService searchService = fIndexerAndSearcher.getSearcher(storeRef, true);
            ResultSet results = searchService.query(storeRef, "lucene", "@cm\\:name:testdir");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"//.\"");
            AVMServiceTest.assertEquals((int)2, (int)results.length());
            results.close();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testCreateFile() throws Exception {
        try {
            this.testCreateDirectory();
            fService.createFile("main:/testdir", "testfile").close();
            fService.createFile("main:/", "testfile2").close();
            fService.createSnapshot("main", null, null);
            StoreRef storeRef = AVMNodeConverter.ToStoreRef("main");
            SearchService searchService = fIndexerAndSearcher.getSearcher(storeRef, true);
            ResultSet results = searchService.query(storeRef, "lucene", "@cm\\:name:testfile");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "@cm\\:name:testfile2");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "TEXT:\"This is testdir/testfile\"");
            AVMServiceTest.assertEquals((int)0, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "TEXT:\"This is testfile2\"");
            AVMServiceTest.assertEquals((int)0, (int)results.length());
            results.close();
            ContentWriter writer = fService.getContentWriter("main:/testdir/testfile", true);
            writer.setEncoding("UTF-8");
            writer.setMimetype("text/plain");
            PrintStream out = new PrintStream(writer.getContentOutputStream());
            out.println("This is testdir/testfile");
            out.close();
            out = new PrintStream(fService.getFileOutputStream("main:/testfile2"));
            writer = fService.getContentWriter("main:/testfile2", true);
            writer.setEncoding("UTF-8");
            writer.setMimetype("text/plain");
            out = new PrintStream(writer.getContentOutputStream());
            out.println("This is testfile2");
            out.close();
            fService.createSnapshot("main", null, null);
            results = searchService.query(storeRef, "lucene", "TEXT:\"This is testdir/testfile\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "TEXT:\"This is testfile2\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            List<VersionDescriptor> versions = fService.getStoreVersions("main");
            for (VersionDescriptor version : versions) {
                System.out.println("V:" + version.getVersionID());
                System.out.println(this.recursiveList("main", version.getVersionID(), true));
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "main:/testdir/testfile")));
            String line = reader.readLine();
            AVMServiceTest.assertEquals((String)"This is testdir/testfile", (String)line);
            reader.close();
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "main:/testfile2")));
            line = reader.readLine();
            AVMServiceTest.assertEquals((String)"This is testfile2", (String)line);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testCreateBranch() throws Exception {
        try {
            this.setupBasicTree();
            fService.createBranch(-1, "main:/a", "main:/d/e", "abranch");
            fService.createSnapshot("main", null, null);
            List<VersionDescriptor> versions = fService.getStoreVersions("main");
            for (VersionDescriptor version : versions) {
                System.out.println("V:" + version.getVersionID());
                System.out.println(this.recursiveList("main", version.getVersionID(), true));
            }
            String original = this.recursiveList("main:/a", -1, 0, true);
            original = original.substring(original.indexOf(10));
            String branch = this.recursiveList("main:/d/e/abranch", -1, 0, true);
            branch = branch.substring(branch.indexOf(10));
            AVMServiceTest.assertEquals((String)original, (String)branch);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testCreateLayer() throws Exception {
        try {
            this.setupBasicTree();
            fService.createLayeredDirectory("main:/a", "main:/d/e", "alayer");
            fService.createSnapshot("main", null, null);
            System.out.println(this.recursiveList("main", -1, true));
            AVMServiceTest.assertEquals((String)"main:/a", (String)fService.getIndirectionPath(-1, "main:/d/e/alayer"));
            AVMServiceTest.assertEquals((String)this.recursiveContents("main:/a", -1, true), (String)this.recursiveContents("main:/d/e/alayer", -1, true));
            PrintStream out = new PrintStream(fService.getFileOutputStream("main:/d/e/alayer/b/c/foo"));
            out.println("I am main:/d/e/alayer/b/c/foo");
            out.close();
            fService.createSnapshot("main", null, null);
            BufferedReader reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "main:/a/b/c/foo")));
            String line = reader.readLine();
            reader.close();
            AVMServiceTest.assertEquals((String)"I am main:/a/b/c/foo", (String)line);
            System.out.println(this.recursiveList("main", -1, true));
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testLayeredFile1() throws Exception {
        try {
            this.setupBasicTree();
            fService.createLayeredFile("main:/a/b/c/foo", "main:/d", "lfoo");
            AVMServiceTest.assertTrue((boolean)fService.lookup(-1, "main:/d/lfoo").isLayeredFile());
            fService.createSnapshot("main", null, null);
            System.out.println(this.recursiveList("main", -1, true));
            AVMServiceTest.assertEquals((String)"main:/a/b/c/foo", (String)fService.lookup(-1, "main:/d/lfoo").getIndirection());
            AVMServiceTest.assertTrue((boolean)fService.lookup(-1, "main:/d/lfoo").isLayeredFile());
            BufferedReader reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "main:/d/lfoo")));
            String line = reader.readLine();
            reader.close();
            AVMServiceTest.assertEquals((String)"I am main:/a/b/c/foo", (String)line);
            PrintStream out = new PrintStream(fService.getFileOutputStream("main:/d/lfoo"));
            out.println("I am main:/d/lfoo");
            out.close();
            AVMServiceTest.assertFalse((boolean)fService.lookup(-1, "main:/d/lfoo").isLayeredFile());
            fService.createSnapshot("main", null, null);
            System.out.println(this.recursiveList("main", -1, true));
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "main:/a/b/c/foo")));
            line = reader.readLine();
            reader.close();
            AVMServiceTest.assertEquals((String)"I am main:/a/b/c/foo", (String)line);
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "main:/d/lfoo")));
            line = reader.readLine();
            reader.close();
            AVMServiceTest.assertEquals((String)"I am main:/d/lfoo", (String)line);
            AVMServiceTest.assertFalse((boolean)fService.lookup(-1, "main:/d/lfoo").isLayeredFile());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testLayeredFile2() throws Exception {
        try {
            AVMNodeDescriptor desc = fService.lookup(-1, "main:/foo");
            AVMServiceTest.assertNull((Object)desc);
            try {
                fService.getFileOutputStream("main:/foo");
                AVMServiceTest.fail((String)"Unexpected");
            }
            catch (AVMNotFoundException nfe) {
                // empty catch block
            }
            try {
                fService.getFileInputStream(-1, "main:/foo");
                AVMServiceTest.fail((String)"Unexpected");
            }
            catch (AVMNotFoundException nfe) {
                // empty catch block
            }
            fService.createFile("main:/", "foo").close();
            AVMServiceTest.assertEquals((int)1, (int)fService.lookup(-1, "main:/foo").getVersionID());
            BufferedReader reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "main:/foo")));
            String line = reader.readLine();
            reader.close();
            AVMServiceTest.assertNull((Object)line);
            PrintStream out = new PrintStream(fService.getFileOutputStream("main:/foo"));
            out.println("I am main:/foo V1a");
            out.close();
            out = new PrintStream(fService.getFileOutputStream("main:/foo"));
            out.println("I am main:/foo V1b");
            out.close();
            out = new PrintStream(fService.getFileOutputStream("main:/foo"));
            out.println("I am main:/foo V1c");
            out.close();
            AVMServiceTest.assertEquals((int)1, (int)fService.lookup(-1, "main:/foo").getVersionID());
            fService.createSnapshot("main", null, null);
            AVMServiceTest.assertEquals((int)1, (int)fService.lookup(-1, "main:/foo").getVersionID());
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "main:/foo")));
            line = reader.readLine();
            reader.close();
            AVMServiceTest.assertEquals((String)"I am main:/foo V1c", (String)line);
            out = new PrintStream(fService.getFileOutputStream("main:/foo"));
            out.println("I am main:/foo V2a");
            out.close();
            AVMServiceTest.assertEquals((int)2, (int)fService.lookup(-1, "main:/foo").getVersionID());
            out = new PrintStream(fService.getFileOutputStream("main:/foo"));
            out.println("I am main:/foo V2b");
            out.close();
            AVMServiceTest.assertEquals((int)2, (int)fService.lookup(-1, "main:/foo").getVersionID());
            fService.createSnapshot("main", null, null);
            AVMServiceTest.assertEquals((int)2, (int)fService.lookup(-1, "main:/foo").getVersionID());
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "main:/foo")));
            line = reader.readLine();
            reader.close();
            AVMServiceTest.assertEquals((String)"I am main:/foo V2b", (String)line);
            out = new PrintStream(fService.getFileOutputStream("main:/foo"));
            out.println("I am main:/foo V3");
            out.close();
            AVMServiceTest.assertEquals((int)3, (int)fService.lookup(-1, "main:/foo").getVersionID());
            fService.createSnapshot("main", null, null);
            AVMServiceTest.assertEquals((int)3, (int)fService.lookup(-1, "main:/foo").getVersionID());
            try {
                fService.createLayeredFile("main:/foo", "main:/", "foo");
                AVMServiceTest.fail((String)"Unexpected");
            }
            catch (AVMExistsException ee) {
                // empty catch block
            }
            fService.createLayeredFile("main:/foo", "main:/", "lfoo");
            AVMServiceTest.assertEquals((int)3, (int)fService.lookup(-1, "main:/foo").getVersionID());
            AVMServiceTest.assertEquals((int)1, (int)fService.lookup(-1, "main:/lfoo").getVersionID());
            AVMServiceTest.assertTrue((boolean)fService.lookup(-1, "main:/lfoo").isLayeredFile());
            AVMServiceTest.assertEquals((String)"main:/foo", (String)fService.lookup(-1, "main:/lfoo").getIndirection());
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "main:/foo")));
            line = reader.readLine();
            reader.close();
            AVMServiceTest.assertEquals((String)"I am main:/foo V3", (String)line);
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "main:/lfoo")));
            line = reader.readLine();
            reader.close();
            AVMServiceTest.assertEquals((String)"I am main:/foo V3", (String)line);
            fService.createSnapshot("main", null, null);
            AVMServiceTest.assertEquals((int)3, (int)fService.lookup(-1, "main:/foo").getVersionID());
            AVMServiceTest.assertEquals((int)1, (int)fService.lookup(-1, "main:/lfoo").getVersionID());
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "main:/foo")));
            line = reader.readLine();
            reader.close();
            AVMServiceTest.assertEquals((String)"I am main:/foo V3", (String)line);
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "main:/lfoo")));
            line = reader.readLine();
            reader.close();
            AVMServiceTest.assertEquals((String)"I am main:/foo V3", (String)line);
            out = new PrintStream(fService.getFileOutputStream("main:/foo"));
            out.println("I am main:/foo V4");
            out.close();
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "main:/foo")));
            line = reader.readLine();
            reader.close();
            AVMServiceTest.assertEquals((String)"I am main:/foo V4", (String)line);
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "main:/lfoo")));
            line = reader.readLine();
            reader.close();
            AVMServiceTest.assertEquals((String)"I am main:/foo V4", (String)line);
            AVMServiceTest.assertEquals((int)4, (int)fService.lookup(-1, "main:/foo").getVersionID());
            AVMServiceTest.assertEquals((int)1, (int)fService.lookup(-1, "main:/lfoo").getVersionID());
            fService.createSnapshot("main", null, null);
            AVMServiceTest.assertEquals((int)4, (int)fService.lookup(-1, "main:/foo").getVersionID());
            AVMServiceTest.assertEquals((int)2, (int)fService.lookup(-1, "main:/lfoo").getVersionID());
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "main:/foo")));
            line = reader.readLine();
            reader.close();
            AVMServiceTest.assertEquals((String)"I am main:/foo V4", (String)line);
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "main:/lfoo")));
            line = reader.readLine();
            reader.close();
            AVMServiceTest.assertEquals((String)"I am main:/foo V4", (String)line);
            out = new PrintStream(fService.getFileOutputStream("main:/foo"));
            out.println("I am main:/foo V5a");
            out.close();
            out = new PrintStream(fService.getFileOutputStream("main:/foo"));
            out.println("I am main:/foo V5b");
            out.close();
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "main:/foo")));
            line = reader.readLine();
            reader.close();
            AVMServiceTest.assertEquals((String)"I am main:/foo V5b", (String)line);
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "main:/lfoo")));
            line = reader.readLine();
            reader.close();
            AVMServiceTest.assertEquals((String)"I am main:/foo V5b", (String)line);
            AVMServiceTest.assertEquals((int)5, (int)fService.lookup(-1, "main:/foo").getVersionID());
            AVMServiceTest.assertEquals((int)2, (int)fService.lookup(-1, "main:/lfoo").getVersionID());
            fService.createSnapshot("main", null, null);
            AVMServiceTest.assertEquals((int)5, (int)fService.lookup(-1, "main:/foo").getVersionID());
            AVMServiceTest.assertEquals((int)3, (int)fService.lookup(-1, "main:/lfoo").getVersionID());
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "main:/foo")));
            line = reader.readLine();
            reader.close();
            AVMServiceTest.assertEquals((String)"I am main:/foo V5b", (String)line);
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "main:/lfoo")));
            line = reader.readLine();
            reader.close();
            AVMServiceTest.assertEquals((String)"I am main:/foo V5b", (String)line);
            out = new PrintStream(fService.getFileOutputStream("main:/foo"));
            out.println("I am main:/foo V6");
            out.close();
            AVMServiceTest.assertEquals((int)6, (int)fService.lookup(-1, "main:/foo").getVersionID());
            AVMServiceTest.assertEquals((int)3, (int)fService.lookup(-1, "main:/lfoo").getVersionID());
            fService.createSnapshot("main", null, null);
            AVMServiceTest.assertEquals((int)6, (int)fService.lookup(-1, "main:/foo").getVersionID());
            AVMServiceTest.assertEquals((int)4, (int)fService.lookup(-1, "main:/lfoo").getVersionID());
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "main:/foo")));
            line = reader.readLine();
            reader.close();
            AVMServiceTest.assertEquals((String)"I am main:/foo V6", (String)line);
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "main:/lfoo")));
            line = reader.readLine();
            reader.close();
            AVMServiceTest.assertEquals((String)"I am main:/foo V6", (String)line);
            out = new PrintStream(fService.getFileOutputStream("main:/lfoo"));
            out.println("I am main:/lfoo V1");
            out.close();
            AVMServiceTest.assertEquals((int)6, (int)fService.lookup(-1, "main:/foo").getVersionID());
            AVMServiceTest.assertEquals((int)5, (int)fService.lookup(-1, "main:/lfoo").getVersionID());
            AVMServiceTest.assertFalse((boolean)fService.lookup(-1, "main:/lfoo").isLayeredFile());
            fService.createSnapshot("main", null, null);
            AVMServiceTest.assertEquals((int)6, (int)fService.lookup(-1, "main:/foo").getVersionID());
            AVMServiceTest.assertEquals((int)5, (int)fService.lookup(-1, "main:/lfoo").getVersionID());
            AVMServiceTest.assertFalse((boolean)fService.lookup(-1, "main:/lfoo").isLayeredFile());
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "main:/foo")));
            line = reader.readLine();
            reader.close();
            AVMServiceTest.assertEquals((String)"I am main:/foo V6", (String)line);
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "main:/lfoo")));
            line = reader.readLine();
            reader.close();
            AVMServiceTest.assertEquals((String)"I am main:/lfoo V1", (String)line);
            out = new PrintStream(fService.getFileOutputStream("main:/lfoo"));
            out.println("I am main:/lfoo V2");
            out.close();
            AVMServiceTest.assertEquals((int)6, (int)fService.lookup(-1, "main:/foo").getVersionID());
            AVMServiceTest.assertEquals((int)6, (int)fService.lookup(-1, "main:/lfoo").getVersionID());
            AVMServiceTest.assertFalse((boolean)fService.lookup(-1, "main:/lfoo").isLayeredFile());
            fService.createSnapshot("main", null, null);
            AVMServiceTest.assertEquals((int)6, (int)fService.lookup(-1, "main:/foo").getVersionID());
            AVMServiceTest.assertEquals((int)6, (int)fService.lookup(-1, "main:/lfoo").getVersionID());
            AVMServiceTest.assertFalse((boolean)fService.lookup(-1, "main:/lfoo").isLayeredFile());
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "main:/foo")));
            line = reader.readLine();
            reader.close();
            AVMServiceTest.assertEquals((String)"I am main:/foo V6", (String)line);
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "main:/lfoo")));
            line = reader.readLine();
            reader.close();
            AVMServiceTest.assertEquals((String)"I am main:/lfoo V2", (String)line);
            fService.removeNode("main:/foo");
            desc = fService.lookup(-1, "main:/foo");
            AVMServiceTest.assertNull((Object)desc);
            try {
                fService.getFileOutputStream("main:/foo");
                AVMServiceTest.fail((String)"Unexpected");
            }
            catch (AVMNotFoundException nfe) {
                // empty catch block
            }
            try {
                fService.getFileInputStream(-1, "main:/foo");
                AVMServiceTest.fail((String)"Unexpected");
            }
            catch (AVMNotFoundException nfe) {
                // empty catch block
            }
            fService.createSnapshot("main", null, null);
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "main:/lfoo")));
            line = reader.readLine();
            reader.close();
            AVMServiceTest.assertEquals((String)"I am main:/lfoo V2", (String)line);
            AVMServiceTest.assertEquals((int)6, (int)fService.lookup(-1, "main:/lfoo").getVersionID());
            fService.removeNode("main:/lfoo");
            desc = fService.lookup(-1, "main:/lfoo");
            AVMServiceTest.assertNull((Object)desc);
            try {
                fService.getFileOutputStream("main:/lfoo");
                AVMServiceTest.fail((String)"Unexpected");
            }
            catch (AVMNotFoundException nfe) {
                // empty catch block
            }
            try {
                fService.getFileInputStream(-1, "main:/lfoo");
                AVMServiceTest.fail((String)"Unexpected");
            }
            catch (AVMNotFoundException nfe) {
                // empty catch block
            }
            fService.createSnapshot("main", null, null);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testLayeredFile3() throws Exception {
        try {
            AVMNodeDescriptor desc = fService.lookup(-1, "main:/foo");
            AVMServiceTest.assertNull((Object)desc);
            try {
                fService.getFileOutputStream("main:/foo");
                AVMServiceTest.fail((String)"Unexpected");
            }
            catch (AVMNotFoundException nfe) {
                // empty catch block
            }
            try {
                fService.getFileInputStream(-1, "main:/foo");
                AVMServiceTest.fail((String)"Unexpected");
            }
            catch (AVMNotFoundException nfe) {
                // empty catch block
            }
            fService.createLayeredFile("main:/foo", "main:/", "lfoo");
            AVMServiceTest.assertEquals((int)1, (int)fService.lookup(-1, "main:/lfoo").getVersionID());
            fService.createSnapshot("main", null, null);
            try {
                fService.getFileOutputStream("main:/lfoo");
                AVMServiceTest.fail((String)"Unexpected");
            }
            catch (AVMException e) {
                // empty catch block
            }
            try {
                fService.getFileInputStream(-1, "main:/lfoo");
                AVMServiceTest.fail((String)"Unexpected");
            }
            catch (AVMException e) {
                // empty catch block
            }
            fService.createFile("main:/", "foo").close();
            AVMServiceTest.assertEquals((int)1, (int)fService.lookup(-1, "main:/foo").getVersionID());
            AVMServiceTest.assertEquals((int)1, (int)fService.lookup(-1, "main:/lfoo").getVersionID());
            BufferedReader reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "main:/foo")));
            String line = reader.readLine();
            reader.close();
            AVMServiceTest.assertNull((Object)line);
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "main:/lfoo")));
            line = reader.readLine();
            reader.close();
            AVMServiceTest.assertNull((Object)line);
            PrintStream out = new PrintStream(fService.getFileOutputStream("main:/foo"));
            out.println("I am main:/foo V1");
            out.close();
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "main:/foo")));
            line = reader.readLine();
            reader.close();
            AVMServiceTest.assertEquals((String)"I am main:/foo V1", (String)line);
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "main:/lfoo")));
            line = reader.readLine();
            reader.close();
            AVMServiceTest.assertEquals((String)"I am main:/foo V1", (String)line);
            AVMServiceTest.assertEquals((int)1, (int)fService.lookup(-1, "main:/foo").getVersionID());
            AVMServiceTest.assertEquals((int)1, (int)fService.lookup(-1, "main:/lfoo").getVersionID());
            fService.createSnapshot("main", null, null);
            AVMServiceTest.assertEquals((int)1, (int)fService.lookup(-1, "main:/foo").getVersionID());
            AVMServiceTest.assertEquals((int)2, (int)fService.lookup(-1, "main:/lfoo").getVersionID());
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "main:/foo")));
            line = reader.readLine();
            reader.close();
            AVMServiceTest.assertEquals((String)"I am main:/foo V1", (String)line);
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "main:/lfoo")));
            line = reader.readLine();
            reader.close();
            AVMServiceTest.assertEquals((String)"I am main:/foo V1", (String)line);
            fService.removeNode("main:/foo");
            desc = fService.lookup(-1, "main:/foo");
            AVMServiceTest.assertNull((Object)desc);
            try {
                fService.getFileOutputStream("main:/foo");
                AVMServiceTest.fail((String)"Unexpected");
            }
            catch (AVMNotFoundException nfe) {
                // empty catch block
            }
            try {
                fService.getFileInputStream(-1, "main:/foo");
                AVMServiceTest.fail((String)"Unexpected");
            }
            catch (AVMNotFoundException nfe) {
                // empty catch block
            }
            AVMServiceTest.assertEquals((int)2, (int)fService.lookup(-1, "main:/lfoo").getVersionID());
            try {
                fService.getFileInputStream(-1, "main:/lfoo");
                AVMServiceTest.fail((String)"Unexpected");
            }
            catch (AVMNotFoundException nfe) {
                // empty catch block
            }
            fService.createSnapshot("main", null, null);
            AVMServiceTest.assertEquals((int)3, (int)fService.lookup(-1, "main:/lfoo").getVersionID());
            try {
                fService.getFileInputStream(-1, "main:/lfoo");
                AVMServiceTest.fail((String)"Unexpected");
            }
            catch (AVMNotFoundException nfe) {
                // empty catch block
            }
            AVMServiceTest.assertTrue((boolean)fService.lookup(-1, "main:/lfoo").isLayeredFile());
            AVMServiceTest.assertFalse((boolean)fService.lookup(-1, "main:/lfoo").isPlainFile());
            try {
                fService.getFileOutputStream("main:/lfoo");
                AVMServiceTest.fail();
            }
            catch (AVMException e) {
                // empty catch block
            }
            fService.removeNode("main:/lfoo");
            fService.createSnapshot("main", null, null);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testLayeredFile4() throws Exception {
        try {
            fService.createStore("mainA");
            fService.createStore("mainB");
            fService.createStore("mainB--layer");
            fService.createDirectory("mainA:/", "a");
            fService.createDirectory("mainB:/", "a");
            fService.createLayeredDirectory("mainB:/a", "mainB--layer:/", "a");
            fService.createFile("mainA:/a", "foo").close();
            PrintStream out = new PrintStream(fService.getFileOutputStream("mainA:/a/foo"));
            out.println("I am mainA:/a/foo");
            out.close();
            fService.createSnapshot("mainA", null, null);
            fService.createLayeredFile("mainA:/a/foo", "mainB:/a", "foo");
            AVMNodeDescriptor foo = fService.lookup(-1, "mainB--layer:/a/foo");
            AVMServiceTest.assertEquals((int)1, (int)foo.getVersionID());
            AVMServiceTest.assertTrue((boolean)foo.isLayeredFile());
            ContentData cData = fService.getContentDataForRead(foo);
            AVMServiceTest.assertNotNull((Object)cData);
            BufferedReader reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "mainB--layer:/a/foo")));
            String line = reader.readLine();
            reader.close();
            AVMServiceTest.assertEquals((String)"I am mainA:/a/foo", (String)line);
            foo = fService.lookup(-1, "mainB:/a/foo");
            AVMServiceTest.assertEquals((int)1, (int)foo.getVersionID());
            AVMServiceTest.assertTrue((boolean)foo.isLayeredFile());
            cData = fService.getContentDataForRead(foo);
            AVMServiceTest.assertNotNull((Object)cData);
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "mainB:/a/foo")));
            line = reader.readLine();
            reader.close();
            AVMServiceTest.assertEquals((String)"I am mainA:/a/foo", (String)line);
            foo = fService.lookup(-1, "mainA:/a/foo");
            AVMServiceTest.assertEquals((int)1, (int)foo.getVersionID());
            AVMServiceTest.assertTrue((boolean)foo.isPlainFile());
            cData = fService.getContentDataForRead(foo);
            AVMServiceTest.assertNotNull((Object)cData);
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "mainA:/a/foo")));
            line = reader.readLine();
            reader.close();
            AVMServiceTest.assertEquals((String)"I am mainA:/a/foo", (String)line);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
        finally {
            fService.purgeStore("mainA");
            fService.purgeStore("mainB");
            fService.purgeStore("mainB--layer");
        }
    }

    public void testRename() throws Exception {
        try {
            this.setupBasicTree();
            try {
                fService.rename("main:/a", "b", "main:/a/b", "b");
                AVMServiceTest.fail((String)"Renaming folder into itself should cause cycle exception");
            }
            catch (AVMCycleException ace) {
                // empty catch block
            }
            try {
                fService.rename("main:/a/", "b", "main:/a/b/", "b");
                AVMServiceTest.fail((String)"Renaming folder into itself should cause cycle exception");
            }
            catch (AVMCycleException ace) {
                // empty catch block
            }
            try {
                fService.rename("main:/", "a", "main:/a/b", "c");
                AVMServiceTest.fail((String)"Renaming folder tree into itself should cause cycle exception");
            }
            catch (AVMCycleException ace) {
                // empty catch block
            }
            fService.rename("main:/a", "b", "main:/d/e", "brenamed");
            fService.createSnapshot("main", null, null);
            System.out.println(this.recursiveList("main", -1, true));
            AVMServiceTest.assertEquals((String)this.recursiveContents("main:/a/b", 1, true), (String)this.recursiveContents("main:/d/e/brenamed", 2, true));
            StoreRef storeRef = AVMNodeConverter.ToStoreRef("main");
            SearchService searchService = fIndexerAndSearcher.getSearcher(storeRef, true);
            ResultSet results = searchService.query(storeRef, "lucene", "TEXT:\"I am main\"");
            AVMServiceTest.assertEquals((int)2, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_NAME)) + ":\"foo\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_NAME)) + ":foo");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_CREATOR)) + ":admin");
            AVMServiceTest.assertEquals((int)9, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_MODIFIER)) + ":admin");
            AVMServiceTest.assertEquals((int)9, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_OWNER)) + ":admin");
            AVMServiceTest.assertEquals((int)9, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_NODE_UUID)) + ":unknown");
            AVMServiceTest.assertEquals((int)9, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_STORE_PROTOCOL)) + ":avm");
            AVMServiceTest.assertEquals((int)9, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_STORE_IDENTIFIER)) + ":main");
            AVMServiceTest.assertEquals((int)9, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/a\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/a/b\"");
            AVMServiceTest.assertEquals((int)0, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/d\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/d/e\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/d/e/brenamed\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/d/e/brenamed/c\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/d/e/brenamed/c/foo\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/d/e/brenamed/c/bar\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/d/e/f\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"//.\"");
            AVMServiceTest.assertEquals((int)9, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"//*\"");
            AVMServiceTest.assertEquals((int)8, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/a//.\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/a//*\"");
            AVMServiceTest.assertEquals((int)0, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/a/*\"");
            AVMServiceTest.assertEquals((int)0, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"//c/*\"");
            AVMServiceTest.assertEquals((int)2, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/*\"");
            AVMServiceTest.assertEquals((int)2, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/*/*\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/*/*/*\"");
            AVMServiceTest.assertEquals((int)2, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/*/*/*/*\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/*/*/*/*/*\"");
            AVMServiceTest.assertEquals((int)2, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/*/*/*/*/*/*\"");
            AVMServiceTest.assertEquals((int)0, (int)results.length());
            results.close();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testRemove() throws Exception {
        try {
            this.setupBasicTree();
            TreeMap<Integer, String> history = new TreeMap<Integer, String>();
            this.checkHistory(history, "main");
            System.out.println(history.get(0));
            fService.removeNode("main:/a/b/c", "foo");
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            System.out.println(history.get(1));
            SortedMap<String, AVMNodeDescriptor> l = fService.getDirectoryListing(-1, "main:/a/b/c");
            AVMServiceTest.assertEquals((int)1, (int)l.size());
            fService.removeNode("main:/d", "e");
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            System.out.println(history.get(2));
            l = fService.getDirectoryListing(-1, "main:/d");
            AVMServiceTest.assertEquals((int)0, (int)l.size());
            StoreRef storeRef = AVMNodeConverter.ToStoreRef("main");
            SearchService searchService = fIndexerAndSearcher.getSearcher(storeRef, true);
            ResultSet results = searchService.query(storeRef, "lucene", "TEXT:\"I am main\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_NAME)) + ":\"foo\"");
            AVMServiceTest.assertEquals((int)0, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_NAME)) + ":foo");
            AVMServiceTest.assertEquals((int)0, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_CREATOR)) + ":admin");
            AVMServiceTest.assertEquals((int)6, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_MODIFIER)) + ":admin");
            AVMServiceTest.assertEquals((int)6, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_OWNER)) + ":admin");
            AVMServiceTest.assertEquals((int)6, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_NODE_UUID)) + ":unknown");
            AVMServiceTest.assertEquals((int)6, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_STORE_PROTOCOL)) + ":avm");
            AVMServiceTest.assertEquals((int)6, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_STORE_IDENTIFIER)) + ":" + "main");
            AVMServiceTest.assertEquals((int)6, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/a\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/a/b\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/a/b/c\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/a/b/c/foo\"");
            AVMServiceTest.assertEquals((int)0, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/a/b/c/bar\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/d\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/d/e\"");
            AVMServiceTest.assertEquals((int)0, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/d/e/f\"");
            AVMServiceTest.assertEquals((int)0, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"//.\"");
            AVMServiceTest.assertEquals((int)6, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"//*\"");
            AVMServiceTest.assertEquals((int)5, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/a//.\"");
            AVMServiceTest.assertEquals((int)4, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/a//*\"");
            AVMServiceTest.assertEquals((int)3, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/a/*\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"//c/*\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/*\"");
            AVMServiceTest.assertEquals((int)2, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/*/*\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/*/*/*\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/*/*/*/*\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "PATH:\"/*/*/*/*/*\"");
            AVMServiceTest.assertEquals((int)0, (int)results.length());
            results.close();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testBranchAcross() throws Exception {
        try {
            this.setupBasicTree();
            fService.createStore("second");
            List<AVMStoreDescriptor> repos = fService.getStores();
            AVMServiceTest.assertTrue((boolean)this.checkStoreExists("main", repos));
            AVMServiceTest.assertTrue((boolean)this.checkStoreExists("second", repos));
            fService.createBranch(-1, "main:/", "second:/", "main");
            fService.createSnapshot("second", null, null);
            System.out.println(this.recursiveList("second", -1, true));
            AVMServiceTest.assertEquals((String)this.recursiveContents("main:/", -1, true), (String)this.recursiveContents("second:/main", -1, true));
            PrintStream out = new PrintStream(fService.getFileOutputStream("second:/main/a/b/c/foo"));
            out.println("I am second:/main/a/b/c/foo");
            out.close();
            fService.createSnapshot("second", null, null);
            System.out.println(this.recursiveList("second", -1, true));
            BufferedReader reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "main:/a/b/c/foo")));
            String line = reader.readLine();
            reader.close();
            AVMServiceTest.assertEquals((String)"I am main:/a/b/c/foo", (String)line);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
        finally {
            fService.purgeStore("second");
        }
    }

    private boolean checkStoreExists(String storeName, List<AVMStoreDescriptor> stores) {
        for (AVMStoreDescriptor store : stores) {
            if (!store.getName().equals(storeName)) continue;
            return true;
        }
        return false;
    }

    public void testLayerAcross() throws Exception {
        try {
            this.setupBasicTree();
            fService.createStore("second");
            fService.createLayeredDirectory("main:/", "second:/", "main");
            fService.createSnapshot("second", null, null);
            System.out.println(this.recursiveList("second", -1, true));
            AVMServiceTest.assertEquals((String)this.recursiveContents("main:/", -1, true), (String)this.recursiveContents("second:/main", -1, true));
            PrintStream out = new PrintStream(fService.getFileOutputStream("second:/main/a/b/c/foo"));
            out.println("I am second:/main/a/b/c/foo");
            out.close();
            fService.createSnapshot("second", null, null);
            System.out.println(this.recursiveList("second", -1, true));
            BufferedReader reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "second:/main/a/b/c/foo")));
            String line = reader.readLine();
            reader.close();
            AVMServiceTest.assertEquals((String)"I am second:/main/a/b/c/foo", (String)line);
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "main:/a/b/c/foo")));
            line = reader.readLine();
            reader.close();
            AVMServiceTest.assertEquals((String)"I am main:/a/b/c/foo", (String)line);
            fService.purgeStore("second");
            fService.purgeVersion(1, "main");
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testRenameAcross() throws Exception {
        try {
            this.setupBasicTree();
            fService.createStore("second");
            fService.rename("main:/a/b", "c", "second:/", "cmoved");
            ArrayList<String> toSnapshot = new ArrayList<String>();
            toSnapshot.add("main");
            toSnapshot.add("second");
            System.out.println(this.recursiveList("main", -1, true));
            System.out.println(this.recursiveList("second", -1, true));
            AVMServiceTest.assertEquals((String)this.recursiveContents("main:/a/b/c", 1, true), (String)this.recursiveContents("second:/cmoved", -1, true));
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
        finally {
            fService.purgeStore("second");
        }
    }

    public void testDeepCOW() throws Exception {
        try {
            fService.createDirectory("main:/", "a");
            fService.createDirectory("main:/a", "b");
            fService.createSnapshot("main", null, null);
            SortedMap<String, AVMNodeDescriptor> listing = fService.getDirectoryListing(-1, "main:/a");
            AVMServiceTest.assertEquals((int)1, (int)listing.size());
            ArrayList list = new ArrayList(listing.keySet());
            AVMServiceTest.assertEquals((String)"b", (String)((String)list.get(0)));
            fService.createLayeredDirectory("main:/a", "main:/", "c");
            fService.createLayeredDirectory("main:/c", "main:/", "d");
            fService.createFile("main:/d/b", "foo.txt").close();
            fService.createSnapshot("main", null, null);
            System.out.println(this.recursiveList("main", -1, true));
            listing = fService.getDirectoryListing(-1, "main:/d/b");
            AVMServiceTest.assertEquals((int)1, (int)listing.size());
            list = new ArrayList(listing.keySet());
            AVMServiceTest.assertEquals((String)"foo.txt", (String)((String)list.get(0)));
            fService.createFile("main:/c/b", "bar.txt").close();
            fService.createSnapshot("main", null, null);
            System.out.println(this.recursiveList("main", -1, true));
            listing = fService.getDirectoryListing(-1, "main:/c/b");
            AVMServiceTest.assertEquals((int)1, (int)listing.size());
            list = new ArrayList(listing.keySet());
            AVMServiceTest.assertEquals((String)"bar.txt", (String)((String)list.get(0)));
            listing = fService.getDirectoryListing(-1, "main:/d/b");
            AVMServiceTest.assertEquals((int)2, (int)listing.size());
            list = new ArrayList(listing.keySet());
            AVMServiceTest.assertEquals((String)"bar.txt", (String)((String)list.get(0)));
            AVMServiceTest.assertEquals((String)"foo.txt", (String)((String)list.get(1)));
            AVMNodeDescriptor[] arrayListing = fService.getDirectoryListingArray(-1, "main:/d/b", false);
            AVMServiceTest.assertEquals((String)"bar.txt", (String)arrayListing[0].getName());
            AVMServiceTest.assertEquals((String)"foo.txt", (String)arrayListing[1].getName());
            fService.rename("main:/", "c", "main:/", "e");
            fService.createSnapshot("main", null, null);
            System.out.println(this.recursiveList("main", -1, true));
            listing = fService.getDirectoryListing(-1, "main:/d/b");
            AVMServiceTest.assertEquals((int)1, (int)listing.size());
            list = new ArrayList(listing.keySet());
            AVMServiceTest.assertEquals((String)"foo.txt", (String)((String)list.get(0)));
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testBranchAndLayer() throws Exception {
        try {
            fService.createDirectory("main:/", "a");
            fService.createDirectory("main:/a", "b");
            fService.createFile("main:/a/b", "c.txt").close();
            fService.createFile("main:/a/b", "d.txt").close();
            fService.createFile("main:/a", "e.txt").close();
            fService.createSnapshot("main", null, null);
            fService.createBranch(-1, "main:/a", "main:/", "branch");
            fService.createSnapshot("main", null, null);
            AVMServiceTest.assertEquals((String)this.recursiveContents("main:/a", -1, true), (String)this.recursiveContents("main:/branch", -1, true));
            fService.createLayeredDirectory("main:/branch/b", "main:/", "layer");
            fService.createSnapshot("main", null, null);
            AVMServiceTest.assertEquals((String)this.recursiveContents("main:/branch/b", -1, true), (String)this.recursiveContents("main:/layer", -1, true));
            PrintStream out = new PrintStream(fService.getFileOutputStream("main:/a/b/c.txt"));
            out.println("I am c, modified in main:/a/b.");
            out.close();
            fService.createSnapshot("main", null, null);
            AVMServiceTest.assertEquals((String)this.recursiveContents("main:/branch/b", -1, true), (String)this.recursiveContents("main:/layer", -1, true));
            AVMServiceTest.assertFalse((boolean)this.recursiveContents("main:/a/b", -1, true).equals(this.recursiveContents("main:/layer", -1, true)));
            out = new PrintStream(fService.getFileOutputStream("main:/branch/b/d.txt"));
            out.println("I am d, modified in main:/branch/b");
            out.close();
            fService.createSnapshot("main", null, null);
            AVMServiceTest.assertEquals((String)this.recursiveContents("main:/branch/b", -1, true), (String)this.recursiveContents("main:/layer", -1, true));
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testLayering() throws Exception {
        try {
            fService.createDirectory("main:/", "a");
            fService.createDirectory("main:/a", "b");
            fService.createDirectory("main:/a/b", "c");
            fService.createDirectory("main:/a/b/c", "d");
            fService.createSnapshot("main", null, null);
            fService.createLayeredDirectory("main:/a", "main:/", "e");
            fService.createLayeredDirectory("main:/e", "main:/", "f");
            fService.createLayeredDirectory("main:/f", "main:/", "g");
            fService.createSnapshot("main", null, null);
            String a = this.recursiveContents("main:/a", -1, true);
            String e = this.recursiveContents("main:/e", -1, true);
            String f = this.recursiveContents("main:/f", -1, true);
            String g = this.recursiveContents("main:/g", -1, true);
            AVMServiceTest.assertEquals((String)a, (String)e);
            AVMServiceTest.assertEquals((String)a, (String)f);
            AVMServiceTest.assertEquals((String)a, (String)g);
            fService.createFile("main:/g/b/c/d", "foo").close();
            fService.createFile("main:/f/b/c/d", "bar").close();
            fService.createSnapshot("main", null, null);
            SortedMap<String, AVMNodeDescriptor> listing = fService.getDirectoryListing(-1, "main:/g/b/c/d");
            AVMServiceTest.assertEquals((int)2, (int)listing.size());
            ArrayList list = new ArrayList(listing.keySet());
            AVMServiceTest.assertEquals((String)"bar", (String)((String)list.get(0)));
            AVMServiceTest.assertEquals((String)"foo", (String)((String)list.get(1)));
            listing = fService.getDirectoryListing(-1, "main:/f/b/c/d");
            AVMServiceTest.assertEquals((int)1, (int)listing.size());
            list = new ArrayList(listing.keySet());
            AVMServiceTest.assertEquals((String)"bar", (String)((String)list.get(0)));
            fService.createFile("main:/a/b/c", "baz").close();
            fService.createSnapshot("main", null, null);
            listing = fService.getDirectoryListing(-1, "main:/e/b/c");
            AVMServiceTest.assertEquals((int)2, (int)listing.size());
            list = new ArrayList(listing.keySet());
            AVMServiceTest.assertEquals((String)"baz", (String)((String)list.get(0)));
            AVMServiceTest.assertEquals((String)"d", (String)((String)list.get(1)));
            fService.createFile("main:/e/b/c/d", "bing").close();
            fService.createSnapshot("main", null, null);
            listing = fService.getDirectoryListing(-1, "main:/f/b/c/d");
            AVMServiceTest.assertEquals((int)2, (int)listing.size());
            list = new ArrayList(listing.keySet());
            AVMServiceTest.assertEquals((String)"bar", (String)((String)list.get(0)));
            AVMServiceTest.assertEquals((String)"bing", (String)((String)list.get(1)));
            System.out.println(this.recursiveList("main", -1, true));
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testRenameInLayer() throws Exception {
        try {
            fService.createDirectory("main:/", "a");
            fService.createDirectory("main:/a", "b");
            fService.createDirectory("main:/a/b", "c");
            fService.createDirectory("main:/a", "d");
            fService.createSnapshot("main", null, null);
            fService.createLayeredDirectory("main:/a", "main:/", "layer");
            fService.createSnapshot("main", null, null);
            AVMServiceTest.assertEquals((String)this.recursiveContents("main:/a", -1, true), (String)this.recursiveContents("main:/layer", -1, true));
            fService.rename("main:/layer", "d", "main:/layer", "moved");
            fService.createSnapshot("main", null, null);
            SortedMap<String, AVMNodeDescriptor> listing = fService.getDirectoryListing(-1, "main:/layer");
            AVMServiceTest.assertEquals((int)2, (int)listing.size());
            ArrayList list = new ArrayList(listing.keySet());
            AVMServiceTest.assertEquals((String)"b", (String)((String)list.get(0)));
            AVMServiceTest.assertEquals((String)"moved", (String)((String)list.get(1)));
            fService.rename("main:/layer", "moved", "main:/layer", "d");
            fService.createSnapshot("main", null, null);
            listing = fService.getDirectoryListing(-1, "main:/layer");
            AVMServiceTest.assertEquals((int)2, (int)listing.size());
            list = new ArrayList(listing.keySet());
            AVMServiceTest.assertEquals((String)"b", (String)((String)list.get(0)));
            AVMServiceTest.assertEquals((String)"d", (String)((String)list.get(1)));
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testMultiLayerUnregistered() throws Exception {
        try {
            TreeMap<Integer, String> history = new TreeMap<Integer, String>();
            this.setupBasicTree();
            this.checkHistory(history, "main");
            fService.createLayeredDirectory("main:/a", "main:/d/e/f", "l0");
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            fService.createLayeredDirectory("main:/d/e/f", "main:/d", "l1");
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            fService.createLayeredDirectory("main:/d", "main:/", "l2");
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            fService.createFile("main:/l2/l1/l0/b", "foo").close();
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            AVMServiceTest.assertEquals((String)"main:/d/l1/l0", (String)fService.lookup(-1, "main:/l2/l1/l0").getIndirection());
            AVMServiceTest.assertEquals((String)"main:/d/l1/l0/b", (String)fService.lookup(-1, "main:/l2/l1/l0/b").getIndirection());
            for (String val : history.values()) {
                System.out.println(val);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testMakePrimary() throws Exception {
        try {
            TreeMap<Integer, String> history = new TreeMap<Integer, String>();
            this.setupBasicTree();
            this.checkHistory(history, "main");
            fService.createLayeredDirectory("main:/a", "main:/", "layer");
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            fService.makePrimary("main:/layer/b/c");
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            fService.rename("main:/layer/b", "c", "main:/layer", "c");
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            AVMServiceTest.assertEquals((String)this.recursiveContents("main:/a/b/c", -1, true), (String)this.recursiveContents("main:/layer/c", -1, true));
            fService.createLayeredDirectory("main:/a", "main:/", "layer2");
            fService.createFile("main:/layer2/b/c", "baz").close();
            fService.makePrimary("main:/layer2/b/c");
            fService.rename("main:/layer2/b", "c", "main:/layer2", "c");
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            SortedMap<String, AVMNodeDescriptor> listing = fService.getDirectoryListing(-1, "main:/layer2/c");
            AVMServiceTest.assertEquals((int)3, (int)listing.size());
            ArrayList list = new ArrayList(listing.keySet());
            AVMServiceTest.assertEquals((String)"bar", (String)((String)list.get(0)));
            AVMServiceTest.assertEquals((String)"baz", (String)((String)list.get(1)));
            AVMServiceTest.assertEquals((String)"foo", (String)((String)list.get(2)));
            for (String val : history.values()) {
                System.out.println(val);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testRetarget() throws Exception {
        try {
            TreeMap<Integer, String> history = new TreeMap<Integer, String>();
            this.setupBasicTree();
            this.checkHistory(history, "main");
            fService.createLayeredDirectory("main:/a", "main:/", "layer");
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            fService.retargetLayeredDirectory("main:/layer/b/c", "main:/d");
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            SortedMap<String, AVMNodeDescriptor> listing = fService.getDirectoryListing(-1, "main:/layer/b/c");
            AVMServiceTest.assertEquals((int)1, (int)listing.size());
            ArrayList list = new ArrayList(listing.keySet());
            AVMServiceTest.assertEquals((String)"e", (String)((String)list.get(0)));
            fService.rename("main:/layer/b", "c", "main:/layer", "c");
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            AVMServiceTest.assertEquals((String)this.recursiveContents("main:/d", -1, true), (String)this.recursiveContents("main:/layer/c", -1, true));
            fService.createLayeredDirectory("main:/a", "main:/", "layer2");
            fService.createFile("main:/layer2/b/c", "baz").close();
            fService.retargetLayeredDirectory("main:/layer2/b/c", "main:/d");
            fService.rename("main:/layer2/b", "c", "main:/layer2", "c");
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            listing = fService.getDirectoryListing(-1, "main:/layer2/c");
            AVMServiceTest.assertEquals((int)2, (int)listing.size());
            list = new ArrayList(listing.keySet());
            AVMServiceTest.assertEquals((String)"baz", (String)((String)list.get(0)));
            AVMServiceTest.assertEquals((String)"e", (String)((String)list.get(1)));
            for (String val : history.values()) {
                System.out.println(val);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testRenameBranchToBranch() throws Exception {
        try {
            TreeMap<Integer, String> history = new TreeMap<Integer, String>();
            fService.createDirectory("main:/", "a");
            fService.createDirectory("main:/a", "b");
            fService.createDirectory("main:/a/b", "c");
            fService.createFile("main:/a/b/c", "foo").close();
            fService.createFile("main:/a/b/c", "bar").close();
            fService.createDirectory("main:/", "d");
            fService.createDirectory("main:/d", "e");
            fService.createDirectory("main:/d/e", "f");
            fService.createFile("main:/d/e/f", "moo").close();
            fService.createFile("main:/d/e/f", "cow").close();
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            fService.createBranch(-1, "main:/a/b", "main:/", "abranch");
            fService.createBranch(-1, "main:/d/e", "main:/", "dbranch");
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            fService.rename("main:/abranch/c", "foo", "main:/dbranch", "foo");
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            int version = fService.getNextVersionID("main");
            AVMServiceTest.assertEquals((String)this.recursiveContents("main:/a", version - 1, true), (String)this.recursiveContents("main:/a", version - 2, true));
            AVMServiceTest.assertEquals((String)this.recursiveContents("main:/d", version - 1, true), (String)this.recursiveContents("main:/d", version - 2, true));
            fService.rename("main:/dbranch", "f", "main:/abranch/c", "f");
            fService.createSnapshot("main", null, null);
            version = fService.getNextVersionID("main");
            AVMServiceTest.assertEquals((String)this.recursiveContents("main:/a", version - 1, true), (String)this.recursiveContents("main:/a", version - 2, true));
            AVMServiceTest.assertEquals((String)this.recursiveContents("main:/d", version - 1, true), (String)this.recursiveContents("main:/d", version - 2, true));
            this.checkHistory(history, "main");
            for (String val : history.values()) {
                System.out.println(val);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testBranchIntoLayer() throws Exception {
        try {
            TreeMap<Integer, String> history = new TreeMap<Integer, String>();
            fService.createDirectory("main:/", "a");
            fService.createDirectory("main:/a", "b");
            fService.createDirectory("main:/a/b", "c");
            fService.createFile("main:/a/b/c", "foo").close();
            fService.createFile("main:/a/b/c", "bar").close();
            fService.createDirectory("main:/", "d");
            fService.createDirectory("main:/d", "e");
            fService.createDirectory("main:/d/e", "f");
            fService.createFile("main:/d/e/f", "moo").close();
            fService.createFile("main:/d/e/f", "cow").close();
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            fService.createLayeredDirectory("main:/a", "main:/", "layer");
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            fService.createBranch(-1, "main:/d", "main:/layer/b", "branch");
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            PrintStream out = new PrintStream(fService.getFileOutputStream("main:/layer/b/branch/e/f/moo"));
            out.println("moo modified.");
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            SortedMap<String, AVMNodeDescriptor> listing = fService.getDirectoryListing(-1, "main:/layer/b/branch/e/f");
            AVMServiceTest.assertEquals((int)2, (int)listing.size());
            ArrayList list = new ArrayList(listing.keySet());
            AVMServiceTest.assertEquals((String)"cow", (String)((String)list.get(0)));
            AVMServiceTest.assertEquals((String)"moo", (String)((String)list.get(1)));
            for (String val : history.values()) {
                System.out.println(val);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testRenameIntoLayer() throws Exception {
        try {
            TreeMap<Integer, String> history = new TreeMap<Integer, String>();
            fService.createDirectory("main:/", "a");
            fService.createDirectory("main:/a", "b");
            fService.createDirectory("main:/a/b", "c");
            fService.createFile("main:/a/b/c", "foo").close();
            fService.createFile("main:/a/b/c", "bar").close();
            fService.createDirectory("main:/", "d");
            fService.createDirectory("main:/d", "e");
            fService.createDirectory("main:/d/e", "f");
            fService.createFile("main:/d/e/f", "moo").close();
            fService.createFile("main:/d/e/f", "cow").close();
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            fService.createLayeredDirectory("main:/a", "main:/", "layer");
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            fService.rename("main:/", "d", "main:/layer/b", "d");
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            PrintStream out = new PrintStream(fService.getFileOutputStream("main:/layer/b/d/e/f/moo"));
            out.println("moo modified.");
            out.close();
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            SortedMap<String, AVMNodeDescriptor> listing = fService.getDirectoryListing(-1, "main:/layer/b/d/e/f");
            AVMServiceTest.assertEquals((int)2, (int)listing.size());
            ArrayList list = new ArrayList(listing.keySet());
            AVMServiceTest.assertEquals((String)"cow", (String)((String)list.get(0)));
            AVMServiceTest.assertEquals((String)"moo", (String)((String)list.get(1)));
            for (String val : history.values()) {
                System.out.println(val);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testIndirectionBehavior() throws Exception {
        try {
            TreeMap<Integer, String> history = new TreeMap<Integer, String>();
            fService.createDirectory("main:/", "a");
            fService.createDirectory("main:/a", "b");
            fService.createDirectory("main:/a/b", "c");
            fService.createDirectory("main:/a/b/c", "d");
            fService.createDirectory("main:/a/b/c/d", "e");
            fService.createLayeredDirectory("main:/a", "main:/", "layer");
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            fService.createDirectory("main:/", "f");
            fService.createDirectory("main:/f", "g");
            fService.createDirectory("main:/f/g", "h");
            fService.createLayeredDirectory("main:/f", "main:/", "flayer");
            fService.createLayeredDirectory("main:/flayer", "main:/layer/b/c", "fover");
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            fService.createDirectory("main:/", "i");
            fService.createDirectory("main:/i", "j");
            fService.createDirectory("main:/i/j", "k");
            fService.createLayeredDirectory("main:/i", "main:/f/g/h", "iover");
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            fService.createFile("main:/layer/b/c/fover/g/h/iover/j/k", "foo").close();
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            fService.createFile("main:/i/j/k", "pismo").close();
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            SortedMap<String, AVMNodeDescriptor> listing = fService.getDirectoryListing(-1, "main:/layer/b/c/fover/g/h/iover/j/k");
            AVMServiceTest.assertEquals((int)2, (int)listing.size());
            ArrayList list = new ArrayList(listing.keySet());
            AVMServiceTest.assertEquals((String)"foo", (String)((String)list.get(0)));
            AVMServiceTest.assertEquals((String)"pismo", (String)((String)list.get(1)));
            fService.createFile("main:/flayer/g/h/iover/j/k", "zuma").close();
            fService.createSnapshot("main", null, null);
            this.checkHistory(history, "main");
            listing = fService.getDirectoryListing(-1, "main:/layer/b/c/fover/g/h/iover/j/k");
            AVMServiceTest.assertEquals((int)3, (int)listing.size());
            list = new ArrayList(listing.keySet());
            AVMServiceTest.assertEquals((String)"foo", (String)((String)list.get(0)));
            AVMServiceTest.assertEquals((String)"pismo", (String)((String)list.get(1)));
            AVMServiceTest.assertEquals((String)"zuma", (String)((String)list.get(2)));
            for (String val : history.values()) {
                System.out.println(val);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testVersionedRead() throws Exception {
        try {
            PrintStream out = new PrintStream(fService.createFile("main:/", "foo"));
            out.print("version1");
            out.close();
            fService.createLayeredFile("main:/foo", "main:/", "afoo");
            fService.createSnapshot("main", null, null);
            AVMServiceTest.assertEquals((long)8L, (long)fService.lookup(-1, "main:/foo").getLength());
            out = new PrintStream(fService.getFileOutputStream("main:/foo"));
            out.print("version2");
            out.close();
            fService.createSnapshot("main", null, null);
            BufferedReader reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(1, "main:/afoo")));
            AVMServiceTest.assertEquals((String)"version1", (String)reader.readLine());
            reader.close();
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(2, "main:/afoo")));
            AVMServiceTest.assertEquals((String)"version2", (String)reader.readLine());
            reader.close();
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "main:/afoo")));
            AVMServiceTest.assertEquals((String)"version2", (String)reader.readLine());
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testVersionedRead2() throws Exception {
        try {
            AVMServiceTest.assertNull((Object)fService.lookup(-1, "main:/foo"));
            AVMServiceTest.assertNull((Object)fService.lookup(-1, "main:/afoo"));
            try {
                fService.getFileInputStream(-1, "main:/afoo");
                AVMServiceTest.fail();
            }
            catch (AVMNotFoundException nfe) {
                // empty catch block
            }
            PrintStream out = new PrintStream(fService.createFile("main:/", "foo"));
            out.print("version1");
            out.close();
            BufferedReader reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "main:/foo")));
            AVMServiceTest.assertEquals((String)"version1", (String)reader.readLine());
            reader.close();
            fService.createLayeredFile("main:/foo", "main:/", "afoo");
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(-1, "main:/afoo")));
            AVMServiceTest.assertEquals((String)"version1", (String)reader.readLine());
            reader.close();
            fService.createSnapshot("main", null, null);
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(1, "main:/foo")));
            AVMServiceTest.assertEquals((String)"version1", (String)reader.readLine());
            reader.close();
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(1, "main:/afoo")));
            AVMServiceTest.assertEquals((String)"version1", (String)reader.readLine());
            reader.close();
            AVMServiceTest.assertEquals((long)8L, (long)fService.lookup(-1, "main:/foo").getLength());
            out = new PrintStream(fService.getFileOutputStream("main:/foo"));
            out.print("version2");
            out.close();
            fService.createSnapshot("main", null, null);
            fService.createSnapshot("main", null, null);
            fService.removeNode("main:/foo");
            fService.createSnapshot("main", null, null);
            try {
                fService.getFileInputStream(0, "main:/foo");
                AVMServiceTest.fail();
            }
            catch (AVMNotFoundException nfe) {
                // empty catch block
            }
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(1, "main:/foo")));
            AVMServiceTest.assertEquals((String)"version1", (String)reader.readLine());
            reader.close();
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(2, "main:/foo")));
            AVMServiceTest.assertEquals((String)"version2", (String)reader.readLine());
            reader.close();
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(3, "main:/foo")));
            AVMServiceTest.assertEquals((String)"version2", (String)reader.readLine());
            reader.close();
            try {
                fService.getFileInputStream(4, "main:/foo");
                AVMServiceTest.fail();
            }
            catch (AVMNotFoundException nfe) {
                // empty catch block
            }
            try {
                fService.getFileInputStream(-1, "main:/foo");
                AVMServiceTest.fail();
            }
            catch (AVMNotFoundException nfe) {
                // empty catch block
            }
            try {
                fService.getFileInputStream(0, "main:/afoo");
                AVMServiceTest.fail();
            }
            catch (AVMNotFoundException nfe) {
                // empty catch block
            }
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(1, "main:/afoo")));
            AVMServiceTest.assertEquals((String)"version1", (String)reader.readLine());
            reader.close();
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(2, "main:/afoo")));
            AVMServiceTest.assertEquals((String)"version2", (String)reader.readLine());
            reader.close();
            reader = new BufferedReader(new InputStreamReader(fService.getFileInputStream(3, "main:/afoo")));
            AVMServiceTest.assertEquals((String)"version2", (String)reader.readLine());
            reader.close();
            try {
                fService.getFileInputStream(4, "main:/afoo");
                AVMServiceTest.fail();
            }
            catch (AVMNotFoundException nfe) {
                // empty catch block
            }
            try {
                fService.getFileInputStream(-1, "main:/afoo");
                AVMServiceTest.fail();
            }
            catch (AVMNotFoundException aVMNotFoundException) {}
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testRenameLayerInLayer() throws Exception {
        try {
            fService.createDirectory("main:/", "a");
            fService.createDirectory("main:/a", "b");
            fService.createDirectory("main:/a/b", "c");
            fService.createSnapshot("main", null, null);
            fService.createLayeredDirectory("main:/a", "main:/", "layer");
            fService.createSnapshot("main", null, null);
            fService.createFile("main:/layer/b/c", "foo").close();
            fService.createSnapshot("main", null, null);
            AVMServiceTest.assertEquals((String)"main:/a/b/c", (String)fService.lookup(-1, "main:/layer/b/c").getIndirection());
            fService.rename("main:/layer/b", "c", "main:/layer/b", "d");
            fService.createSnapshot("main", null, null);
            AVMServiceTest.assertEquals((String)"main:/a/b/d", (String)fService.lookup(-1, "main:/layer/b/d").getIndirection());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testAnotherRename() throws Exception {
        try {
            fService.createDirectory("main:/", "a");
            fService.createDirectory("main:/a", "b");
            fService.createDirectory("main:/a/b", "c");
            fService.createDirectory("main:/", "d");
            fService.createDirectory("main:/d", "e");
            fService.createDirectory("main:/d/e", "f");
            fService.createSnapshot("main", null, null);
            this.runQueriesForInitialRenameStructure("main");
            fService.createLayeredDirectory("main:/a", "main:/", "la");
            fService.createLayeredDirectory("main:/d", "main:/", "ld");
            fService.createSnapshot("main", null, null);
            fService.rename("main:/ld/e", "f", "main:/la/b", "f");
            fService.createSnapshot("main", null, null);
            AVMNodeDescriptor desc = fService.lookup(-1, "main:/la/b/f");
            AVMServiceTest.assertTrue((boolean)desc.isPrimary());
            AVMServiceTest.assertEquals((String)"main:/d/e/f", (String)desc.getIndirection());
            fService.rename("main:/la/b", "f", "main:/la/b/c", "f");
            fService.createSnapshot("main", null, null);
            desc = fService.lookup(-1, "main:/la/b/c/f");
            AVMServiceTest.assertTrue((boolean)desc.isPrimary());
            AVMServiceTest.assertEquals((String)"main:/d/e/f", (String)desc.getIndirection());
            fService.createDirectory("main:/la/b/c/f", "dir");
            fService.createSnapshot("main", null, null);
            desc = fService.lookup(-1, "main:/la/b/c/f/dir");
            AVMServiceTest.assertFalse((boolean)desc.isPrimary());
            AVMServiceTest.assertEquals((String)"main:/d/e/f/dir", (String)desc.getIndirection());
            fService.rename("main:/la/b/c/f", "dir", "main:/la/b", "dir");
            fService.createSnapshot("main", null, null);
            desc = fService.lookup(-1, "main:/la/b/dir");
            AVMServiceTest.assertFalse((boolean)desc.isPrimary());
            AVMServiceTest.assertEquals((String)"main:/a/b/dir", (String)desc.getIndirection());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    protected void runQueriesForInitialRenameStructure(String store) throws Exception {
        StoreRef storeRef = AVMNodeConverter.ToStoreRef(store);
        SearchService searchService = fIndexerAndSearcher.getSearcher(AVMNodeConverter.ToStoreRef(store), true);
        ResultSet results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_CREATOR)) + ":admin");
        AVMServiceTest.assertEquals((int)7, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_MODIFIER)) + ":admin");
        AVMServiceTest.assertEquals((int)7, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_OWNER)) + ":admin");
        AVMServiceTest.assertEquals((int)7, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_NODE_UUID)) + ":unknown");
        AVMServiceTest.assertEquals((int)7, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_STORE_PROTOCOL)) + ":avm");
        AVMServiceTest.assertEquals((int)7, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_STORE_IDENTIFIER)) + ":" + store);
        AVMServiceTest.assertEquals((int)7, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a/b\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a/b/c\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/d\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/d/e\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/d/e/f\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"//.\"");
        AVMServiceTest.assertEquals((int)7, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"//*\"");
        AVMServiceTest.assertEquals((int)6, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a//.\"");
        AVMServiceTest.assertEquals((int)3, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a//*\"");
        AVMServiceTest.assertEquals((int)2, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a/*\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"//c/*\"");
        AVMServiceTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/*\"");
        AVMServiceTest.assertEquals((int)2, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/*/*\"");
        AVMServiceTest.assertEquals((int)2, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/*/*/*\"");
        AVMServiceTest.assertEquals((int)2, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/*/*/*/*\"");
        AVMServiceTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/*/*/*/*/*\"");
        AVMServiceTest.assertEquals((int)0, (int)results.length());
        results.close();
    }

    protected void runQueriesForInitialRenameStructureAndInitialLayers(String store) {
        StoreRef storeRef = AVMNodeConverter.ToStoreRef(store);
        SearchService searchService = fIndexerAndSearcher.getSearcher(AVMNodeConverter.ToStoreRef(store), true);
        ResultSet results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_CREATOR)) + ":admin");
        AVMServiceTest.assertEquals((int)9, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_MODIFIER)) + ":admin");
        AVMServiceTest.assertEquals((int)7, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_OWNER)) + ":admin");
        AVMServiceTest.assertEquals((int)7, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_NODE_UUID)) + ":unknown");
        AVMServiceTest.assertEquals((int)7, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_STORE_PROTOCOL)) + ":avm");
        AVMServiceTest.assertEquals((int)7, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_STORE_IDENTIFIER)) + ":" + store);
        AVMServiceTest.assertEquals((int)7, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a/b\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a/b/c\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/d\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/d/e\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/d/e/f\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"//.\"");
        AVMServiceTest.assertEquals((int)7, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"//*\"");
        AVMServiceTest.assertEquals((int)6, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a//.\"");
        AVMServiceTest.assertEquals((int)3, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a//*\"");
        AVMServiceTest.assertEquals((int)2, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a/*\"");
        AVMServiceTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"//c/*\"");
        AVMServiceTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/*\"");
        AVMServiceTest.assertEquals((int)2, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/*/*\"");
        AVMServiceTest.assertEquals((int)2, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/*/*/*\"");
        AVMServiceTest.assertEquals((int)2, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/*/*/*/*\"");
        AVMServiceTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/*/*/*/*/*\"");
        AVMServiceTest.assertEquals((int)0, (int)results.length());
        results.close();
    }

    public void testFileRenameLayer() throws Exception {
        try {
            fService.createDirectory("main:/", "a");
            fService.createDirectory("main:/a", "b");
            fService.createDirectory("main:/a/b", "c");
            fService.createFile("main:/", "foo").close();
            fService.createSnapshot("main", null, null);
            fService.createLayeredDirectory("main:/a", "main:/", "la");
            fService.createSnapshot("main", null, null);
            fService.createLayeredFile("main:/foo", "main:/la/b", "foo");
            fService.createSnapshot("main", null, null);
            AVMNodeDescriptor desc = fService.lookup(-1, "main:/la/b/foo");
            AVMServiceTest.assertEquals((String)"main:/foo", (String)desc.getIndirection());
            fService.rename("main:/la/b", "foo", "main:/la", "foo");
            fService.createSnapshot("main", null, null);
            desc = fService.lookup(-1, "main:/la/foo");
            AVMServiceTest.assertEquals((String)"main:/foo", (String)desc.getIndirection());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testCOWLongOps() throws Exception {
        try {
            this.setupBasicTree();
            fService.createLayeredDirectory("main:/a", "main:/d/e/f", "layer");
            fService.createLayeredDirectory("main:/d", "main:/", "l2");
            fService.createFile("main:/l2", "baz").close();
            fService.createFile("main:/d/e/f/layer/b/c", "fink").close();
            fService.createFile("main:/l2/e/f/layer/b/c", "nottle").close();
            fService.createSnapshot("main", null, null);
            System.out.println(this.recursiveList("main", -1, true));
            AVMServiceTest.assertFalse((fService.lookup(-1, "main:/d/e/f/layer/b/c").getId() == fService.lookup(-1, "main:/l2/e/f/layer/b/c").getId() ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testLookup() throws Exception {
        try {
            this.setupBasicTree();
            AVMNodeDescriptor desc = fService.getStoreRoot(-1, "main");
            AVMServiceTest.assertNotNull((Object)desc);
            System.out.println(desc.toString());
            AVMNodeDescriptor child = fService.lookup(desc, "a");
            AVMServiceTest.assertNotNull((Object)child);
            System.out.println(child.toString());
            child = fService.lookup(child, "b");
            AVMServiceTest.assertNotNull((Object)child);
            System.out.println(child.toString());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testAVMStore() throws Exception {
        try {
            try {
                fService.createStore("main");
                AVMServiceTest.fail();
            }
            catch (AVMExistsException ae) {
                // empty catch block
            }
            AVMStoreDescriptor desc = fService.getStore("main");
            AVMServiceTest.assertNotNull((Object)desc);
            System.out.println(desc);
            fService.purgeStore("main");
            AVMServiceTest.assertNull((Object)fService.getStore("main"));
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testOpacity() throws Exception {
        try {
            this.setupBasicTree();
            fService.createLayeredDirectory("main:/a", "main:/", "layer");
            fService.createSnapshot("main", null, null);
            fService.createFile("main:/layer/b/c", "baz").close();
            fService.createFile("main:/layer/b/c", "fig").close();
            fService.createSnapshot("main", null, null);
            SortedMap<String, AVMNodeDescriptor> listing = fService.getDirectoryListing(-1, "main:/layer/b/c");
            AVMServiceTest.assertEquals((int)4, (int)listing.size());
            System.out.println(this.recursiveList("main", -1, true));
            fService.setOpacity("main:/layer", true);
            fService.createSnapshot("main", null, null);
            AVMServiceTest.assertTrue((boolean)fService.lookup(-1, "main:/layer").getOpacity());
            AVMServiceTest.assertEquals((int)4, (int)fService.getDirectoryListing(-1, "main:/layer/b/c").size());
            System.out.println(this.recursiveList("main", -1, true));
            fService.setOpacity("main:/layer", false);
            fService.setOpacity("main:/layer/b/c", true);
            fService.createSnapshot("main", null, null);
            AVMServiceTest.assertFalse((boolean)fService.lookup(-1, "main:/layer").getOpacity());
            AVMServiceTest.assertTrue((boolean)fService.lookup(-1, "main:/layer/b/c").getOpacity());
            AVMServiceTest.assertEquals((int)2, (int)fService.getDirectoryListing(-1, "main:/layer/b/c").size());
            System.out.println(this.recursiveList("main", -1, true));
            fService.retargetLayeredDirectory("main:/layer", "main:/d");
            fService.setOpacity("main:/layer/b/c", false);
            fService.createSnapshot("main", null, null);
            AVMServiceTest.assertFalse((boolean)fService.lookup(-1, "main:/layer/b/c").getOpacity());
            AVMServiceTest.assertEquals((int)2, (int)fService.getDirectoryListing(-1, "main:/layer/b/c").size());
            fService.setOpacity("main:/layer/e/f", true);
            System.out.println(this.recursiveList("main", -1, true));
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testCommonAncestor() throws Exception {
        try {
            this.setupBasicTree();
            fService.createBranch(-1, "main:/a", "main:/", "branch");
            fService.createSnapshot("main", null, null);
            AVMNodeDescriptor ancestor = fService.lookup(-1, "main:/a/b/c/foo");
            fService.getFileOutputStream("main:/a/b/c/foo").close();
            fService.getFileOutputStream("main:/branch/b/c/foo").close();
            fService.createSnapshot("main", null, null);
            AVMNodeDescriptor main = fService.lookup(-1, "main:/a/b/c/foo");
            AVMNodeDescriptor branch = fService.lookup(-1, "main:/branch/b/c/foo");
            AVMNodeDescriptor ca = fService.getCommonAncestor(main, branch);
            AVMServiceTest.assertEquals((Object)ancestor, (Object)ca);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testStoreProperties() throws Exception {
        try {
            Map<QName, PropertyValue> props = fService.getStoreProperties("main");
            AVMServiceTest.assertEquals((int)2, (int)props.size());
            AVMServiceTest.assertEquals((String)AuthenticationUtil.getAdminUserName(), (String)props.get(ContentModel.PROP_CREATOR).getStringValue());
            AVMServiceTest.assertNotNull((Object)props.get(ContentModel.PROP_CREATED));
            System.out.println(props.toString());
            QName name = QName.createQName((String)"silly.uri", (String)"SillyProperty");
            PropertyValue value = new PropertyValue(DataTypeDefinition.TEXT, (Serializable)((Object)"Silly Property Value"));
            fService.setStoreProperty("main", name, value);
            PropertyValue found = fService.getStoreProperty("main", name);
            AVMServiceTest.assertEquals((String)value.toString(), (String)found.toString());
            props = fService.getStoreProperties("main");
            AVMServiceTest.assertEquals((int)3, (int)props.size());
            props = new HashMap<QName, PropertyValue>(5);
            QName n1 = QName.createQName((String)"silly.uri", (String)"Prop1");
            PropertyValue p1 = new PropertyValue(null, new Date(System.currentTimeMillis()));
            props.put(n1, p1);
            QName n2 = QName.createQName((String)"silly.uri", (String)"Prop2");
            PropertyValue p2 = new PropertyValue(null, (Serializable)((Object)"A String Property."));
            props.put(n2, p2);
            QName n3 = QName.createQName((String)"silly.uri", (String)"Prop3");
            PropertyValue p3 = new PropertyValue(null, Integer.valueOf(42));
            props.put(n3, p3);
            QName n4 = QName.createQName((String)"silly.uri", (String)"Prop4");
            PropertyValue p4 = new PropertyValue(null, new Boolean(false));
            props.put(n4, p4);
            QName n5 = QName.createQName((String)"silly.uri", (String)"Prop5");
            ArrayList<String> strList = new ArrayList<String>(2);
            strList.add("hello");
            strList.add("world");
            PropertyValue p5 = new PropertyValue(DataTypeDefinition.TEXT, strList);
            props.put(n5, p5);
            fService.setStoreProperties("main", props);
            props = fService.getStoreProperties("main");
            System.out.println(props.toString());
            AVMServiceTest.assertEquals((int)8, (int)props.size());
            AVMServiceTest.assertEquals((String)p1.toString(), (String)props.get(n1).toString());
            AVMServiceTest.assertEquals((String)p2.toString(), (String)props.get(n2).toString());
            AVMServiceTest.assertEquals((String)p3.toString(), (String)props.get(n3).toString());
            AVMServiceTest.assertEquals((String)p4.toString(), (String)props.get(n4).toString());
            AVMServiceTest.assertEquals((String)p5.toString(), (String)props.get(n5).toString());
            props = new HashMap<QName, PropertyValue>(5);
            n1 = QName.createQName((String)"silly.uri", (String)"Prop1");
            p1 = new PropertyValue(null, new Date(System.currentTimeMillis()));
            props.put(n1, p1);
            n2 = QName.createQName((String)"silly.uri", (String)"Prop2");
            p2 = new PropertyValue(null, (Serializable)((Object)"A String Property - updated."));
            props.put(n2, p2);
            n3 = QName.createQName((String)"silly.uri", (String)"Prop3");
            p3 = new PropertyValue(null, Integer.valueOf(-42));
            props.put(n3, p3);
            n4 = QName.createQName((String)"silly.uri", (String)"Prop4");
            p4 = new PropertyValue(null, new Boolean(true));
            props.put(n4, p4);
            n5 = QName.createQName((String)"silly.uri", (String)"Prop5");
            strList = new ArrayList(2);
            strList.add("goodbye");
            strList.add("world");
            p5 = new PropertyValue(DataTypeDefinition.TEXT, strList);
            props.put(n5, p5);
            fService.setStoreProperties("main", props);
            props = fService.getStoreProperties("main");
            System.out.println(props.toString());
            AVMServiceTest.assertEquals((int)8, (int)props.size());
            AVMServiceTest.assertEquals((String)p1.toString(), (String)props.get(n1).toString());
            AVMServiceTest.assertEquals((String)p2.toString(), (String)props.get(n2).toString());
            AVMServiceTest.assertEquals((String)p3.toString(), (String)props.get(n3).toString());
            AVMServiceTest.assertEquals((String)p4.toString(), (String)props.get(n4).toString());
            AVMServiceTest.assertEquals((String)p5.toString(), (String)props.get(n5).toString());
            fService.deleteStoreProperty("main", name);
            props = fService.getStoreProperties("main");
            AVMServiceTest.assertEquals((int)7, (int)props.size());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testAspectNames() throws Exception {
        try {
            this.setupBasicTree();
            StoreRef storeRef = AVMNodeConverter.ToStoreRef("main");
            SearchService searchService = fIndexerAndSearcher.getSearcher(storeRef, true);
            ResultSet results = searchService.query(storeRef, "lucene", "ASPECT:\"" + ContentModel.ASPECT_TITLED.toString() + "\"");
            AVMServiceTest.assertEquals((int)0, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "ASPECT:\"" + ContentModel.ASPECT_AUDITABLE.toString() + "\"");
            AVMServiceTest.assertEquals((int)0, (int)results.length());
            results.close();
            fService.addAspect("main:/a/b/c/foo", ContentModel.ASPECT_TITLED);
            fService.addAspect("main:/a/b/c/foo", ContentModel.ASPECT_AUDITABLE);
            HashMap<QName, PropertyValue> properties = new HashMap<QName, PropertyValue>();
            properties.put(ContentModel.PROP_ACCESSED, new PropertyValue(DataTypeDefinition.DATETIME, new Date(System.currentTimeMillis())));
            properties.put(ContentModel.PROP_CREATED, new PropertyValue(DataTypeDefinition.DATETIME, new Date(System.currentTimeMillis())));
            properties.put(ContentModel.PROP_MODIFIED, new PropertyValue(DataTypeDefinition.DATETIME, new Date(System.currentTimeMillis())));
            properties.put(ContentModel.PROP_CREATOR, new PropertyValue(DataTypeDefinition.TEXT, (Serializable)((Object)"Giles")));
            properties.put(ContentModel.PROP_MODIFIER, new PropertyValue(DataTypeDefinition.TEXT, (Serializable)((Object)"Quentin")));
            fService.setNodeProperties("main:/a/b/c/foo", properties);
            fService.createSnapshot("main", null, null);
            results = searchService.query(storeRef, "lucene", "ASPECT:\"" + ContentModel.ASPECT_TITLED.toString() + "\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "ASPECT:\"" + ContentModel.ASPECT_AUDITABLE.toString() + "\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            fService.removeNode("main:/a/b/c/bar");
            fService.addAspect("main:/a/b/c/bar", ContentModel.ASPECT_TITLED);
            Set<QName> names = fService.getAspects(-1, "main:/a/b/c/foo");
            AVMServiceTest.assertEquals((int)2, (int)names.size());
            AVMServiceTest.assertTrue((boolean)fService.hasAspect(-1, "main:/a/b/c/foo", ContentModel.ASPECT_TITLED));
            AVMServiceTest.assertFalse((boolean)fService.hasAspect(-1, "main:/a/b/c/foo", ContentModel.ASPECT_AUTHOR));
            AVMServiceTest.assertTrue((boolean)fService.hasAspect(-1, "main:/a/b/c/foo", ContentModel.ASPECT_TITLED));
            fService.removeAspect("main:/a/b/c/foo", ContentModel.ASPECT_TITLED);
            fService.createSnapshot("main", null, null);
            results = searchService.query(storeRef, "lucene", "ASPECT:\"" + ContentModel.ASPECT_TITLED.toString() + "\"");
            AVMServiceTest.assertEquals((int)0, (int)results.length());
            results.close();
            results = searchService.query(storeRef, "lucene", "ASPECT:\"" + ContentModel.ASPECT_AUDITABLE.toString() + "\"");
            AVMServiceTest.assertEquals((int)1, (int)results.length());
            results.close();
            fService.getFileOutputStream("main:/a/b/c/foo").close();
            AVMServiceTest.assertFalse((boolean)fService.hasAspect(-1, "main:/a/b/c/foo", ContentModel.ASPECT_TITLED));
            AVMServiceTest.assertTrue((boolean)fService.hasAspect(-1, "main:/a/b/c/foo", ContentModel.ASPECT_AUDITABLE));
            Map<QName, PropertyValue> props = fService.getNodeProperties(-1, "main:/a/b/c/foo");
            AVMServiceTest.assertEquals((int)5, (int)props.size());
            fService.removeAspect("main:/a/b/c/foo", ContentModel.ASPECT_AUDITABLE);
            props = fService.getNodeProperties(-1, "main:/a/b/c/foo");
            AVMServiceTest.assertEquals((int)0, (int)props.size());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testCaseInsensitive() throws Exception {
        String storeName = "caseIn";
        String storeNameUpper = storeName.toUpperCase();
        String storeNameLower = storeName.toLowerCase();
        try {
            fService.createStore(storeName);
            try {
                fService.createStore(storeNameUpper);
                AVMServiceTest.fail();
            }
            catch (AVMExistsException e) {
                // empty catch block
            }
            AVMStoreDescriptor storeDesc1 = fService.getStore(storeNameUpper);
            AVMServiceTest.assertNotNull((Object)storeDesc1);
            AVMServiceTest.assertEquals((String)storeName, (String)storeDesc1.getName());
            AVMStoreDescriptor storeDesc2 = fService.getStore(storeNameLower);
            AVMServiceTest.assertNotNull((Object)storeDesc2);
            AVMServiceTest.assertEquals((String)storeName, (String)storeDesc2.getName());
            AVMServiceTest.assertEquals((Object)storeDesc1, (Object)storeDesc2);
            fService.createDirectory(storeName + ":/", "a");
            fService.createDirectory(storeName + ":/a", "B");
            fService.createDirectory(storeName + ":/a/B", "c");
            fService.createFile(storeName + ":/a/B/c", "Foo").close();
            AVMNodeDescriptor desc1 = fService.lookup(-1, storeNameUpper + ":/A/B/C/FOO");
            AVMServiceTest.assertNotNull((Object)desc1);
            AVMServiceTest.assertEquals((String)(storeName + ":/a/B/c/Foo"), (String)desc1.getPath());
            try {
                fService.createFile(storeName + ":/a/B/c", "FoO").close();
                AVMServiceTest.fail();
            }
            catch (AVMExistsException e) {
                // empty catch block
            }
            AVMNodeDescriptor desc2 = fService.lookup(-1, storeNameLower + ":/a/b/c/foo");
            AVMServiceTest.assertNotNull((Object)desc2);
            AVMServiceTest.assertEquals((String)(storeName + ":/a/B/c/Foo"), (String)desc2.getPath());
            AVMServiceTest.assertEquals((Object)desc1, (Object)desc2);
            desc1 = fService.lookup(-1, storeNameUpper + ":/A/B/C");
            AVMServiceTest.assertNotNull((Object)desc1);
            AVMServiceTest.assertEquals((String)(storeName + ":/a/B/c"), (String)desc1.getPath());
            try {
                fService.createFile(storeName + ":/a/b", "C").close();
                AVMServiceTest.fail();
            }
            catch (AVMExistsException e) {
                // empty catch block
            }
            desc2 = fService.lookup(-1, storeNameLower + ":/a/b/c");
            AVMServiceTest.assertNotNull((Object)desc2);
            AVMServiceTest.assertEquals((String)(storeName + ":/a/B/c"), (String)desc2.getPath());
            AVMServiceTest.assertEquals((Object)desc1, (Object)desc2);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
        finally {
            fService.purgeStore(storeName);
        }
    }

    public void testACLs() throws Exception {
        try {
            this.setupBasicTree();
            PermissionService perm = (PermissionService)fContext.getBean("PermissionService");
            perm.setPermission(AVMNodeConverter.ToNodeRef(-1, "main:/a/b/c/foo"), "ROLE_ADMINISTRATOR", "All", true);
            fService.createSnapshot("main", null, null);
            fService.getFileOutputStream("main:/a/b/c/foo").close();
            Set perms = perm.getPermissions(AVMNodeConverter.ToNodeRef(-1, "main:/a/b/c/foo"));
            for (AccessPermission permission : perms) {
                System.out.println(permission);
            }
            AVMServiceTest.assertTrue((perms.size() > 0 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testFileFolderService() throws Exception {
        try {
            this.setupBasicTree();
            FileFolderService ffs = (FileFolderService)fContext.getBean("FileFolderService");
            AVMServiceTest.assertTrue((ffs.create(AVMNodeConverter.ToNodeRef(-1, "main:/a/b/c/"), "banana", WCMModel.TYPE_AVM_PLAIN_CONTENT) != null ? 1 : 0) != 0);
            AVMServiceTest.assertTrue((ffs.create(AVMNodeConverter.ToNodeRef(-1, "main://"), "banana", WCMModel.TYPE_AVM_PLAIN_CONTENT) != null ? 1 : 0) != 0);
            AVMServiceTest.assertTrue((ffs.create(AVMNodeConverter.ToNodeRef(-1, "main:/a/b/c"), "apples", WCMModel.TYPE_AVM_PLAIN_FOLDER) != null ? 1 : 0) != 0);
            NodeService ns = (NodeService)fContext.getBean("NodeService");
            HashMap<QName, NodeRef> properties = new HashMap<QName, NodeRef>();
            properties.put(WCMModel.PROP_AVM_DIR_INDIRECTION, AVMNodeConverter.ToNodeRef(-1, "main:/a"));
            AVMServiceTest.assertTrue((ns.createNode(AVMNodeConverter.ToNodeRef(-1, "main:/"), ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)"layer"), WCMModel.TYPE_AVM_LAYERED_FOLDER, properties) != null ? 1 : 0) != 0);
            AVMServiceTest.assertTrue((ns.getProperty(AVMNodeConverter.ToNodeRef(-1, "main:/layer"), WCMModel.PROP_AVM_DIR_INDIRECTION) != null ? 1 : 0) != 0);
            properties.clear();
            properties.put(WCMModel.PROP_AVM_FILE_INDIRECTION, AVMNodeConverter.ToNodeRef(-1, "main:/a/b/c/foo"));
            AVMServiceTest.assertTrue((ns.createNode(AVMNodeConverter.ToNodeRef(-1, "main:/"), ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)"foo"), WCMModel.TYPE_AVM_LAYERED_CONTENT, properties) != null ? 1 : 0) != 0);
            AVMServiceTest.assertTrue((ns.getProperty(AVMNodeConverter.ToNodeRef(-1, "main:/foo"), WCMModel.PROP_AVM_FILE_INDIRECTION) != null ? 1 : 0) != 0);
            fService.createSnapshot("main", null, null);
            System.out.println(this.recursiveList("main", -1, true));
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testOverwrite() throws Exception {
        try {
            this.setupBasicTree();
            TransactionService transactionService = (TransactionService)fContext.getBean("transactionService");
            RetryingTransactionHelper helper = transactionService.getRetryingTransactionHelper();
            class TxnCallback
            implements RetryingTransactionHelper.RetryingTransactionCallback<Object> {
                TxnCallback() {
                }

                @Override
                public Object execute() throws Exception {
                    try {
                        AVMService service = (AVMService)AVMServiceTestBase.fContext.getBean("avmService");
                        service.createLayeredDirectory("main:/a", "main:/", "layer");
                        service.getFileOutputStream("main:/a/b/c/foo").close();
                        service.getFileOutputStream("main:/a/b/c/foo").close();
                        service.getFileOutputStream("main:/a/b/c/foo").close();
                        service.createFile("main:/a/b/c", "pint").close();
                        service.createFile("main:/a/b/c", "quart").close();
                        service.getFileOutputStream("main:/a/b/c/bar").close();
                        service.getFileOutputStream("main:/a/b/c/bar").close();
                        service.lookup(-1, "main:/a/b/c");
                        service.createFile("main:/a/b/c", "figment").close();
                        service.getFileOutputStream("main:/layer/b/c/foo").close();
                        service.getFileOutputStream("main:/layer/b/c/foo").close();
                        service.getFileOutputStream("main:/layer/b/c/foo").close();
                        service.createFile("main:/layer/b/c", "gallon").close();
                        service.createFile("main:/layer/b/c", "dram").close();
                        service.getFileOutputStream("main:/layer/b/c/bar").close();
                        service.getFileOutputStream("main:/layer/b/c/bar").close();
                        try {
                            service.lookup(-1, "main:/a/b/c/froo");
                        }
                        catch (AVMException ae) {
                            // empty catch block
                        }
                        service.createDirectory("main:/a/b/c", "froo");
                        service.createFile("main:/a/b/c/froo", "franistan").close();
                        try {
                            service.lookup(-1, "main:/layer/b/c/groo");
                        }
                        catch (AVMException aVMException) {
                            // empty catch block
                        }
                        service.createDirectory("main:/layer/b/c", "groo");
                        service.createFile("main:/layer/b/c/groo", "granistan").close();
                        return null;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        throw e;
                    }
                }
            }
            helper.doInTransaction(new TxnCallback(), false);
            AVMServiceTest.assertNotNull((Object)fService.lookup(-1, "main:/layer/b/c/groo"));
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testCreateOverDeleted() throws Exception {
        try {
            this.setupBasicTree();
            fService.removeNode("main:/a/b/c", "foo");
            fService.createFile("main:/a/b/c", "foo").close();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testDeleted() throws Exception {
        try {
            this.setupBasicTree();
            fService.createLayeredDirectory("main:/a", "main:/", "layer");
            fService.removeNode("main:/a/b/c", "foo");
            AVMNodeDescriptor desc = fService.lookup(-1, "main:/a/b/c/foo", true);
            AVMServiceTest.assertTrue((boolean)desc.isDeleted());
            AVMServiceTest.assertTrue((boolean)desc.isDeletedFile());
            SortedMap<String, AVMNodeDescriptor> listing = fService.getDirectoryListing(-1, "main:/a/b/c", true);
            AVMServiceTest.assertEquals((int)2, (int)listing.size());
            AVMServiceTest.assertTrue((boolean)((AVMNodeDescriptor)listing.get("foo")).isDeleted());
            AVMNodeDescriptor dir = fService.lookup(-1, "main:/a/b/c", true);
            desc = fService.lookup(dir, "foo", true);
            AVMServiceTest.assertTrue((boolean)desc.isDeleted());
            listing = fService.getDirectoryListing(dir, true);
            AVMServiceTest.assertEquals((int)2, (int)listing.size());
            AVMServiceTest.assertTrue((boolean)((AVMNodeDescriptor)listing.get("foo")).isDeleted());
            desc = fService.lookup(-1, "main:/layer/b/c/foo", true);
            AVMServiceTest.assertTrue((boolean)desc.isDeleted());
            listing = fService.getDirectoryListing(-1, "main:/layer/b/c", true);
            AVMServiceTest.assertEquals((int)2, (int)listing.size());
            AVMServiceTest.assertTrue((boolean)((AVMNodeDescriptor)listing.get("foo")).isDeleted());
            dir = fService.lookup(-1, "main:/layer/b/c", true);
            listing = fService.getDirectoryListing(dir, true);
            AVMServiceTest.assertEquals((int)2, (int)listing.size());
            AVMServiceTest.assertTrue((boolean)((AVMNodeDescriptor)listing.get("foo")).isDeleted());
            fService.removeNode("main:/layer/b/c", "bar");
            desc = fService.lookup(-1, "main:/layer/b/c/bar", true);
            AVMServiceTest.assertTrue((boolean)desc.isDeleted());
            AVMServiceTest.assertTrue((boolean)desc.isDeletedFile());
            listing = fService.getDirectoryListing(-1, "main:/layer/b/c", true);
            AVMServiceTest.assertEquals((int)2, (int)listing.size());
            AVMServiceTest.assertTrue((boolean)((AVMNodeDescriptor)listing.get("foo")).isDeleted());
            AVMServiceTest.assertTrue((boolean)((AVMNodeDescriptor)listing.get("bar")).isDeleted());
            listing = fService.getDirectoryListingDirect(-1, "main:/layer/b/c", true);
            AVMServiceTest.assertEquals((int)1, (int)listing.size());
            AVMServiceTest.assertTrue((boolean)((AVMNodeDescriptor)listing.get("bar")).isDeleted());
            dir = fService.lookup(-1, "main:/layer/b/c", true);
            desc = fService.lookup(dir, "bar", true);
            AVMServiceTest.assertTrue((boolean)desc.isDeleted());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public void testStorePropertyQuerying() throws Exception {
        try {
            fService.setStoreProperty("main", QName.createQName(null, (String)".dns.alice--preview"), new PropertyValue(null, (Serializable)((Object)"alice-preview")));
            fService.setStoreProperty("main", QName.createQName((String)"", (String)".other.property"), new PropertyValue(null, (Serializable)((Object)"other value")));
            Map<QName, PropertyValue> result = fService.queryStorePropertyKey("main", QName.createQName((String)"", (String)".dns.%"));
            AVMServiceTest.assertEquals((int)1, (int)result.size());
            fService.createStore("second");
            fService.setStoreProperty("second", QName.createQName((String)"", (String)".dns.alice"), new PropertyValue(null, (Serializable)((Object)"alice-space")));
            Map<String, Map<QName, PropertyValue>> matches = fService.queryStoresPropertyKeys(QName.createQName((String)"", (String)".dns.%"));
            AVMServiceTest.assertEquals((int)1, (int)matches.get("main").size());
            AVMServiceTest.assertEquals((int)1, (int)matches.get("second").size());
            AVMServiceTest.assertEquals((String)"alice-preview", (String)matches.get("main").get(QName.createQName(null, (String)".dns.alice--preview")).getStringValue());
            AVMServiceTest.assertEquals((String)"alice-space", (String)matches.get("second").get(QName.createQName(null, (String)".dns.alice")).getStringValue());
            fService.createStore("third");
            fService.setStoreProperty("third", QName.createQName((String)"", (String)".dns.someUPPERcase"), new PropertyValue(null, (Serializable)((Object)"someUPPERcase-space")));
            matches = fService.queryStoresPropertyKeys(QName.createQName((String)"", (String)".dns.someuppercase%"));
            AVMServiceTest.assertNotNull(matches.get("third"));
            AVMServiceTest.assertEquals((int)1, (int)matches.get("third").size());
            AVMServiceTest.assertEquals((String)"someUPPERcase-space", (String)matches.get("third").get(QName.createQName(null, (String)".dns.someUPPERcase")).getStringValue());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
        finally {
            fService.purgeStore("second");
            fService.purgeStore("third");
        }
    }

    private static enum DiffActionEnum {
        CREATION,
        MODIFICATION,
        DELETION,
        DELETION_AND_MODIFICATION;

    }
}

