/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import org.alfresco.service.cmr.avm.AVMException;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.repository.ContentIOException;

class AVMTester
implements Runnable {
    private static final int CREATE_FILE = 0;
    private static final int CREATE_DIR = 1;
    private static final int RENAME = 2;
    private static final int CREATE_LAYERED_DIR = 3;
    private static final int CREATE_LAYERED_FILE = 4;
    private static final int REMOVE_NODE = 5;
    private static final int MODIFY_FILE = 6;
    private static final int READ_FILE = 7;
    private static final int SNAPSHOT = 8;
    private List<String> fAllPaths;
    private List<String> fAllDirectories;
    private List<String> fAllFiles;
    private static int fgOpCount = 0;
    private int[] fOpTable;
    private int fOpCount;
    private AVMService fService;
    private static Random fgRandom = new Random();
    private String[] fNames;
    private boolean fError = false;
    private String fErrorStackTrace = null;
    private boolean fExit = false;

    public AVMTester(int createFile, int createDir, int rename, int createLayeredDir, int createLayeredFile, int removeNode, int modifyFile, int readFile, int snapshot, int opCount, AVMService service) {
        int i;
        this.fService = service;
        this.fOpCount = opCount;
        int count = createFile + createDir + rename + createLayeredDir + createLayeredFile + removeNode + modifyFile + readFile + snapshot;
        this.fOpTable = new int[count];
        int off = 0;
        for (i = 0; i < createFile; ++i) {
            this.fOpTable[off + i] = 0;
        }
        off += createFile;
        for (i = 0; i < createDir; ++i) {
            this.fOpTable[off + i] = 1;
        }
        off += createDir;
        for (i = 0; i < rename; ++i) {
            this.fOpTable[off + i] = 2;
        }
        off += rename;
        for (i = 0; i < createLayeredDir; ++i) {
            this.fOpTable[off + i] = 3;
        }
        off += createLayeredDir;
        for (i = 0; i < createLayeredFile; ++i) {
            this.fOpTable[off + i] = 4;
        }
        off += createLayeredFile;
        for (i = 0; i < removeNode; ++i) {
            this.fOpTable[off + i] = 5;
        }
        off += removeNode;
        for (i = 0; i < modifyFile; ++i) {
            this.fOpTable[off + i] = 6;
        }
        off += modifyFile;
        for (i = 0; i < readFile; ++i) {
            this.fOpTable[off + i] = 7;
        }
        off += readFile;
        for (i = 0; i < snapshot; ++i) {
            this.fOpTable[off + i] = 8;
        }
        off += snapshot;
        String[] letters = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
        this.fNames = new String[676];
        for (int i2 = 0; i2 < 26; ++i2) {
            for (int j = 0; j < 26; ++j) {
                this.fNames[i2 * 26 + j] = letters[i2] + letters[j];
            }
        }
    }

    @Override
    public void run() {
        try {
            long threadID = Thread.currentThread().getId();
            long startTime = System.currentTimeMillis();
            for (int i = 0; i < this.fOpCount; ++i) {
                if (this.fExit) {
                    return;
                }
                System.out.print(threadID + ":" + i + ":");
                int which = fgRandom.nextInt(this.fOpTable.length);
                try {
                    switch (this.fOpTable[which]) {
                        case 0: {
                            this.createFile();
                            break;
                        }
                        case 1: {
                            this.createDirectory();
                            break;
                        }
                        case 2: {
                            this.rename();
                            break;
                        }
                        case 3: {
                            this.createLayeredDir();
                            break;
                        }
                        case 4: {
                            this.createLayeredFile();
                            break;
                        }
                        case 5: {
                            this.removeNode();
                            break;
                        }
                        case 6: {
                            this.modifyFile();
                            break;
                        }
                        case 7: {
                            this.readFile();
                            break;
                        }
                        case 8: {
                            this.snapshot();
                        }
                    }
                    AVMTester.IncCount();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    if (e instanceof AVMException || e instanceof ContentIOException) continue;
                    throw new AVMException("Failure", e);
                }
            }
            System.out.println(this.fAllPaths.size() + " fses in " + (System.currentTimeMillis() - startTime) + "ms");
        }
        catch (Throwable t) {
            t.printStackTrace();
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            this.fError = true;
            this.fErrorStackTrace = sw.toString();
        }
    }

    private void createFile() {
        String name = "PF" + this.fNames[fgRandom.nextInt(676)];
        String path = this.randomDirectory();
        if (path != null) {
            try {
                System.out.println("create " + path + " " + name);
                PrintStream out = new PrintStream(this.fService.createFile(path, name));
                out.println(path + "/" + name);
                out.close();
                this.addFile(this.appendPath(path, name));
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    private void createDirectory() {
        String name = "PD" + this.fNames[fgRandom.nextInt(676)];
        String path = this.randomDirectory();
        if (path != null) {
            try {
                System.out.println("mkdir " + path + " " + name);
                this.fService.createDirectory(path, name);
                this.addDirectory(this.appendPath(path, name));
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    private void rename() {
        String name = this.fNames[fgRandom.nextInt(676)];
        String path = this.randomPath();
        if (path == null) {
            return;
        }
        AVMNodeDescriptor desc = this.fService.lookup(-1, path);
        if (desc == null) {
            return;
        }
        if (path.equals("main:/")) {
            return;
        }
        int lastSlash = path.lastIndexOf(47);
        String srcPath = path.substring(0, lastSlash);
        if (srcPath.equals("main:")) {
            srcPath = srcPath + "/";
        }
        String srcName = path.substring(lastSlash + 1);
        String dstPath = this.randomDirectory();
        if (dstPath != null) {
            try {
                System.out.println("rename " + srcPath + " " + srcName + " " + dstPath + " " + name);
                this.fService.rename(srcPath, srcName, dstPath, name);
                this.removePath(path);
                if (desc.isDirectory()) {
                    this.addDirectory(this.appendPath(dstPath, name));
                } else {
                    this.addFile(this.appendPath(dstPath, name));
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    private void createLayeredDir() {
        String name = "LD" + this.fNames[fgRandom.nextInt(676)];
        String path = this.randomDirectory();
        String target = this.randomDirectory();
        if (path != null && target != null) {
            try {
                System.out.println("mklayereddir " + path + " " + name + " " + target);
                this.fService.createLayeredDirectory(target, path, name);
                this.addDirectory(this.appendPath(path, name));
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    private void createLayeredFile() {
        String name = "LF" + this.fNames[fgRandom.nextInt(676)];
        String path = this.randomDirectory();
        String target = this.randomFile();
        if (path != null && target != null) {
            try {
                System.out.println("createlayered " + path + " " + name + " " + target);
                this.fService.createLayeredFile(target, path, name);
                this.addFile(this.appendPath(path, name));
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    private void removeNode() {
        String target = this.randomPath();
        if (target == null) {
            return;
        }
        int lastSlash = target.lastIndexOf(47);
        String path = target.substring(0, lastSlash);
        if (path.equals("main:")) {
            path = path + "/";
        }
        String name = target.substring(lastSlash + 1);
        try {
            System.out.println("remove " + target);
            this.fService.removeNode(path, name);
            this.removePath(target);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void modifyFile() {
        String path = this.randomFile();
        if (path != null) {
            try {
                System.out.println("modify " + path);
                PrintStream out = new PrintStream(this.fService.getFileOutputStream(path));
                out.println("I am " + path);
                out.close();
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    private void readFile() {
        String path = this.randomFile();
        if (path != null) {
            try {
                System.out.println("read " + path);
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.fService.getFileInputStream(-1, path)));
                String line = reader.readLine();
                System.out.println(line);
                reader.close();
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    public void refresh() {
        System.out.println("refresh");
        this.fAllPaths = new ArrayList<String>();
        this.fAllDirectories = new ArrayList<String>();
        this.fAllFiles = new ArrayList<String>();
        this.fAllPaths.add("main:/");
        this.fAllDirectories.add("main:/");
        HashSet<Long> visited = new HashSet<Long>();
        AVMNodeDescriptor root = this.fService.getStoreRoot(-1, "main");
        this.recursiveRefresh(root, visited);
    }

    private void recursiveRefresh(AVMNodeDescriptor dir, Set<Long> visited) {
        try {
            String baseName = dir.getPath().endsWith("/") ? dir.getPath() : dir.getPath() + "/";
            SortedMap<String, AVMNodeDescriptor> listing = this.fService.getDirectoryListing(dir);
            for (String name : listing.keySet()) {
                String path = baseName + name;
                AVMNodeDescriptor desc = (AVMNodeDescriptor)listing.get(name);
                switch (desc.getType()) {
                    case 2: 
                    case 3: {
                        if (visited.contains(desc.getId())) break;
                        visited.add(desc.getId());
                        this.fAllPaths.add(path);
                        this.fAllDirectories.add(path);
                        this.recursiveRefresh(desc, visited);
                        break;
                    }
                    case 0: 
                    case 1: {
                        this.fAllPaths.add(path);
                        this.fAllFiles.add(path);
                    }
                }
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void snapshot() {
        System.out.println("snapshot");
        try {
            this.fService.createSnapshot("main", null, null);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public boolean getError() {
        return this.fError;
    }

    public String getErrorStackTrace() {
        return this.fErrorStackTrace;
    }

    public void setExit() {
        this.fExit = true;
    }

    private void addDirectory(String path) {
        this.fAllDirectories.add(path);
        this.fAllPaths.add(path);
    }

    private void addFile(String path) {
        this.fAllFiles.add(path);
        this.fAllPaths.add(path);
    }

    private void removePath(String path) {
        ArrayList<String> allPaths = new ArrayList<String>();
        ArrayList<String> allDirectories = new ArrayList<String>();
        ArrayList<String> allFiles = new ArrayList<String>();
        for (String p : this.fAllPaths) {
            if (p.indexOf(path) == 0) continue;
            allPaths.add(p);
        }
        for (String p : this.fAllDirectories) {
            if (p.indexOf(path) == 0) continue;
            allDirectories.add(p);
        }
        for (String p : this.fAllFiles) {
            if (p.indexOf(path) == 0) continue;
            allFiles.add(p);
        }
        this.fAllPaths = allPaths;
        this.fAllDirectories = allDirectories;
        this.fAllFiles = allFiles;
    }

    private String appendPath(String path, String name) {
        return path.endsWith("/") ? path + name : path + "/" + name;
    }

    private String randomDirectory() {
        if (this.fAllDirectories.size() == 0) {
            System.out.println("cannot select random directory since no directories");
            return null;
        }
        return this.fAllDirectories.get(fgRandom.nextInt(this.fAllDirectories.size()));
    }

    private String randomFile() {
        if (this.fAllFiles.size() == 0) {
            System.out.println("cannot select random file since no files");
            return null;
        }
        return this.fAllFiles.get(fgRandom.nextInt(this.fAllFiles.size()));
    }

    private String randomPath() {
        if (this.fAllPaths.size() == 0) {
            System.out.println("cannot select random path since no paths");
            return null;
        }
        return this.fAllPaths.get(fgRandom.nextInt(this.fAllPaths.size()));
    }

    private static synchronized void IncCount() {
        ++fgOpCount;
    }

    public static synchronized int GetCount() {
        return fgOpCount;
    }

    private void handleException(Exception e) {
        e.printStackTrace(System.err);
        if (e instanceof AVMException) {
            return;
        }
        if (e instanceof ContentIOException) {
            return;
        }
        throw new AVMException("Naughty Exception.", e);
    }
}

