/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm;

import org.alfresco.repo.avm.AVMDAOs;
import org.alfresco.repo.avm.AVMNode;
import org.alfresco.repo.avm.AVMNodeImpl;
import org.alfresco.repo.avm.AVMStore;
import org.alfresco.repo.avm.ChildEntry;
import org.alfresco.repo.avm.ChildEntryImpl;
import org.alfresco.repo.avm.ChildKey;
import org.alfresco.repo.avm.DirectoryNode;
import org.alfresco.repo.avm.LayeredDirectoryNode;
import org.alfresco.repo.avm.Lookup;
import org.alfresco.service.cmr.avm.AVMBadArgumentException;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMNotFoundException;
import org.alfresco.util.Pair;

public abstract class DirectoryNodeImpl
extends AVMNodeImpl
implements DirectoryNode {
    protected DirectoryNodeImpl() {
    }

    protected DirectoryNodeImpl(AVMStore repo) {
        super(repo);
    }

    @Override
    public void link(String name, AVMNodeDescriptor toLink) {
        AVMNode node = AVMDAOs.Instance().fAVMNodeDAO.getByID(toLink.getId());
        if (node == null) {
            throw new AVMNotFoundException("Child node not found.");
        }
        if (node.getType() == 3 && !((LayeredDirectoryNode)node).getPrimaryIndirection()) {
            throw new AVMBadArgumentException("Non primary layered directories cannot be linked.");
        }
        ChildKey key = new ChildKey(this, name);
        ChildEntryImpl newChild = new ChildEntryImpl(key, node);
        AVMDAOs.Instance().fChildEntryDAO.save(newChild);
    }

    @Override
    public boolean directlyContains(AVMNode node) {
        return AVMDAOs.Instance().fChildEntryDAO.existsParentChild(this, node);
    }

    @Override
    public Pair<AVMNode, Boolean> lookupChild(Lookup lPath, String name, boolean includeDeleted) {
        Pair<ChildEntry, Boolean> result = this.lookupChildEntry(lPath, name, includeDeleted);
        if (result == null) {
            return null;
        }
        return new Pair((Object)((ChildEntry)result.getFirst()).getChild(), result.getSecond());
    }
}

